/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi.financial;

import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.chartfx.renderer.spi.financial.AbstractFinancialRenderer;
import io.fair_acc.chartfx.renderer.spi.financial.FinancialDataSetNode;
import io.fair_acc.chartfx.renderer.spi.financial.service.OhlcvRendererEpData;
import io.fair_acc.chartfx.renderer.spi.financial.service.RendererPaintAfterEP;
import io.fair_acc.chartfx.renderer.spi.financial.service.RendererPaintAfterEPAware;
import io.fair_acc.chartfx.ui.css.DataSetNode;
import io.fair_acc.chartfx.ui.css.StyleUtil;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.spi.financial.api.attrs.AttributeModelAware;
import io.fair_acc.dataset.spi.financial.api.ohlcv.IOhlcvItemAware;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Paint;

public class HighLowRenderer
extends AbstractFinancialRenderer<HighLowRenderer>
implements Renderer,
RendererPaintAfterEPAware {
    private final boolean paintVolume;
    private final AbstractFinancialRenderer.FindAreaDistances findAreaDistances;
    protected List<RendererPaintAfterEP> paintAfterEPS = new ArrayList<RendererPaintAfterEP>();

    public HighLowRenderer(boolean bl2) {
        StyleUtil.addStyles(this, "highlow");
        this.paintVolume = bl2;
        this.findAreaDistances = bl2 ? new AbstractFinancialRenderer.XMinVolumeMaxAreaDistances() : new AbstractFinancialRenderer.XMinAreaDistances();
    }

    public HighLowRenderer() {
        this(false);
    }

    public boolean isPaintVolume() {
        return this.paintVolume;
    }

    @Override
    public boolean drawLegendSymbol(DataSetNode dataSetNode, Canvas canvas) {
        int n2 = (int)canvas.getWidth();
        int n3 = (int)canvas.getHeight();
        GraphicsContext graphicsContext = canvas.getGraphicsContext2D();
        graphicsContext.save();
        FinancialDataSetNode financialDataSetNode = (FinancialDataSetNode)dataSetNode;
        Paint paint = financialDataSetNode.getHighLowLongColor();
        Paint paint2 = financialDataSetNode.getHighLowShortColor();
        graphicsContext.setStroke(paint2);
        double d2 = (double)n2 / 4.0;
        graphicsContext.strokeLine(2.0, 3.0, d2, 3.0);
        graphicsContext.strokeLine(d2, (double)n3 - 4.0, (double)n2 / 2.0 - 2.0, (double)n3 - 4.0);
        graphicsContext.strokeLine(d2, 1.0, d2, (double)n3 - 2.0);
        graphicsContext.setStroke(paint);
        d2 = 3.0 * (double)n2 / 4.0;
        graphicsContext.strokeLine(d2 - 3.0, (double)n3 - 8.0, d2, (double)n3 - 8.0);
        graphicsContext.strokeLine(d2, 5.0, d2 + 3.0, 5.0);
        graphicsContext.strokeLine(d2, 2.0, d2, (double)n3 - 2.0);
        graphicsContext.restore();
        return true;
    }

    @Override
    protected HighLowRenderer getThis() {
        return this;
    }

    @Override
    protected void render(GraphicsContext graphicsContext, DataSet dataSet, DataSetNode dataSetNode) {
        if (dataSet.getDimension() < 7) {
            return;
        }
        AttributeModelAware attributeModelAware = null;
        if (dataSet instanceof AttributeModelAware) {
            attributeModelAware = (AttributeModelAware)((Object)dataSet);
        }
        IOhlcvItemAware iOhlcvItemAware = null;
        if (dataSet instanceof IOhlcvItemAware) {
            iOhlcvItemAware = (IOhlcvItemAware)((Object)dataSet);
        }
        boolean bl2 = !this.paintAfterEPS.isEmpty() || this.paintBarMarker != null;
        graphicsContext.save();
        FinancialDataSetNode financialDataSetNode = (FinancialDataSetNode)dataSetNode;
        graphicsContext.setLineWidth(financialDataSetNode.getLineWidth());
        graphicsContext.setLineDashes(financialDataSetNode.getLineDashes());
        Paint paint = financialDataSetNode.getHighLowLongColor();
        Paint paint2 = financialDataSetNode.getHighLowShortColor();
        Paint paint3 = financialDataSetNode.getHighLowLongTickColor();
        Paint paint4 = financialDataSetNode.getHighLowShortTickColor();
        Paint paint5 = financialDataSetNode.getHiLowShadowColor();
        Paint paint6 = financialDataSetNode.getCandleVolumeLongColor();
        Paint paint7 = financialDataSetNode.getCandleVolumeShortColor();
        double d2 = financialDataSetNode.getHighLowBodyLineWidth();
        double d3 = financialDataSetNode.getHighLowTickLineWidth();
        double d4 = financialDataSetNode.getHiLowBarWidthPercent();
        double d5 = financialDataSetNode.getShadowLineWidth();
        double d6 = financialDataSetNode.getShadowTransPercent();
        if (dataSet.getDataCount() > 0) {
            int n2 = dataSet.getIndex(0, this.xMin);
            if (n2 < 0) {
                n2 = 0;
            }
            int n3 = Math.min(dataSet.getIndex(0, this.xMax) + 1, dataSet.getDataCount());
            double[] dArray = null;
            double d7 = 0.0;
            if (dataSetNode.getLocalIndex() == 0) {
                dArray = this.findAreaDistances(this.findAreaDistances, dataSet, this.xAxis, this.yAxis, this.xMin, this.xMax);
                d7 = dArray[0];
            }
            double d8 = d7 * d4;
            double d9 = d8 / 2.0;
            for (int i2 = n2; i2 < n3; ++i2) {
                double d10 = this.xAxis.getDisplayPosition(dataSet.get(0, i2));
                double d11 = this.yAxis.getDisplayPosition(dataSet.get(1, i2));
                double d12 = this.yAxis.getDisplayPosition(dataSet.get(2, i2));
                double d13 = this.yAxis.getDisplayPosition(dataSet.get(3, i2));
                double d14 = this.yAxis.getDisplayPosition(dataSet.get(4, i2));
                OhlcvRendererEpData ohlcvRendererEpData = null;
                if (bl2) {
                    ohlcvRendererEpData = new OhlcvRendererEpData();
                    ohlcvRendererEpData.gc = graphicsContext;
                    ohlcvRendererEpData.ds = dataSet;
                    ohlcvRendererEpData.style = financialDataSetNode;
                    ohlcvRendererEpData.attrs = attributeModelAware;
                    ohlcvRendererEpData.ohlcvItemAware = iOhlcvItemAware;
                    ohlcvRendererEpData.ohlcvItem = iOhlcvItemAware != null ? iOhlcvItemAware.getItem(i2) : null;
                    ohlcvRendererEpData.index = i2;
                    ohlcvRendererEpData.minIndex = n2;
                    ohlcvRendererEpData.maxIndex = n3;
                    ohlcvRendererEpData.barWidth = d8;
                    ohlcvRendererEpData.barWidthHalf = d9;
                    ohlcvRendererEpData.xCenter = d10;
                    ohlcvRendererEpData.yOpen = d11;
                    ohlcvRendererEpData.yHigh = d12;
                    ohlcvRendererEpData.yLow = d13;
                    ohlcvRendererEpData.yClose = d14;
                }
                if (this.paintVolume) {
                    assert (dArray != null);
                    this.paintVolume(graphicsContext, dataSet, i2, paint6, paint7, this.yAxis, dArray, d8, d9, d10);
                }
                if (paint5 != null) {
                    double d15 = graphicsContext.getLineWidth();
                    this.paintHiLowShadow(graphicsContext, paint5, d5, d6, d9, d10, d11, d14, d13, d12);
                    graphicsContext.setLineWidth(d15);
                }
                Paint paint8 = ohlcvRendererEpData == null ? null : this.getPaintBarColor(ohlcvRendererEpData);
                graphicsContext.setStroke(Objects.requireNonNullElse(paint8, d11 > d14 ? paint : paint2));
                graphicsContext.setLineWidth(d2);
                graphicsContext.strokeLine(d10, d13, d10, d12);
                graphicsContext.setStroke(Objects.requireNonNullElse(paint8, d11 > d14 ? paint3 : paint4));
                graphicsContext.setLineWidth(d3);
                graphicsContext.strokeLine(d10 - d9, d11, d10, d11);
                graphicsContext.strokeLine(d10, d14, d10 + d9, d14);
                if (this.paintAfterEPS.isEmpty()) continue;
                this.paintAfter(ohlcvRendererEpData);
            }
        }
        graphicsContext.restore();
        if (this.computeLocalRange()) {
            this.applyLocalYRange(dataSet, this.yAxis, this.xMin, this.xMax);
        }
    }

    protected void paintAfter(OhlcvRendererEpData ohlcvRendererEpData) {
        for (RendererPaintAfterEP rendererPaintAfterEP : this.paintAfterEPS) {
            rendererPaintAfterEP.paintAfter(ohlcvRendererEpData);
        }
    }

    protected void paintHiLowShadow(GraphicsContext graphicsContext, Paint paint, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = d3 * d4;
        graphicsContext.setLineWidth(d2);
        graphicsContext.setStroke(paint);
        graphicsContext.strokeLine(d5 + d10, d8 + d10, d5 + d10, d9 + d10);
        graphicsContext.strokeLine(d5 - d4 + d10, d6 + d10, d5 + d10, d6 + d10);
        graphicsContext.strokeLine(d5 + d10, d7 + d10, d5 + d4 + d10, d7 + d10);
    }

    @Override
    public void addPaintAfterEp(RendererPaintAfterEP rendererPaintAfterEP) {
        this.paintAfterEPS.add(rendererPaintAfterEP);
    }

    @Override
    public List<RendererPaintAfterEP> getPaintAfterEps() {
        return this.paintAfterEPS;
    }
}

