/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi;

import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.chartfx.renderer.spi.AbstractRendererXY;
import io.fair_acc.chartfx.ui.css.DataSetNode;
import io.fair_acc.dataset.DataSet;
import javafx.scene.canvas.GraphicsContext;

public class ReducingLineRenderer
extends AbstractRendererXY<ReducingLineRenderer>
implements Renderer {
    private int maxPoints;

    public ReducingLineRenderer() {
        this.maxPoints = 300;
    }

    public ReducingLineRenderer(int n2) {
        this.maxPoints = n2;
    }

    public int getMaxPoints() {
        return this.maxPoints;
    }

    @Override
    protected ReducingLineRenderer getThis() {
        return this;
    }

    @Override
    protected void render(GraphicsContext graphicsContext, DataSet dataSet, DataSetNode dataSetNode) {
        graphicsContext.save();
        dataSetNode.applyLineStrokeStyle(graphicsContext);
        if (dataSet.getDataCount() > 0) {
            int n2 = Math.max(0, dataSet.getIndex(0, this.xMin));
            int n3 = Math.min(dataSet.getIndex(0, this.xMax) + 1, dataSet.getDataCount());
            int n4 = Math.abs(n3 - n2);
            int n5 = n4 / this.maxPoints;
            if (n5 <= 1) {
                int n6 = dataSet.getIndex(0, this.xMin);
                if (n6 < 0) {
                    n6 = 0;
                }
                double d2 = this.xAxis.getDisplayPosition(dataSet.get(0, n6));
                double d3 = this.yAxis.getDisplayPosition(dataSet.get(1, n6));
                ++n6;
                while (n6 < Math.min(dataSet.getIndex(0, this.xMax) + 1, dataSet.getDataCount())) {
                    double d4 = this.xAxis.getDisplayPosition(dataSet.get(0, n6));
                    double d5 = this.yAxis.getDisplayPosition(dataSet.get(1, n6));
                    graphicsContext.strokeLine(d2, d3, d4, d5);
                    d2 = d4;
                    d3 = d5;
                    ++n6;
                }
            } else {
                int n7 = dataSet.getIndex(0, this.xMin);
                if (n7 < 0) {
                    n7 = 0;
                }
                double d6 = this.xAxis.getDisplayPosition(dataSet.get(0, n7));
                double d7 = this.yAxis.getDisplayPosition(dataSet.get(1, n7));
                double d8 = this.xAxis.getDisplayPosition(dataSet.get(0, ++n7));
                double d9 = this.yAxis.getDisplayPosition(dataSet.get(1, n7));
                double d10 = Math.abs(d9 - d7);
                ++n7;
                int n8 = n5 - 2;
                while (n7 < Math.min(dataSet.getIndex(0, this.xMax) + 1, dataSet.getDataCount())) {
                    if (n8 > 0) {
                        double d11 = this.xAxis.getDisplayPosition(dataSet.get(0, n7));
                        double d12 = this.yAxis.getDisplayPosition(dataSet.get(1, n7));
                        if (Math.abs(d12 - d7) > d10) {
                            d8 = d11;
                            d9 = d12;
                            d10 = Math.abs(d12 - d7);
                        }
                        --n8;
                    } else {
                        graphicsContext.strokeLine(d6, d7, d8, d9);
                        d6 = d8;
                        d7 = d9;
                        d8 = this.xAxis.getDisplayPosition(dataSet.get(0, n7));
                        d9 = this.yAxis.getDisplayPosition(dataSet.get(1, n7));
                        d10 = Math.abs(d9 - d7);
                        n8 = n5 - 1;
                    }
                    ++n7;
                }
            }
        }
        graphicsContext.restore();
    }

    public void setMaxPoints(int n2) {
        this.maxPoints = n2;
    }
}

