/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi;

import io.fair_acc.chartfx.XYChart;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.chartfx.renderer.spi.AbstractRendererXY;
import io.fair_acc.chartfx.ui.css.DataSetNode;
import io.fair_acc.chartfx.ui.css.DataSetStyleParser;
import io.fair_acc.dataset.DataSet;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.geometry.Orientation;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextAlignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelledMarkerRenderer
extends AbstractRendererXY<LabelledMarkerRenderer>
implements Renderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(LabelledMarkerRenderer.class);
    private static final String STYLE_CLASS_LABELLED_MARKER = "chart-labelled-marker";
    private static final String DEFAULT_FONT = "Helvetica";
    private static final int DEFAULT_FONT_SIZE = 18;
    private static final Color DEFAULT_GRID_LINE_COLOR = Color.GREEN;
    private static final double DEFAULT_GRID_LINE_WIDTH = 1.0;
    private static final double[] DEFAULT_GRID_DASH_PATTERM = new double[]{3.0, 3.0};
    protected final BooleanProperty verticalMarker = new SimpleBooleanProperty((Object)this, "verticalMarker", true);
    protected final BooleanProperty horizontalMarker = new SimpleBooleanProperty((Object)this, "horizontalMarker", false);
    protected Paint strokeColorMarker = DEFAULT_GRID_LINE_COLOR;
    protected double strokeLineWidthMarker = 1.0;
    protected double[] strokeDashPattern = DEFAULT_GRID_DASH_PATTERM;
    private static final DataSetStyleParser styleParser = DataSetStyleParser.newInstance();

    public LabelledMarkerRenderer() {
        this.updateCSS();
        this.setShowInLegend(false);
    }

    protected void drawHorizontalLabelledMarker(GraphicsContext graphicsContext, XYChart xYChart, DataSet dataSet, int n2, int n3) {
        Axis axis = this.getFirstAxis(Orientation.VERTICAL, xYChart);
        graphicsContext.save();
        this.setGraphicsContextAttributes(graphicsContext, dataSet.getStyle());
        graphicsContext.setTextAlign(TextAlignment.RIGHT);
        double d2 = xYChart.getCanvas().getWidth();
        double d3 = -1.7976931348623157E308;
        double d4 = 0.0;
        for (int i2 = n2; i2 < n3; ++i2) {
            double d5 = (int)axis.getDisplayPosition(dataSet.get(1, i2));
            String string = dataSet.getDataLabel(i2);
            if (string == null) continue;
            String string2 = dataSet.getStyle(i2);
            if (string2 != null) {
                graphicsContext.save();
                this.setGraphicsContextAttributes(graphicsContext, string2);
            }
            graphicsContext.strokeLine(0.0, d5, d2, d5);
            if (Math.abs(d5 - d3) > d4 && !string.isEmpty()) {
                graphicsContext.save();
                graphicsContext.setLineWidth(0.8);
                graphicsContext.setLineDashes(new double[]{1.0});
                graphicsContext.translate(Math.ceil(d5 + 3.0), Math.ceil(0.99 * d2));
                graphicsContext.fillText(string, 0.0, 0.0);
                graphicsContext.restore();
                d3 = d5;
                d4 = graphicsContext.getFont().getSize();
            }
            if (string2 == null) continue;
            graphicsContext.restore();
        }
        graphicsContext.restore();
    }

    protected void drawVerticalLabelledMarker(GraphicsContext graphicsContext, XYChart xYChart, DataSet dataSet, int n2, int n3) {
        Axis axis = this.getFirstAxis(Orientation.HORIZONTAL);
        if (axis == null) {
            axis = xYChart.getFirstAxis(Orientation.HORIZONTAL);
        }
        if (axis == null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.atWarn().addArgument(LabelledMarkerRenderer.class.getSimpleName()).log("{}::drawVerticalLabelledMarker(...) getFirstAxis(HORIZONTAL) returned null skip plotting");
            }
            return;
        }
        graphicsContext.save();
        this.setGraphicsContextAttributes(graphicsContext, dataSet.getStyle());
        graphicsContext.setTextAlign(TextAlignment.LEFT);
        double d2 = xYChart.getCanvas().getHeight();
        double d3 = -1.7976931348623157E308;
        double d4 = 0.0;
        for (int i2 = n2; i2 < n3; ++i2) {
            double d5 = (int)axis.getDisplayPosition(dataSet.get(0, i2));
            String string = dataSet.getDataLabel(i2);
            if (string == null) continue;
            String string2 = dataSet.getStyle(i2);
            if (string2 != null) {
                graphicsContext.save();
                this.setGraphicsContextAttributes(graphicsContext, string2);
            }
            graphicsContext.strokeLine(d5, 0.0, d5, d2);
            if (Math.abs(d5 - d3) > d4 && !string.isEmpty()) {
                graphicsContext.save();
                graphicsContext.setLineWidth(0.8);
                graphicsContext.setLineDashes(new double[]{1.0});
                graphicsContext.translate(Math.ceil(d5 + 3.0), Math.ceil(0.01 * d2));
                graphicsContext.rotate(90.0);
                graphicsContext.fillText(string, 0.0, 0.0);
                graphicsContext.restore();
                d3 = d5;
                d4 = graphicsContext.getFont().getSize();
            }
            if (string2 == null) continue;
            graphicsContext.restore();
        }
        graphicsContext.restore();
    }

    public LabelledMarkerRenderer enableHorizontalMarker(boolean bl2) {
        this.horizontalMarkerProperty().set(bl2);
        return this.getThis();
    }

    public LabelledMarkerRenderer enableVerticalMarker(boolean bl2) {
        this.verticalMarkerProperty().set(bl2);
        return this.getThis();
    }

    @Override
    protected LabelledMarkerRenderer getThis() {
        return this;
    }

    public BooleanProperty horizontalMarkerProperty() {
        return this.horizontalMarker;
    }

    public boolean isHorizontalMarker() {
        return this.horizontalMarkerProperty().get();
    }

    public boolean isVerticalMarker() {
        return this.verticalMarkerProperty().get();
    }

    @Override
    protected void render(GraphicsContext graphicsContext, DataSet dataSet, DataSetNode dataSetNode) {
        int n2 = Math.max(0, dataSet.getIndex(0, this.xMin));
        int n3 = Math.min(dataSet.getIndex(0, this.xMax) + 1, dataSet.getDataCount());
        if (n3 - n2 <= 0) {
            return;
        }
        if (this.isHorizontalMarker()) {
            this.drawHorizontalLabelledMarker(graphicsContext, this.getChart(), dataSet, n2, n3);
        }
        if (this.isVerticalMarker()) {
            this.drawVerticalLabelledMarker(graphicsContext, this.getChart(), dataSet, n2, n3);
        }
    }

    protected void setGraphicsContextAttributes(GraphicsContext graphicsContext, String string) {
        if (!styleParser.tryParse(string)) {
            return;
        }
        styleParser.getLineColor().ifPresent(arg_0 -> ((GraphicsContext)graphicsContext).setStroke(arg_0));
        styleParser.getLineWidth().ifPresent(arg_0 -> ((GraphicsContext)graphicsContext).setLineWidth(arg_0));
        styleParser.getLineDashes().ifPresent(arg_0 -> ((GraphicsContext)graphicsContext).setLineDashes(arg_0));
        styleParser.getMarkerColor().ifPresent(arg_0 -> ((GraphicsContext)graphicsContext).setFill(arg_0));
        styleParser.getFontFull().ifPresent(arg_0 -> ((GraphicsContext)graphicsContext).setFont(arg_0));
    }

    public final LabelledMarkerRenderer updateCSS() {
        this.strokeColorMarker = DEFAULT_GRID_LINE_COLOR;
        this.strokeLineWidthMarker = 1.0;
        this.strokeDashPattern = DEFAULT_GRID_DASH_PATTERM;
        return this.getThis();
    }

    public BooleanProperty verticalMarkerProperty() {
        return this.verticalMarker;
    }
}

