/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi;

import io.fair_acc.bench.DurationMeasure;
import io.fair_acc.bench.MeasurementRecorder;
import io.fair_acc.chartfx.XYChart;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.axes.spi.AxisRange;
import io.fair_acc.chartfx.axes.spi.TickMark;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.chartfx.renderer.spi.utils.DashPatternStyle;
import io.fair_acc.chartfx.ui.css.CssPropertyFactory;
import io.fair_acc.chartfx.ui.css.DataSetNode;
import io.fair_acc.chartfx.ui.css.LineStyle;
import io.fair_acc.chartfx.ui.css.StyleGroup;
import io.fair_acc.chartfx.ui.css.StyleUtil;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.utils.AssertUtils;
import io.fair_acc.dataset.utils.NoDuplicatesList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.text.TextAlignment;

public class GridRenderer
extends Parent
implements Renderer {
    private static final double DEG_TO_RAD = Math.PI / 180;
    private static final String STYLE_CLASS_GRID_RENDERER = "grid-renderer";
    private static final String STYLE_CLASS_MAJOR_GRID_LINE = "chart-major-grid-lines";
    private static final String STYLE_CLASS_MAJOR_GRID_LINE_H = "chart-major-horizontal-lines";
    private static final String STYLE_CLASS_MAJOR_GRID_LINE_V = "chart-major-vertical-lines";
    private static final String STYLE_CLASS_MINOR_GRID_LINE = "chart-minor-grid-lines";
    private static final String STYLE_CLASS_MINOR_GRID_LINE_H = "chart-minor-horizontal-lines";
    private static final String STYLE_CLASS_MINOR_GRID_LINE_V = "chart-minor-vertical-lines";
    private static final String STYLE_CLASS_GRID_ON_TOP = "chart-grid-line-on-top";
    private static final PseudoClass WITH_MINOR_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"withMinor");
    private final StyleGroup styles = new StyleGroup((ObservableList<Node>)this.getChildren());
    private final LineStyle horMajorGridStyleNode = this.styles.newLineStyle("chart-major-grid-lines", "chart-major-horizontal-lines");
    private final LineStyle verMajorGridStyleNode = this.styles.newLineStyle("chart-major-grid-lines", "chart-major-vertical-lines");
    private final LineStyle horMinorGridStyleNode = this.styles.newLineStyle("chart-minor-grid-lines", "chart-minor-horizontal-lines");
    private final LineStyle verMinorGridStyleNode = this.styles.newLineStyle("chart-minor-grid-lines", "chart-minor-vertical-lines");
    private final StyleableBooleanProperty drawGridOnTop = CSS.createBooleanProperty(this, "drawGridOnTop", true, new Runnable[0]);
    protected final ObservableList<Axis> axesList = FXCollections.observableList(new NoDuplicatesList());
    private final XYChart chart;
    private static final CssPropertyFactory<GridRenderer> CSS = new CssPropertyFactory(Parent.getClassCssMetaData());
    private DurationMeasure benchDrawGrid = DurationMeasure.DISABLED;

    public GridRenderer(XYChart xYChart) {
        this.chart = AssertUtils.notNull("chart", xYChart);
        StyleUtil.hiddenStyleNode(this, STYLE_CLASS_GRID_RENDERER);
        StyleUtil.applyPseudoClass((Node)this.horMajorGridStyleNode, WITH_MINOR_PSEUDO_CLASS, (ObservableBooleanValue)this.horMinorGridStyleNode.visibleProperty());
        StyleUtil.applyPseudoClass((Node)this.verMajorGridStyleNode, WITH_MINOR_PSEUDO_CLASS, (ObservableBooleanValue)this.verMinorGridStyleNode.visibleProperty());
    }

    protected void drawEuclideanGrid(GraphicsContext graphicsContext, XYChart xYChart) {
        Axis axis = xYChart.getXAxis();
        Axis axis2 = xYChart.getYAxis();
        double d2 = xYChart.getCanvas().getWidth();
        double d3 = GridRenderer.snap(d2);
        double d4 = xYChart.getCanvas().getHeight();
        double d5 = GridRenderer.snap(d4);
        if (axis instanceof Node) {
            ((Node)axis).setVisible(true);
        }
        graphicsContext.save();
        this.drawVerticalMajorGridLines(graphicsContext, axis, d2, d5);
        this.drawVerticalMinorGridLines(graphicsContext, axis, d2, d5);
        this.drawHorizontalMajorGridLines(graphicsContext, axis2, d3, d4);
        this.drawHorizontalMinorGridLines(graphicsContext, axis2, d3, d4);
        graphicsContext.restore();
    }

    protected void drawHorizontalMajorGridLines(GraphicsContext graphicsContext, Axis axis, double d2, double d3) {
        if (!this.horMajorGridStyleNode.isVisible() && !this.horMinorGridStyleNode.isVisible()) {
            return;
        }
        double d4 = GridRenderer.snap(0.0);
        GridRenderer.applyGraphicsStyleFromLineStyle(graphicsContext, this.horMajorGridStyleNode);
        ObservableList<TickMark> observableList = axis.getTickMarks();
        for (TickMark tickMark : observableList) {
            double d5 = GridRenderer.snap(axis.getDisplayPosition(tickMark.getValue()));
            if (!(d5 >= 0.0) || !(d5 < d3)) continue;
            DashPatternStyle.strokeDashedLine(graphicsContext, d4, d5, d2, d5);
        }
    }

    protected void drawHorizontalMinorGridLines(GraphicsContext graphicsContext, Axis axis, double d2, double d3) {
        if (!axis.isLogAxis() && !this.horMinorGridStyleNode.isVisible()) {
            return;
        }
        double d4 = GridRenderer.snap(0.0);
        GridRenderer.applyGraphicsStyleFromLineStyle(graphicsContext, this.horMinorGridStyleNode);
        ObservableList<TickMark> observableList = axis.getMinorTickMarks();
        for (TickMark tickMark : observableList) {
            double d5 = GridRenderer.snap(axis.getDisplayPosition(tickMark.getValue()));
            if (!(d5 >= 0.0) || !(d5 < d3)) continue;
            DashPatternStyle.strokeDashedLine(graphicsContext, d4, d5, d2, d5);
        }
    }

    protected void drawPolarCircle(GraphicsContext graphicsContext, Axis axis, double d2, double d3, double d4, double d5) {
        if (!this.horMajorGridStyleNode.isVisible() && !this.horMinorGridStyleNode.isVisible()) {
            return;
        }
        GridRenderer.applyGraphicsStyleFromLineStyle(graphicsContext, this.horMajorGridStyleNode);
        ObservableList<TickMark> observableList = axis.getTickMarks();
        graphicsContext.strokeOval(d3 - d5, d4 - d5, 2.0 * d5, 2.0 * d5);
        observableList.forEach(tickMark -> {
            double d6 = d2 - axis.getDisplayPosition(tickMark.getValue());
            String string = axis.getTickMarkLabel(tickMark.getValue());
            double d7 = d6 / d2 * d5;
            if (d7 >= 0.0 && d7 < d5) {
                graphicsContext.strokeOval(d3 - d7, d4 - d7, 2.0 * d7, 2.0 * d7);
                graphicsContext.save();
                graphicsContext.setFont(axis.getTickLabelStyle().getFont());
                graphicsContext.setStroke(axis.getTickLabelStyle().getFill());
                graphicsContext.setLineDashes((double[])null);
                graphicsContext.setTextBaseline(VPos.CENTER);
                graphicsContext.strokeText(string, d3 + (double)((int)axis.getTickLabelGap()), d4 - d7);
                graphicsContext.restore();
            }
        });
        if (!axis.isLogAxis() && !this.horMinorGridStyleNode.isVisible()) {
            return;
        }
        GridRenderer.applyGraphicsStyleFromLineStyle(graphicsContext, this.horMinorGridStyleNode);
        axis.getMinorTickMarks().stream().mapToDouble(tickMark -> d2 - tickMark.getPosition()).forEach(d6 -> {
            double d7 = d6 / d2 * d5;
            if (d7 >= 0.0 && d7 < d5) {
                graphicsContext.strokeOval(d3 - d7, d4 - d7, 2.0 * d7, 2.0 * d7);
            }
        });
    }

    protected void drawPolarGrid(GraphicsContext graphicsContext, XYChart xYChart) {
        Axis axis = xYChart.getXAxis();
        Axis axis2 = xYChart.getYAxis();
        double d2 = xYChart.getCanvas().getWidth();
        double d3 = xYChart.getCanvas().getHeight();
        double d5 = axis.getWidth();
        double d6 = axis2.getHeight();
        double d7 = d5 / 2.0;
        double d8 = d6 / 2.0;
        double d9 = 0.5 * Math.min(d5, d6) * 0.9;
        if (axis instanceof Node) {
            ((Node)axis).setVisible(false);
        }
        graphicsContext.save();
        if (this.verMajorGridStyleNode.isVisible() || this.verMinorGridStyleNode.isVisible()) {
            GridRenderer.applyGraphicsStyleFromLineStyle(graphicsContext, this.verMajorGridStyleNode);
            for (double d10 = 0.0; d10 <= 360.0; d10 += xYChart.getPolarStepSize().get()) {
                double d11 = d7 + d9 * Math.sin(d10 * (Math.PI / 180));
                double d12 = d8 - d9 * Math.cos(d10 * (Math.PI / 180));
                double d13 = d7 + d9 * Math.sin(d10 * (Math.PI / 180)) * 1.05;
                double d14 = d8 - d9 * Math.cos(d10 * (Math.PI / 180)) * 1.05;
                graphicsContext.strokeLine(d7, d8, d11, d12);
                graphicsContext.save();
                graphicsContext.setFont(axis2.getTickLabelStyle().getFont());
                graphicsContext.setStroke(axis2.getTickLabelStyle().getFill());
                graphicsContext.setLineDashes((double[])null);
                graphicsContext.setTextBaseline(VPos.CENTER);
                if (d10 < 350.0) {
                    if (d10 < 20.0) {
                        graphicsContext.setTextAlign(TextAlignment.CENTER);
                    } else if (d10 <= 160.0) {
                        graphicsContext.setTextAlign(TextAlignment.LEFT);
                    } else if (d10 <= 200.0) {
                        graphicsContext.setTextAlign(TextAlignment.CENTER);
                    } else {
                        graphicsContext.setTextAlign(TextAlignment.RIGHT);
                    }
                    graphicsContext.strokeText(String.valueOf(d10), d13, d14);
                }
                graphicsContext.restore();
            }
            if (axis.isLogAxis() || this.verMinorGridStyleNode.isVisible()) {
                GridRenderer.applyGraphicsStyleFromLineStyle(graphicsContext, this.verMinorGridStyleNode);
                axis.getMinorTickMarks().stream().mapToDouble(TickMark::getPosition).forEach(d4 -> {
                    if (d4 > 0.0 && d4 <= d2) {
                        graphicsContext.strokeLine(d4, 0.0, d4, d3);
                    }
                });
            }
        }
        this.drawPolarCircle(graphicsContext, axis2, d6, d7, d8, d9);
        graphicsContext.restore();
    }

    protected void drawVerticalMajorGridLines(GraphicsContext graphicsContext, Axis axis, double d2, double d3) {
        if (!this.verMajorGridStyleNode.isVisible() && !this.verMinorGridStyleNode.isVisible()) {
            return;
        }
        double d4 = GridRenderer.snap(0.0);
        GridRenderer.applyGraphicsStyleFromLineStyle(graphicsContext, this.verMajorGridStyleNode);
        ObservableList<TickMark> observableList = axis.getTickMarks();
        for (TickMark tickMark : observableList) {
            double d5 = GridRenderer.snap(axis.getDisplayPosition(tickMark.getValue()));
            if (!(d5 > 0.0) || !(d5 <= d2)) continue;
            DashPatternStyle.strokeDashedLine(graphicsContext, d5, d4, d5, d3);
        }
    }

    protected void drawVerticalMinorGridLines(GraphicsContext graphicsContext, Axis axis, double d2, double d3) {
        if (!axis.isLogAxis() && !this.verMinorGridStyleNode.isVisible()) {
            return;
        }
        double d4 = GridRenderer.snap(0.0);
        GridRenderer.applyGraphicsStyleFromLineStyle(graphicsContext, this.verMinorGridStyleNode);
        ObservableList<TickMark> observableList = axis.getMinorTickMarks();
        for (TickMark tickMark : observableList) {
            double d5 = GridRenderer.snap(axis.getDisplayPosition(tickMark.getValue()));
            if (!(d5 > 0.0) || !(d5 <= d2)) continue;
            DashPatternStyle.strokeDashedLine(graphicsContext, d5, d4, d5, d3);
        }
    }

    @Override
    public ObservableList<Axis> getAxes() {
        return this.axesList;
    }

    @Override
    public ObservableList<DataSet> getDatasets() {
        return FXCollections.emptyObservableList();
    }

    @Override
    public ObservableList<DataSetNode> getDatasetNodes() {
        return FXCollections.emptyObservableList();
    }

    @Override
    public void updateAxisRange(Axis axis, AxisRange axisRange) {
    }

    public LineStyle getHorizontalMajorGrid() {
        return this.horMajorGridStyleNode;
    }

    public LineStyle getHorizontalMinorGrid() {
        return this.horMinorGridStyleNode;
    }

    public LineStyle getVerticalMajorGrid() {
        return this.verMajorGridStyleNode;
    }

    public LineStyle getVerticalMinorGrid() {
        return this.verMinorGridStyleNode;
    }

    public final void setDrawOnTop(boolean bl2) {
        this.drawOnTopProperty().set(bl2);
    }

    public final boolean isDrawOnTop() {
        return this.drawOnTopProperty().get();
    }

    public final BooleanProperty drawOnTopProperty() {
        return this.drawGridOnTop;
    }

    @Override
    public void render() {
        this.benchDrawGrid.start();
        if (this.chart.isPolarPlot()) {
            this.drawPolarGrid(this.chart.getCanvas().getGraphicsContext2D(), this.chart);
        } else {
            this.drawEuclideanGrid(this.chart.getCanvas().getGraphicsContext2D(), this.chart);
        }
        this.benchDrawGrid.stop();
    }

    @Override
    public Renderer setShowInLegend(boolean bl2) {
        return this;
    }

    @Override
    public boolean showInLegend() {
        return false;
    }

    @Override
    public BooleanProperty showInLegendProperty() {
        return null;
    }

    @Override
    public void setGlobalIndexOffset(int n2) {
    }

    @Override
    public int getGlobalIndexOffset() {
        return 0;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return GridRenderer.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return CSS.getCssMetaData();
    }

    protected static void applyGraphicsStyleFromLineStyle(GraphicsContext graphicsContext, LineStyle lineStyle) {
        lineStyle.copyStyleTo(graphicsContext);
    }

    private static double snap(double d2) {
        return (double)((int)d2) + 0.5;
    }

    @Override
    public void setRecorder(MeasurementRecorder measurementRecorder) {
        this.benchDrawGrid = measurementRecorder.newDebugDuration("grid-drawGrid");
    }
}

