/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi;

import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.renderer.ErrorStyle;
import io.fair_acc.chartfx.renderer.RendererDataReducer;
import io.fair_acc.chartfx.ui.css.DataSetNode;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.DataSetError;
import io.fair_acc.dataset.utils.CachedDaemonThreadFactory;
import io.fair_acc.dataset.utils.IndexedStringConsumer;
import io.fair_acc.dataset.utils.ProcessingProfiler;
import io.fair_acc.math.ArrayUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class CachedDataPoints {
    private static final double DEG_TO_RAD = Math.PI / 180;
    protected double[] xValues;
    protected double[] yValues;
    protected double[] errorXNeg;
    protected double[] errorXPos;
    protected double[] errorYNeg;
    protected double[] errorYPos;
    protected boolean[] selected;
    protected String[] styles;
    protected boolean xAxisInverted;
    protected boolean yAxisInverted;
    protected boolean allowForNaNs;
    protected boolean hasStyles;
    protected DataSetError.ErrorType[] errorType;
    protected int indexMin;
    protected int indexMax;
    protected int minDistanceX = Integer.MAX_VALUE;
    protected double xZero;
    protected double yZero;
    protected double yMin;
    protected double yMax;
    protected double xMin;
    protected double xMax;
    protected boolean polarPlot;
    protected ErrorStyle rendererErrorStyle;
    protected double xRange;
    protected double yRange;
    protected double maxRadius;
    protected int maxDataCount;
    protected int actualDataCount;
    private final IndexedStringConsumer styleSetter = (n2, string) -> {
        this.styles[n2] = string;
    };

    public void trim() {
        this.xValues = ArrayUtils.clearIfLarger(this.xValues, this.maxDataCount);
        this.yValues = ArrayUtils.clearIfLarger(this.yValues, this.maxDataCount);
        this.errorYNeg = ArrayUtils.clearIfLarger(this.errorYNeg, this.maxDataCount);
        this.errorYPos = ArrayUtils.clearIfLarger(this.errorYPos, this.maxDataCount);
        this.errorXNeg = ArrayUtils.clearIfLarger(this.errorXNeg, this.maxDataCount);
        this.errorXPos = ArrayUtils.clearIfLarger(this.errorXPos, this.maxDataCount);
        this.selected = ArrayUtils.clearIfLarger(this.selected, this.maxDataCount);
        this.styles = ArrayUtils.clearIfLarger(this.styles, this.maxDataCount);
        this.errorType = ArrayUtils.clearIfLarger(this.errorType, 10);
    }

    public CachedDataPoints resizeMin(int n2, int n3, int n4, boolean bl2) {
        this.indexMin = n2;
        this.indexMax = n3;
        this.maxDataCount = n4;
        this.xValues = ArrayUtils.resizeMin(this.xValues, n4);
        this.yValues = ArrayUtils.resizeMin(this.yValues, n4);
        this.errorYNeg = ArrayUtils.resizeMin(this.errorYNeg, n4);
        this.errorYPos = ArrayUtils.resizeMin(this.errorYPos, n4);
        if (bl2) {
            this.errorXNeg = ArrayUtils.resizeMin(this.errorXNeg, n4);
            this.errorXPos = ArrayUtils.resizeMin(this.errorXPos, n4);
        }
        this.selected = ArrayUtils.resizeMin(this.selected, n4);
        this.hasStyles = false;
        return this;
    }

    protected void computeBoundaryVariables(Axis axis, Axis axis2) {
        this.xAxisInverted = axis.isInvertedAxis();
        this.yAxisInverted = axis2.isInvertedAxis();
        this.xZero = axis.isLogAxis() ? axis.getDisplayPosition(axis.getMin()) : axis.getDisplayPosition(0.0);
        this.yZero = axis2.isLogAxis() ? axis2.getDisplayPosition(axis2.getMin()) : axis2.getDisplayPosition(0.0);
        this.yMin = axis2.getDisplayPosition(axis2.getMin());
        this.yMax = axis2.getDisplayPosition(axis2.getMax());
        this.xMin = axis.getDisplayPosition(axis.getMin());
        this.xMax = axis.getDisplayPosition(axis.getMax());
        this.xRange = Math.abs(this.xMax - this.xMin);
        this.yRange = Math.abs(this.yMax - this.yMin);
        this.maxRadius = 0.5 * Math.max(Math.min(this.xRange, this.yRange), 20.0) * 0.9;
        if (this.polarPlot) {
            this.xZero = 0.5 * this.xRange;
            this.yZero = 0.5 * this.yRange;
        }
    }

    private void computeFullPolar(Axis axis, DataSetError dataSetError, int n2, int n3) {
        for (int i2 = n2; i2 < n3; ++i2) {
            double d2 = dataSetError.get(0, i2);
            double d3 = dataSetError.get(1, i2);
            double d4 = d2 * (Math.PI / 180);
            double d5 = this.maxRadius * Math.abs(1.0 - axis.getDisplayPosition(d3) / this.yRange);
            this.xValues[i2] = this.xZero + d5 * Math.cos(d4);
            this.yValues[i2] = this.yZero + d5 * Math.sin(d4);
            this.errorXNeg[i2] = 0.0;
            this.errorXPos[i2] = 0.0;
            this.errorYNeg[i2] = 0.0;
            this.errorYPos[i2] = 0.0;
            if (Double.isFinite(this.yValues[i2])) continue;
            this.yValues[i2] = this.yZero;
        }
    }

    private void computeNoErrorPolar(Axis axis, DataSet dataSet, int n2, int n3) {
        for (int i2 = n2; i2 < n3; ++i2) {
            double d2 = dataSet.get(0, i2);
            double d3 = dataSet.get(1, i2);
            double d4 = d2 * (Math.PI / 180);
            double d5 = this.maxRadius * Math.abs(1.0 - axis.getDisplayPosition(d3) / this.yRange);
            this.xValues[i2] = this.xZero + d5 * Math.cos(d4);
            this.yValues[i2] = this.yZero + d5 * Math.sin(d4);
            if (Double.isFinite(this.yValues[i2])) continue;
            this.yValues[i2] = this.yZero;
        }
    }

    protected void computeScreenCoordinates(Axis axis, Axis axis2, DataSet dataSet, DataSetNode dataSetNode, int n2, int n3, ErrorStyle errorStyle, boolean bl2, boolean bl3) {
        this.setBoundaryConditions(axis, axis2, dataSet, dataSetNode, n2, n3, errorStyle, bl2, bl3);
        this.computeScreenCoordinatesNonThreaded(axis, axis2, dataSet, n2, n3);
    }

    private void computeScreenCoordinatesEuclidean(Axis axis, Axis axis2, DataSet dataSet, int n2, int n3) {
        block3: for (int i2 = 0; i2 < 2; ++i2) {
            switch (this.errorType[i2]) {
                case NO_ERROR: {
                    if (this.allowForNaNs) {
                        this.computeWithNoErrorAllowingNaNs(i2 == 0 ? axis : axis2, dataSet, i2, n2, n3);
                        continue block3;
                    }
                    this.computeWithNoError(i2 == 0 ? axis : axis2, dataSet, i2, n2, n3);
                    continue block3;
                }
                default: {
                    if (this.allowForNaNs) {
                        this.computeWithErrorAllowingNaNs(i2 == 0 ? axis : axis2, dataSet, i2, n2, n3);
                        continue block3;
                    }
                    this.computeWithError(i2 == 0 ? axis : axis2, dataSet, i2, n2, n3);
                }
            }
        }
    }

    protected void computeScreenCoordinatesInParallel(Axis axis, Axis axis2, DataSet dataSet, DataSetNode dataSetNode, int n2, int n3, ErrorStyle errorStyle, boolean bl2, boolean bl3) {
        this.setBoundaryConditions(axis, axis2, dataSet, dataSetNode, n2, n3, errorStyle, bl2, bl3);
        this.computeScreenCoordinatesParallel(axis, axis2, dataSet, n2, n3);
    }

    protected void computeScreenCoordinatesNonThreaded(Axis axis, Axis axis2, DataSet dataSet, int n2, int n3) {
        if (this.polarPlot) {
            this.computeScreenCoordinatesPolar(axis2, dataSet, n2, n3);
        } else {
            this.computeScreenCoordinatesEuclidean(axis, axis2, dataSet, n2, n3);
        }
    }

    protected void computeScreenCoordinatesParallel(Axis axis, Axis axis2, DataSet dataSet, int n2, int n3) {
        int n4 = 1000;
        int n5 = (int)Math.ceil((double)Math.abs(n3 - n2) / (double)CachedDaemonThreadFactory.getNumbersOfThreads());
        int n6 = Math.max(n5, 1000);
        ArrayList<Callable<Boolean>> arrayList = new ArrayList<Callable<Boolean>>();
        for (int i2 = n2; i2 < n3; i2 += n6) {
            int n7 = i2;
            arrayList.add(() -> {
                if (this.polarPlot) {
                    this.computeScreenCoordinatesPolar(axis2, dataSet, n7, Math.min(n3, n7 + n6));
                } else {
                    this.computeScreenCoordinatesEuclidean(axis, axis2, dataSet, n7, Math.min(n3, n7 + n6));
                }
                return Boolean.TRUE;
            });
        }
        try {
            List list = CachedDaemonThreadFactory.getCommonPool().invokeAll(arrayList);
            for (Future future : list) {
                Boolean bl2 = (Boolean)future.get();
                if (!Boolean.FALSE.equals(bl2)) continue;
                throw new IllegalStateException("one parallel worker thread finished execution with error");
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new IllegalStateException("one parallel worker thread finished execution with error", exception);
        }
    }

    private void computeScreenCoordinatesPolar(Axis axis, DataSet dataSet, int n2, int n3) {
        if (this.errorType[0] == DataSetError.ErrorType.NO_ERROR && this.errorType[1] == DataSetError.ErrorType.NO_ERROR) {
            this.computeNoErrorPolar(axis, dataSet, n2, n3);
        } else if (this.errorType[0] == DataSetError.ErrorType.NO_ERROR) {
            this.computeYonlyPolar(axis, dataSet, n2, n3);
        } else {
            DataSetError dataSetError = (DataSetError)dataSet;
            this.computeFullPolar(axis, dataSetError, n2, n3);
        }
    }

    private void computeWithError(Axis axis, DataSet dataSet, int n2, int n3, int n4) {
        if (dataSet instanceof DataSetError) {
            double[] dArray = n2 == 0 ? this.xValues : this.yValues;
            double[] dArray2 = n2 == 0 ? this.errorXNeg : this.errorYNeg;
            double[] dArray3 = n2 == 0 ? this.errorXPos : this.errorYPos;
            double d2 = n2 == 0 ? this.xMin : this.yMin;
            DataSetError dataSetError = (DataSetError)dataSet;
            for (int i2 = n3; i2 < n4; ++i2) {
                double d3 = dataSet.get(n2, i2);
                dArray[i2] = axis.getDisplayPosition(d3);
                if (!Double.isNaN(dArray[i2])) {
                    dArray2[i2] = axis.getDisplayPosition(d3 - dataSetError.getErrorNegative(n2, i2));
                    dArray3[i2] = axis.getDisplayPosition(d3 + dataSetError.getErrorPositive(n2, i2));
                    continue;
                }
                dArray[i2] = d2;
                dArray2[i2] = d2;
                dArray3[i2] = d2;
            }
            return;
        }
        double[] dArray = n2 == 0 ? this.xValues : this.yValues;
        double[] dArray4 = n2 == 0 ? this.errorXNeg : this.errorYNeg;
        double[] dArray5 = n2 == 0 ? this.errorXPos : this.errorYPos;
        double d4 = n2 == 0 ? this.xMin : this.yMin;
        for (int i3 = n3; i3 < n4; ++i3) {
            dArray[i3] = axis.getDisplayPosition(dataSet.get(n2, i3));
            if (Double.isFinite(dArray[i3])) {
                dArray4[i3] = dArray[i3];
                dArray5[i3] = dArray[i3];
                continue;
            }
            dArray[i3] = d4;
            dArray4[i3] = d4;
            dArray5[i3] = d4;
        }
    }

    private void computeWithErrorAllowingNaNs(Axis axis, DataSet dataSet, int n2, int n3, int n4) {
        if (dataSet instanceof DataSetError) {
            double[] dArray = n2 == 0 ? this.xValues : this.yValues;
            double[] dArray2 = n2 == 0 ? this.errorXNeg : this.errorYNeg;
            double[] dArray3 = n2 == 0 ? this.errorXPos : this.errorYPos;
            DataSetError dataSetError = (DataSetError)dataSet;
            for (int i2 = n3; i2 < n4; ++i2) {
                double d2 = dataSet.get(n2, i2);
                if (!Double.isFinite(d2)) {
                    dArray[i2] = Double.NaN;
                    dArray2[i2] = Double.NaN;
                    dArray3[i2] = Double.NaN;
                    continue;
                }
                dArray[i2] = axis.getDisplayPosition(d2);
                dArray2[i2] = axis.getDisplayPosition(d2 - dataSetError.getErrorNegative(n2, i2));
                dArray3[i2] = axis.getDisplayPosition(d2 + dataSetError.getErrorPositive(n2, i2));
            }
            return;
        }
        double[] dArray = n2 == 0 ? this.xValues : this.yValues;
        double[] dArray4 = n2 == 0 ? this.errorXNeg : this.errorYNeg;
        double[] dArray5 = n2 == 0 ? this.errorXPos : this.errorYPos;
        for (int i3 = n3; i3 < n4; ++i3) {
            dArray[i3] = axis.getDisplayPosition(dataSet.get(n2, i3));
            if (Double.isFinite(dArray[i3])) {
                dArray4[i3] = dArray[i3];
                dArray5[i3] = dArray[i3];
                continue;
            }
            dArray[i3] = Double.NaN;
            dArray4[i3] = Double.NaN;
            dArray5[i3] = Double.NaN;
        }
    }

    private void computeWithNoError(Axis axis, DataSet dataSet, int n2, int n3, int n4) {
        double[] dArray = n2 == 0 ? this.xValues : this.yValues;
        double d2 = n2 == 0 ? this.xMin : this.yMin;
        for (int i2 = n3; i2 < n4; ++i2) {
            double d3 = dataSet.get(n2, i2);
            dArray[i2] = axis.getDisplayPosition(d3);
            if (!Double.isNaN(dArray[i2])) continue;
            this.yValues[i2] = d2;
        }
        if (n2 == 1 && this.rendererErrorStyle != ErrorStyle.NONE) {
            System.arraycopy(dArray, n3, this.errorYNeg, n3, n4 - n3);
            System.arraycopy(dArray, n3, this.errorYPos, n3, n4 - n3);
        }
    }

    private void computeWithNoErrorAllowingNaNs(Axis axis, DataSet dataSet, int n2, int n3, int n4) {
        double[] dArray = n2 == 0 ? this.xValues : this.yValues;
        for (int i2 = n3; i2 < n4; ++i2) {
            double d2 = dataSet.get(n2, i2);
            dArray[i2] = Double.isFinite(d2) ? axis.getDisplayPosition(d2) : Double.NaN;
        }
        if (n2 == 1 && this.rendererErrorStyle != ErrorStyle.NONE) {
            System.arraycopy(dArray, n3, this.errorYNeg, n3, n4 - n3);
            System.arraycopy(dArray, n3, this.errorYPos, n3, n4 - n3);
        }
    }

    private void computeYonlyPolar(Axis axis, DataSet dataSet, int n2, int n3) {
        for (int i2 = n2; i2 < n3; ++i2) {
            double d2 = dataSet.get(0, i2);
            double d3 = dataSet.get(1, i2);
            double d4 = d2 * (Math.PI / 180);
            double d5 = this.maxRadius * Math.abs(1.0 - axis.getDisplayPosition(d3) / this.yRange);
            this.xValues[i2] = this.xZero + d5 * Math.cos(d4);
            this.yValues[i2] = this.yZero + d5 * Math.sin(d4);
            this.errorXNeg[i2] = 0.0;
            this.errorXPos[i2] = 0.0;
            this.errorYNeg[i2] = 0.0;
            this.errorYPos[i2] = 0.0;
            if (Double.isFinite(this.yValues[i2])) continue;
            this.yValues[i2] = this.yZero;
        }
    }

    protected int getMinXDistance() {
        if (this.minDistanceX < Integer.MAX_VALUE) {
            return this.minDistanceX;
        }
        if (this.indexMin >= this.indexMax) {
            this.minDistanceX = 1;
            return this.minDistanceX;
        }
        this.minDistanceX = Integer.MAX_VALUE;
        for (int i2 = 1; i2 < this.actualDataCount; ++i2) {
            double d2 = this.xValues[i2 - 1];
            double d3 = this.xValues[i2];
            this.minDistanceX = Math.min(this.minDistanceX, (int)Math.abs(d3 - d2));
        }
        return this.minDistanceX;
    }

    private int minDataPointDistanceX() {
        if (this.actualDataCount <= 1) {
            this.minDistanceX = 1;
            return this.minDistanceX;
        }
        this.minDistanceX = Integer.MAX_VALUE;
        for (int i2 = 1; i2 < this.actualDataCount; ++i2) {
            double d2 = this.xValues[i2 - 1];
            double d3 = this.xValues[i2];
            this.minDistanceX = Math.min(this.minDistanceX, (int)Math.abs(d3 - d2));
        }
        return this.minDistanceX;
    }

    protected void reduce(RendererDataReducer rendererDataReducer, boolean bl2, int n2) {
        long l2 = ProcessingProfiler.getTimeStamp();
        this.actualDataCount = 1;
        if (!bl2 || Math.abs(this.indexMax - this.indexMin) < n2) {
            this.actualDataCount = this.indexMax - this.indexMin;
            System.arraycopy(this.xValues, this.indexMin, this.xValues, 0, this.actualDataCount);
            System.arraycopy(this.yValues, this.indexMin, this.yValues, 0, this.actualDataCount);
            System.arraycopy(this.selected, this.indexMin, this.selected, 0, this.actualDataCount);
            if (this.errorType[0] != DataSetError.ErrorType.NO_ERROR) {
                System.arraycopy(this.errorXNeg, this.indexMin, this.errorXNeg, 0, this.actualDataCount);
                System.arraycopy(this.errorXPos, this.indexMin, this.errorXPos, 0, this.actualDataCount);
                System.arraycopy(this.errorYNeg, this.indexMin, this.errorYNeg, 0, this.actualDataCount);
                System.arraycopy(this.errorYPos, this.indexMin, this.errorYPos, 0, this.actualDataCount);
            } else if (this.errorType[1] != DataSetError.ErrorType.NO_ERROR) {
                System.arraycopy(this.errorYNeg, this.indexMin, this.errorYNeg, 0, this.actualDataCount);
                System.arraycopy(this.errorYPos, this.indexMin, this.errorYPos, 0, this.actualDataCount);
            }
            ProcessingProfiler.getTimeDiff(l2, String.format("no data reduction (%d)", this.actualDataCount));
            return;
        }
        this.actualDataCount = this.errorType[0] == DataSetError.ErrorType.NO_ERROR ? rendererDataReducer.reducePoints(this.xValues, this.yValues, null, null, this.errorYPos, this.errorYNeg, this.styles, this.selected, this.indexMin, this.indexMax) : rendererDataReducer.reducePoints(this.xValues, this.yValues, this.errorXPos, this.errorXNeg, this.errorYPos, this.errorYNeg, this.styles, this.selected, this.indexMin, this.indexMax);
        this.minDataPointDistanceX();
    }

    private void setBoundaryConditions(Axis axis, Axis axis2, DataSet dataSet, DataSetNode dataSetNode, int n2, int n3, ErrorStyle errorStyle, boolean bl2, boolean bl3) {
        this.indexMin = n2;
        this.indexMax = n3;
        this.polarPlot = bl2;
        this.allowForNaNs = bl3;
        this.rendererErrorStyle = errorStyle;
        this.hasStyles = dataSet.hasStyles();
        if (this.hasStyles) {
            this.styles = ArrayUtils.resizeMinNulled(this.styles, this.maxDataCount, String[]::new);
            dataSet.forEachStyle(n2, n3, this.styleSetter);
        } else {
            this.styles = ArrayUtils.resizeMin(this.styles, this.maxDataCount, String[]::new, false);
        }
        this.computeBoundaryVariables(axis, axis2);
        this.setErrorType(dataSet, errorStyle);
    }

    protected void setErrorType(DataSet dataSet, ErrorStyle errorStyle) {
        this.errorType = ArrayUtils.resizeMinNulled(this.errorType, dataSet.getDimension(), DataSetError.ErrorType[]::new);
        if (dataSet instanceof DataSetError) {
            DataSetError dataSetError = (DataSetError)dataSet;
            for (int i2 = 0; i2 < dataSetError.getDimension(); ++i2) {
                this.errorType[i2] = dataSetError.getErrorType(i2);
            }
        } else if (errorStyle == ErrorStyle.NONE) {
            for (int i3 = 0; i3 < dataSet.getDimension(); ++i3) {
                this.errorType[i3] = DataSetError.ErrorType.NO_ERROR;
            }
        } else {
            for (int i4 = 0; i4 < dataSet.getDimension(); ++i4) {
                this.errorType[i4] = i4 == 1 ? DataSetError.ErrorType.ASYMMETRIC : DataSetError.ErrorType.NO_ERROR;
            }
        }
    }
}

