/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi;

import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.axes.spi.AxisRange;
import io.fair_acc.chartfx.axes.spi.DefaultNumericAxis;
import io.fair_acc.chartfx.renderer.spi.AbstractPointReducingRenderer;
import io.fair_acc.chartfx.ui.geometry.Side;
import java.util.List;

public abstract class AbstractRendererXYZ<R extends AbstractRendererXYZ<R>>
extends AbstractPointReducingRenderer<R> {
    protected Axis zAxis;

    @Override
    public void updateAxes() {
        super.updateAxes();
        if (this.zAxis == null) {
            this.zAxis = this.ensureAxisInChart(this.getFirstZAxis((List<Axis>)this.getAxes(), false));
        }
        if (this.zAxis == null) {
            this.zAxis = this.getFirstZAxis((List<Axis>)this.getChart().getAxes(), true);
        }
        if (this.zAxis == null) {
            this.zAxis = this.ensureAxisInChart(AbstractRendererXYZ.createZAxis());
        }
    }

    @Override
    public void updateAxisRange(Axis axis, AxisRange axisRange) {
        super.updateAxisRange(axis, axisRange);
        if (axis == this.zAxis) {
            this.updateAxisRange(axisRange, 2);
        }
    }

    private Axis getFirstZAxis(List<Axis> list, boolean bl2) {
        Axis axis = null;
        for (Axis axis2 : list) {
            if (axis2 == this.xAxis || axis2 == this.yAxis) continue;
            if (axis2.getDimIndex() == 2) {
                return axis2;
            }
            if (axis != null) continue;
            axis = axis2;
        }
        return bl2 ? null : axis;
    }

    public static DefaultNumericAxis createZAxis() {
        DefaultNumericAxis defaultNumericAxis = new DefaultNumericAxis("z-Axis");
        defaultNumericAxis.setAnimated(false);
        defaultNumericAxis.setSide(Side.RIGHT);
        defaultNumericAxis.setDimIndex(2);
        return defaultNumericAxis;
    }

    public void shiftZAxisToLeft() {
        this.zAxis.setSide(Side.LEFT);
    }

    public void shiftZAxisToRight() {
        this.zAxis.setSide(Side.RIGHT);
    }
}

