/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi;

import io.fair_acc.chartfx.renderer.spi.utils.ChartIconFactory;
import java.security.InvalidParameterException;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public abstract class AbstractMetaDataRendererParameter<R extends AbstractMetaDataRendererParameter<R>> {
    protected static final String STYLE_CLASS_LABELLED_MARKER = "chart-meta-data";
    protected static final String DEFAULT_FONT = "Helvetica";
    protected static final int DEFAULT_FONT_SIZE = 18;
    protected static final Color DEFAULT_GRID_LINE_COLOR = Color.GREEN;
    protected static final double DEFAULT_GRID_LINE_WIDTH = 1.0;
    protected static final double[] DEFAULT_GRID_DASH_PATTERM = new double[]{3.0, 3.0};
    protected final StringProperty style = new SimpleStringProperty((Object)this, "style", null);
    protected final IntegerProperty indexOffset = new SimpleIntegerProperty((Object)this, "indexOffset", 0);
    protected Paint strokeColorMarker = DEFAULT_GRID_LINE_COLOR;
    protected double strokeLineWidthMarker = 1.0;
    protected double[] strokeDashPattern = DEFAULT_GRID_DASH_PATTERM;
    protected Node iconInfo = ChartIconFactory.getInfoIcon();
    protected Node iconWarning = ChartIconFactory.getWarningIcon();
    protected Node iconError = ChartIconFactory.getErrorIcon();
    protected final DoubleProperty iconSize = new SimpleDoubleProperty(this, "drawOnPane", 10.0){

        public void set(double d2) {
            if (d2 <= 0.0) {
                throw new InvalidParameterException("size should be >= 0, requested = " + d2);
            }
            super.set(d2);
            AbstractMetaDataRendererParameter.this.iconInfo = ChartIconFactory.getInfoIcon(d2);
            AbstractMetaDataRendererParameter.this.iconWarning = ChartIconFactory.getWarningIcon(d2);
            AbstractMetaDataRendererParameter.this.iconError = ChartIconFactory.getErrorIcon(d2);
        }
    };
    protected final BooleanProperty showInfoMessages = new SimpleBooleanProperty((Object)this, "showInfoMessages", true);
    protected final BooleanProperty showWarningMessages = new SimpleBooleanProperty((Object)this, "showWarningMessages", true);
    protected final BooleanProperty showErrorMessages = new SimpleBooleanProperty((Object)this, "showErrorMessages", true);

    public String getStyle() {
        return (String)this.style.get();
    }

    protected abstract R getThis();

    public boolean isShowErrorMessages() {
        return this.showErrorMessages.get();
    }

    public boolean isShowInfoMessages() {
        return this.showInfoMessages.get();
    }

    public boolean isShowWarningMessages() {
        return this.showWarningMessages.get();
    }

    public void setshowErrorMessages(boolean bl2) {
        this.showErrorMessages.set(bl2);
    }

    public void setshowInfoMessages(boolean bl2) {
        this.showInfoMessages.set(bl2);
    }

    public void setshowWarningMessages(boolean bl2) {
        this.showWarningMessages.set(bl2);
    }

    public R setStyle(String string) {
        this.style.set((Object)string);
        return this.getThis();
    }

    public BooleanProperty showErrorMessagesProperty() {
        return this.showErrorMessages;
    }

    public BooleanProperty showInfoMessagesProperty() {
        return this.showInfoMessages;
    }

    public BooleanProperty showWarningMessagesProperty() {
        return this.showWarningMessages;
    }

    public StringProperty styleProperty() {
        return this.style;
    }

    public int getGlobalIndexOffset() {
        return this.indexOffset.get();
    }

    public IntegerProperty indexOffsetProperty() {
        return this.indexOffset;
    }

    public void setGlobalIndexOffset(int n2) {
        this.indexOffset.set(n2);
    }

    public final R updateCSS() {
        this.strokeColorMarker = DEFAULT_GRID_LINE_COLOR;
        this.strokeLineWidthMarker = 1.0;
        this.strokeDashPattern = DEFAULT_GRID_DASH_PATTERM;
        return this.getThis();
    }
}

