/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.plugins;

import io.fair_acc.chartfx.Chart;
import io.fair_acc.chartfx.XYChart;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.axes.AxisMode;
import io.fair_acc.chartfx.plugins.ChartPlugin;
import io.fair_acc.chartfx.plugins.MouseEventsHelper;
import io.fair_acc.chartfx.ui.ObservableDeque;
import io.fair_acc.chartfx.ui.geometry.Side;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Separator;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.HBox;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;
import org.controlsfx.control.RangeSlider;
import org.kordamp.ikonli.javafx.FontIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Zoomer
extends ChartPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(Zoomer.class);
    public static final String ZOOMER_OMIT_AXIS = "OmitAxisZoom";
    public static final String STYLE_CLASS_ZOOM_RECT = "chart-zoom-rect";
    private static final int ZOOM_RECT_MIN_SIZE = 5;
    private static final Duration DEFAULT_ZOOM_DURATION = Duration.millis((double)500.0);
    private static final int DEFAULT_AUTO_ZOOM_THRESHOLD = 15;
    private static final int DEFAULT_FLICKER_THRESHOLD = 3;
    private static final int FONT_SIZE = 22;
    private static final String ICON_ZOOM_OUT = "fa-arrows-alt:22";
    private static final String ICON_ZOOM_HV = "fa-arrows:22";
    private static final String ICON_ZOOM_H = "fa-arrows-h:22";
    private static final String ICON_ZOOM_V = "fa-arrows-v:22";
    public static final Predicate<MouseEvent> DEFAULT_MOUSE_FILTER = MouseEventsHelper::isOnlyMiddleButtonDown;
    private double panShiftX;
    private double panShiftY;
    private Point2D previousMouseLocation;
    private final BooleanProperty enablePanner = new SimpleBooleanProperty((Object)this, "enablePanner", true);
    private final BooleanProperty autoZoomEnable = new SimpleBooleanProperty((Object)this, "enableAutoZoom", false);
    private final IntegerProperty autoZoomThreshold = new SimpleIntegerProperty((Object)this, "autoZoomThreshold", 15);
    private final EventHandler<MouseEvent> panStartHandler = mouseEvent -> {
        if (this.isPannerEnabled() && DEFAULT_MOUSE_FILTER.test((MouseEvent)mouseEvent)) {
            this.panStarted((MouseEvent)mouseEvent);
            mouseEvent.consume();
        }
    };
    private final EventHandler<MouseEvent> panDragHandler = mouseEvent -> {
        if (this.panOngoing()) {
            this.panDragged((MouseEvent)mouseEvent);
            mouseEvent.consume();
        }
    };
    private final EventHandler<MouseEvent> panEndHandler = mouseEvent -> {
        if (this.panOngoing()) {
            this.panEnded();
            mouseEvent.consume();
        }
    };
    public final Predicate<MouseEvent> defaultZoomInMouseFilter = mouseEvent -> MouseEventsHelper.isOnlyPrimaryButtonDown(mouseEvent) && MouseEventsHelper.modifierKeysUp(mouseEvent) && this.isMouseEventWithinCanvas((MouseEvent)mouseEvent);
    public final Predicate<MouseEvent> defaultZoomOutMouseFilter = mouseEvent -> MouseEventsHelper.isOnlySecondaryButtonDown(mouseEvent) && MouseEventsHelper.modifierKeysUp(mouseEvent) && this.isMouseEventWithinCanvas((MouseEvent)mouseEvent);
    public final Predicate<MouseEvent> defaultZoomOriginFilter = mouseEvent -> MouseEventsHelper.isOnlySecondaryButtonDown(mouseEvent) && MouseEventsHelper.isOnlyCtrlModifierDown(mouseEvent) && this.isMouseEventWithinCanvas((MouseEvent)mouseEvent);
    public final Predicate<ScrollEvent> defaultScrollFilter = this::isMouseEventWithinCanvas;
    private Predicate<MouseEvent> zoomInMouseFilter = this.defaultZoomInMouseFilter;
    private Predicate<MouseEvent> zoomOutMouseFilter = this.defaultZoomOutMouseFilter;
    private Predicate<MouseEvent> zoomOriginMouseFilter = this.defaultZoomOriginFilter;
    private Predicate<ScrollEvent> zoomScrollFilter = this.defaultScrollFilter;
    private final Rectangle zoomRectangle = new Rectangle();
    private Point2D zoomStartPoint;
    private Point2D zoomEndPoint;
    private final ObservableDeque<Map<Axis, ZoomState>> zoomStacks = new ObservableDeque(new ArrayDeque());
    private final HBox zoomButtons = this.getZoomInteractorBar();
    private ZoomRangeSlider xRangeSlider;
    private boolean xRangeSliderInit;
    private final ObservableList<Axis> omitAxisZoom = FXCollections.observableArrayList();
    private final ObjectProperty<AxisMode> axisMode = new SimpleObjectProperty<AxisMode>((Object)this, "axisMode", AxisMode.XY){

        protected void invalidated() {
            Objects.requireNonNull((AxisMode)((Object)this.get()), "The " + this.getName() + " must not be null");
        }
    };
    private Cursor originalCursor;
    private final ObjectProperty<Cursor> dragCursor = new SimpleObjectProperty((Object)this, "dragCursor");
    private final ObjectProperty<Cursor> zoomCursor = new SimpleObjectProperty((Object)this, "zoomCursor");
    private final BooleanProperty animated = new SimpleBooleanProperty((Object)this, "animated", false);
    private final ObjectProperty<Duration> zoomDuration = new SimpleObjectProperty<Duration>((Object)this, "zoomDuration", DEFAULT_ZOOM_DURATION){

        protected void invalidated() {
            Objects.requireNonNull((Duration)this.get(), "The " + this.getName() + " must not be null");
        }
    };
    private final BooleanProperty updateTickUnit = new SimpleBooleanProperty((Object)this, "updateTickUnit", true);
    private final BooleanProperty sliderVisible = new SimpleBooleanProperty((Object)this, "sliderVisible", true);
    private final EventHandler<MouseEvent> zoomInStartHandler = mouseEvent -> {
        if (this.getZoomInMouseFilter() == null || this.getZoomInMouseFilter().test((MouseEvent)mouseEvent)) {
            this.zoomInStarted((MouseEvent)mouseEvent);
            mouseEvent.consume();
        }
    };
    private final EventHandler<MouseEvent> zoomInDragHandler = mouseEvent -> {
        if (this.zoomOngoing()) {
            this.zoomInDragged((MouseEvent)mouseEvent);
            mouseEvent.consume();
        }
    };
    private final EventHandler<MouseEvent> zoomInEndHandler = mouseEvent -> {
        if (this.zoomOngoing()) {
            this.zoomInEnded();
            mouseEvent.consume();
        }
    };
    private final EventHandler<ScrollEvent> zoomScrollHandler = scrollEvent -> {
        if (this.getZoomScrollFilter() == null || this.getZoomScrollFilter().test((ScrollEvent)scrollEvent)) {
            AxisMode axisMode = this.getAxisMode();
            if (this.zoomStacks.isEmpty()) {
                this.makeSnapshotOfView();
            }
            for (Axis axis : this.getChart().getAxes()) {
                if (axis.getSide() == null || !(axis.getSide().isHorizontal() ? axisMode.allowsX() : axisMode.allowsY()) || this.isOmitZoomInternal(axis)) continue;
                Zoomer.zoomOnAxis(axis, scrollEvent);
            }
            scrollEvent.consume();
        }
    };
    private final EventHandler<MouseEvent> zoomOutHandler = mouseEvent -> {
        boolean bl2;
        if ((this.getZoomOutMouseFilter() == null || this.getZoomOutMouseFilter().test((MouseEvent)mouseEvent)) && (bl2 = this.zoomOut())) {
            mouseEvent.consume();
        }
    };
    private final EventHandler<MouseEvent> zoomOriginHandler = mouseEvent -> {
        boolean bl2;
        if ((this.getZoomOriginMouseFilter() == null || this.getZoomOriginMouseFilter().test((MouseEvent)mouseEvent)) && (bl2 = this.zoomOrigin())) {
            mouseEvent.consume();
        }
    };

    public Zoomer() {
        this(AxisMode.XY);
    }

    public Zoomer(AxisMode axisMode) {
        this(axisMode, false);
    }

    public Zoomer(AxisMode axisMode, boolean bl2) {
        this.setAxisMode(axisMode);
        this.setAnimated(bl2);
        this.setZoomCursor(Cursor.CROSSHAIR);
        this.setDragCursor(Cursor.CLOSED_HAND);
        this.zoomRectangle.setManaged(false);
        this.zoomRectangle.getStyleClass().add((Object)STYLE_CLASS_ZOOM_RECT);
        this.getChartChildren().add((Object)this.zoomRectangle);
        this.registerMouseHandlers();
        this.chartProperty().addListener((observableValue, chart, chart2) -> {
            if (chart != null) {
                chart.getToolBar().getChildren().remove((Object)this.zoomButtons);
                chart.getPlotArea().setBottom(null);
                this.xRangeSlider.prefWidthProperty().unbind();
            }
            if (chart2 != null) {
                if (this.isAddButtonsToToolBar()) {
                    chart2.getToolBar().getChildren().add((Object)this.zoomButtons);
                }
                ZoomRangeSlider zoomRangeSlider = new ZoomRangeSlider((Chart)chart2);
                if (this.isSliderVisible()) {
                    chart2.getPlotArea().setBottom((Node)zoomRangeSlider);
                    this.xRangeSlider.prefWidthProperty().bind((ObservableValue)chart2.getCanvasForeground().widthProperty());
                }
            }
        });
    }

    public Zoomer(boolean bl2) {
        this(AxisMode.XY, bl2);
    }

    public final BooleanProperty animatedProperty() {
        return this.animated;
    }

    public final BooleanProperty autoZoomEnabledProperty() {
        return this.autoZoomEnable;
    }

    public IntegerProperty autoZoomThresholdProperty() {
        return this.autoZoomThreshold;
    }

    public final ObjectProperty<AxisMode> axisModeProperty() {
        return this.axisMode;
    }

    public void clear() {
        this.zoomStacks.clear();
    }

    public void clear(Axis axis) {
        for (Map map : this.zoomStacks) {
            map.remove(axis);
        }
    }

    public final ObjectProperty<Cursor> dragCursorProperty() {
        return this.dragCursor;
    }

    public int getAutoZoomThreshold() {
        return this.autoZoomThresholdProperty().get();
    }

    public final AxisMode getAxisMode() {
        return (AxisMode)((Object)this.axisModeProperty().get());
    }

    public final Cursor getDragCursor() {
        return (Cursor)this.dragCursorProperty().get();
    }

    public RangeSlider getRangeSlider() {
        return this.xRangeSlider;
    }

    public final Cursor getZoomCursor() {
        return (Cursor)this.zoomCursorProperty().get();
    }

    public final Duration getZoomDuration() {
        return (Duration)this.zoomDurationProperty().get();
    }

    public Predicate<MouseEvent> getZoomInMouseFilter() {
        return this.zoomInMouseFilter;
    }

    public HBox getZoomInteractorBar() {
        Separator separator = new Separator();
        separator.setOrientation(Orientation.VERTICAL);
        HBox hBox = new HBox();
        hBox.setPadding(new Insets(1.0, 1.0, 1.0, 1.0));
        Button button = new Button(null, (Node)new FontIcon(ICON_ZOOM_OUT));
        button.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        button.setTooltip(new Tooltip("zooms to origin and enables auto-ranging"));
        Button button2 = new Button(null, (Node)new FontIcon(ICON_ZOOM_HV));
        button2.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        button2.setTooltip(new Tooltip("set zoom-mode to X & Y range (N.B. disables auto-ranging)"));
        Button button3 = new Button(null, (Node)new FontIcon(ICON_ZOOM_H));
        button3.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        button3.setTooltip(new Tooltip("set zoom-mode to X range (N.B. disables auto-ranging)"));
        Button button4 = new Button(null, (Node)new FontIcon(ICON_ZOOM_V));
        button4.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        button4.setTooltip(new Tooltip("set zoom-mode to Y range (N.B. disables auto-ranging)"));
        button.setOnAction(actionEvent -> {
            this.zoomOrigin();
            this.getChart().getAxes().forEach(axis -> axis.setAutoRanging(true));
        });
        button2.setOnAction(actionEvent -> this.setAxisMode(AxisMode.XY));
        button3.setOnAction(actionEvent -> this.setAxisMode(AxisMode.X));
        button4.setOnAction(actionEvent -> this.setAxisMode(AxisMode.Y));
        hBox.getChildren().addAll((Object[])new Node[]{separator, button, button2, button3, button4});
        return hBox;
    }

    public Predicate<MouseEvent> getZoomOriginMouseFilter() {
        return this.zoomOriginMouseFilter;
    }

    public Predicate<MouseEvent> getZoomOutMouseFilter() {
        return this.zoomOutMouseFilter;
    }

    public Predicate<ScrollEvent> getZoomScrollFilter() {
        return this.zoomScrollFilter;
    }

    public final boolean isAnimated() {
        return this.animatedProperty().get();
    }

    public final boolean isAutoZoomEnabled() {
        return this.autoZoomEnabledProperty().get();
    }

    public final boolean isPannerEnabled() {
        return this.pannerEnabledProperty().get();
    }

    public final boolean isSliderVisible() {
        return this.sliderVisibleProperty().get();
    }

    public final boolean isUpdateTickUnit() {
        return this.updateTickUnitProperty().get();
    }

    public final ObservableList<Axis> omitAxisZoomList() {
        return this.omitAxisZoom;
    }

    public final BooleanProperty pannerEnabledProperty() {
        return this.enablePanner;
    }

    public final void setAnimated(boolean bl2) {
        this.animatedProperty().set(bl2);
    }

    public final void setAutoZoomEnabled(boolean bl2) {
        this.autoZoomEnabledProperty().set(bl2);
    }

    public void setAutoZoomThreshold(int n2) {
        this.autoZoomThresholdProperty().set(n2);
    }

    public final void setAxisMode(AxisMode axisMode) {
        this.axisModeProperty().set((Object)axisMode);
    }

    public final void setDragCursor(Cursor cursor) {
        this.dragCursorProperty().set((Object)cursor);
    }

    public final void setPannerEnabled(boolean bl2) {
        this.pannerEnabledProperty().set(bl2);
    }

    public final void setSliderVisible(boolean bl2) {
        this.sliderVisibleProperty().set(bl2);
    }

    public final void setUpdateTickUnit(boolean bl2) {
        this.updateTickUnitProperty().set(bl2);
    }

    public final void setZoomCursor(Cursor cursor) {
        this.zoomCursorProperty().set((Object)cursor);
    }

    public final void setZoomDuration(Duration duration) {
        this.zoomDurationProperty().set((Object)duration);
    }

    public void setZoomInMouseFilter(Predicate<MouseEvent> predicate) {
        this.zoomInMouseFilter = predicate;
    }

    public void setZoomOriginMouseFilter(Predicate<MouseEvent> predicate) {
        this.zoomOriginMouseFilter = predicate;
    }

    public void setZoomOutMouseFilter(Predicate<MouseEvent> predicate) {
        this.zoomOutMouseFilter = predicate;
    }

    public void setZoomScrollFilter(Predicate<ScrollEvent> predicate) {
        this.zoomScrollFilter = predicate;
    }

    public final BooleanProperty sliderVisibleProperty() {
        return this.sliderVisible;
    }

    public final BooleanProperty updateTickUnitProperty() {
        return this.updateTickUnit;
    }

    public final ObjectProperty<Cursor> zoomCursorProperty() {
        return this.zoomCursor;
    }

    public final ObjectProperty<Duration> zoomDurationProperty() {
        return this.zoomDuration;
    }

    public boolean zoomOrigin() {
        this.clearZoomStackIfAxisAutoRangingIsEnabled();
        Map<Axis, ZoomState> map = this.zoomStacks.peekLast();
        if (map == null || map.isEmpty()) {
            return false;
        }
        this.clear();
        this.performZoom(map, false);
        if (this.xRangeSlider != null) {
            this.xRangeSlider.reset();
        }
        for (Axis axis : this.getChart().getAxes()) {
            axis.forceRedraw();
        }
        return true;
    }

    public ObservableDeque<Map<Axis, ZoomState>> zoomStackDeque() {
        return this.zoomStacks;
    }

    private void clearZoomStackIfAxisAutoRangingIsEnabled() {
        Chart chart = this.getChart();
        if (chart == null) {
            return;
        }
        for (Axis axis : this.getChart().getAxes()) {
            if (axis.getSide().isHorizontal()) {
                if (!this.getAxisMode().allowsX() || !axis.isAutoRanging() && !axis.isAutoGrowRanging()) continue;
                this.clear(axis);
                continue;
            }
            if (!this.getAxisMode().allowsY() || !axis.isAutoRanging() && !axis.isAutoGrowRanging()) continue;
            this.clear(axis);
        }
    }

    private Map<Axis, ZoomState> getZoomDataWindows() {
        HashMap<Axis, ZoomState> hashMap = new HashMap<Axis, ZoomState>();
        if (this.getChart() == null) {
            return hashMap;
        }
        double d2 = this.zoomRectangle.getX();
        double d3 = this.zoomRectangle.getY() + this.zoomRectangle.getHeight();
        double d4 = this.zoomRectangle.getX() + this.zoomRectangle.getWidth();
        double d5 = this.zoomRectangle.getY();
        Point2D point2D = this.getChart().toPlotArea(d2, d3);
        Point2D point2D2 = this.getChart().toPlotArea(d4, d5);
        block4: for (Axis axis : this.getChart().getAxes()) {
            double d6;
            double d7;
            if (axis.getSide().isVertical()) {
                d7 = axis.getValueForDisplay(point2D.getY());
                d6 = axis.getValueForDisplay(point2D2.getY());
            } else {
                d7 = axis.getValueForDisplay(point2D.getX());
                d6 = axis.getValueForDisplay(point2D2.getX());
            }
            switch (this.getAxisMode()) {
                case X: {
                    if (!axis.getSide().isHorizontal()) continue block4;
                    hashMap.put(axis, new ZoomState(d7, d6, axis.isAutoRanging(), axis.isAutoGrowRanging()));
                    continue block4;
                }
                case Y: {
                    if (!axis.getSide().isVertical()) continue block4;
                    hashMap.put(axis, new ZoomState(d7, d6, axis.isAutoRanging(), axis.isAutoGrowRanging()));
                    continue block4;
                }
            }
            hashMap.put(axis, new ZoomState(d7, d6, axis.isAutoRanging(), axis.isAutoGrowRanging()));
        }
        return hashMap;
    }

    private void installDragCursor() {
        Chart chart = this.getChart();
        this.originalCursor = chart.getCursor();
        if (this.getDragCursor() != null) {
            chart.setCursor(this.getDragCursor());
        }
    }

    private void installZoomCursor() {
        Chart chart = this.getChart();
        this.originalCursor = chart.getCursor();
        if (this.getDragCursor() != null) {
            chart.setCursor(this.getZoomCursor());
        }
    }

    private boolean isOmitZoomInternal(Axis axis) {
        boolean bl2 = Zoomer.isOmitZoom(axis);
        return bl2 || this.omitAxisZoomList().contains((Object)axis);
    }

    private void makeSnapshotOfView() {
        Bounds bounds = this.getChart().getBoundsInLocal();
        double d2 = bounds.getMinX();
        double d3 = bounds.getMinY();
        double d4 = bounds.getMaxX();
        double d5 = bounds.getMaxY();
        this.zoomRectangle.setX(bounds.getMinX());
        this.zoomRectangle.setY(bounds.getMinY());
        this.zoomRectangle.setWidth(d4 - d2);
        this.zoomRectangle.setHeight(d5 - d3);
        this.pushCurrentZoomWindows();
        this.performZoom(this.getZoomDataWindows(), true);
        this.zoomRectangle.setVisible(false);
    }

    private void panChart(Chart chart, Point2D point2D) {
        if (!(chart instanceof XYChart)) {
            return;
        }
        double d2 = this.previousMouseLocation.getX();
        double d3 = this.previousMouseLocation.getY();
        double d4 = point2D.getX();
        double d5 = point2D.getY();
        this.panShiftX += d2 - d4;
        this.panShiftY += d3 - d5;
        for (Axis axis : chart.getAxes()) {
            boolean bl2;
            if (axis.getSide() == null || this.isOmitZoomInternal(axis)) continue;
            Side side = axis.getSide();
            boolean bl3 = bl2 = side.isHorizontal() ? this.getAxisMode().allowsX() : this.getAxisMode().allowsY();
            if (Zoomer.hasBoundedRange(axis) || !bl2) continue;
            double d6 = (side.isHorizontal() ? d2 : d3) - (side.isHorizontal() ? d4 : d5);
            axis.setAutoRanging(false);
            double d7 = axis.getValueForDisplay(0.0 + d6);
            double d8 = axis.getValueForDisplay(axis.getLength() + d6);
            if (side.isHorizontal()) {
                axis.set(d7, d8);
            } else {
                axis.set(d8, d7);
            }
            axis.updateCachedTransforms();
        }
        this.previousMouseLocation = point2D;
    }

    private void panDragged(MouseEvent mouseEvent) {
        Point2D point2D = this.getLocationInPlotArea(mouseEvent);
        this.panChart(this.getChart(), point2D);
        this.previousMouseLocation = point2D;
    }

    private void panEnded() {
        Chart chart = this.getChart();
        if (chart == null || this.panShiftX == 0.0 || this.panShiftY == 0.0 || this.previousMouseLocation == null) {
            return;
        }
        for (Axis axis : chart.getAxes()) {
            boolean bl2;
            if (axis.getSide() == null || this.isOmitZoomInternal(axis)) continue;
            Side side = axis.getSide();
            boolean bl3 = bl2 = side.isHorizontal() ? this.getAxisMode().allowsX() : this.getAxisMode().allowsY();
            if (Zoomer.hasBoundedRange(axis) || !bl2) continue;
            axis.setAutoRanging(false);
        }
        this.panShiftX = 0.0;
        this.panShiftY = 0.0;
        this.previousMouseLocation = null;
        this.uninstallCursor();
    }

    protected static boolean hasBoundedRange(Axis axis) {
        return axis.minProperty().isBound() || axis.maxProperty().isBound();
    }

    private boolean panOngoing() {
        return this.previousMouseLocation != null;
    }

    private void panStarted(MouseEvent mouseEvent) {
        this.previousMouseLocation = this.getLocationInPlotArea(mouseEvent);
        this.panShiftX = 0.0;
        this.panShiftY = 0.0;
        this.installDragCursor();
        this.clearZoomStackIfAxisAutoRangingIsEnabled();
        this.pushCurrentZoomWindows();
    }

    private void performZoom(Map.Entry<Axis, ZoomState> entry, boolean bl2) {
        ZoomState zoomState = entry.getValue();
        if (zoomState.zoomRangeMax - zoomState.zoomRangeMin == 0.0) {
            LOGGER.atDebug().log("Cannot zoom in deeper than numerical precision");
            return;
        }
        Axis axis = entry.getKey();
        if (bl2 && (axis.getSide().isHorizontal() && this.getAxisMode().allowsX() || axis.getSide().isVertical() && this.getAxisMode().allowsY())) {
            axis.setAutoRanging(false);
        }
        if (this.isAnimated()) {
            if (!Zoomer.hasBoundedRange(axis)) {
                Timeline timeline = new Timeline();
                timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)axis.minProperty(), (Object)axis.getMin()), new KeyValue((WritableValue)axis.maxProperty(), (Object)axis.getMax())}), new KeyFrame(this.getZoomDuration(), new KeyValue[]{new KeyValue((WritableValue)axis.minProperty(), (Object)zoomState.zoomRangeMin), new KeyValue((WritableValue)axis.maxProperty(), (Object)zoomState.zoomRangeMax)})});
                timeline.play();
            }
        } else if (!Zoomer.hasBoundedRange(axis)) {
            axis.set(zoomState.zoomRangeMin, zoomState.zoomRangeMax);
            axis.updateCachedTransforms();
        }
        if (!bl2) {
            axis.setAutoRanging(zoomState.wasAutoRanging);
            axis.setAutoGrowRanging(zoomState.wasAutoGrowRanging);
        }
    }

    private void performZoom(Map<Axis, ZoomState> map, boolean bl2) {
        for (Map.Entry<Axis, ZoomState> entry : map.entrySet()) {
            if (this.isOmitZoomInternal(entry.getKey())) continue;
            this.performZoom(entry, bl2);
        }
        for (Map.Entry<Axis, ZoomState> entry : this.getChart().getAxes()) {
            entry.forceRedraw();
        }
    }

    private void performZoomIn() {
        this.clearZoomStackIfAxisAutoRangingIsEnabled();
        this.pushCurrentZoomWindows();
        this.performZoom(this.getZoomDataWindows(), true);
    }

    private void pushCurrentZoomWindows() {
        if (this.getChart() == null) {
            return;
        }
        HashMap<Axis, ZoomState> hashMap = new HashMap<Axis, ZoomState>();
        block4: for (Axis axis : this.getChart().getAxes()) {
            switch (this.getAxisMode()) {
                case X: {
                    if (!axis.getSide().isHorizontal()) continue block4;
                    hashMap.put(axis, new ZoomState(axis.getMin(), axis.getMax(), axis.isAutoRanging(), axis.isAutoGrowRanging()));
                    continue block4;
                }
                case Y: {
                    if (!axis.getSide().isVertical()) continue block4;
                    hashMap.put(axis, new ZoomState(axis.getMin(), axis.getMax(), axis.isAutoRanging(), axis.isAutoGrowRanging()));
                    continue block4;
                }
            }
            hashMap.put(axis, new ZoomState(axis.getMin(), axis.getMax(), axis.isAutoRanging(), axis.isAutoGrowRanging()));
        }
        if (!hashMap.keySet().isEmpty()) {
            this.zoomStacks.addFirst(hashMap);
        }
    }

    private void registerMouseHandlers() {
        this.registerInputEventHandler(MouseEvent.MOUSE_PRESSED, this.zoomInStartHandler);
        this.registerInputEventHandler(MouseEvent.MOUSE_DRAGGED, this.zoomInDragHandler);
        this.registerInputEventHandler(MouseEvent.MOUSE_RELEASED, this.zoomInEndHandler);
        this.registerInputEventHandler(MouseEvent.MOUSE_CLICKED, this.zoomOutHandler);
        this.registerInputEventHandler(MouseEvent.MOUSE_CLICKED, this.zoomOriginHandler);
        this.registerInputEventHandler(ScrollEvent.SCROLL, this.zoomScrollHandler);
        this.registerInputEventHandler(MouseEvent.MOUSE_PRESSED, this.panStartHandler);
        this.registerInputEventHandler(MouseEvent.MOUSE_DRAGGED, this.panDragHandler);
        this.registerInputEventHandler(MouseEvent.MOUSE_RELEASED, this.panEndHandler);
    }

    private void uninstallCursor() {
        this.getChart().setCursor(this.originalCursor);
    }

    private void zoomInDragged(MouseEvent mouseEvent) {
        Bounds bounds = this.getChart().getPlotArea().getBoundsInLocal();
        this.zoomEndPoint = Zoomer.limitToPlotArea(mouseEvent, bounds);
        double d2 = bounds.getMinX();
        double d3 = bounds.getMinY();
        double d4 = bounds.getWidth();
        double d5 = bounds.getHeight();
        if (this.isAutoZoomEnabled()) {
            boolean bl2;
            double d6 = this.zoomEndPoint.getX() - this.zoomStartPoint.getX();
            double d7 = this.zoomEndPoint.getY() - this.zoomStartPoint.getY();
            int n2 = Math.abs(this.getAutoZoomThreshold());
            boolean bl3 = Math.abs(d7) <= (double)n2 && Math.abs(d6) >= (double)n2 && Math.abs(d6 / d7) > 3.0;
            boolean bl4 = bl2 = Math.abs(d6) <= (double)n2 && Math.abs(d7) >= (double)n2 && Math.abs(d7 / d6) > 3.0;
            if (bl3) {
                this.setAxisMode(AxisMode.X);
            } else if (bl2) {
                this.setAxisMode(AxisMode.Y);
            } else {
                this.setAxisMode(AxisMode.XY);
            }
        }
        if (this.getAxisMode().allowsX()) {
            d2 = Math.min(this.zoomStartPoint.getX(), this.zoomEndPoint.getX());
            d4 = Math.abs(this.zoomEndPoint.getX() - this.zoomStartPoint.getX());
        }
        if (this.getAxisMode().allowsY()) {
            d3 = Math.min(this.zoomStartPoint.getY(), this.zoomEndPoint.getY());
            d5 = Math.abs(this.zoomEndPoint.getY() - this.zoomStartPoint.getY());
        }
        this.zoomRectangle.setX(d2);
        this.zoomRectangle.setY(d3);
        this.zoomRectangle.setWidth(d4);
        this.zoomRectangle.setHeight(d5);
    }

    private void zoomInEnded() {
        this.zoomRectangle.setVisible(false);
        if (this.zoomRectangle.getWidth() > 5.0 && this.zoomRectangle.getHeight() > 5.0) {
            this.performZoomIn();
        }
        this.zoomEndPoint = null;
        this.zoomStartPoint = null;
        this.uninstallCursor();
    }

    private void zoomInStarted(MouseEvent mouseEvent) {
        this.zoomStartPoint = new Point2D(mouseEvent.getX(), mouseEvent.getY());
        this.zoomRectangle.setX(this.zoomStartPoint.getX());
        this.zoomRectangle.setY(this.zoomStartPoint.getY());
        this.zoomRectangle.setWidth(0.0);
        this.zoomRectangle.setHeight(0.0);
        this.zoomRectangle.setVisible(true);
        this.installZoomCursor();
    }

    private boolean zoomOngoing() {
        return this.zoomStartPoint != null;
    }

    private boolean zoomOut() {
        this.clearZoomStackIfAxisAutoRangingIsEnabled();
        Map<Axis, ZoomState> map = this.zoomStacks.pollFirst();
        if (map == null || map.isEmpty()) {
            return this.zoomOrigin();
        }
        this.performZoom(map, false);
        return true;
    }

    public static boolean isOmitZoom(Axis axis) {
        return axis instanceof Node && ((Node)axis).getProperties().get((Object)ZOOMER_OMIT_AXIS) == Boolean.TRUE;
    }

    public static void setOmitZoom(Axis axis, boolean bl2) {
        if (!(axis instanceof Node)) {
            return;
        }
        if (bl2) {
            ((Node)axis).getProperties().put((Object)ZOOMER_OMIT_AXIS, (Object)true);
        } else {
            ((Node)axis).getProperties().remove((Object)ZOOMER_OMIT_AXIS);
        }
    }

    private static Point2D limitToPlotArea(MouseEvent mouseEvent, Bounds bounds) {
        double d2 = Math.max(Math.min(mouseEvent.getX() - bounds.getMinX(), bounds.getMaxX()), bounds.getMinX());
        double d3 = Math.max(Math.min(mouseEvent.getY() - bounds.getMinY(), bounds.getMaxY()), bounds.getMinY());
        return new Point2D(d2, d3);
    }

    private static void zoomOnAxis(Axis axis, ScrollEvent scrollEvent) {
        double d2;
        double d3;
        double d4;
        if (Zoomer.hasBoundedRange(axis) || scrollEvent.getDeltaY() == 0.0) {
            return;
        }
        boolean bl2 = scrollEvent.getDeltaY() > 0.0;
        boolean bl3 = axis.getSide().isHorizontal();
        double d5 = bl3 ? scrollEvent.getX() : scrollEvent.getY();
        double d6 = axis.getLength();
        double d7 = d4 = bl2 ? 0.9 : 1.1111111111111112;
        if (bl3) {
            d3 = (1.0 - d4) * d5;
            d2 = d5 + d4 * (d6 - d5);
        } else {
            d2 = (1.0 - d4) * d5;
            d3 = d5 + d4 * (d6 - d5);
        }
        double d8 = axis.getValueForDisplay(d3);
        double d9 = axis.getValueForDisplay(d2);
        axis.set(d8, d9);
        axis.updateCachedTransforms();
        axis.forceRedraw();
    }

    private class ZoomRangeSlider
    extends RangeSlider {
        private final BooleanProperty invertedSlide = new SimpleBooleanProperty((Object)this, "invertedSlide", false);
        private boolean isUpdating;
        private final ChangeListener<Boolean> sliderResetHandler = (observableValue, bl2, bl3) -> this.resetSlider((Boolean)bl3);
        private final ChangeListener<Number> rangeChangeListener = (observableValue, number, number2) -> {
            if (this.isUpdating) {
                return;
            }
            this.isUpdating = true;
            Axis axis = Zoomer.this.getChart().getFirstAxis(Orientation.HORIZONTAL);
            axis.getMax();
            axis.getMin();
            double d2 = Math.min(axis.getMin(), this.getMin());
            double d3 = Math.max(axis.getMax(), this.getMax());
            if (Zoomer.this.xRangeSliderInit) {
                this.setMin(d2);
                this.setMax(d3);
            }
            this.isUpdating = false;
        };
        private final ChangeListener<Number> sliderValueChanged = (observableValue, number, number2) -> {
            if (!Zoomer.this.isSliderVisible() || number2 == null || this.isUpdating) {
                return;
            }
            this.isUpdating = true;
            Axis axis = Zoomer.this.getChart().getFirstAxis(Orientation.HORIZONTAL);
            if (axis.isAutoRanging() || axis.isAutoGrowRanging()) {
                this.setMin(axis.getMin());
                this.setMax(axis.getMax());
                this.isUpdating = false;
                return;
            }
            this.isUpdating = false;
        };
        private final EventHandler<? super MouseEvent> mouseEventHandler = mouseEvent -> {
            if (Zoomer.this.zoomStacks.isEmpty()) {
                Zoomer.this.makeSnapshotOfView();
            }
            Axis axis = Zoomer.this.getChart().getFirstAxis(Orientation.HORIZONTAL);
            axis.setAutoRanging(false);
            axis.setAutoGrowRanging(false);
            axis.set(this.getLowValue(), this.getHighValue());
        };

        protected void resetSlider(Boolean bl2) {
            if (Zoomer.this.getChart() == null) {
                return;
            }
            Axis axis = Zoomer.this.getChart().getFirstAxis(Orientation.HORIZONTAL);
            if (Boolean.TRUE.equals(bl2)) {
                this.setMin(axis.getMin());
                this.setMax(axis.getMax());
            }
        }

        public ZoomRangeSlider(Chart chart) {
            Axis axis = chart.getFirstAxis(Orientation.HORIZONTAL);
            Zoomer.this.xRangeSlider = this;
            this.setPrefWidth(-1.0);
            this.setMaxWidth(Double.MAX_VALUE);
            axis.invertAxisProperty().bindBidirectional((Property)this.invertedSlide);
            this.invertedSlide.addListener((observableValue, bl2, bl3) -> this.setRotate(Boolean.TRUE.equals(bl3) ? 180.0 : 0.0));
            axis.autoRangingProperty().addListener(this.sliderResetHandler);
            axis.autoGrowRangingProperty().addListener(this.sliderResetHandler);
            axis.minProperty().addListener(this.rangeChangeListener);
            axis.maxProperty().addListener(this.rangeChangeListener);
            this.lowValueProperty().addListener(this.sliderValueChanged);
            this.highValueProperty().addListener(this.sliderValueChanged);
            this.setOnMouseReleased(this.mouseEventHandler);
            this.lowValueProperty().bindBidirectional((Property)axis.minProperty());
            this.highValueProperty().bindBidirectional((Property)axis.maxProperty());
            Zoomer.this.sliderVisibleProperty().addListener((observableValue, bl2, bl3) -> {
                if (Zoomer.this.getChart() == null || bl3.equals(bl2) || this.isUpdating) {
                    return;
                }
                this.isUpdating = true;
                if (Boolean.TRUE.equals(bl3)) {
                    Zoomer.this.getChart().getPlotArea().setBottom((Node)Zoomer.this.xRangeSlider);
                    this.prefWidthProperty().bind((ObservableValue)Zoomer.this.getChart().getCanvasForeground().widthProperty());
                } else {
                    Zoomer.this.getChart().getPlotArea().setBottom(null);
                    this.prefWidthProperty().unbind();
                }
                this.isUpdating = false;
            });
            Zoomer.this.addButtonsToToolBarProperty().addListener((observableValue, bl2, bl3) -> {
                Chart chart = Zoomer.this.getChart();
                if (chart == null || bl3.equals(bl2)) {
                    return;
                }
                if (Boolean.TRUE.equals(bl3)) {
                    chart.getToolBar().getChildren().add((Object)Zoomer.this.zoomButtons);
                } else {
                    chart.getToolBar().getChildren().remove((Object)Zoomer.this.zoomButtons);
                }
            });
            Zoomer.this.xRangeSliderInit = true;
        }

        public void reset() {
            this.resetSlider(true);
        }
    }

    public static class ZoomState {
        protected double zoomRangeMin;
        protected double zoomRangeMax;
        protected boolean wasAutoRanging;
        protected boolean wasAutoGrowRanging;

        private ZoomState(double d2, double d3, boolean bl2, boolean bl3) {
            this.zoomRangeMin = Math.min(d2, d3);
            this.zoomRangeMax = Math.max(d2, d3);
            this.wasAutoRanging = bl2;
            this.wasAutoGrowRanging = bl3;
        }

        public double getZoomRangeMax() {
            return this.zoomRangeMax;
        }

        public double getZoomRangeMin() {
            return this.zoomRangeMin;
        }

        public String toString() {
            return "ZoomState[zoomRangeMin= " + this.zoomRangeMin + ", zoomRangeMax= " + this.zoomRangeMax + ", wasAutoRanging= " + this.wasAutoRanging + ", wasAutoGrowRanging= " + this.wasAutoGrowRanging + "]";
        }

        public boolean wasAutoGrowRanging() {
            return this.wasAutoGrowRanging;
        }

        public boolean wasAutoRanging() {
            return this.wasAutoRanging;
        }
    }
}

