/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.plugins;

import io.fair_acc.chartfx.Chart;
import io.fair_acc.chartfx.XYChart;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.plugins.ChartPlugin;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.chartfx.utils.FXUtils;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.events.StateListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javafx.beans.value.ChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class UpdateAxisLabels
extends ChartPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateAxisLabels.class);
    private final Map<Renderer, Map<DataSet, StateListener>> rendererDataSetsListeners = new HashMap<Renderer, Map<DataSet, StateListener>>();
    private final Map<DataSet, StateListener> chartDataSetsListeners = new HashMap<DataSet, StateListener>();
    private final Map<Renderer, ListChangeListener<DataSet>> renderersListeners = new HashMap<Renderer, ListChangeListener<DataSet>>();
    private final ListChangeListener<Renderer> renderersListener = change2 -> {
        while (change2.next()) {
            if (change2.wasAdded()) {
                for (Renderer renderer : change2.getAddedSubList()) {
                    ListChangeListener listChangeListener = change -> {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.atDebug().log("update listener -> dataSetsChanged ");
                        }
                        this.dataSetsChanged((ListChangeListener.Change<? extends DataSet>)change, renderer);
                    };
                    renderer.getDatasets().forEach(dataSet -> this.dataSetChange((DataSet)dataSet, renderer));
                    renderer.getDatasets().addListener(listChangeListener);
                    this.renderersListeners.put(renderer, (ListChangeListener<DataSet>)listChangeListener);
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.atDebug().addArgument(renderer.getClass().getSimpleName()).addArgument(this.rendererDataSetsListeners.size()).log("added listener for render {}, number of data set listeners {}");
                }
            }
            if (!change2.wasRemoved()) continue;
            for (Renderer renderer : change2.getRemoved()) {
                renderer.getDatasets().removeListener(this.renderersListeners.get(renderer));
                this.renderersListeners.remove(renderer);
            }
        }
    };
    private final ChangeListener<? super Chart> chartChangeListener = (observableValue, chart, chart2) -> {
        this.removeRendererAndDataSetListener((XYChart)chart);
        this.addRendererAndDataSetListener((XYChart)chart2);
    };

    public UpdateAxisLabels() {
        this.chartProperty().addListener(this.chartChangeListener);
        this.addRendererAndDataSetListener(this.getXYChart());
    }

    private void addRendererAndDataSetListener(XYChart xYChart) {
        if (xYChart == null) {
            return;
        }
        this.setupDataSetListeners(null, xYChart.getDatasets());
        xYChart.getRenderers().addListener(this.renderersListener);
        xYChart.getRenderers().forEach(renderer -> this.setupDataSetListeners((Renderer)renderer, renderer.getDatasets()));
    }

    private XYChart getXYChart() {
        return (XYChart)super.getChart();
    }

    private void dataSetChange(DataSet dataSet, Renderer renderer) {
        if (renderer == null) {
            if (this.getXYChart().getDatasets().size() == 1) {
                int n2 = 0;
                while (n2 < dataSet.getDimension()) {
                    int n3 = n2++;
                    Optional<Axis> optional = this.getChart().getAxes().stream().filter(axis -> axis.getDimIndex() == n3).findFirst();
                    optional.ifPresent(axis -> axis.set(dataSet.getAxisDescription(n3).getName(), dataSet.getAxisDescription(n3).getUnit()));
                }
            } else if (LOGGER.isWarnEnabled()) {
                LOGGER.atWarn().log("Applying axis information not possible for more than one DataSet added to chart. Please add datasets to separate Renderers");
            }
        } else if (renderer.getDatasets().size() == 1) {
            int n4 = 0;
            while (n4 < dataSet.getDimension()) {
                int n5 = n4++;
                Optional<Axis> optional = renderer.getAxes().stream().filter(axis -> axis.getDimIndex() == n5).findFirst().or(() -> this.getChart().getAxes().stream().filter(axis -> axis.getDimIndex() == n5).findFirst());
                optional.ifPresent(axis -> axis.set(dataSet.getAxisDescription(n5).getName(), dataSet.getAxisDescription(n5).getUnit()));
            }
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.atWarn().log("Applying axis information not possible for more than one DataSet added to renderer. Please add datasets to separate Renderers");
        }
    }

    private void dataSetsChanged(ListChangeListener.Change<? extends DataSet> change, Renderer renderer) {
        Map<DataSet, StateListener> map;
        if (renderer == null) {
            map = this.chartDataSetsListeners;
        } else if (this.rendererDataSetsListeners.containsKey(renderer)) {
            map = this.rendererDataSetsListeners.get(renderer);
        } else {
            map = new HashMap<DataSet, StateListener>();
            this.rendererDataSetsListeners.put(renderer, map);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().log("dataSetsChanged added/removed - invoked");
        }
        while (change.next()) {
            StateListener stateListener;
            if (change.wasAdded()) {
                for (DataSet dataSet : change.getAddedSubList()) {
                    stateListener = FXUtils.runOnFxThread((bitState, n2) -> this.dataSetChange(dataSet, renderer));
                    dataSet.getBitState().addChangeListener(ChartBits.DataSetName, stateListener);
                    map.put(dataSet, stateListener);
                }
            }
            if (!change.wasRemoved()) continue;
            for (DataSet dataSet : change.getRemoved()) {
                stateListener = map.get(dataSet);
                if (stateListener == null) continue;
                dataSet.removeListener(stateListener);
                map.remove(dataSet);
            }
        }
    }

    private void removeRendererAndDataSetListener(XYChart xYChart) {
        if (xYChart == null) {
            return;
        }
        this.teardownDataSetListeners(null, xYChart.getDatasets());
        xYChart.getRenderers().removeListener(this.renderersListener);
        xYChart.getRenderers().forEach(renderer -> this.teardownDataSetListeners((Renderer)renderer, renderer.getDatasets()));
    }

    private void setupDataSetListeners(Renderer renderer, ObservableList<DataSet> observableList) {
        Map<DataSet, StateListener> map;
        if (renderer == null) {
            map = this.chartDataSetsListeners;
        } else if (this.rendererDataSetsListeners.containsKey(renderer)) {
            map = this.rendererDataSetsListeners.get(renderer);
        } else {
            map = new HashMap<DataSet, StateListener>();
            this.rendererDataSetsListeners.put(renderer, map);
        }
        ListChangeListener listChangeListener = change -> this.dataSetsChanged((ListChangeListener.Change<? extends DataSet>)change, renderer);
        observableList.addListener(listChangeListener);
        this.renderersListeners.put(renderer, (ListChangeListener<DataSet>)listChangeListener);
        observableList.forEach(dataSet -> {
            StateListener stateListener = FXUtils.runOnFxThread((bitState, n2) -> this.dataSetChange((DataSet)dataSet, renderer));
            dataSet.getBitState().addChangeListener(ChartBits.DataSetName, stateListener);
            map.put((DataSet)dataSet, stateListener);
        });
    }

    private void teardownDataSetListeners(Renderer renderer, ObservableList<DataSet> observableList) {
        Map<DataSet, StateListener> map;
        if (renderer == null) {
            map = this.chartDataSetsListeners;
        } else if (this.rendererDataSetsListeners.containsKey(renderer)) {
            map = this.rendererDataSetsListeners.get(renderer);
        } else {
            map = new HashMap<DataSet, StateListener>();
            this.rendererDataSetsListeners.put(renderer, map);
        }
        observableList.removeListener(this.renderersListeners.get(renderer));
        this.renderersListeners.remove(renderer);
        observableList.forEach(dataSet -> {
            dataSet.removeListener((StateListener)map.get(dataSet));
            map.remove(dataSet);
        });
    }
}

