/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.plugins;

import io.fair_acc.chartfx.Chart;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.axes.AxisMode;
import io.fair_acc.chartfx.axes.spi.AbstractAxis;
import io.fair_acc.chartfx.axes.spi.DefaultNumericAxis;
import io.fair_acc.chartfx.plugins.ChartPlugin;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.util.Duration;
import javafx.util.StringConverter;
import javafx.util.converter.NumberStringConverter;
import org.controlsfx.control.PopOver;
import org.kordamp.ikonli.javafx.FontIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditAxis
extends ChartPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditAxis.class);
    public static final String STYLE_CLASS_AXIS_EDITOR = "chart-axis-editor";
    protected static final int DEFAULT_SHUTDOWN_PERIOD = 5000;
    protected static final int DEFAULT_UPDATE_PERIOD = 100;
    protected static final int DEFAULT_PREFERRED_WIDTH = 700;
    protected static final int DEFAULT_PREFERRED_HEIGHT = 200;
    private static final Duration DEFAULT_ANIMATION_DURATION = Duration.millis((double)500.0);
    private final BooleanProperty animated = new SimpleBooleanProperty((Object)this, "animated", false);
    protected final List<MyPopOver> popUpList = new ArrayList<MyPopOver>();
    private final ObjectProperty<Duration> fadeDuration = new SimpleObjectProperty<Duration>((Object)this, "fadeDuration", DEFAULT_ANIMATION_DURATION){

        protected void invalidated() {
            Objects.requireNonNull((Duration)this.get(), "The " + this.getName() + " must not be null");
        }
    };
    private final ObjectProperty<AxisMode> axisMode = new SimpleObjectProperty<AxisMode>((Object)this, "axisMode", AxisMode.XY){

        protected void invalidated() {
            Objects.requireNonNull((AxisMode)((Object)this.get()), "The " + this.getName() + " must not be null");
        }
    };

    public EditAxis() {
        this(AxisMode.XY);
    }

    public EditAxis(AxisMode axisMode) {
        this(axisMode, false);
    }

    public EditAxis(AxisMode axisMode, boolean bl2) {
        this.setAxisMode(axisMode);
        this.setAnimated(bl2);
        this.chartProperty().addListener((observableValue, chart, chart2) -> {
            this.removeMouseEventHandlers((Chart)chart);
            this.addMouseEventHandlers((Chart)chart2);
        });
    }

    public EditAxis(boolean bl2) {
        this(AxisMode.XY, bl2);
    }

    protected void addMouseEventHandlers(Chart chart) {
        if (chart == null) {
            return;
        }
        chart.getAxes().forEach(axis -> this.popUpList.add(new MyPopOver((Axis)axis, axis.getSide().isHorizontal())));
        chart.getAxes().addListener(this::axesChangedHandler);
    }

    private void axesChangedHandler(ListChangeListener.Change<? extends Axis> change) {
        this.removeMouseEventHandlers(null);
        this.addMouseEventHandlers(this.getChart());
    }

    public final BooleanProperty animatedProperty() {
        return this.animated;
    }

    public final ObjectProperty<AxisMode> axisModeProperty() {
        return this.axisMode;
    }

    public final AxisMode getAxisMode() {
        return (AxisMode)((Object)this.axisModeProperty().get());
    }

    public final Duration getZoomDuration() {
        return (Duration)this.zoomDurationProperty().get();
    }

    public final boolean isAnimated() {
        return this.animatedProperty().get();
    }

    protected void removeMouseEventHandlers(Chart chart) {
        this.popUpList.forEach(MyPopOver::deregisterMouseEvents);
        this.popUpList.clear();
        if (chart == null) {
            return;
        }
        chart.getAxes().removeListener(this::axesChangedHandler);
    }

    public final void setAnimated(boolean bl2) {
        this.animatedProperty().set(bl2);
    }

    public final void setAxisMode(AxisMode axisMode) {
        this.axisModeProperty().set((Object)axisMode);
    }

    public final void setZoomDuration(Duration duration) {
        this.zoomDurationProperty().set((Object)duration);
    }

    public final ObjectProperty<Duration> zoomDurationProperty() {
        return this.fadeDuration;
    }

    private class MyPopOver
    extends PopOver {
        private long popOverShowStartTime;
        private boolean isMouseInPopOver;
        private Axis axis;
        private final ChangeListener<Duration> fadeDurationListener;
        private final EventHandler<? super MouseEvent> axisClickEventHandler;

        MyPopOver(Axis axis, boolean bl2) {
            super((Node)new AxisEditor(axis, bl2));
            this.fadeDurationListener = (observableValue, duration, duration2) -> {
                super.fadeInDurationProperty().set((Object)duration2.multiply(2.0));
                super.fadeOutDurationProperty().set(duration2);
            };
            this.axisClickEventHandler = mouseEvent -> {
                if (mouseEvent.getButton() == MouseButton.SECONDARY) {
                    double d2 = mouseEvent.getScreenX();
                    double d3 = mouseEvent.getScreenY();
                    if (this.axis != null) {
                        this.show((Node)this.axis, d2, d3);
                    }
                }
            };
            this.axis = axis;
            this.popOverShowStartTime = 0L;
            this.getStyleClass().add((Object)EditAxis.STYLE_CLASS_AXIS_EDITOR);
            super.setAutoHide(true);
            super.animatedProperty().bind((ObservableValue)EditAxis.this.animatedProperty());
            EditAxis.this.zoomDurationProperty().addListener(this.fadeDurationListener);
            super.fadeInDurationProperty().set((Object)EditAxis.this.getZoomDuration().multiply(2.0));
            super.fadeOutDurationProperty().set((Object)EditAxis.this.getZoomDuration());
            this.setFadeInDuration(Duration.millis((double)1000.0));
            this.setFadeOutDuration(Duration.millis((double)500.0));
            switch (axis.getSide()) {
                case TOP: {
                    this.setArrowLocation(PopOver.ArrowLocation.TOP_CENTER);
                    break;
                }
                case LEFT: {
                    this.setArrowLocation(PopOver.ArrowLocation.LEFT_CENTER);
                    break;
                }
                case RIGHT: {
                    this.setArrowLocation(PopOver.ArrowLocation.RIGHT_CENTER);
                    break;
                }
                default: {
                    this.setArrowLocation(PopOver.ArrowLocation.BOTTOM_CENTER);
                }
            }
            this.getRoot().setBackground(Background.EMPTY);
            this.getScene().getStylesheets().add((Object)"plugin/editaxis.css");
            this.getStyleClass().add((Object)"axis-editor-view-pane");
            Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)100.0), actionEvent -> {
                if (!this.isShowing()) {
                    return;
                }
                long l2 = System.currentTimeMillis();
                if (this.isMouseInPopOver) {
                    this.popOverShowStartTime = System.currentTimeMillis();
                }
                if (Math.abs(l2 - this.popOverShowStartTime) > 5000L) {
                    this.hide();
                }
            }, new KeyValue[0])});
            timeline.play();
            this.registerMouseEvents();
        }

        public void deregisterMouseEvents() {
            ((Node)this.axis).removeEventHandler(MouseEvent.MOUSE_CLICKED, this.axisClickEventHandler);
            EditAxis.this.zoomDurationProperty().removeListener(this.fadeDurationListener);
            super.animatedProperty().unbind();
        }

        public final void registerMouseEvents() {
            this.setOnShowing(windowEvent -> {
                this.popOverShowStartTime = System.currentTimeMillis();
            });
            this.getContentNode().setOnMouseEntered(mouseEvent -> {
                this.isMouseInPopOver = true;
            });
            this.getContentNode().setOnMouseExited(mouseEvent -> {
                this.isMouseInPopOver = false;
            });
            ((Node)this.axis).setOnMouseClicked(this.axisClickEventHandler);
        }
    }

    protected static class AxisEditor
    extends BorderPane {
        AxisEditor(Axis axis, boolean bl2) {
            this.setTop(this.getLabelEditor(axis, bl2));
            HBox hBox = bl2 ? new HBox() : new VBox();
            this.setCenter((Node)hBox);
            if (bl2) {
                hBox.setPrefWidth(700.0);
            } else {
                hBox.setPrefHeight(200.0);
            }
            hBox.getChildren().add((Object)this.getMinMaxButtons(axis, bl2, true));
            hBox.getChildren().add((Object)this.getBoundField(axis, bl2));
            hBox.getChildren().add((Object)this.createSpacer());
            hBox.getChildren().add((Object)this.getLogCheckBoxes(axis));
            hBox.getChildren().add((Object)this.getRangeChangeButtons(axis, bl2));
            hBox.getChildren().add((Object)this.getAutoRangeCheckBoxes(axis));
            hBox.getChildren().add((Object)this.createSpacer());
            hBox.getChildren().add((Object)this.getBoundField(axis, !bl2));
            hBox.getChildren().add((Object)this.getMinMaxButtons(axis, bl2, false));
        }

        protected void changeAxisRange(Axis axis, boolean bl2) {
            double d2 = Math.abs(axis.getMax() - axis.getMin());
            this.changeAxisRangeLinearScale(d2, axis.minProperty(), !bl2);
            this.changeAxisRangeLinearScale(d2, axis.maxProperty(), bl2);
        }

        private void changeAxisRangeLimit(Axis axis, boolean bl2, boolean bl3) {
            boolean bl4 = axis.isInvertedAxis();
            DoubleProperty doubleProperty = bl2 ? (bl4 ? axis.maxProperty() : axis.minProperty()) : (bl4 ? axis.minProperty() : axis.maxProperty());
            double d2 = Double.MAX_VALUE;
            ArrayList arrayList = new ArrayList();
            axis.getTickMarks().forEach(tickMark -> arrayList.add(tickMark.getValue()));
            if (!axis.isLogAxis()) {
                axis.getMinorTickMarks().forEach(tickMark -> arrayList.add(tickMark.getPosition()));
            }
            for (Number number : arrayList) {
                for (Number number2 : arrayList) {
                    d2 = Math.min(Math.abs(number.doubleValue() - number2.doubleValue()), d2);
                }
            }
            if (axis.isLogAxis()) {
                d2 *= 0.1;
            }
            if (d2 == Double.MAX_VALUE || d2 <= 0.0) {
                d2 = 0.05 * Math.abs(axis.getMax() - axis.getMin());
            }
            if (axis.getTickUnit() > 0.0) {
                d2 = axis.getTickUnit();
            }
            this.changeAxisRangeLinearScale(d2, doubleProperty, bl3);
            if (axis instanceof AbstractAxis) {
                axis.setTickUnit(((AbstractAxis)axis).computePreferredTickUnit(axis.getLength()));
            }
        }

        protected void changeAxisRangeLinearScale(double d2, DoubleProperty doubleProperty, boolean bl2) {
            double d3 = doubleProperty.doubleValue();
            if (bl2) {
                doubleProperty.set(d3 + d2);
            } else {
                doubleProperty.set(d3 - d2);
            }
        }

        private Node createSpacer() {
            Region region = new Region();
            VBox.setVgrow((Node)region, (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)region, (Priority)Priority.ALWAYS);
            return region;
        }

        private Pane getAutoRangeCheckBoxes(Axis axis) {
            VBox vBox = new VBox();
            VBox.setVgrow((Node)vBox, (Priority)Priority.ALWAYS);
            CheckBox checkBox = new CheckBox("auto ranging");
            HBox.setHgrow((Node)checkBox, (Priority)Priority.ALWAYS);
            VBox.setVgrow((Node)checkBox, (Priority)Priority.ALWAYS);
            checkBox.setMaxWidth(Double.MAX_VALUE);
            checkBox.setSelected(axis.isAutoRanging());
            checkBox.selectedProperty().bindBidirectional((Property)axis.autoRangingProperty());
            vBox.getChildren().add((Object)checkBox);
            CheckBox checkBox2 = new CheckBox("auto grow");
            HBox.setHgrow((Node)checkBox2, (Priority)Priority.ALWAYS);
            VBox.setVgrow((Node)checkBox2, (Priority)Priority.ALWAYS);
            checkBox2.setMaxWidth(Double.MAX_VALUE);
            checkBox2.setSelected(axis.isAutoGrowRanging());
            checkBox2.selectedProperty().bindBidirectional((Property)axis.autoGrowRangingProperty());
            vBox.getChildren().add((Object)checkBox2);
            return vBox;
        }

        private TextField getBoundField(Axis axis, boolean bl4) {
            TextField textField = new TextField();
            Runnable runnable = () -> {
                boolean bl3 = axis.isInvertedAxis();
                double d2 = bl4 ? (bl3 ? axis.getMax() : axis.getMin()) : (bl3 ? axis.getMin() : axis.getMax());
                textField.setText(Double.toString(d2));
            };
            axis.invertAxisProperty().addListener((observableValue, bl2, bl3) -> runnable.run());
            axis.minProperty().addListener((observableValue, number, number2) -> runnable.run());
            axis.maxProperty().addListener((observableValue, number, number2) -> runnable.run());
            textField.textProperty().addListener((observableValue, string, string2) -> {
                if (string2 != null && !string2.matches("\\d*")) {
                    double d2;
                    try {
                        d2 = Double.parseDouble(string2);
                    }
                    catch (NullPointerException | NumberFormatException runtimeException) {
                        textField.setText(string);
                        return;
                    }
                    if (axis.isLogAxis() && d2 <= 0.0) {
                        textField.setText(string);
                        return;
                    }
                    textField.setText(Double.toString(d2));
                }
            });
            textField.setOnKeyPressed(keyEvent -> {
                if (keyEvent.getCode().equals((Object)KeyCode.ENTER)) {
                    double d2 = Double.parseDouble(textField.getText());
                    if (bl4 && !axis.isInvertedAxis()) {
                        axis.setMin(d2);
                    } else {
                        axis.setMax(d2);
                    }
                    axis.setAutoRanging(false);
                    if (axis instanceof AbstractAxis) {
                        axis.setTickUnit(((AbstractAxis)axis).computePreferredTickUnit(axis.getLength()));
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("recompute axis tick unit to {}", (Object)((AbstractAxis)axis).computePreferredTickUnit(axis.getLength()));
                        }
                    }
                }
            });
            HBox.setHgrow((Node)textField, (Priority)Priority.ALWAYS);
            VBox.setVgrow((Node)textField, (Priority)Priority.ALWAYS);
            return textField;
        }

        private Node getLabelEditor(Axis axis, boolean bl2) {
            GridPane gridPane = new GridPane();
            gridPane.setAlignment(Pos.BASELINE_LEFT);
            TextField textField = new TextField(axis.getName());
            textField.textProperty().bindBidirectional((Property)axis.nameProperty());
            gridPane.addRow(0, new Node[]{new Label(" axis label: "), textField});
            TextField textField2 = new TextField(axis.getUnit());
            textField2.setPrefWidth(50.0);
            textField2.textProperty().bindBidirectional((Property)axis.unitProperty());
            gridPane.addRow(bl2 ? 0 : 1, new Node[]{new Label(" unit: "), textField2});
            TextField textField3 = new TextField();
            textField3.setPrefWidth(80.0);
            CheckBox checkBox = new CheckBox(" auto");
            if (axis instanceof DefaultNumericAxis) {
                checkBox.selectedProperty().bindBidirectional((Property)axis.autoUnitScalingProperty());
                textField3.textProperty().bindBidirectional((Property)axis.unitScalingProperty(), (StringConverter)new NumberStringConverter((NumberFormat)new DecimalFormat("0.0####E0")));
                textField3.disableProperty().bind((ObservableValue)checkBox.selectedProperty());
            } else {
                checkBox.setDisable(true);
                textField3.setDisable(true);
            }
            HBox hBox = new HBox(new Node[]{textField3, checkBox});
            hBox.setAlignment(Pos.BASELINE_LEFT);
            gridPane.addRow(bl2 ? 0 : 2, new Node[]{new Label(" unit scale:"), hBox});
            return gridPane;
        }

        private Pane getLogCheckBoxes(Axis axis) {
            VBox vBox = new VBox();
            VBox.setVgrow((Node)vBox, (Priority)Priority.ALWAYS);
            CheckBox checkBox = new CheckBox("log axis");
            HBox.setHgrow((Node)checkBox, (Priority)Priority.ALWAYS);
            VBox.setVgrow((Node)checkBox, (Priority)Priority.ALWAYS);
            checkBox.setMaxWidth(Double.MAX_VALUE);
            checkBox.setSelected(axis.isLogAxis());
            vBox.getChildren().add((Object)checkBox);
            if (axis instanceof DefaultNumericAxis) {
                checkBox.selectedProperty().bindBidirectional((Property)((DefaultNumericAxis)axis).logAxisProperty());
            } else {
                checkBox.setDisable(true);
            }
            CheckBox checkBox2 = new CheckBox("inverted");
            HBox.setHgrow((Node)checkBox2, (Priority)Priority.ALWAYS);
            VBox.setVgrow((Node)checkBox2, (Priority)Priority.ALWAYS);
            checkBox2.setMaxWidth(Double.MAX_VALUE);
            checkBox2.setSelected(axis.isInvertedAxis());
            vBox.getChildren().add((Object)checkBox2);
            if (axis instanceof DefaultNumericAxis) {
                checkBox2.selectedProperty().bindBidirectional((Property)axis.invertAxisProperty());
            } else {
                checkBox2.setDisable(true);
            }
            CheckBox checkBox3 = new CheckBox("time axis");
            HBox.setHgrow((Node)checkBox3, (Priority)Priority.ALWAYS);
            VBox.setVgrow((Node)checkBox3, (Priority)Priority.ALWAYS);
            checkBox3.setMaxWidth(Double.MAX_VALUE);
            checkBox3.setSelected(axis.isTimeAxis());
            vBox.getChildren().add((Object)checkBox3);
            if (axis instanceof DefaultNumericAxis) {
                checkBox3.selectedProperty().bindBidirectional((Property)axis.timeAxisProperty());
            } else {
                checkBox3.setDisable(true);
            }
            return vBox;
        }

        private Pane getMinMaxButtons(Axis axis, boolean bl2, boolean bl3) {
            Button button = new Button("", (Node)new FontIcon("fa-chevron-up"));
            button.setMaxWidth(Double.MAX_VALUE);
            VBox.setVgrow((Node)button, (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)button, (Priority)Priority.ALWAYS);
            button.setOnAction(actionEvent -> {
                axis.setAutoRanging(false);
                this.changeAxisRangeLimit(axis, bl2 == bl3, true);
            });
            Button button2 = new Button("", (Node)new FontIcon("fa-chevron-down"));
            button2.setMaxWidth(Double.MAX_VALUE);
            VBox.setVgrow((Node)button2, (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)button2, (Priority)Priority.ALWAYS);
            button2.setOnAction(actionEvent -> {
                axis.setAutoRanging(false);
                this.changeAxisRangeLimit(axis, bl2 == bl3, false);
            });
            VBox vBox = bl2 ? new VBox() : new HBox();
            vBox.getChildren().addAll((Object[])new Node[]{button, button2});
            return vBox;
        }

        private Pane getRangeChangeButtons(Axis axis, boolean bl2) {
            Button button = new Button("", (Node)new FontIcon("fa-expand"));
            button.setMaxWidth(Double.MAX_VALUE);
            VBox.setVgrow((Node)button, (Priority)Priority.NEVER);
            HBox.setHgrow((Node)button, (Priority)Priority.NEVER);
            button.setOnAction(actionEvent -> {
                axis.setAutoRanging(false);
                this.changeAxisRange(axis, true);
            });
            Button button2 = new Button("", (Node)new FontIcon("fa-compress"));
            button2.setMaxWidth(Double.MAX_VALUE);
            VBox.setVgrow((Node)button2, (Priority)Priority.NEVER);
            HBox.setHgrow((Node)button2, (Priority)Priority.NEVER);
            button2.setOnAction(actionEvent -> {
                axis.setAutoRanging(false);
                this.changeAxisRange(axis, false);
            });
            VBox vBox = bl2 ? new VBox() : new HBox();
            vBox.getChildren().addAll((Object[])new Node[]{button, button2});
            return vBox;
        }
    }
}

