/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.marker;

import io.fair_acc.chartfx.marker.Marker;
import io.fair_acc.chartfx.utils.PropUtil;
import java.util.Arrays;
import java.util.Objects;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class CachedMarker
implements Marker {
    private WritableImage image = null;
    private final Canvas canvas = new Canvas();
    private static final SnapshotParameters snapshotParams = new SnapshotParameters();
    boolean isUpdating = false;
    private final ObservableObjectValue<Marker> marker;

    public CachedMarker(ObservableObjectValue<Marker> observableObjectValue) {
        this.marker = observableObjectValue;
        PropUtil.runOnChange(() -> {
            this.image = null;
        }, new ObservableValue[]{observableObjectValue});
    }

    @Override
    public void draw(GraphicsContext graphicsContext, double d2, double d3, double d4) {
        if (this.useCachedImage(graphicsContext, d4)) {
            graphicsContext.drawImage((Image)this.image, d2 - d4, d3 - d4, this.image.getWidth(), this.image.getHeight());
            return;
        }
        this.updateCache(graphicsContext, d4);
        ((Marker)this.marker.get()).draw(graphicsContext, d2, d3, d4);
    }

    private boolean useCachedImage(GraphicsContext graphicsContext, double d2) {
        GraphicsContext graphicsContext2 = this.canvas.getGraphicsContext2D();
        return this.image != null && this.canvas.getWidth() == d2 * 2.0 && Objects.equals(graphicsContext2.getFill(), graphicsContext.getFill()) && Objects.equals(graphicsContext2.getStroke(), graphicsContext.getStroke()) && Objects.equals(graphicsContext2.getLineWidth(), graphicsContext.getLineWidth()) && Arrays.equals(graphicsContext2.getLineDashes(), graphicsContext.getLineDashes());
    }

    private void updateCache(GraphicsContext graphicsContext, double d2) {
        if (this.isUpdating) {
            return;
        }
        this.isUpdating = true;
        double d3 = Math.ceil(d2 * 2.0);
        this.canvas.setWidth(d3);
        this.canvas.setHeight(d3);
        GraphicsContext graphicsContext2 = this.canvas.getGraphicsContext2D();
        graphicsContext2.clearRect(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight());
        graphicsContext2.setFill(graphicsContext.getFill());
        graphicsContext2.setStroke(graphicsContext.getStroke());
        graphicsContext2.setLineWidth(graphicsContext.getLineWidth());
        graphicsContext2.setLineDashes(graphicsContext.getLineDashes());
        ((Marker)this.marker.get()).draw(graphicsContext2, d2, d2, d2);
        this.canvas.snapshot(snapshotResult -> {
            this.image = snapshotResult.getImage();
            this.isUpdating = false;
            return null;
        }, snapshotParams, this.image);
    }

    static {
        snapshotParams.setFill((Paint)Color.TRANSPARENT);
    }
}

