/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.events;

import io.fair_acc.dataset.events.BitState;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.events.EventProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javafx.animation.AnimationTimer;
import org.apache.commons.lang3.tuple.Pair;

public class FxEventProcessor
extends AnimationTimer
implements EventProcessor {
    BitState localState = BitState.initDirty(this, ChartBits.DataSetMask);
    BitState stateRoot = BitState.initDirtyMultiThreaded(this, ChartBits.DataSetMask);
    List<Pair<BitState, Runnable>> actions = new ArrayList<Pair<BitState, Runnable>>();
    private static final AtomicReference<FxEventProcessor> INSTANCE = new AtomicReference();

    public static FxEventProcessor getInstance() {
        FxEventProcessor fxEventProcessor = INSTANCE.get();
        if (fxEventProcessor != null) {
            return fxEventProcessor;
        }
        fxEventProcessor = new FxEventProcessor();
        if (INSTANCE.compareAndSet(null, fxEventProcessor)) {
            return fxEventProcessor;
        }
        return INSTANCE.get();
    }

    public FxEventProcessor() {
        this.start();
    }

    public void handle(long l2) {
        this.localState.setDirty(this.stateRoot.clear());
        if (this.localState.isDirty()) {
            for (Pair<BitState, Runnable> pair : this.actions) {
                if (!((BitState)pair.getLeft()).isDirty(ChartBits.DataSetMask)) continue;
                ((BitState)pair.getLeft()).clear();
                try {
                    ((Runnable)pair.getRight()).run();
                }
                catch (Exception exception) {}
            }
        }
        this.localState.clear();
    }

    public BitState getBitState() {
        return this.stateRoot;
    }

    @Override
    public void addAction(BitState bitState, Runnable runnable) {
        bitState.addInvalidateListener(this.stateRoot);
        this.actions.add((Pair<BitState, Runnable>)Pair.of((Object)bitState, (Object)runnable));
    }
}

