/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.bench;

import io.fair_acc.chartfx.utils.FXUtils;
import io.fair_acc.dataset.AxisDescription;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.spi.AbstractDataSet;
import io.fair_acc.dataset.utils.DoubleCircularBuffer;

class CircularDoubleDataSet2D
extends AbstractDataSet<CircularDoubleDataSet2D> {
    protected final DoubleCircularBuffer x;
    protected final DoubleCircularBuffer y;

    public CircularDoubleDataSet2D(String string, int n2) {
        super(string, 2);
        this.x = new DoubleCircularBuffer(n2);
        this.y = new DoubleCircularBuffer(n2);
    }

    @Override
    public double get(int n2, int n3) {
        switch (n2) {
            case 0: {
                return this.x.get(n3);
            }
            case 1: {
                return this.y.get(n3);
            }
        }
        return Double.NaN;
    }

    public void add(double d2, double d3) {
        FXUtils.assertJavaFxThread();
        this.x.put(d2);
        this.y.put(d3);
        this.getAxisDescription(0).add(d2);
        this.getAxisDescription(1).add(d3);
        this.fireInvalidated(ChartBits.DataSetData);
    }

    @Override
    public int getDataCount() {
        return this.x.available();
    }

    public void clear() {
        this.x.reset();
        this.y.reset();
        for (AxisDescription axisDescription : this.getAxisDescriptions()) {
            axisDescription.clear();
        }
    }

    @Override
    public DataSet set(DataSet dataSet, boolean bl2) {
        throw new UnsupportedOperationException();
    }
}

