/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.axes.spi.format;

import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.axes.TickUnitSupplier;
import io.fair_acc.chartfx.axes.spi.format.AbstractFormatter;
import io.fair_acc.chartfx.axes.spi.format.DefaultTickUnitSupplier;
import java.text.DecimalFormat;
import java.text.ParseException;

public class SimpleFormatter
extends AbstractFormatter {
    private static final TickUnitSupplier DEFAULT_TICK_UNIT_SUPPLIER = new DefaultTickUnitSupplier();
    private final DecimalFormat formatter = new DecimalFormat("0.######");
    private String prefix;
    private String suffix;

    public SimpleFormatter() {
        this.setTickUnitSupplier(DEFAULT_TICK_UNIT_SUPPLIER);
    }

    public SimpleFormatter(Axis axis) {
        super(axis);
    }

    public SimpleFormatter(Axis axis, String string, String string2) {
        this(axis);
        this.prefix = string;
        this.suffix = string2;
    }

    @Override
    public Number fromString(String string) {
        try {
            int n2 = this.prefix == null ? 0 : this.prefix.length();
            int n3 = this.suffix == null ? 0 : this.suffix.length();
            return this.formatter.parse(string.substring(n2, string.length() - n3));
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(parseException);
        }
    }

    @Override
    protected void rangeUpdated() {
    }

    @Override
    public String toString(Number number) {
        return this.toString(number, this.formatter);
    }

    private String toString(Number number, DecimalFormat decimalFormat) {
        String string = this.prefix == null ? "" : this.prefix;
        String string2 = this.suffix == null ? "" : this.suffix;
        return string + decimalFormat.format(number) + string2;
    }
}

