/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.axes.spi;

import io.fair_acc.chartfx.Chart;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.axes.AxisLabelOverlapPolicy;
import io.fair_acc.chartfx.axes.spi.AxisRange;
import io.fair_acc.chartfx.axes.spi.MetricPrefix;
import io.fair_acc.chartfx.axes.spi.TickMark;
import io.fair_acc.chartfx.ui.css.CssPropertyFactory;
import io.fair_acc.chartfx.ui.css.LineStyle;
import io.fair_acc.chartfx.ui.css.StyleGroup;
import io.fair_acc.chartfx.ui.css.TextStyle;
import io.fair_acc.chartfx.ui.geometry.Side;
import io.fair_acc.chartfx.utils.PropUtil;
import io.fair_acc.dataset.events.BitState;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.spi.fastutil.DoubleArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.IntSupplier;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableIntegerProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableStringProperty;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.text.Font;
import javafx.util.StringConverter;

public abstract class AbstractAxisParameter
extends Pane
implements Axis {
    protected final BitState state = BitState.initDirty(this, ChartBits.AxisMask);
    protected final Runnable invalidateLayout;
    protected final Runnable invalidateAxisRange;
    protected final Runnable invalidateCanvas;
    protected final Runnable invalidateTickLabels;
    protected final Runnable invalidateAxisLabel;
    private static final String CHART_CSS = Objects.requireNonNull(Chart.class.getResource("chart.css")).toExternalForm();
    private static final CssPropertyFactory<AbstractAxisParameter> CSS = new CssPropertyFactory(Region.getClassCssMetaData());
    protected static final int MAX_TICK_COUNT = 20;
    private static final double DEFAULT_MIN_RANGE = -1.0;
    private static final double DEFAULT_MAX_RANGE = 1.0;
    private static final double DEFAULT_TICK_UNIT = 5.0;
    protected static final int DEFAULT_MINOR_TICK_COUNT = 10;
    private final transient StyleableIntegerProperty dimIndex = CSS.createIntegerProperty(this, "dimIndex", -1, new Runnable[0]);
    private final transient StyleGroup styleGroup = new StyleGroup(this, "axis");
    private final transient LineStyle majorTickStyle = this.styleGroup.newLineStyle("axis-major-tick-mark");
    private final transient LineStyle minorTickStyle = this.styleGroup.newLineStyle("axis-minor-tick-mark");
    private final transient TextStyle tickLabelStyle = this.styleGroup.newTextStyle("axis-tick-label");
    private final transient TextStyle axisLabel = this.styleGroup.newTextStyle("axis-label");
    protected final transient DoubleArrayList majorTickMarkValues = new DoubleArrayList();
    protected final transient DoubleArrayList minorTickMarkValues = new DoubleArrayList();
    protected final transient ObservableList<TickMark> majorTickMarks = FXCollections.observableArrayList();
    protected final transient ObservableList<TickMark> minorTickMarks = FXCollections.observableArrayList();
    private final transient AxisRange autoRange = new AxisRange();
    private final transient AxisRange userRange = new AxisRange();
    private final transient StyleableObjectProperty<Side> side = CSS.createSideProperty(this, Side.BOTTOM, new Runnable[0]);
    private final transient StyleableObjectProperty<AxisLabelOverlapPolicy> overlapPolicy = CSS.createObjectProperty(this, "overlapPolicy", AxisLabelOverlapPolicy.SKIP_ALT, StyleConverter.getEnumConverter(AxisLabelOverlapPolicy.class), new Runnable[0]);
    private final transient StyleableDoubleProperty axisCenterPosition = CSS.createDoubleProperty(this, "axisCenterPosition", 0.5, true, (d2, d3) -> Math.max(0.0, Math.min(d3, 1.0)), new Runnable[0]);
    private final transient StyleableStringProperty axisName = CSS.createStringProperty(this, "axisName", "", new Runnable[0]);
    private final transient StyleableDoubleProperty axisPadding = CSS.createDoubleProperty(this, "axisPadding", 15.0, new Runnable[0]);
    private final transient StyleableDoubleProperty tickLength = CSS.createDoubleProperty(this, "tickLength", 8.0, new Runnable[0]);
    private final transient StyleableBooleanProperty autoRanging = CSS.createBooleanProperty(this, "autoRanging", true, () -> {
        if (this.isAutoRanging()) {
            this.setAutoGrowRanging(false);
        }
    });
    private final transient StyleableBooleanProperty autoGrowRanging = CSS.createBooleanProperty(this, "autoGrowRanging", false, () -> {
        if (this.isAutoGrowRanging()) {
            this.setAutoRanging(false);
        }
    });
    private final transient StyleableDoubleProperty tickMarkGap = CSS.createDoubleProperty(this, "tickMarkGap", 0.0, new Runnable[0]);
    private final transient StyleableDoubleProperty tickLabelGap = CSS.createDoubleProperty(this, "tickLabelGap", 3.0, new Runnable[0]);
    private final transient StyleableDoubleProperty tickLabelSpacing = CSS.createDoubleProperty(this, "tickLabelSpacing", 3.0, new Runnable[0]);
    private final transient StyleableDoubleProperty axisLabelGap = CSS.createDoubleProperty(this, "axisLabelGap", 3.0, new Runnable[0]);
    private final transient StyleableIntegerProperty animationDuration = CSS.createIntegerProperty(this, "animationDuration", 250, new Runnable[0]);
    private final transient StyleableIntegerProperty maxMajorTickLabelCount = CSS.createIntegerProperty(this, "maxMajorTickLabelCount", 20, new Runnable[0]);
    private final transient BooleanProperty animated = new SimpleBooleanProperty((Object)this, "animated", false);
    private final transient ReadOnlyDoubleWrapper scale = PropUtil.createReadOnlyDoubleWrapper(this, "scale", 1.0, new Runnable[0]);
    private final transient ReadOnlyDoubleWrapper length = PropUtil.createReadOnlyDoubleWrapper(this, "length", Double.NaN, new Runnable[0]);
    protected final transient ReadOnlyDoubleWrapper maxProp = PropUtil.createReadOnlyDoubleWrapper(this, "upperBound", 1.0, new Runnable[0]);
    protected final transient ReadOnlyDoubleWrapper minProp = PropUtil.createReadOnlyDoubleWrapper(this, "lowerBound", -1.0, new Runnable[0]);
    protected double cachedOffset;
    private final transient ObjectProperty<StringConverter<Number>> tickLabelFormatter = PropUtil.createObjectProperty(this, "tickLabelFormatter", null, new Runnable[0]);
    private final transient StyleableDoubleProperty minorTickLength = CSS.createDoubleProperty(this, "minorTickLength", 5.0, new Runnable[0]);
    private final transient StyleableIntegerProperty minorTickCount = CSS.createIntegerProperty(this, "minorTickCount", 10, new Runnable[0]);
    protected boolean isInvertedAxis = false;
    private final transient StyleableBooleanProperty invertAxis = CSS.createBooleanProperty(this, "invertAxis", this.isInvertedAxis, () -> {
        this.isInvertedAxis = this.invertAxisProperty().get();
    });
    protected boolean isTimeAxis = false;
    private final transient BooleanProperty timeAxis = PropUtil.createBooleanProperty(this, "timeAxis", this.isTimeAxis, () -> {
        this.isTimeAxis = this.timeAxisProperty().get();
        if (this.isTimeAxis) {
            this.setMinorTickCount(0);
        } else {
            this.setMinorTickCount(10);
        }
    });
    private final transient StyleableBooleanProperty autoRangeRounding = CSS.createBooleanProperty(this, "autoRangeRounding", false, new Runnable[0]);
    private final transient StyleableDoubleProperty autoRangePadding = CSS.createDoubleProperty(this, "autoRangePadding", 0.0, new Runnable[0]);
    private final transient StyleableStringProperty axisUnit = CSS.createStringProperty(this, "axisUnit", "", new Runnable[0]);
    private final transient StyleableBooleanProperty autoUnitScaling = CSS.createBooleanProperty(this, "autoUnitScaling", false, new Runnable[0]);
    private final transient DoubleProperty unitScaling = PropUtil.createDoubleProperty(this, "unitScaling", 1.0, new Runnable[0]);
    protected final transient StyleableDoubleProperty tickUnit = CSS.createDoubleProperty(this, "tickUnit", 5.0, new Runnable[0]);

    public AbstractAxisParameter() {
        this.invalidateLayout = this.state.onAction(ChartBits.AxisLayout, ChartBits.AxisCanvas);
        PropUtil.runOnChange(this.invalidateLayout, new ObservableValue[]{this.side, this.axisPadding, this.tickMarkGap, this.tickLength, this.majorTickStyle.changeCounterProperty(), this.tickLabelGap, this.overlapPolicy, this.tickLabelStyle.changeCounterProperty(), this.axisLabelGap, this.axisLabel.changeCounterProperty(), this.animationDuration, this.dimIndex});
        this.state.addChangeListener(ChartBits.AxisLayout, (bitState, n2) -> super.requestLayout());
        this.invalidateAxisRange = () -> {
            this.state.setDirty(ChartBits.AxisRange, new IntSupplier[0]);
            if (!this.isTickMarkVisible() || !this.isTickLabelsVisible()) {
                return;
            }
            int n2 = Math.abs((int)this.getTickLabelRotation() % 360);
            if (this.getOverlapPolicy() == AxisLabelOverlapPolicy.SHIFT_ALT || this.getSide() == null || this.getSide().isHorizontal() && n2 != 0 && n2 != 180 || this.getSide().isVertical() && n2 != 90 && n2 != 270) {
                this.state.setDirty(ChartBits.AxisLayout, new IntSupplier[0]);
            }
        };
        PropUtil.runOnChange(this.invalidateAxisRange, new ObservableValue[]{this.autoRanging, this.autoGrowRanging, this.autoRangeRounding, this.autoRangePadding, this.tickLabelSpacing, this.maxMajorTickLabelCount, this.invertAxis});
        this.invalidateCanvas = this.state.onAction(ChartBits.AxisCanvas, new IntSupplier[0]);
        PropUtil.runOnChange(this.invalidateCanvas, new ObservableValue[]{this.minorTickStyle.changeCounterProperty(), this.minorTickCount, this.minorTickLength, this.axisCenterPosition, this.minProp, this.maxProp, this.length, this.scale, this.tickUnit});
        this.invalidateAxisLabel = this.state.onAction(ChartBits.AxisCanvas, ChartBits.AxisLabelText);
        PropUtil.runOnChange(this.invalidateAxisLabel, new ObservableValue[]{this.axisName, this.unitScaling, this.autoUnitScaling, this.axisUnit});
        this.invalidateTickLabels = this.state.onAction(ChartBits.AxisCanvas, ChartBits.AxisTickLabelText);
        PropUtil.runOnChange(this.invalidateTickLabels, new ObservableValue[]{this.tickLabelFormatter, this.unitScaling, this.autoUnitScaling, this.timeAxis});
        PropUtil.runOnChange(() -> {
            if (this.getUserRange().set(this.getMin(), this.getMax()) && !this.isAutoGrowRanging() && !this.isAutoRanging()) {
                this.invalidateAxisRange.run();
            }
        }, new ObservableValue[]{this.minProp, this.maxProp});
        PropUtil.runOnChange(() -> {
            if (this.isAutoRanging() || this.isAutoGrowRanging()) {
                this.invalidateAxisRange.run();
            }
        }, new ObservableValue[]{this.tickUnit});
    }

    public String getUserAgentStylesheet() {
        return CHART_CSS;
    }

    @Override
    public void updateCachedTransforms() {
        this.cachedOffset = this.getSide().isHorizontal() ? 0.0 : this.getLength();
    }

    @Override
    public boolean add(double d2) {
        if (!Double.isFinite(d2)) {
            return false;
        }
        if (d2 > this.getMin() && d2 < this.getMax()) {
            return false;
        }
        if (d2 < this.getMin()) {
            this.setMin(d2);
        }
        if (d2 > this.getMax()) {
            this.setMax(d2);
        }
        this.state.setDirty(ChartBits.AxisRange, new IntSupplier[0]);
        return true;
    }

    @Override
    public boolean add(double[] dArray, int n2) {
        boolean bl2 = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            bl2 |= this.add(dArray[i2]);
        }
        return bl2;
    }

    public BooleanProperty animatedProperty() {
        return this.animated;
    }

    public IntegerProperty animationDurationProperty() {
        return this.animationDuration;
    }

    @Override
    public BooleanProperty autoGrowRangingProperty() {
        return this.autoGrowRanging;
    }

    public DoubleProperty autoRangePaddingProperty() {
        return this.autoRangePadding;
    }

    public BooleanProperty autoRangeRoundingProperty() {
        return this.autoRangeRounding;
    }

    @Override
    public BooleanProperty autoRangingProperty() {
        return this.autoRanging;
    }

    @Override
    public BooleanProperty autoUnitScalingProperty() {
        return this.autoUnitScaling;
    }

    public DoubleProperty axisLabelGapProperty() {
        return this.axisLabelGap;
    }

    public DoubleProperty axisPaddingProperty() {
        return this.axisPadding;
    }

    public DoubleProperty axisCenterPositionProperty() {
        return this.axisCenterPosition;
    }

    @Override
    public boolean clear() {
        this.minProp.set(-1.0);
        this.maxProp.set(1.0);
        return false;
    }

    @Override
    public boolean contains(double d2) {
        return Double.isFinite(d2) && d2 >= this.getMin() && d2 <= this.getMax();
    }

    public int getAnimationDuration() {
        return this.animationDurationProperty().get();
    }

    @Override
    public AxisRange getAutoRange() {
        return this.autoRange;
    }

    public double getAutoRangePadding() {
        return this.autoRangePaddingProperty().get();
    }

    public double getAxisCenterPosition() {
        return this.axisCenterPositionProperty().get();
    }

    @Override
    public TextStyle getAxisLabel() {
        return this.axisLabel;
    }

    public double getAxisLabelGap() {
        return this.axisLabelGapProperty().get();
    }

    public double getAxisPadding() {
        return this.axisPaddingProperty().get();
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return AbstractAxisParameter.getClassCssMetaData();
    }

    public IntegerProperty dimIndexProperty() {
        return this.dimIndex;
    }

    public void setDimIndex(int n2) {
        this.dimIndexProperty().set(n2);
    }

    @Override
    public int getDimIndex() {
        return this.dimIndexProperty().get();
    }

    @Override
    public double getLength() {
        return this.lengthProperty().get();
    }

    @Override
    public LineStyle getMajorTickStyle() {
        return this.majorTickStyle;
    }

    @Override
    public double getMax() {
        return this.maxProperty().get();
    }

    public int getMaxMajorTickLabelCount() {
        return this.maxMajorTickLabelCountProperty().get();
    }

    @Override
    public double getMin() {
        return this.minProperty().get();
    }

    @Override
    public int getMinorTickCount() {
        return this.minorTickCountProperty().get();
    }

    public double getMinorTickLength() {
        return this.minorTickLengthProperty().get();
    }

    @Override
    public ObservableList<TickMark> getMinorTickMarks() {
        return this.minorTickMarks;
    }

    public DoubleArrayList getMinorTickMarkValues() {
        return this.minorTickMarkValues;
    }

    @Override
    public LineStyle getMinorTickStyle() {
        return this.minorTickStyle;
    }

    @Override
    public TextStyle getTickLabelStyle() {
        return this.tickLabelStyle;
    }

    @Override
    public String getName() {
        return (String)this.nameProperty().get();
    }

    public AxisLabelOverlapPolicy getOverlapPolicy() {
        return (AxisLabelOverlapPolicy)((Object)this.overlapPolicyProperty().get());
    }

    public double getScale() {
        return this.scaleProperty().get();
    }

    @Override
    public Side getSide() {
        return (Side)((Object)this.sideProperty().get());
    }

    @Override
    public StringConverter<Number> getTickLabelFormatter() {
        return (StringConverter)this.tickLabelFormatterProperty().getValue();
    }

    @Override
    public double getTickMarkGap() {
        return this.tickMarkGapProperty().get();
    }

    @Override
    public double getTickLabelGap() {
        return this.tickLabelGapProperty().get();
    }

    @Override
    public double getTickLabelSpacing() {
        return this.tickLabelSpacingProperty().get();
    }

    public double getTickLength() {
        return this.tickLengthProperty().get();
    }

    @Override
    public ObservableList<TickMark> getTickMarks() {
        return this.majorTickMarks;
    }

    public DoubleArrayList getTickMarkValues() {
        return this.majorTickMarkValues;
    }

    @Override
    public double getTickUnit() {
        return this.tickUnitProperty().get();
    }

    @Override
    public String getUnit() {
        return (String)this.unitProperty().get();
    }

    @Override
    public double getUnitScaling() {
        return this.unitScalingProperty().get();
    }

    @Override
    public AxisRange getUserRange() {
        return this.userRange;
    }

    @Override
    public void invertAxis(boolean bl2) {
        this.invertAxisProperty().set(bl2);
    }

    @Override
    public BooleanProperty invertAxisProperty() {
        return this.invertAxis;
    }

    public boolean isAnimated() {
        return this.animatedProperty().get();
    }

    @Override
    public boolean isAutoGrowRanging() {
        return this.autoGrowRangingProperty().get();
    }

    public boolean isAutoRangeRounding() {
        return this.autoRangeRoundingProperty().get();
    }

    @Override
    public boolean isAutoRanging() {
        return this.autoRangingProperty().get();
    }

    @Override
    public boolean isAutoUnitScaling() {
        return this.autoUnitScalingProperty().get();
    }

    @Override
    public boolean isDefined() {
        return Double.isFinite(this.getMin()) && Double.isFinite(this.getMax());
    }

    @Override
    public boolean isInvertedAxis() {
        return this.invertAxisProperty().get();
    }

    @Override
    public boolean isTimeAxis() {
        return this.timeAxisProperty().get();
    }

    public boolean isValid() {
        return this.state.isClean();
    }

    public IntegerProperty maxMajorTickLabelCountProperty() {
        return this.maxMajorTickLabelCount;
    }

    public IntegerProperty minorTickCountProperty() {
        return this.minorTickCount;
    }

    public DoubleProperty minorTickLengthProperty() {
        return this.minorTickLength;
    }

    @Override
    public DoubleProperty tickUnitProperty() {
        return this.tickUnit;
    }

    @Override
    public DoubleProperty minProperty() {
        return this.minProp;
    }

    @Override
    public DoubleProperty maxProperty() {
        return this.maxProp;
    }

    public ReadOnlyDoubleProperty scaleProperty() {
        return this.scale.getReadOnlyProperty();
    }

    public ReadOnlyDoubleProperty lengthProperty() {
        return this.length.getReadOnlyProperty();
    }

    @Override
    public StringProperty nameProperty() {
        return this.axisName;
    }

    public ObjectProperty<AxisLabelOverlapPolicy> overlapPolicyProperty() {
        return this.overlapPolicy;
    }

    @Override
    public boolean set(double d2, double d3) {
        boolean bl2 = PropUtil.set((DoubleProperty)this.minProp, d2) | PropUtil.set((DoubleProperty)this.maxProp, d3);
        return bl2;
    }

    @Override
    public boolean set(String string, String ... stringArray) {
        boolean bl2 = PropUtil.set(this.nameProperty(), string);
        if (stringArray.length > 0) {
            bl2 |= PropUtil.set(this.unitProperty(), stringArray[0]);
        }
        return bl2;
    }

    @Override
    public boolean set(String string, String string2, double d2, double d3) {
        return this.set(string, string2) | this.set(d2, d3);
    }

    @Override
    public void setAnimated(boolean bl2) {
        this.animatedProperty().set(bl2);
    }

    public void setAnimationDuration(int n2) {
        this.animationDurationProperty().set(n2);
    }

    @Override
    public void setAutoGrowRanging(boolean bl2) {
        this.autoGrowRangingProperty().set(bl2);
    }

    public void setAutoRangePadding(double d2) {
        this.autoRangePaddingProperty().set(d2);
    }

    public void setAutoRangeRounding(boolean bl2) {
        this.autoRangeRoundingProperty().set(bl2);
    }

    @Override
    public void setAutoRanging(boolean bl2) {
        this.autoRangingProperty().set(bl2);
    }

    @Override
    public void setAutoUnitScaling(boolean bl2) {
        this.autoUnitScalingProperty().set(bl2);
    }

    public void setAxisCenterPosition(double d2) {
        this.axisCenterPositionProperty().set(d2);
    }

    public void setAxisLabelGap(double d2) {
        this.axisLabelGapProperty().set(d2);
    }

    public void setAxisPadding(double d2) {
        this.axisPaddingProperty().set(d2);
    }

    @Override
    public void setTickUnit(double d2) {
        this.tickUnit.set(d2);
    }

    @Override
    public boolean setMax(double d2) {
        return PropUtil.set((DoubleProperty)this.maxProp, d2);
    }

    @Override
    public boolean setMin(double d2) {
        return PropUtil.set((DoubleProperty)this.minProp, d2);
    }

    protected void setLength(double d2) {
        this.length.set(d2);
    }

    public void setMaxMajorTickLabelCount(int n2) {
        this.maxMajorTickLabelCountProperty().set(n2);
    }

    public void setMinorTickCount(int n2) {
        this.minorTickCountProperty().set(n2);
    }

    public void setMinorTickLength(double d2) {
        this.minorTickLengthProperty().set(d2);
    }

    @Override
    public void setName(String string) {
        this.nameProperty().set((Object)string);
    }

    public void setOverlapPolicy(AxisLabelOverlapPolicy axisLabelOverlapPolicy) {
        this.overlapPolicyProperty().set((Object)axisLabelOverlapPolicy);
    }

    @Override
    public void setSide(Side side) {
        this.sideProperty().set((Object)side);
    }

    public void setTickLabelFormatter(StringConverter<Number> stringConverter) {
        this.tickLabelFormatterProperty().setValue(stringConverter);
    }

    public void setTickMarkGap(double d2) {
        this.tickMarkGapProperty().set(d2);
    }

    public void setTickLabelGap(double d2) {
        this.tickLabelGapProperty().set(d2);
    }

    public void setTickLabelSpacing(double d2) {
        this.tickLabelSpacingProperty().set(d2);
    }

    public void setTickLength(double d2) {
        this.tickLengthProperty().set(d2);
    }

    @Override
    public void setTimeAxis(boolean bl2) {
        this.timeAxisProperty().set(bl2);
    }

    @Override
    public void setUnit(String string) {
        this.unitProperty().set((Object)string);
    }

    @Override
    public void setUnitScaling(double d2) {
        if (!Double.isFinite(d2) || d2 == 0.0) {
            throw new IllegalArgumentException("provided number is not finite and/or zero: " + d2);
        }
        this.unitScalingProperty().set(d2);
    }

    @Override
    public void setUnitScaling(MetricPrefix metricPrefix) {
        this.unitScalingProperty().set(metricPrefix.getPower());
    }

    @Override
    public ObjectProperty<Side> sideProperty() {
        return this.side;
    }

    public ObjectProperty<StringConverter<Number>> tickLabelFormatterProperty() {
        return this.tickLabelFormatter;
    }

    public DoubleProperty tickMarkGapProperty() {
        return this.tickMarkGap;
    }

    public DoubleProperty tickLabelGapProperty() {
        return this.tickLabelGap;
    }

    public DoubleProperty tickLabelSpacingProperty() {
        return this.tickLabelSpacing;
    }

    public DoubleProperty tickLengthProperty() {
        return this.tickLength;
    }

    @Override
    public BooleanProperty timeAxisProperty() {
        return this.timeAxis;
    }

    @Override
    public StringProperty unitProperty() {
        return this.axisUnit;
    }

    @Override
    public DoubleProperty unitScalingProperty() {
        return this.unitScaling;
    }

    protected boolean isMinorTickVisible() {
        return this.minorTickStyle.isVisible();
    }

    protected boolean isTickLabelsVisible() {
        return this.tickLabelStyle.isVisible();
    }

    protected boolean isTickMarkVisible() {
        return this.majorTickStyle.isVisible();
    }

    protected double getTickLabelRotation() {
        return this.tickLabelStyle.getRotate();
    }

    protected Font getTickLabelFont() {
        return this.getTickLabelStyle().getFont();
    }

    protected void setScale(double d2) {
        this.scalePropertyImpl().set(d2);
    }

    protected void updateScale() {
        double d2;
        double d3 = this.getLength();
        double d4 = this.getMax() - this.getMin();
        if (!Double.isFinite(d4)) {
            return;
        }
        if (this.getSide().isVertical()) {
            d2 = d4 == 0.0 ? -d3 : -(d3 / d4);
            this.cachedOffset = d3;
        } else {
            d2 = d4 == 0.0 ? d3 : d3 / d4;
            this.cachedOffset = 0.0;
        }
        this.setScale(d2 == 0.0 ? -1.0 : d2);
    }

    @Override
    public BitState getBitState() {
        return this.state;
    }

    protected void updateAxisLabel() {
        if (this.state.isClean(ChartBits.AxisLabelText)) {
            return;
        }
        String string = this.getUnit();
        String string2 = MetricPrefix.getShortPrefix(this.getUnitScaling());
        if (string == null && PropUtil.isNullOrEmpty(string2)) {
            this.getAxisLabel().setText(this.getName());
        } else {
            string = string == null ? "" : string;
            string2 = string2 == null ? "" : string2;
            this.getAxisLabel().setText(this.getName() + " [" + string2 + string + "]");
        }
        this.state.clear(ChartBits.AxisLabelText);
    }

    protected void updateScaleAndUnitPrefix() {
        double d2;
        double d3;
        if (!this.isAutoUnitScaling()) {
            return;
        }
        double d4 = Math.abs(this.getMax() - this.getMin());
        double d5 = Math.log10(d4);
        double d6 = 3.0 * Math.ceil(d5 / 3.0);
        double d7 = Math.min(d6, d3 = 3.0 * Math.floor(d5 / 3.0));
        double d8 = Math.pow(10.0, d7);
        if (d8 != (d2 = this.getUnitScaling()) && d8 != 0.0 && Double.isFinite(d8)) {
            this.setUnitScaling(d8);
        }
        this.setTickUnit(d4 / (double)this.getMinorTickCount());
    }

    ReadOnlyDoubleWrapper scalePropertyImpl() {
        return this.scale;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return CSS.getCssMetaData();
    }

    protected static boolean equalString(String string, String string2) {
        return Objects.equals(string, string2);
    }
}

