/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx;

import io.fair_acc.bench.DurationMeasure;
import io.fair_acc.bench.Measurable;
import io.fair_acc.bench.MeasurementRecorder;
import io.fair_acc.chartfx.Chart;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.axes.spi.AxisRange;
import io.fair_acc.chartfx.renderer.PolarTickStep;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.chartfx.renderer.spi.ErrorDataSetRenderer;
import io.fair_acc.chartfx.renderer.spi.GridRenderer;
import io.fair_acc.chartfx.renderer.spi.LabelledMarkerRenderer;
import io.fair_acc.chartfx.ui.css.DataSetNode;
import io.fair_acc.chartfx.ui.geometry.Side;
import io.fair_acc.chartfx.utils.FXUtils;
import io.fair_acc.chartfx.utils.PropUtil;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.utils.AssertUtils;
import java.util.function.IntSupplier;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.canvas.GraphicsContext;

public class XYChart
extends Chart {
    protected static final int BURST_LIMIT_MS = 15;
    protected final BooleanProperty polarPlot = new SimpleBooleanProperty((Object)this, "polarPlot", false);
    private final ObjectProperty<PolarTickStep> polarStepSize = new SimpleObjectProperty((Object)PolarTickStep.THIRTY);
    private final GridRenderer gridRenderer = new GridRenderer(this);
    private final AxisRange axisRange = new AxisRange();
    private DurationMeasure benchDrawData = DurationMeasure.DISABLED;
    private DurationMeasure benchDrawGrid = DurationMeasure.DISABLED;

    public XYChart() {
        this(new Axis[0]);
    }

    public XYChart(Axis ... axisArray) {
        super(axisArray);
        for (int i2 = 0; i2 < axisArray.length; ++i2) {
            Axis axis = axisArray[i2];
            if (axis == null) continue;
            switch (i2) {
                case 0: {
                    axis.setSide(Side.BOTTOM);
                    break;
                }
                case 1: {
                    axis.setSide(Side.LEFT);
                    break;
                }
                default: {
                    axis.setSide(Side.RIGHT);
                }
            }
            this.getAxes().add((Object)axis);
        }
        this.styleableNodes.getChildren().add((Object)this.gridRenderer);
        PropUtil.runOnChange(this.getBitState().onAction(ChartBits.ChartCanvas, new IntSupplier[0]), new ObservableValue[]{this.gridRenderer.getHorizontalMajorGrid().changeCounterProperty(), this.gridRenderer.getHorizontalMinorGrid().changeCounterProperty(), this.gridRenderer.getVerticalMajorGrid().changeCounterProperty(), this.gridRenderer.getVerticalMinorGrid().changeCounterProperty(), this.gridRenderer.drawOnTopProperty()});
        this.getRenderers().addListener(this::rendererChanged);
        this.getRenderers().add((Object)new ErrorDataSetRenderer());
    }

    public ObservableList<DataSet> getDatasets() {
        if (this.getRenderers().isEmpty()) {
            this.getRenderers().add((Object)new ErrorDataSetRenderer());
        }
        return ((Renderer)this.getRenderers().get(0)).getDatasets();
    }

    @Override
    public ObservableList<DataSet> getAllDatasets() {
        if (this.getRenderers() == null) {
            return this.allDataSets;
        }
        this.allDataSets.clear();
        for (Renderer renderer : this.getRenderers()) {
            if (renderer instanceof LabelledMarkerRenderer) continue;
            this.allDataSets.addAll(renderer.getDatasets());
        }
        return this.allDataSets;
    }

    public ObservableList<DataSet> getAllShownDatasets() {
        ObservableList observableList = FXCollections.observableArrayList();
        this.getRenderers().stream().filter(Renderer::showInLegend).forEach(renderer -> observableList.addAll(renderer.getDatasets()));
        return observableList;
    }

    public GridRenderer getGridRenderer() {
        return this.gridRenderer;
    }

    public PolarTickStep getPolarStepSize() {
        return (PolarTickStep)((Object)this.polarStepSizeProperty().get());
    }

    public Axis getXAxis() {
        return this.getFirstAxis(Orientation.HORIZONTAL);
    }

    public Axis getYAxis() {
        return this.getFirstAxis(Orientation.VERTICAL);
    }

    public final boolean isPolarPlot() {
        return this.polarPlotProperty().get();
    }

    public final BooleanProperty polarPlotProperty() {
        return this.polarPlot;
    }

    public ObjectProperty<PolarTickStep> polarStepSizeProperty() {
        return this.polarStepSize;
    }

    public final XYChart setPolarPlot(boolean bl2) {
        this.polarPlotProperty().set(bl2);
        return this;
    }

    public void setPolarStepSize(PolarTickStep polarTickStep) {
        this.polarStepSizeProperty().set((Object)polarTickStep);
    }

    @Override
    public void updateAxisRange() {
        this.getRenderers().stream().flatMap(renderer -> renderer.getDatasetNodes().stream()).filter(Node::isVisible).map(DataSetNode::getDataSet).filter(dataSet -> dataSet.getBitState().isDirty(ChartBits.DataSetData, ChartBits.DataSetRange)).distinct().forEach(dataSet -> dataSet.getAxisDescriptions().parallelStream().filter(axisDescription -> !axisDescription.isDefined() || axisDescription.getBitState().isDirty()).forEach(axisDescription -> dataSet.recomputeLimits(axisDescription.getDimIndex())));
        for (Axis axis : this.getAxes()) {
            this.axisRange.clear();
            for (Renderer renderer2 : this.getRenderers()) {
                renderer2.updateAxisRange(axis, this.axisRange);
            }
            boolean bl2 = false;
            if (axis.isAutoGrowRanging() && axis.getAutoRange().isDefined()) {
                if (this.axisRange.isDefined()) {
                    bl2 = axis.getAutoRange().add(this.axisRange);
                }
            } else {
                bl2 = axis.getAutoRange().set(this.axisRange.getMin(), this.axisRange.getMax());
            }
            if (!bl2 || !axis.isAutoRanging() && !axis.isAutoGrowRanging()) continue;
            axis.invalidateRange();
        }
    }

    @Override
    protected void axesChanged(ListChangeListener.Change<? extends Axis> change) {
        while (change.next()) {
            change.getRemoved().forEach(axis -> AssertUtils.notNull("to be removed axis is null", axis));
            change.getAddedSubList().forEach(axis -> AssertUtils.notNull("to be added axis is null", axis));
        }
        this.invalidate();
    }

    @Override
    protected void redrawCanvas() {
        FXUtils.assertJavaFxThread();
        GraphicsContext graphicsContext = this.canvas.getGraphicsContext2D();
        graphicsContext.clearRect(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight());
        if (!this.gridRenderer.isDrawOnTop()) {
            this.benchDrawGrid.start();
            this.gridRenderer.render();
            this.benchDrawGrid.stop();
        }
        this.benchDrawData.start();
        for (Renderer renderer : this.getRenderers()) {
            renderer.render();
        }
        this.benchDrawData.stop();
        if (this.gridRenderer.isDrawOnTop()) {
            this.benchDrawGrid.start();
            this.gridRenderer.render();
            this.benchDrawGrid.stop();
        }
    }

    public void setGlobalRecorder(MeasurementRecorder measurementRecorder) {
        this.setRecorder(measurementRecorder);
        int n2 = 0;
        for (Measurable.EmptyDefault emptyDefault : this.getRenderers()) {
            MeasurementRecorder measurementRecorder2 = measurementRecorder.addPrefix("renderer" + n2);
            emptyDefault.setRecorder(measurementRecorder2);
            int n3 = 0;
            for (DataSet dataSet : emptyDefault.getDatasets()) {
                dataSet.setRecorder(measurementRecorder2.addPrefix("ds" + n3));
                dataSet.lock().setRecorder(measurementRecorder2.addPrefix("ds" + n3));
                ++n3;
            }
            ++n2;
        }
        this.gridRenderer.setRecorder(measurementRecorder);
        n2 = 0;
        for (Measurable.EmptyDefault emptyDefault : this.getAxes()) {
            if (emptyDefault == this.getXAxis()) {
                emptyDefault.setRecorder(measurementRecorder.addPrefix("x"));
            } else if (emptyDefault == this.getYAxis()) {
                emptyDefault.setRecorder(measurementRecorder.addPrefix("y"));
            } else {
                emptyDefault.setRecorder(measurementRecorder.addPrefix("axis" + n2));
            }
            ++n2;
        }
        n2 = 0;
        for (Measurable.EmptyDefault emptyDefault : this.getPlugins()) {
            emptyDefault.setRecorder(measurementRecorder.addPrefix("plugin" + n2++));
        }
    }

    @Override
    public void setRecorder(MeasurementRecorder measurementRecorder) {
        this.benchDrawData = measurementRecorder.newDuration("xychart-drawData");
        this.benchDrawGrid = measurementRecorder.newDuration("xychart-drawGrid");
        super.setRecorder(measurementRecorder);
    }
}

