/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.status;

import org.agrona.UnsafeAccess;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.status.CountersReader;

public final class ReadableCounter
implements AutoCloseable {
    private final long addressOffset;
    private final long registrationId;
    private final int counterId;
    private volatile boolean isClosed = false;
    private final byte[] buffer;
    private final CountersReader countersReader;

    public ReadableCounter(CountersReader countersReader, long l2, int n2) {
        int n3 = countersReader.getCounterState(n2);
        if (n3 != 1) {
            throw new IllegalStateException("Counter not allocated: id=" + n2 + " state=" + n3);
        }
        this.countersReader = countersReader;
        this.counterId = n2;
        this.registrationId = l2;
        AtomicBuffer atomicBuffer = countersReader.valuesBuffer();
        int n4 = CountersReader.counterOffset(n2);
        atomicBuffer.boundsCheck(n4, 8);
        this.buffer = atomicBuffer.byteArray();
        this.addressOffset = atomicBuffer.addressOffset() + (long)n4;
    }

    public ReadableCounter(CountersReader countersReader, int n2) {
        this(countersReader, -1L, n2);
    }

    public long registrationId() {
        return this.registrationId;
    }

    public int counterId() {
        return this.counterId;
    }

    public int state() {
        return this.countersReader.getCounterState(this.counterId);
    }

    public String label() {
        return this.countersReader.getCounterLabel(this.counterId);
    }

    public long get() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this.buffer, this.addressOffset);
    }

    public long getWeak() {
        return UnsafeAccess.UNSAFE.getLong(this.buffer, this.addressOffset);
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

