/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.protocol;

import io.aeron.protocol.HeaderFlyweight;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.agrona.BitUtil;
import org.agrona.LangUtil;
import org.agrona.concurrent.UnsafeBuffer;

public class ResolutionEntryFlyweight
extends HeaderFlyweight {
    public static final byte RES_TYPE_NAME_TO_IP4_MD = 1;
    public static final byte RES_TYPE_NAME_TO_IP6_MD = 2;
    public static final int ADDRESS_LENGTH_IP4 = 4;
    public static final int ADDRESS_LENGTH_IP6 = 16;
    public static final short SELF_FLAG = 128;
    public static final int RES_TYPE_FIELD_OFFSET = 0;
    public static final int RES_FLAGS_FIELD_OFFSET = 1;
    public static final int UDP_PORT_FIELD_OFFSET = 2;
    public static final int AGE_IN_MS_FIELD_OFFSET = 4;
    public static final int ADDRESS_FIELD_OFFSET = 8;
    public static final int MAX_NAME_LENGTH = 512;

    public ResolutionEntryFlyweight() {
    }

    public ResolutionEntryFlyweight(UnsafeBuffer unsafeBuffer) {
        super(unsafeBuffer);
    }

    public ResolutionEntryFlyweight(ByteBuffer byteBuffer) {
        super(byteBuffer);
    }

    public ResolutionEntryFlyweight resType(byte by2) {
        this.putByte(0, by2);
        return this;
    }

    public byte resType() {
        return this.getByte(0);
    }

    @Override
    public ResolutionEntryFlyweight flags(short s2) {
        this.putByte(1, (byte)s2);
        return this;
    }

    @Override
    public short flags() {
        return (short)(this.getByte(1) & 0xFF);
    }

    public ResolutionEntryFlyweight udpPort(int n2) {
        this.putShort(2, (short)n2, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int udpPort() {
        return this.getShort(2, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public ResolutionEntryFlyweight ageInMs(int n2) {
        this.putInt(4, n2, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int ageInMs() {
        return this.getInt(4, ByteOrder.LITTLE_ENDIAN);
    }

    public ResolutionEntryFlyweight putAddress(byte[] byArray) {
        switch (this.resType()) {
            case 1: {
                if (4 != byArray.length) {
                    throw new IllegalArgumentException("Invalid address length: " + byArray.length);
                }
                this.putBytes(8, byArray, 0, 4);
                break;
            }
            case 2: {
                if (16 != byArray.length) {
                    throw new IllegalArgumentException("Invalid address length: " + byArray.length);
                }
                this.putBytes(8, byArray, 0, 16);
                break;
            }
            default: {
                throw new IllegalStateException("unknown RES_TYPE=" + this.resType());
            }
        }
        return this;
    }

    public int getAddress(byte[] byArray) {
        switch (this.resType()) {
            case 1: {
                if (4 > byArray.length) {
                    throw new IllegalArgumentException("Insufficient length: " + byArray.length);
                }
                this.getBytes(8, byArray, 0, 4);
                return 4;
            }
            case 2: {
                if (16 > byArray.length) {
                    throw new IllegalArgumentException("Insufficient length: " + byArray.length);
                }
                this.getBytes(8, byArray, 0, 16);
                return 16;
            }
        }
        throw new IllegalStateException("unknown RES_TYPE=" + this.resType());
    }

    public void appendAddress(Appendable appendable) {
        try {
            switch (this.resType()) {
                case 1: {
                    int n2 = 8;
                    appendable.append(String.valueOf(this.getByte(8) & 0xFF)).append('.').append(String.valueOf(this.getByte(9) & 0xFF)).append('.').append(String.valueOf(this.getByte(10) & 0xFF)).append('.').append(String.valueOf(this.getByte(11) & 0xFF));
                    break;
                }
                case 2: {
                    int n3 = 8;
                    appendable.append(Integer.toHexString(this.getByte(8) << 8 & 0xFF00 | this.getByte(9) & 0xFF)).append(':').append(Integer.toHexString(this.getByte(10) << 8 & 0xFF00 | this.getByte(11) & 0xFF)).append(':').append(Integer.toHexString(this.getByte(12) << 8 & 0xFF00 | this.getByte(13) & 0xFF)).append(':').append(Integer.toHexString(this.getByte(14) << 8 & 0xFF00 | this.getByte(15) & 0xFF)).append(':').append(Integer.toHexString(this.getByte(16) << 8 & 0xFF00 | this.getByte(17) & 0xFF)).append(':').append(Integer.toHexString(this.getByte(18) << 8 & 0xFF00 | this.getByte(19) & 0xFF)).append(':').append(Integer.toHexString(this.getByte(20) << 8 & 0xFF00 | this.getByte(21) & 0xFF)).append(':').append(Integer.toHexString(this.getByte(22) << 8 & 0xFF00 | this.getByte(23) & 0xFF));
                    break;
                }
                default: {
                    appendable.append("unknown RES_TYPE=").append(String.valueOf(this.resType()));
                    break;
                }
            }
        }
        catch (Exception exception) {
            LangUtil.rethrowUnchecked(exception);
        }
    }

    public ResolutionEntryFlyweight putName(byte[] byArray) {
        int n2 = ResolutionEntryFlyweight.nameOffset(this.resType());
        this.putShort(n2, (short)byArray.length, ByteOrder.LITTLE_ENDIAN);
        this.putBytes(n2 + 2, byArray);
        return this;
    }

    public int getName(byte[] byArray) {
        int n2 = ResolutionEntryFlyweight.nameOffset(this.resType());
        short s2 = this.getShort(n2, ByteOrder.LITTLE_ENDIAN);
        if (s2 > byArray.length) {
            throw new IllegalArgumentException("Insufficient length: " + byArray.length);
        }
        this.getBytes(n2 + 2, byArray, 0, (int)s2);
        return s2;
    }

    public void appendName(StringBuilder stringBuilder) {
        int n2 = ResolutionEntryFlyweight.nameOffset(this.resType());
        short s2 = this.getShort(n2, ByteOrder.LITTLE_ENDIAN);
        this.getStringWithoutLengthAscii(n2 + 2, s2, stringBuilder);
    }

    public int entryLength() {
        int n2 = ResolutionEntryFlyweight.nameOffset(this.resType());
        return BitUtil.align(n2 + 2 + this.getShort(n2, ByteOrder.LITTLE_ENDIAN), 8);
    }

    public static int nameOffset(byte by2) {
        switch (by2) {
            case 1: {
                return 12;
            }
            case 2: {
                return 24;
            }
        }
        throw new IllegalStateException("unknown RES_TYPE=" + by2);
    }

    public static int entryLengthRequired(byte by2, int n2) {
        return BitUtil.align(ResolutionEntryFlyweight.nameOffset(by2) + 2 + n2, 8);
    }

    public static int addressLength(byte by2) {
        switch (by2) {
            case 1: {
                return 4;
            }
            case 2: {
                return 16;
            }
        }
        throw new IllegalStateException("unknown RES_TYPE=" + by2);
    }

    public static boolean isAnyLocalAddress(byte[] byArray, int n2) {
        if (n2 == 4) {
            return 0 == byArray[0] && 0 == byArray[1] && 0 == byArray[2] && 0 == byArray[3];
        }
        if (n2 == 16) {
            byte by2 = 0;
            for (int i2 = 0; i2 < 16; ++i2) {
                by2 = (byte)(by2 | byArray[i2]);
            }
            return 0 == by2;
        }
        return false;
    }
}

