/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.logbuffer;

import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class LogBufferDescriptor {
    public static final int PARTITION_COUNT = 3;
    public static final int LOG_META_DATA_SECTION_INDEX = 3;
    public static final int TERM_MIN_LENGTH = 65536;
    public static final int TERM_MAX_LENGTH = 0x40000000;
    public static final int PAGE_MIN_SIZE = 4096;
    public static final int PAGE_MAX_SIZE = 0x40000000;
    public static final int TERM_TAIL_COUNTERS_OFFSET;
    public static final int LOG_ACTIVE_TERM_COUNT_OFFSET;
    public static final int LOG_END_OF_STREAM_POSITION_OFFSET;
    public static final int LOG_IS_CONNECTED_OFFSET;
    public static final int LOG_ACTIVE_TRANSPORT_COUNT;
    public static final int LOG_INITIAL_TERM_ID_OFFSET;
    public static final int LOG_DEFAULT_FRAME_HEADER_LENGTH_OFFSET;
    public static final int LOG_MTU_LENGTH_OFFSET;
    public static final int LOG_CORRELATION_ID_OFFSET;
    public static final int LOG_TERM_LENGTH_OFFSET;
    public static final int LOG_PAGE_SIZE_OFFSET;
    public static final int LOG_DEFAULT_FRAME_HEADER_OFFSET;
    public static final int LOG_DEFAULT_FRAME_HEADER_MAX_LENGTH = 128;
    public static final int LOG_META_DATA_LENGTH;

    public static void checkTermLength(int n2) {
        if (n2 < 65536) {
            throw new IllegalStateException("Term length less than min length of 65536: length=" + n2);
        }
        if (n2 > 0x40000000) {
            throw new IllegalStateException("Term length more than max length of 1073741824: length=" + n2);
        }
        if (!BitUtil.isPowerOfTwo(n2)) {
            throw new IllegalStateException("Term length not a power of 2: length=" + n2);
        }
    }

    public static void checkPageSize(int n2) {
        if (n2 < 4096) {
            throw new IllegalStateException("Page size less than min size of 4096: page size=" + n2);
        }
        if (n2 > 0x40000000) {
            throw new IllegalStateException("Page size more than max size of 1073741824: page size=" + n2);
        }
        if (!BitUtil.isPowerOfTwo(n2)) {
            throw new IllegalStateException("Page size not a power of 2: page size=" + n2);
        }
    }

    public static int initialTermId(UnsafeBuffer unsafeBuffer) {
        return unsafeBuffer.getInt(LOG_INITIAL_TERM_ID_OFFSET);
    }

    public static void initialTermId(UnsafeBuffer unsafeBuffer, int n2) {
        unsafeBuffer.putInt(LOG_INITIAL_TERM_ID_OFFSET, n2);
    }

    public static int mtuLength(UnsafeBuffer unsafeBuffer) {
        return unsafeBuffer.getInt(LOG_MTU_LENGTH_OFFSET);
    }

    public static void mtuLength(UnsafeBuffer unsafeBuffer, int n2) {
        unsafeBuffer.putInt(LOG_MTU_LENGTH_OFFSET, n2);
    }

    public static int termLength(UnsafeBuffer unsafeBuffer) {
        return unsafeBuffer.getInt(LOG_TERM_LENGTH_OFFSET);
    }

    public static void termLength(UnsafeBuffer unsafeBuffer, int n2) {
        unsafeBuffer.putInt(LOG_TERM_LENGTH_OFFSET, n2);
    }

    public static int pageSize(UnsafeBuffer unsafeBuffer) {
        return unsafeBuffer.getInt(LOG_PAGE_SIZE_OFFSET);
    }

    public static void pageSize(UnsafeBuffer unsafeBuffer, int n2) {
        unsafeBuffer.putInt(LOG_PAGE_SIZE_OFFSET, n2);
    }

    public static long correlationId(UnsafeBuffer unsafeBuffer) {
        return unsafeBuffer.getLong(LOG_CORRELATION_ID_OFFSET);
    }

    public static void correlationId(UnsafeBuffer unsafeBuffer, long l2) {
        unsafeBuffer.putLong(LOG_CORRELATION_ID_OFFSET, l2);
    }

    public static boolean isConnected(UnsafeBuffer unsafeBuffer) {
        return unsafeBuffer.getIntVolatile(LOG_IS_CONNECTED_OFFSET) == 1;
    }

    public static void isConnected(UnsafeBuffer unsafeBuffer, boolean bl2) {
        unsafeBuffer.putIntOrdered(LOG_IS_CONNECTED_OFFSET, bl2 ? 1 : 0);
    }

    public static int activeTransportCount(UnsafeBuffer unsafeBuffer) {
        return unsafeBuffer.getIntVolatile(LOG_ACTIVE_TRANSPORT_COUNT);
    }

    public static void activeTransportCount(UnsafeBuffer unsafeBuffer, int n2) {
        unsafeBuffer.putIntOrdered(LOG_ACTIVE_TRANSPORT_COUNT, n2);
    }

    public static long endOfStreamPosition(UnsafeBuffer unsafeBuffer) {
        return unsafeBuffer.getLongVolatile(LOG_END_OF_STREAM_POSITION_OFFSET);
    }

    public static void endOfStreamPosition(UnsafeBuffer unsafeBuffer, long l2) {
        unsafeBuffer.putLongOrdered(LOG_END_OF_STREAM_POSITION_OFFSET, l2);
    }

    public static int activeTermCount(UnsafeBuffer unsafeBuffer) {
        return unsafeBuffer.getIntVolatile(LOG_ACTIVE_TERM_COUNT_OFFSET);
    }

    public static void activeTermCountOrdered(UnsafeBuffer unsafeBuffer, int n2) {
        unsafeBuffer.putIntOrdered(LOG_ACTIVE_TERM_COUNT_OFFSET, n2);
    }

    public static boolean casActiveTermCount(UnsafeBuffer unsafeBuffer, int n2, int n3) {
        return unsafeBuffer.compareAndSetInt(LOG_ACTIVE_TERM_COUNT_OFFSET, n2, n3);
    }

    public static void activeTermCount(UnsafeBuffer unsafeBuffer, int n2) {
        unsafeBuffer.putInt(LOG_ACTIVE_TERM_COUNT_OFFSET, n2);
    }

    public static int nextPartitionIndex(int n2) {
        return (n2 + 1) % 3;
    }

    public static int indexByTerm(int n2, int n3) {
        return (n3 - n2) % 3;
    }

    public static int indexByTermCount(long l2) {
        return (int)(l2 % 3L);
    }

    public static int indexByPosition(long l2, int n2) {
        return (int)((l2 >>> n2) % 3L);
    }

    public static long computePosition(int n2, int n3, int n4, int n5) {
        long l2 = n2 - n5;
        return (l2 << n4) + (long)n3;
    }

    public static long computeTermBeginPosition(int n2, int n3, int n4) {
        long l2 = n2 - n4;
        return l2 << n3;
    }

    public static int computeTermIdFromPosition(long l2, int n2, int n3) {
        return (int)(l2 >>> n2) + n3;
    }

    public static long computeLogLength(int n2, int n3) {
        if (n2 < 0x40000000) {
            return BitUtil.align(n2 * 3 + LOG_META_DATA_LENGTH, n3);
        }
        return 3L * (long)n2 + (long)BitUtil.align(LOG_META_DATA_LENGTH, n3);
    }

    public static void storeDefaultFrameHeader(UnsafeBuffer unsafeBuffer, DirectBuffer directBuffer) {
        if (directBuffer.capacity() != 32) {
            throw new IllegalArgumentException("Default header length not equal to HEADER_LENGTH: length=" + directBuffer.capacity());
        }
        unsafeBuffer.putInt(LOG_DEFAULT_FRAME_HEADER_LENGTH_OFFSET, 32);
        unsafeBuffer.putBytes(LOG_DEFAULT_FRAME_HEADER_OFFSET, directBuffer, 0, 32);
    }

    public static UnsafeBuffer defaultFrameHeader(UnsafeBuffer unsafeBuffer) {
        return new UnsafeBuffer(unsafeBuffer, LOG_DEFAULT_FRAME_HEADER_OFFSET, 32);
    }

    public static void applyDefaultHeader(UnsafeBuffer unsafeBuffer, UnsafeBuffer unsafeBuffer2, int n2) {
        unsafeBuffer2.putBytes(n2, unsafeBuffer, LOG_DEFAULT_FRAME_HEADER_OFFSET, 32);
    }

    public static boolean rotateLog(UnsafeBuffer unsafeBuffer, int n2, int n3) {
        long l2;
        int n4 = n3 + 1;
        int n5 = n2 + 1;
        int n6 = LogBufferDescriptor.indexByTermCount(n5);
        int n7 = n4 - 3;
        while (n7 == LogBufferDescriptor.termId(l2 = LogBufferDescriptor.rawTailVolatile(unsafeBuffer, n6)) && !LogBufferDescriptor.casRawTail(unsafeBuffer, n6, l2, LogBufferDescriptor.packTail(n4, 0))) {
        }
        return LogBufferDescriptor.casActiveTermCount(unsafeBuffer, n2, n5);
    }

    public static void initialiseTailWithTermId(UnsafeBuffer unsafeBuffer, int n2, int n3) {
        unsafeBuffer.putLong(TERM_TAIL_COUNTERS_OFFSET + n2 * 8, LogBufferDescriptor.packTail(n3, 0));
    }

    public static int termId(long l2) {
        return (int)(l2 >> 32);
    }

    public static int termOffset(long l2, long l3) {
        long l4 = l2 & 0xFFFFFFFFL;
        return (int)Math.min(l4, l3);
    }

    public static int termOffset(long l2) {
        return (int)l2;
    }

    public static long packTail(int n2, int n3) {
        return (long)n2 << 32 | (long)n3;
    }

    public static void rawTail(UnsafeBuffer unsafeBuffer, int n2, long l2) {
        unsafeBuffer.putLong(TERM_TAIL_COUNTERS_OFFSET + 8 * n2, l2);
    }

    public static long rawTail(UnsafeBuffer unsafeBuffer, int n2) {
        return unsafeBuffer.getLong(TERM_TAIL_COUNTERS_OFFSET + 8 * n2);
    }

    public static void rawTailVolatile(UnsafeBuffer unsafeBuffer, int n2, long l2) {
        unsafeBuffer.putLongVolatile(TERM_TAIL_COUNTERS_OFFSET + 8 * n2, l2);
    }

    public static long rawTailVolatile(UnsafeBuffer unsafeBuffer, int n2) {
        return unsafeBuffer.getLongVolatile(TERM_TAIL_COUNTERS_OFFSET + 8 * n2);
    }

    public static long rawTailVolatile(UnsafeBuffer unsafeBuffer) {
        int n2 = LogBufferDescriptor.indexByTermCount(LogBufferDescriptor.activeTermCount(unsafeBuffer));
        return unsafeBuffer.getLongVolatile(TERM_TAIL_COUNTERS_OFFSET + 8 * n2);
    }

    public static boolean casRawTail(UnsafeBuffer unsafeBuffer, int n2, long l2, long l3) {
        int n3 = TERM_TAIL_COUNTERS_OFFSET + 8 * n2;
        return unsafeBuffer.compareAndSetLong(n3, l2, l3);
    }

    public static int positionBitsToShift(int n2) {
        switch (n2) {
            case 65536: {
                return 16;
            }
            case 131072: {
                return 17;
            }
            case 262144: {
                return 18;
            }
            case 524288: {
                return 19;
            }
            case 0x100000: {
                return 20;
            }
            case 0x200000: {
                return 21;
            }
            case 0x400000: {
                return 22;
            }
            case 0x800000: {
                return 23;
            }
            case 0x1000000: {
                return 24;
            }
            case 0x2000000: {
                return 25;
            }
            case 0x4000000: {
                return 26;
            }
            case 0x8000000: {
                return 27;
            }
            case 0x10000000: {
                return 28;
            }
            case 0x20000000: {
                return 29;
            }
            case 0x40000000: {
                return 30;
            }
        }
        throw new IllegalArgumentException("invalid term buffer length: " + n2);
    }

    static {
        int n2;
        TERM_TAIL_COUNTERS_OFFSET = n2 = 0;
        LOG_ACTIVE_TERM_COUNT_OFFSET = n2 += 24;
        LOG_END_OF_STREAM_POSITION_OFFSET = n2 = 128;
        LOG_IS_CONNECTED_OFFSET = LOG_END_OF_STREAM_POSITION_OFFSET + 8;
        LOG_ACTIVE_TRANSPORT_COUNT = LOG_IS_CONNECTED_OFFSET + 4;
        LOG_CORRELATION_ID_OFFSET = n2 += 128;
        LOG_INITIAL_TERM_ID_OFFSET = LOG_CORRELATION_ID_OFFSET + 8;
        LOG_DEFAULT_FRAME_HEADER_LENGTH_OFFSET = LOG_INITIAL_TERM_ID_OFFSET + 4;
        LOG_MTU_LENGTH_OFFSET = LOG_DEFAULT_FRAME_HEADER_LENGTH_OFFSET + 4;
        LOG_TERM_LENGTH_OFFSET = LOG_MTU_LENGTH_OFFSET + 4;
        LOG_PAGE_SIZE_OFFSET = LOG_TERM_LENGTH_OFFSET + 4;
        LOG_DEFAULT_FRAME_HEADER_OFFSET = n2 += 64;
        LOG_META_DATA_LENGTH = BitUtil.align(n2 + 128, 4096);
    }
}

