/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.exceptions;

import io.aeron.ErrorCode;
import io.aeron.exceptions.AeronException;

public class RegistrationException
extends AeronException {
    private static final long serialVersionUID = 9076689715024983035L;
    private final long correlationId;
    private final int errorCodeValue;
    private final ErrorCode errorCode;

    public RegistrationException(long l2, int n2, ErrorCode errorCode, String string) {
        super(RegistrationException.stripCategoryName(string) + ", errorCodeValue=" + n2, ErrorCode.RESOURCE_TEMPORARILY_UNAVAILABLE == errorCode ? AeronException.Category.WARN : AeronException.Category.ERROR);
        this.correlationId = l2;
        this.errorCode = errorCode;
        this.errorCodeValue = n2;
    }

    public RegistrationException(RegistrationException registrationException) {
        super(RegistrationException.stripCategoryName(registrationException.getMessage()), registrationException, registrationException.category());
        this.correlationId = registrationException.correlationId;
        this.errorCode = registrationException.errorCode;
        this.errorCodeValue = registrationException.errorCodeValue;
    }

    public long correlationId() {
        return this.correlationId;
    }

    public ErrorCode errorCode() {
        return this.errorCode;
    }

    public int errorCodeValue() {
        return this.errorCodeValue;
    }

    private static String stripCategoryName(String string) {
        if (null != string && string.length() > 7) {
            if (string.startsWith("ERROR - ") || string.startsWith("FATAL - ")) {
                return string.substring(8);
            }
            if (string.startsWith("WARN - ")) {
                return string.substring(7);
            }
        }
        return string;
    }
}

