/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.ChannelUri;
import io.aeron.driver.DefaultNameResolver;
import io.aeron.driver.NameResolver;
import io.aeron.driver.exceptions.InvalidChannelException;
import io.aeron.driver.media.InterfaceSearchAddress;
import io.aeron.driver.media.NetworkUtil;
import io.aeron.driver.media.SocketAddressParser;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ProtocolFamily;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.agrona.BitUtil;
import org.agrona.SystemUtil;

public final class UdpChannel {
    public static final int RESERVED_VALUE_MESSAGE_OFFSET = -8;
    private static final AtomicInteger UNIQUE_CANONICAL_FORM_VALUE = new AtomicInteger();
    private static final InetSocketAddress ANY_IPV4 = new InetSocketAddress("0.0.0.0", 0);
    private static final InetSocketAddress ANY_IPV6 = new InetSocketAddress("::", 0);
    private final boolean isManualControlMode;
    private final boolean isDynamicControlMode;
    private final boolean hasExplicitControl;
    private final boolean hasExplicitEndpoint;
    private final boolean isMulticast;
    private final boolean hasMulticastTtl;
    private final boolean hasTag;
    private final int multicastTtl;
    private final int socketRcvbufLength;
    private final int socketSndbufLength;
    private final int receiverWindowLength;
    private final long tag;
    private final InetSocketAddress remoteData;
    private final InetSocketAddress localData;
    private final InetSocketAddress remoteControl;
    private final InetSocketAddress localControl;
    private final String uriStr;
    private final String canonicalForm;
    private final NetworkInterface localInterface;
    private final ProtocolFamily protocolFamily;
    private final ChannelUri channelUri;
    private final int channelReceiveTimestampOffset;
    private final int channelSendTimestampOffset;
    private final Long groupTag;

    private UdpChannel(Context context) {
        this.isManualControlMode = context.isManualControlMode;
        this.isDynamicControlMode = context.isDynamicControlMode;
        this.hasExplicitEndpoint = context.hasExplicitEndpoint;
        this.hasExplicitControl = context.hasExplicitControl;
        this.isMulticast = context.isMulticast;
        this.hasTag = context.hasTagId;
        this.tag = context.tagId;
        this.hasMulticastTtl = context.hasMulticastTtl;
        this.multicastTtl = context.multicastTtl;
        this.remoteData = context.remoteData;
        this.localData = context.localData;
        this.remoteControl = context.remoteControl;
        this.localControl = context.localControl;
        this.uriStr = context.uriStr;
        this.canonicalForm = context.canonicalForm;
        this.localInterface = context.localInterface;
        this.protocolFamily = context.protocolFamily;
        this.channelUri = context.channelUri;
        this.socketRcvbufLength = context.socketRcvbufLength;
        this.socketSndbufLength = context.socketSndbufLength;
        this.receiverWindowLength = context.receiverWindowLength;
        this.channelReceiveTimestampOffset = context.channelReceiveTimestampOffset;
        this.channelSendTimestampOffset = context.channelSendTimestampOffset;
        this.groupTag = context.groupTag;
    }

    public static UdpChannel parse(String string) {
        return UdpChannel.parse(string, DefaultNameResolver.INSTANCE, false);
    }

    public static UdpChannel parse(String string, NameResolver nameResolver) {
        return UdpChannel.parse(string, nameResolver, false);
    }

    public static UdpChannel parse(String string, NameResolver nameResolver, boolean bl2) {
        try {
            Object object;
            boolean bl3;
            ChannelUri channelUri = ChannelUri.parse(string);
            UdpChannel.validateConfiguration(channelUri);
            InetSocketAddress inetSocketAddress = UdpChannel.getEndpointAddress(channelUri, nameResolver);
            InetSocketAddress inetSocketAddress2 = UdpChannel.getExplicitControlAddress(channelUri, nameResolver);
            String string2 = channelUri.channelTag();
            String string3 = channelUri.get("control-mode");
            boolean bl4 = "manual".equals(string3);
            boolean bl5 = "dynamic".equals(string3);
            int n2 = UdpChannel.parseBufferLength(channelUri, "so-rcvbuf");
            int n3 = UdpChannel.parseBufferLength(channelUri, "so-sndbuf");
            int n4 = UdpChannel.parseBufferLength(channelUri, "rcv-wnd");
            boolean bl6 = !bl2 && (null == inetSocketAddress && null == inetSocketAddress2 || null != inetSocketAddress && inetSocketAddress.getPort() == 0 || null != inetSocketAddress2 && inetSocketAddress2.getPort() == 0);
            boolean bl7 = bl3 = null == inetSocketAddress && null == inetSocketAddress2 && null == string2;
            if (bl5 && null == inetSocketAddress2) {
                throw new IllegalArgumentException("explicit control expected with dynamic control mode: " + string);
            }
            if (bl3 && !bl4) {
                throw new IllegalArgumentException("URIs for UDP must specify an endpoint, control, tags, or control-mode=manual: " + string);
            }
            if (null != inetSocketAddress && inetSocketAddress.isUnresolved()) {
                throw new UnknownHostException("could not resolve endpoint address: " + inetSocketAddress);
            }
            if (null != inetSocketAddress2 && inetSocketAddress2.isUnresolved()) {
                throw new UnknownHostException("could not resolve control address: " + inetSocketAddress2);
            }
            boolean bl8 = true;
            if (null == inetSocketAddress) {
                bl8 = false;
                inetSocketAddress = null != inetSocketAddress2 && inetSocketAddress2.getAddress() instanceof Inet6Address ? ANY_IPV6 : ANY_IPV4;
            }
            Context context = new Context().isMulticast(false).hasExplicitControl(false).hasMulticastTtl(false).hasTagId(false).uriStr(string).channelUri(channelUri).isManualControlMode(bl4).isDynamicControlMode(bl5).hasExplicitEndpoint(bl8).hasNoDistinguishingCharacteristic(bl3).socketRcvbufLength(n2).socketSndbufLength(n3).receiverWindowLength(n4);
            if (null != string2) {
                context.hasTagId(true).tagId(Long.parseLong(string2));
            }
            if (inetSocketAddress.getAddress().isMulticastAddress()) {
                object = UdpChannel.getInterfaceSearchAddress(channelUri);
                NetworkInterface networkInterface = UdpChannel.findInterface((InterfaceSearchAddress)object);
                InetSocketAddress inetSocketAddress3 = UdpChannel.resolveToAddressOfInterface(networkInterface, (InterfaceSearchAddress)object);
                context.isMulticast(true).localControlAddress(inetSocketAddress3).remoteControlAddress(UdpChannel.getMulticastControlAddress(inetSocketAddress)).localDataAddress(inetSocketAddress3).remoteDataAddress(inetSocketAddress).localInterface(networkInterface).protocolFamily(NetworkUtil.getProtocolFamily(inetSocketAddress.getAddress())).canonicalForm(UdpChannel.canonicalise(null, inetSocketAddress3, null, inetSocketAddress));
                String string4 = channelUri.get("ttl");
                if (null != string4) {
                    context.hasMulticastTtl(true).multicastTtl(Integer.parseInt(string4));
                }
            } else if (null != inetSocketAddress2) {
                object = channelUri.get("control");
                String string5 = channelUri.get("endpoint");
                String string6 = "";
                if (bl6) {
                    string6 = null != string2 ? "#" + string2 : "-" + UNIQUE_CANONICAL_FORM_VALUE.getAndAdd(1);
                }
                String string7 = UdpChannel.canonicalise((String)object, inetSocketAddress2, string5, inetSocketAddress) + string6;
                context.hasExplicitControl(true).remoteControlAddress(inetSocketAddress).remoteDataAddress(inetSocketAddress).localControlAddress(inetSocketAddress2).localDataAddress(inetSocketAddress2).protocolFamily(NetworkUtil.getProtocolFamily(inetSocketAddress.getAddress())).canonicalForm(string7);
            } else {
                object = UdpChannel.getInterfaceSearchAddress(channelUri);
                InetSocketAddress inetSocketAddress4 = ((InterfaceSearchAddress)object).getInetAddress().isAnyLocalAddress() ? ((InterfaceSearchAddress)object).getAddress() : UdpChannel.resolveToAddressOfInterface(UdpChannel.findInterface((InterfaceSearchAddress)object), (InterfaceSearchAddress)object);
                String string8 = channelUri.get("endpoint");
                String string9 = "";
                if (bl6) {
                    string9 = null != string2 ? "#" + string2 : "-" + UNIQUE_CANONICAL_FORM_VALUE.getAndAdd(1);
                }
                context.remoteControlAddress(inetSocketAddress).remoteDataAddress(inetSocketAddress).localControlAddress(inetSocketAddress4).localDataAddress(inetSocketAddress4).protocolFamily(NetworkUtil.getProtocolFamily(inetSocketAddress.getAddress())).canonicalForm(UdpChannel.canonicalise(null, inetSocketAddress4, string8, inetSocketAddress) + string9);
            }
            context.channelReceiveTimestampOffset(UdpChannel.parseTimestampOffset(channelUri, "channel-rcv-ts-offset"));
            context.channelSendTimestampOffset(UdpChannel.parseTimestampOffset(channelUri, "channel-snd-ts-offset"));
            object = UdpChannel.parseOptionalLong(channelUri, "gtag");
            context.groupTag((Long)object);
            return new UdpChannel(context);
        }
        catch (Exception exception) {
            throw new InvalidChannelException(exception);
        }
    }

    private static int parseTimestampOffset(ChannelUri channelUri, String string) {
        String string2 = channelUri.get(string);
        if (null == string2) {
            return -1;
        }
        if ("reserved".equals(string2)) {
            return -8;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("timestamp offset must be a valid integer or the 'reserved' keyword", numberFormatException);
        }
    }

    private static Long parseOptionalLong(ChannelUri channelUri, String string) {
        String string2 = channelUri.get(string);
        if (null == string2) {
            return null;
        }
        try {
            return Long.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("'" + string + "' does not contain a valid long value", numberFormatException);
        }
    }

    public static int parseBufferLength(ChannelUri channelUri, String string) {
        int n2 = 0;
        String string2 = channelUri.get(string);
        if (null != string2) {
            long l2 = SystemUtil.parseSize(string, string2);
            if (l2 < 0L || l2 > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Invalid " + string + " length: " + l2);
            }
            n2 = (int)l2;
        }
        return n2;
    }

    public static String canonicalise(String string, InetSocketAddress inetSocketAddress, String string2, InetSocketAddress inetSocketAddress2) {
        StringBuilder stringBuilder = new StringBuilder(48);
        stringBuilder.append("UDP-");
        if (null == string) {
            stringBuilder.append(inetSocketAddress.getHostString()).append(':').append(inetSocketAddress.getPort());
        } else {
            stringBuilder.append(string);
        }
        stringBuilder.append('-');
        if (null == string2) {
            stringBuilder.append(inetSocketAddress2.getHostString()).append(':').append(inetSocketAddress2.getPort());
        } else {
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public InetSocketAddress remoteData() {
        return this.remoteData;
    }

    public InetSocketAddress localData() {
        return this.localData;
    }

    public InetSocketAddress remoteControl() {
        return this.remoteControl;
    }

    public InetSocketAddress localControl() {
        return this.localControl;
    }

    public ChannelUri channelUri() {
        return this.channelUri;
    }

    public boolean hasMulticastTtl() {
        return this.hasMulticastTtl;
    }

    public int multicastTtl() {
        return this.multicastTtl;
    }

    public String canonicalForm() {
        return this.canonicalForm;
    }

    public String toString() {
        return this.canonicalForm;
    }

    public boolean isMulticast() {
        return this.isMulticast;
    }

    public NetworkInterface localInterface() {
        return this.localInterface;
    }

    public String originalUriString() {
        return this.uriStr;
    }

    public ProtocolFamily protocolFamily() {
        return this.protocolFamily;
    }

    public long tag() {
        return this.tag;
    }

    public boolean isManualControlMode() {
        return this.isManualControlMode;
    }

    public boolean isDynamicControlMode() {
        return this.isDynamicControlMode;
    }

    public boolean hasExplicitEndpoint() {
        return this.hasExplicitEndpoint;
    }

    public boolean hasExplicitControl() {
        return this.hasExplicitControl;
    }

    public boolean hasTag() {
        return this.hasTag;
    }

    public boolean isMultiDestination() {
        return this.isDynamicControlMode || this.isManualControlMode || this.hasExplicitControl;
    }

    public int socketRcvbufLength() {
        return this.socketRcvbufLength;
    }

    public int socketRcvbufLengthOrDefault(int n2) {
        return 0 != this.socketRcvbufLength ? this.socketRcvbufLength : n2;
    }

    public int socketSndbufLength() {
        return this.socketSndbufLength;
    }

    public int socketSndbufLengthOrDefault(int n2) {
        return 0 != this.socketSndbufLength ? this.socketSndbufLength : n2;
    }

    public int receiverWindowLength() {
        return this.receiverWindowLength;
    }

    public int receiverWindowLengthOrDefault(int n2) {
        return 0 != this.receiverWindowLength() ? this.receiverWindowLength() : n2;
    }

    public boolean matchesTag(UdpChannel udpChannel) {
        if (!this.hasTag || !udpChannel.hasTag() || this.tag != udpChannel.tag()) {
            return false;
        }
        if (udpChannel.remoteData().getAddress().isAnyLocalAddress() && udpChannel.remoteData().getPort() == 0 && udpChannel.localData().getAddress().isAnyLocalAddress() && udpChannel.localData().getPort() == 0) {
            return true;
        }
        throw new IllegalArgumentException("matching tag=" + this.tag + " has explicit endpoint or control: " + this.uriStr + " <> " + udpChannel.uriStr);
    }

    public String description() {
        return "localData: " + NetworkUtil.formatAddressAndPort(this.localData.getAddress(), this.localData.getPort()) + ", remoteData: " + NetworkUtil.formatAddressAndPort(this.remoteData.getAddress(), this.remoteData.getPort()) + ", ttl: " + this.multicastTtl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        UdpChannel udpChannel = (UdpChannel)object;
        return Objects.equals(this.canonicalForm, udpChannel.canonicalForm);
    }

    public int hashCode() {
        return this.canonicalForm != null ? this.canonicalForm.hashCode() : 0;
    }

    public static InetSocketAddress destinationAddress(ChannelUri channelUri, NameResolver nameResolver) {
        try {
            UdpChannel.validateConfiguration(channelUri);
            String string = channelUri.get("endpoint");
            return SocketAddressParser.parse(string, "endpoint", false, nameResolver);
        }
        catch (Exception exception) {
            throw new InvalidChannelException(exception);
        }
    }

    public static InetSocketAddress resolve(String string, String string2, boolean bl2, NameResolver nameResolver) {
        return SocketAddressParser.parse(string, string2, bl2, nameResolver);
    }

    public int channelReceiveTimestampOffset() {
        return this.channelReceiveTimestampOffset;
    }

    public boolean isChannelReceiveTimestampEnabled() {
        return -8 == this.channelReceiveTimestampOffset || 0 <= this.channelReceiveTimestampOffset;
    }

    public boolean isChannelSendTimestampEnabled() {
        return -8 == this.channelSendTimestampOffset || 0 <= this.channelSendTimestampOffset;
    }

    public int channelSendTimestampOffset() {
        return this.channelSendTimestampOffset;
    }

    public Long groupTag() {
        return this.groupTag;
    }

    private static InetSocketAddress getMulticastControlAddress(InetSocketAddress inetSocketAddress) throws UnknownHostException {
        byte[] byArray = inetSocketAddress.getAddress().getAddress();
        UdpChannel.validateDataAddress(byArray);
        int n2 = byArray.length - 1;
        byArray[n2] = (byte)(byArray[n2] + 1);
        return new InetSocketAddress(InetAddress.getByAddress(byArray), inetSocketAddress.getPort());
    }

    private static InterfaceSearchAddress getInterfaceSearchAddress(ChannelUri channelUri) throws UnknownHostException {
        String string = channelUri.get("interface");
        if (null != string) {
            return InterfaceSearchAddress.parse(string);
        }
        return InterfaceSearchAddress.wildcard();
    }

    private static InetSocketAddress getEndpointAddress(ChannelUri channelUri, NameResolver nameResolver) throws UnknownHostException {
        InetSocketAddress inetSocketAddress = null;
        String string = channelUri.get("endpoint");
        if (null != string && (inetSocketAddress = SocketAddressParser.parse(string, "endpoint", false, nameResolver)).isUnresolved()) {
            throw new UnknownHostException("unresolved - endpoint=" + string + ", name-resolver=" + nameResolver.getClass().getName());
        }
        return inetSocketAddress;
    }

    private static InetSocketAddress getExplicitControlAddress(ChannelUri channelUri, NameResolver nameResolver) throws UnknownHostException {
        InetSocketAddress inetSocketAddress = null;
        String string = channelUri.get("control");
        if (null != string && (inetSocketAddress = SocketAddressParser.parse(string, "control", false, nameResolver)).isUnresolved()) {
            throw new UnknownHostException("unresolved - control=" + string + ", name-resolver=" + nameResolver.getClass().getName());
        }
        return inetSocketAddress;
    }

    private static void validateDataAddress(byte[] byArray) {
        if (BitUtil.isEven(byArray[byArray.length - 1])) {
            throw new IllegalArgumentException("multicast data address must be odd");
        }
    }

    private static void validateConfiguration(ChannelUri channelUri) {
        UdpChannel.validateMedia(channelUri);
    }

    private static void validateMedia(ChannelUri channelUri) {
        if (!channelUri.isUdp()) {
            throw new IllegalArgumentException("UdpChannel only supports UDP media: " + channelUri);
        }
    }

    private static InetSocketAddress resolveToAddressOfInterface(NetworkInterface networkInterface, InterfaceSearchAddress interfaceSearchAddress) {
        InetAddress inetAddress = NetworkUtil.findAddressOnInterface(networkInterface, interfaceSearchAddress.getInetAddress(), interfaceSearchAddress.getSubnetPrefix());
        if (null == inetAddress) {
            throw new IllegalStateException();
        }
        return new InetSocketAddress(inetAddress, interfaceSearchAddress.getPort());
    }

    private static NetworkInterface findInterface(InterfaceSearchAddress interfaceSearchAddress) throws SocketException {
        NetworkInterface[] networkInterfaceArray;
        for (NetworkInterface networkInterface : networkInterfaceArray = NetworkUtil.filterBySubnet(interfaceSearchAddress.getInetAddress(), interfaceSearchAddress.getSubnetPrefix())) {
            if (!networkInterface.isUp() || !networkInterface.supportsMulticast() && !networkInterface.isLoopback()) continue;
            return networkInterface;
        }
        throw new IllegalArgumentException(UdpChannel.noMatchingInterfacesError(networkInterfaceArray, interfaceSearchAddress));
    }

    private static String noMatchingInterfacesError(NetworkInterface[] networkInterfaceArray, InterfaceSearchAddress interfaceSearchAddress) throws SocketException {
        StringBuilder stringBuilder = new StringBuilder().append("Unable to find multicast interface matching criteria: ").append(interfaceSearchAddress.getAddress()).append('/').append(interfaceSearchAddress.getSubnetPrefix());
        if (networkInterfaceArray.length > 0) {
            stringBuilder.append(System.lineSeparator()).append("  Candidates:");
            for (NetworkInterface networkInterface : networkInterfaceArray) {
                stringBuilder.append(System.lineSeparator()).append("  - Name: ").append(networkInterface.getDisplayName()).append(", addresses: ").append(networkInterface.getInterfaceAddresses()).append(", multicast: ").append(networkInterface.supportsMulticast()).append(", state: ").append(networkInterface.isUp() ? "UP" : "DOWN");
            }
        }
        return stringBuilder.toString();
    }

    static final class Context {
        boolean isManualControlMode = false;
        boolean isDynamicControlMode = false;
        boolean hasExplicitEndpoint = false;
        boolean hasExplicitControl = false;
        boolean isMulticast = false;
        boolean hasMulticastTtl = false;
        boolean hasTagId = false;
        boolean hasNoDistinguishingCharacteristic = false;
        int socketRcvbufLength = 0;
        int socketSndbufLength = 0;
        int receiverWindowLength = 0;
        int multicastTtl;
        long tagId;
        InetSocketAddress remoteData;
        InetSocketAddress localData;
        InetSocketAddress remoteControl;
        InetSocketAddress localControl;
        String uriStr;
        String canonicalForm;
        NetworkInterface localInterface;
        ProtocolFamily protocolFamily;
        ChannelUri channelUri;
        int channelReceiveTimestampOffset;
        int channelSendTimestampOffset;
        private Long groupTag = null;

        Context() {
        }

        Context uriStr(String string) {
            this.uriStr = string;
            return this;
        }

        Context remoteDataAddress(InetSocketAddress inetSocketAddress) {
            this.remoteData = inetSocketAddress;
            return this;
        }

        Context localDataAddress(InetSocketAddress inetSocketAddress) {
            this.localData = inetSocketAddress;
            return this;
        }

        Context remoteControlAddress(InetSocketAddress inetSocketAddress) {
            this.remoteControl = inetSocketAddress;
            return this;
        }

        Context localControlAddress(InetSocketAddress inetSocketAddress) {
            this.localControl = inetSocketAddress;
            return this;
        }

        Context canonicalForm(String string) {
            this.canonicalForm = string;
            return this;
        }

        Context localInterface(NetworkInterface networkInterface) {
            this.localInterface = networkInterface;
            return this;
        }

        Context protocolFamily(ProtocolFamily protocolFamily) {
            this.protocolFamily = protocolFamily;
            return this;
        }

        Context hasMulticastTtl(boolean bl2) {
            this.hasMulticastTtl = bl2;
            return this;
        }

        Context multicastTtl(int n2) {
            this.multicastTtl = n2;
            return this;
        }

        Context tagId(long l2) {
            this.tagId = l2;
            return this;
        }

        Context channelUri(ChannelUri channelUri) {
            this.channelUri = channelUri;
            return this;
        }

        Context isManualControlMode(boolean bl2) {
            this.isManualControlMode = bl2;
            return this;
        }

        Context isDynamicControlMode(boolean bl2) {
            this.isDynamicControlMode = bl2;
            return this;
        }

        Context hasExplicitEndpoint(boolean bl2) {
            this.hasExplicitEndpoint = bl2;
            return this;
        }

        Context hasExplicitControl(boolean bl2) {
            this.hasExplicitControl = bl2;
            return this;
        }

        Context isMulticast(boolean bl2) {
            this.isMulticast = bl2;
            return this;
        }

        Context hasTagId(boolean bl2) {
            this.hasTagId = bl2;
            return this;
        }

        Context hasNoDistinguishingCharacteristic(boolean bl2) {
            this.hasNoDistinguishingCharacteristic = bl2;
            return this;
        }

        Context socketRcvbufLength(int n2) {
            this.socketRcvbufLength = n2;
            return this;
        }

        Context socketSndbufLength(int n2) {
            this.socketSndbufLength = n2;
            return this;
        }

        Context receiverWindowLength(int n2) {
            this.receiverWindowLength = n2;
            return this;
        }

        Context channelReceiveTimestampOffset(int n2) {
            this.channelReceiveTimestampOffset = n2;
            return this;
        }

        Context channelSendTimestampOffset(int n2) {
            this.channelSendTimestampOffset = n2;
            return this;
        }

        public void groupTag(Long l2) {
            this.groupTag = l2;
        }
    }
}

