/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.protocol.NakFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import io.aeron.protocol.StatusMessageFlyweight;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.agrona.BitUtil;
import org.agrona.BufferUtil;

public final class ReceiveChannelEndpointThreadLocals {
    private final ByteBuffer smBuffer;
    private final StatusMessageFlyweight statusMessageFlyweight;
    private final ByteBuffer nakBuffer;
    private final NakFlyweight nakFlyweight;
    private final ByteBuffer rttMeasurementBuffer;
    private final RttMeasurementFlyweight rttMeasurementFlyweight;
    private long nextReceiverId;

    public ReceiveChannelEndpointThreadLocals() {
        int n2 = 44;
        int n3 = BitUtil.align(44, 64) + BitUtil.align(28, 64) + BitUtil.align(40, 64);
        UUID uUID = UUID.randomUUID();
        this.nextReceiverId = uUID.getMostSignificantBits() ^ uUID.getLeastSignificantBits();
        ByteBuffer byteBuffer = BufferUtil.allocateDirectAligned(n3, 64);
        byteBuffer.limit(44);
        this.smBuffer = byteBuffer.slice();
        this.statusMessageFlyweight = new StatusMessageFlyweight(this.smBuffer);
        int n4 = BitUtil.align(44, 32);
        byteBuffer.limit(n4 + 28).position(n4);
        this.nakBuffer = byteBuffer.slice();
        this.nakFlyweight = new NakFlyweight(this.nakBuffer);
        int n5 = n4 + BitUtil.align(28, 32);
        byteBuffer.limit(n5 + 40).position(n5);
        this.rttMeasurementBuffer = byteBuffer.slice();
        this.rttMeasurementFlyweight = new RttMeasurementFlyweight(this.rttMeasurementBuffer);
        this.statusMessageFlyweight.version((short)0).headerType(3).frameLength(36);
        this.nakFlyweight.version((short)0).headerType(2).frameLength(28);
        this.rttMeasurementFlyweight.version((short)0).headerType(6).frameLength(40);
    }

    public ByteBuffer statusMessageBuffer() {
        return this.smBuffer;
    }

    public StatusMessageFlyweight statusMessageFlyweight() {
        return this.statusMessageFlyweight;
    }

    public ByteBuffer nakBuffer() {
        return this.nakBuffer;
    }

    public NakFlyweight nakFlyweight() {
        return this.nakFlyweight;
    }

    public ByteBuffer rttMeasurementBuffer() {
        return this.rttMeasurementBuffer;
    }

    public RttMeasurementFlyweight rttMeasurementFlyweight() {
        return this.rttMeasurementFlyweight;
    }

    public long nextReceiverId() {
        return this.nextReceiverId++;
    }

    public String toString() {
        return "ReceiveChannelEndpointThreadLocals{nextReceiverId=" + this.nextReceiverId + '}';
    }
}

