/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.media.DataTransportPoller;
import io.aeron.driver.media.ImageConnection;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.media.ReceiveDestinationTransport;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.media.UdpChannelTransport;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.agrona.collections.ArrayUtil;

final class MultiRcvDestination {
    private static final ReceiveDestinationTransport[] EMPTY_TRANSPORTS = new ReceiveDestinationTransport[0];
    private ReceiveDestinationTransport[] transports = EMPTY_TRANSPORTS;

    MultiRcvDestination() {
    }

    void closeTransports(DataTransportPoller dataTransportPoller) {
        for (ReceiveDestinationTransport receiveDestinationTransport : this.transports) {
            if (null == receiveDestinationTransport) continue;
            receiveDestinationTransport.closeTransport();
            if (null == dataTransportPoller) continue;
            dataTransportPoller.selectNowWithoutProcessing();
        }
    }

    void closeIndicators(DriverConductorProxy driverConductorProxy) {
        for (ReceiveDestinationTransport receiveDestinationTransport : this.transports) {
            if (null == receiveDestinationTransport) continue;
            driverConductorProxy.closeReceiveDestinationIndicators(receiveDestinationTransport);
        }
    }

    int addDestination(ReceiveDestinationTransport receiveDestinationTransport) {
        int n2 = this.transports.length;
        int n3 = this.transports.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (null != this.transports[i2]) continue;
            n2 = i2;
            break;
        }
        this.transports = ArrayUtil.ensureCapacity(this.transports, n2 + 1);
        this.transports[n2] = receiveDestinationTransport;
        return n2;
    }

    void removeDestination(int n2) {
        this.transports[n2] = null;
    }

    boolean hasDestination(int n2) {
        return this.transports.length > n2 && null != this.transports[n2];
    }

    ReceiveDestinationTransport transport(int n2) {
        return this.transports[n2];
    }

    int transport(UdpChannel udpChannel) {
        ReceiveDestinationTransport[] receiveDestinationTransportArray = this.transports;
        int n2 = -1;
        int n3 = receiveDestinationTransportArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            ReceiveDestinationTransport receiveDestinationTransport = receiveDestinationTransportArray[i2];
            if (null == receiveDestinationTransport || !receiveDestinationTransport.udpChannel().equals(udpChannel)) continue;
            n2 = i2;
            break;
        }
        return n2;
    }

    void checkForReResolution(ReceiveChannelEndpoint receiveChannelEndpoint, long l2, DriverConductorProxy driverConductorProxy) {
        for (ReceiveDestinationTransport receiveDestinationTransport : this.transports) {
            UdpChannel udpChannel;
            if (null == receiveDestinationTransport || !(udpChannel = receiveDestinationTransport.udpChannel()).hasExplicitControl() || receiveDestinationTransport.timeOfLastActivityNs() + ReceiveChannelEndpoint.DESTINATION_ADDRESS_TIMEOUT >= l2) continue;
            receiveDestinationTransport.timeOfLastActivityNs(l2);
            driverConductorProxy.reResolveControl(udpChannel.channelUri().get("control"), udpChannel, receiveChannelEndpoint, receiveDestinationTransport.currentControlAddress());
        }
    }

    void updateControlAddress(int n2, InetSocketAddress inetSocketAddress) {
        ReceiveDestinationTransport receiveDestinationTransport;
        if (-1 != n2 && null != (receiveDestinationTransport = this.transports[n2])) {
            receiveDestinationTransport.currentControlAddress(inetSocketAddress);
        }
    }

    int sendToAll(ImageConnection[] imageConnectionArray, ByteBuffer byteBuffer, int n2, long l2) {
        int n3;
        ReceiveDestinationTransport[] receiveDestinationTransportArray = this.transports;
        int n4 = n2;
        for (int i2 = n3 = imageConnectionArray.length - 1; i2 >= 0; --i2) {
            ReceiveDestinationTransport receiveDestinationTransport;
            ImageConnection imageConnection = imageConnectionArray[i2];
            if (null == imageConnection || null == (receiveDestinationTransport = receiveDestinationTransportArray[i2]) || imageConnection.timeOfLastActivityNs + ReceiveChannelEndpoint.DESTINATION_ADDRESS_TIMEOUT - l2 <= 0L) continue;
            byteBuffer.position(0);
            n4 = Math.min(n4, MultiRcvDestination.sendTo(receiveDestinationTransport, byteBuffer, imageConnection.controlAddress));
        }
        return n4;
    }

    static int sendTo(UdpChannelTransport udpChannelTransport, ByteBuffer byteBuffer, InetSocketAddress inetSocketAddress) {
        int n2 = byteBuffer.remaining();
        int n3 = 0;
        try {
            if (null != udpChannelTransport && null != udpChannelTransport.sendDatagramChannel && udpChannelTransport.sendDatagramChannel.isOpen()) {
                udpChannelTransport.sendHook(byteBuffer, inetSocketAddress);
                n3 = udpChannelTransport.sendDatagramChannel.send(byteBuffer, inetSocketAddress);
            }
        }
        catch (IOException iOException) {
            UdpChannelTransport.sendError(n2, iOException, inetSocketAddress);
        }
        return n3;
    }
}

