/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.ChannelUri;
import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.media.Destination;
import io.aeron.driver.media.MultiSndDestination;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.protocol.StatusMessageFlyweight;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.CachedNanoClock;

class ManualSndMultiDestination
extends MultiSndDestination {
    ManualSndMultiDestination(CachedNanoClock cachedNanoClock) {
        super(cachedNanoClock);
    }

    @Override
    void onStatusMessage(StatusMessageFlyweight statusMessageFlyweight, InetSocketAddress inetSocketAddress) {
        long l2 = statusMessageFlyweight.receiverId();
        long l3 = this.nanoClock.nanoTime();
        for (Destination destination : this.destinations) {
            if (destination.isReceiverIdValid && l2 == destination.receiverId && inetSocketAddress.getPort() == destination.port) {
                destination.timeOfLastActivityNs = l3;
                break;
            }
            if (destination.isReceiverIdValid || inetSocketAddress.getPort() != destination.port || !inetSocketAddress.getAddress().equals(destination.address.getAddress())) continue;
            destination.timeOfLastActivityNs = l3;
            destination.receiverId = l2;
            destination.isReceiverIdValid = true;
            break;
        }
    }

    @Override
    int send(DatagramChannel datagramChannel, ByteBuffer byteBuffer, SendChannelEndpoint sendChannelEndpoint, int n2) {
        int n3;
        Destination destination;
        int n4;
        int n5;
        int n6 = byteBuffer.position();
        int n7 = this.destinations.length;
        if ((n5 = this.roundRobinIndex++) >= n7) {
            n5 = 0;
            this.roundRobinIndex = 0;
        }
        for (n4 = n5; n4 < n7; ++n4) {
            destination = this.destinations[n4];
            n3 = ManualSndMultiDestination.send(datagramChannel, byteBuffer, sendChannelEndpoint, n2, n6, destination.address);
            if (n3 >= n2) continue;
            this.roundRobinIndex = n4;
            return n3;
        }
        for (n4 = 0; n4 < n5; ++n4) {
            destination = this.destinations[n4];
            n3 = ManualSndMultiDestination.send(datagramChannel, byteBuffer, sendChannelEndpoint, n2, n6, destination.address);
            if (n3 >= n2) continue;
            this.roundRobinIndex = n4;
            return n3;
        }
        return n2;
    }

    @Override
    void addDestination(ChannelUri channelUri, InetSocketAddress inetSocketAddress) {
        this.destinations = ArrayUtil.add(this.destinations, new Destination(this.nanoClock.nanoTime(), channelUri.get("endpoint"), inetSocketAddress));
        this.destinationsCounter.setOrdered(this.destinations.length);
    }

    @Override
    void removeDestination(ChannelUri channelUri, InetSocketAddress inetSocketAddress) {
        boolean bl2 = false;
        int n2 = 0;
        for (Destination destination : this.destinations) {
            if (destination.address.equals(inetSocketAddress)) {
                bl2 = true;
                break;
            }
            ++n2;
        }
        if (bl2) {
            this.destinations = 1 == this.destinations.length ? EMPTY_DESTINATIONS : ArrayUtil.remove(this.destinations, n2);
        }
        this.destinationsCounter.setOrdered(this.destinations.length);
    }

    @Override
    void checkForReResolution(SendChannelEndpoint sendChannelEndpoint, long l2, DriverConductorProxy driverConductorProxy) {
        for (Destination destination : this.destinations) {
            if (destination.timeOfLastActivityNs + SendChannelEndpoint.DESTINATION_TIMEOUT - l2 >= 0L) continue;
            destination.timeOfLastActivityNs = l2;
            driverConductorProxy.reResolveEndpoint(destination.endpoint, sendChannelEndpoint, destination.address);
        }
    }

    @Override
    void updateDestination(String string, InetSocketAddress inetSocketAddress) {
        for (Destination destination : this.destinations) {
            if (!string.equals(destination.endpoint)) continue;
            destination.address = inetSocketAddress;
            destination.port = inetSocketAddress.getPort();
        }
    }
}

