/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.media.Destination;
import io.aeron.driver.media.MultiSndDestination;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.protocol.StatusMessageFlyweight;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.Arrays;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.CachedNanoClock;

class DynamicSndMultiDestination
extends MultiSndDestination {
    DynamicSndMultiDestination(CachedNanoClock cachedNanoClock) {
        super(cachedNanoClock);
    }

    @Override
    void onStatusMessage(StatusMessageFlyweight statusMessageFlyweight, InetSocketAddress inetSocketAddress) {
        long l2 = statusMessageFlyweight.receiverId();
        long l3 = this.nanoClock.nanoTime();
        boolean bl2 = false;
        for (Destination destination : this.destinations) {
            if (l2 != destination.receiverId || inetSocketAddress.getPort() != destination.port) continue;
            destination.timeOfLastActivityNs = l3;
            bl2 = true;
            break;
        }
        if (!bl2) {
            this.add(new Destination(l3, l2, inetSocketAddress));
        }
    }

    @Override
    int send(DatagramChannel datagramChannel, ByteBuffer byteBuffer, SendChannelEndpoint sendChannelEndpoint, int n2) {
        int n3;
        Destination destination;
        int n4;
        int n5;
        long l2 = this.nanoClock.nanoTime();
        int n6 = byteBuffer.position();
        int n7 = this.destinations.length;
        int n8 = 0;
        if ((n5 = this.roundRobinIndex++) >= n7) {
            n5 = 0;
            this.roundRobinIndex = 0;
        }
        for (n4 = n5; n4 < n7; ++n4) {
            destination = this.destinations[n4];
            if (destination.timeOfLastActivityNs + SendChannelEndpoint.DESTINATION_TIMEOUT - l2 >= 0L) {
                n3 = DynamicSndMultiDestination.send(datagramChannel, byteBuffer, sendChannelEndpoint, n2, n6, destination.address);
                if (n3 >= n2) continue;
                this.roundRobinIndex = n4;
                return n3;
            }
            ++n8;
        }
        for (n4 = 0; n4 < n5; ++n4) {
            destination = this.destinations[n4];
            if (destination.timeOfLastActivityNs + SendChannelEndpoint.DESTINATION_TIMEOUT - l2 >= 0L) {
                n3 = DynamicSndMultiDestination.send(datagramChannel, byteBuffer, sendChannelEndpoint, n2, n6, destination.address);
                if (n3 >= n2) continue;
                this.roundRobinIndex = n4;
                return n3;
            }
            ++n8;
        }
        if (n8 > 0) {
            this.removeInactiveDestinations(l2);
        }
        return n2;
    }

    private void add(Destination destination) {
        this.destinations = ArrayUtil.add(this.destinations, destination);
        this.destinationsCounter.setOrdered(this.destinations.length);
    }

    private void truncateDestinations(int n2) {
        int n3 = this.destinations.length;
        int n4 = n3 - n2;
        this.destinations = 0 == n4 ? EMPTY_DESTINATIONS : Arrays.copyOf(this.destinations, n4);
        this.destinationsCounter.setOrdered(this.destinations.length);
    }

    private void removeInactiveDestinations(long l2) {
        int n2;
        int n3 = 0;
        for (int i2 = n2 = this.destinations.length - 1; i2 >= 0; --i2) {
            Destination destination = this.destinations[i2];
            if (destination.timeOfLastActivityNs + SendChannelEndpoint.DESTINATION_TIMEOUT - l2 >= 0L) continue;
            if (i2 != n2) {
                this.destinations[i2] = this.destinations[n2--];
            }
            ++n3;
        }
        if (n3 > 0) {
            this.truncateDestinations(n3);
        }
    }
}

