/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.ChannelUri;
import io.aeron.CommonContext;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.media.UdpChannel;

final class SubscriptionParams {
    int initialTermId = 0;
    int termId = 0;
    int termOffset = 0;
    int sessionId = 0;
    boolean hasJoinPosition = false;
    boolean hasSessionId = false;
    boolean isReliable = true;
    boolean isRejoin = true;
    boolean isSparse = true;
    boolean isTether = true;
    CommonContext.InferableBoolean group = CommonContext.InferableBoolean.INFER;
    int initialWindowLength;

    SubscriptionParams() {
    }

    static SubscriptionParams getSubscriptionParams(ChannelUri channelUri, MediaDriver.Context context) {
        String string;
        SubscriptionParams subscriptionParams = new SubscriptionParams();
        String string2 = channelUri.get("session-id");
        if (null != string2) {
            subscriptionParams.sessionId = Integer.parseInt(string2);
            subscriptionParams.hasSessionId = true;
        }
        int n2 = 0;
        String string3 = channelUri.get("init-term-id");
        n2 = string3 != null ? n2 + 1 : n2;
        String string4 = channelUri.get("term-id");
        n2 = string4 != null ? n2 + 1 : n2;
        String string5 = channelUri.get("term-offset");
        int n3 = n2 = string5 != null ? n2 + 1 : n2;
        if (n2 > 0) {
            if (n2 < 3) {
                throw new IllegalArgumentException("params must be used as a complete set: init-term-id term-id term-offset channel=" + channelUri);
            }
            subscriptionParams.initialTermId = Integer.parseInt(string3);
            subscriptionParams.termId = Integer.parseInt(string4);
            subscriptionParams.termOffset = Integer.parseInt(string5);
            if (subscriptionParams.termOffset < 0 || subscriptionParams.termOffset > 0x40000000) {
                throw new IllegalArgumentException("term-offset=" + subscriptionParams.termOffset + " out of range: channel=" + channelUri);
            }
            if ((subscriptionParams.termOffset & 0x1F) != 0) {
                throw new IllegalArgumentException("term-offset=" + subscriptionParams.termOffset + " must be a multiple of FRAME_ALIGNMENT: channel=" + channelUri);
            }
            if (subscriptionParams.termId - subscriptionParams.initialTermId < 0) {
                throw new IllegalStateException("difference greater than 2^31 - 1: init-term-id=" + subscriptionParams.initialTermId + " when " + "term-id" + "=" + subscriptionParams.termId + " channel=" + channelUri);
            }
            subscriptionParams.hasJoinPosition = true;
        }
        subscriptionParams.isReliable = null != (string = channelUri.get("reliable")) ? "true".equals(string) : context.reliableStream();
        String string6 = channelUri.get("rejoin");
        subscriptionParams.isRejoin = null != string6 ? "true".equals(string6) : context.rejoinStream();
        String string7 = channelUri.get("tether");
        subscriptionParams.isTether = null != string7 ? "true".equals(string7) : context.tetherSubscriptions();
        String string8 = channelUri.get("sparse");
        subscriptionParams.isSparse = null != string8 ? "true".equals(string8) : context.termBufferSparseFile();
        String string9 = channelUri.get("group");
        subscriptionParams.group = null != string9 ? CommonContext.InferableBoolean.parse(string9) : context.receiverGroupConsideration();
        int n4 = UdpChannel.parseBufferLength(channelUri, "rcv-wnd");
        subscriptionParams.initialWindowLength = 0 != n4 ? n4 : context.initialWindowLength();
        return subscriptionParams;
    }

    static void validateInitialWindowForRcvBuf(SubscriptionParams subscriptionParams, String string, int n2, MediaDriver.Context context, String string2) {
        if (0 != n2 && subscriptionParams.initialWindowLength > n2) {
            throw new IllegalStateException("Initial window greater than SO_RCVBUF for channel: rcv-wnd=" + subscriptionParams.initialWindowLength + " so-rcvbuf=" + n2 + (null == string2 ? "" : " existingChannel=" + string2) + " channel=" + string);
        }
        if (0 == n2 && subscriptionParams.initialWindowLength > context.osDefaultSocketRcvbufLength()) {
            throw new IllegalStateException("Initial window greater than SO_RCVBUF for channel: rcv-wnd=" + subscriptionParams.initialWindowLength + " so-rcvbuf=" + context.osDefaultSocketRcvbufLength() + " (OS default)" + (null == string2 ? "" : " existingChannel=" + string2) + " channel=" + string);
        }
    }

    public String toString() {
        return "SubscriptionParams{initialTermId=" + this.initialTermId + ", termId=" + this.termId + ", termOffset=" + this.termOffset + ", sessionId=" + this.sessionId + ", hasJoinPosition=" + this.hasJoinPosition + ", hasSessionId=" + this.hasSessionId + ", isReliable=" + this.isReliable + ", isRejoin=" + this.isRejoin + ", isSparse=" + this.isSparse + ", isTether=" + this.isTether + ", group=" + (Object)((Object)this.group) + '}';
    }
}

