/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.FeedbackDelayGenerator;
import java.util.concurrent.ThreadLocalRandom;

public class OptimalMulticastDelayGenerator
implements FeedbackDelayGenerator {
    private final double randMax;
    private final double baseX;
    private final double constantT;
    private final double factorT;

    public OptimalMulticastDelayGenerator(double d2, double d3) {
        double d4 = Math.log(d3) + 1.0;
        this.randMax = d4 / d2;
        this.baseX = d4 / (d2 * (Math.exp(d4) - 1.0));
        this.constantT = d2 / d4;
        this.factorT = (Math.exp(d4) - 1.0) * (d2 / d4);
    }

    @Override
    public long generateDelay() {
        return (long)this.generateNewOptimalDelay();
    }

    @Override
    public boolean shouldFeedbackImmediately() {
        return false;
    }

    public double generateNewOptimalDelay() {
        double d2 = OptimalMulticastDelayGenerator.uniformRandom(this.randMax) + this.baseX;
        return this.constantT * Math.log(d2 * this.factorT);
    }

    public static double uniformRandom(double d2) {
        return ThreadLocalRandom.current().nextDouble() * d2;
    }

    public String toString() {
        return "OptimalMulticastDelayGenerator{randMax=" + this.randMax + ", baseX=" + this.baseX + ", constantT=" + this.constantT + ", factorT=" + this.factorT + ", shouldFeedbackImmediately=" + this.shouldFeedbackImmediately() + '}';
    }
}

