/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.AeronClient;
import io.aeron.driver.PublicationImage;
import io.aeron.driver.SubscriptionLink;
import io.aeron.driver.SubscriptionParams;
import io.aeron.driver.media.ReceiveChannelEndpoint;

class NetworkSubscriptionLink
extends SubscriptionLink {
    private final boolean isReliable;
    private final boolean isRejoin;
    private final ReceiveChannelEndpoint channelEndpoint;

    NetworkSubscriptionLink(long l2, ReceiveChannelEndpoint receiveChannelEndpoint, int n2, String string, AeronClient aeronClient, SubscriptionParams subscriptionParams) {
        super(l2, n2, string, aeronClient, subscriptionParams);
        this.isReliable = subscriptionParams.isReliable;
        this.isRejoin = subscriptionParams.isRejoin;
        this.channelEndpoint = receiveChannelEndpoint;
    }

    @Override
    boolean isReliable() {
        return this.isReliable;
    }

    @Override
    boolean isRejoin() {
        return this.isRejoin;
    }

    @Override
    ReceiveChannelEndpoint channelEndpoint() {
        return this.channelEndpoint;
    }

    @Override
    boolean matches(PublicationImage publicationImage) {
        return publicationImage.channelEndpoint() == this.channelEndpoint && publicationImage.streamId() == this.streamId && this.isWildcardOrSessionIdMatch(publicationImage.sessionId());
    }

    @Override
    boolean matches(ReceiveChannelEndpoint receiveChannelEndpoint, int n2, SubscriptionParams subscriptionParams) {
        boolean bl2 = this.hasSessionId == subscriptionParams.hasSessionId && (!this.hasSessionId || this.sessionId == subscriptionParams.sessionId);
        return receiveChannelEndpoint == this.channelEndpoint && n2 == this.streamId && bl2;
    }

    @Override
    boolean matches(ReceiveChannelEndpoint receiveChannelEndpoint, int n2, int n3) {
        return receiveChannelEndpoint == this.channelEndpoint && n2 == this.streamId && this.isWildcardOrSessionIdMatch(n3);
    }

    @Override
    boolean supportsMds() {
        return this.channelEndpoint.hasDestinationControl();
    }
}

