/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverManagedResource;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.PublicationParams;
import io.aeron.driver.Subscribable;
import io.aeron.driver.SubscriptionLink;
import io.aeron.driver.UntetheredSubscription;
import io.aeron.driver.buffer.RawLog;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.logbuffer.LogBufferUnblocker;
import java.util.ArrayList;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.collections.ArrayListUtil;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.Position;
import org.agrona.concurrent.status.ReadablePosition;

public final class IpcPublication
implements DriverManagedResource,
Subscribable {
    private static final ReadablePosition[] EMPTY_POSITIONS = new ReadablePosition[0];
    private final long registrationId;
    private final long tag;
    private final long unblockTimeoutNs;
    private final long untetheredWindowLimitTimeoutNs;
    private final long untetheredRestingTimeoutNs;
    private final String channel;
    private final int sessionId;
    private final int streamId;
    private final int startingTermId;
    private final int startingTermOffset;
    private final int positionBitsToShift;
    private final int termBufferLength;
    private final int termWindowLength;
    private final int initialTermId;
    private final int tripGain;
    private long tripLimit;
    private long consumerPosition;
    private long lastConsumerPosition;
    private long timeOfLastConsumerPositionUpdateNs;
    private long cleanPosition;
    private int refCount = 0;
    private boolean reachedEndOfLife = false;
    private final boolean isExclusive;
    private State state = State.ACTIVE;
    private final UnsafeBuffer[] termBuffers;
    private final Position publisherPos;
    private final Position publisherLimit;
    private final UnsafeBuffer metaDataBuffer;
    private ReadablePosition[] subscriberPositions = EMPTY_POSITIONS;
    private final ArrayList<UntetheredSubscription> untetheredSubscriptions = new ArrayList();
    private final RawLog rawLog;
    private final AtomicCounter unblockedPublications;
    private final ErrorHandler errorHandler;

    IpcPublication(long l2, String string, MediaDriver.Context context, long l3, int n2, int n3, Position position, Position position2, RawLog rawLog, int n4, boolean bl2, PublicationParams publicationParams) {
        int n5;
        this.registrationId = l2;
        this.channel = string;
        this.tag = l3;
        this.sessionId = n2;
        this.streamId = n3;
        this.isExclusive = bl2;
        this.termBuffers = rawLog.termBuffers();
        this.initialTermId = LogBufferDescriptor.initialTermId(rawLog.metaData());
        this.startingTermId = publicationParams.hasPosition ? publicationParams.termId : this.initialTermId;
        this.startingTermOffset = publicationParams.hasPosition ? publicationParams.termOffset : 0;
        this.errorHandler = context.errorHandler();
        this.termBufferLength = n5 = rawLog.termLength();
        this.positionBitsToShift = LogBufferDescriptor.positionBitsToShift(n5);
        this.termWindowLength = n4;
        this.tripGain = n4 >> 3;
        this.publisherPos = position;
        this.publisherLimit = position2;
        this.rawLog = rawLog;
        this.unblockTimeoutNs = context.publicationUnblockTimeoutNs();
        this.untetheredWindowLimitTimeoutNs = context.untetheredWindowLimitTimeoutNs();
        this.untetheredRestingTimeoutNs = context.untetheredRestingTimeoutNs();
        this.unblockedPublications = context.systemCounters().get(SystemCounterDescriptor.UNBLOCKED_PUBLICATIONS);
        this.metaDataBuffer = rawLog.metaData();
        this.lastConsumerPosition = this.consumerPosition = this.producerPosition();
        this.cleanPosition = this.consumerPosition;
        this.timeOfLastConsumerPositionUpdateNs = context.cachedNanoClock().nanoTime();
    }

    public String channel() {
        return this.channel;
    }

    public int sessionId() {
        return this.sessionId;
    }

    public int streamId() {
        return this.streamId;
    }

    @Override
    public long subscribableRegistrationId() {
        return this.registrationId;
    }

    long registrationId() {
        return this.registrationId;
    }

    long tag() {
        return this.tag;
    }

    boolean isExclusive() {
        return this.isExclusive;
    }

    int initialTermId() {
        return this.initialTermId;
    }

    int startingTermId() {
        return this.startingTermId;
    }

    int startingTermOffset() {
        return this.startingTermOffset;
    }

    RawLog rawLog() {
        return this.rawLog;
    }

    int publisherLimitId() {
        return this.publisherLimit.id();
    }

    @Override
    public boolean free() {
        return this.rawLog.free();
    }

    @Override
    public void close() {
        CloseHelper.close(this.errorHandler, this.publisherPos);
        CloseHelper.close(this.errorHandler, this.publisherLimit);
        CloseHelper.closeAll(this.errorHandler, (AutoCloseable[])this.subscriberPositions);
        int n2 = this.untetheredSubscriptions.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            UntetheredSubscription untetheredSubscription = this.untetheredSubscriptions.get(i2);
            if (UntetheredSubscription.State.RESTING != untetheredSubscription.state) continue;
            CloseHelper.close(this.errorHandler, untetheredSubscription.position);
        }
    }

    @Override
    public void addSubscriber(SubscriptionLink subscriptionLink, ReadablePosition readablePosition, long l2) {
        this.subscriberPositions = ArrayUtil.add(this.subscriberPositions, readablePosition);
        if (!subscriptionLink.isTether()) {
            this.untetheredSubscriptions.add(new UntetheredSubscription(subscriptionLink, readablePosition, l2));
        }
        LogBufferDescriptor.isConnected(this.metaDataBuffer, true);
    }

    @Override
    public void removeSubscriber(SubscriptionLink subscriptionLink, ReadablePosition readablePosition) {
        this.updatePublisherLimit();
        this.subscriberPositions = ArrayUtil.remove(this.subscriberPositions, readablePosition);
        readablePosition.close();
        if (this.subscriberPositions.length == 0) {
            LogBufferDescriptor.isConnected(this.metaDataBuffer, false);
        }
        if (!subscriptionLink.isTether()) {
            int n2;
            for (int i2 = n2 = this.untetheredSubscriptions.size() - 1; i2 >= 0; --i2) {
                if (this.untetheredSubscriptions.get((int)i2).subscriptionLink != subscriptionLink) continue;
                ArrayListUtil.fastUnorderedRemove(this.untetheredSubscriptions, i2, n2);
                break;
            }
        }
    }

    @Override
    public void onTimeEvent(long l2, long l3, DriverConductor driverConductor) {
        switch (this.state) {
            case ACTIVE: {
                long l4 = this.producerPosition();
                this.publisherPos.setOrdered(l4);
                if (!this.isExclusive) {
                    this.checkForBlockedPublisher(l4, l2);
                }
                this.checkUntetheredSubscriptions(l2, driverConductor);
                break;
            }
            case DRAINING: {
                long l5 = this.producerPosition();
                this.publisherPos.setOrdered(l5);
                if (this.isDrained(l5)) {
                    driverConductor.transitionToLinger(this);
                    this.state = State.LINGER;
                    break;
                }
                if (!LogBufferUnblocker.unblock(this.termBuffers, this.metaDataBuffer, this.consumerPosition, this.termBufferLength)) break;
                this.unblockedPublications.incrementOrdered();
                break;
            }
            case LINGER: {
                driverConductor.cleanupIpcPublication(this);
                this.reachedEndOfLife = true;
                this.state = State.DONE;
                break;
            }
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return this.reachedEndOfLife;
    }

    void incRef() {
        ++this.refCount;
    }

    void decRef() {
        if (0 == --this.refCount) {
            long l2 = this.producerPosition();
            this.publisherLimit.setOrdered(l2);
            LogBufferDescriptor.endOfStreamPosition(this.metaDataBuffer, l2);
            this.state = State.DRAINING;
        }
    }

    int updatePublisherLimit() {
        int n2 = 0;
        if (State.ACTIVE == this.state) {
            if (this.subscriberPositions.length > 0) {
                long l2;
                long l3 = Long.MAX_VALUE;
                long l4 = this.consumerPosition;
                for (ReadablePosition readablePosition : this.subscriberPositions) {
                    long l5 = readablePosition.getVolatile();
                    l3 = Math.min(l3, l5);
                    l4 = Math.max(l4, l5);
                }
                if (l4 > this.consumerPosition) {
                    this.consumerPosition = l4;
                }
                if ((l2 = l3 + (long)this.termWindowLength) > this.tripLimit) {
                    this.cleanBufferTo(l3);
                    this.publisherLimit.setOrdered(l2);
                    this.tripLimit = l2 + (long)this.tripGain;
                    n2 = 1;
                }
            } else if (this.publisherLimit.get() > this.consumerPosition) {
                this.tripLimit = this.consumerPosition;
                this.publisherLimit.setOrdered(this.consumerPosition);
                this.cleanBufferTo(this.consumerPosition);
            }
        }
        return n2;
    }

    long joinPosition() {
        long l2 = this.consumerPosition;
        for (ReadablePosition readablePosition : this.subscriberPositions) {
            l2 = Math.min(readablePosition.getVolatile(), l2);
        }
        return l2;
    }

    long producerPosition() {
        long l2 = LogBufferDescriptor.rawTailVolatile(this.metaDataBuffer);
        int n2 = LogBufferDescriptor.termOffset(l2, this.termBufferLength);
        return LogBufferDescriptor.computePosition(LogBufferDescriptor.termId(l2), n2, this.positionBitsToShift, this.initialTermId);
    }

    long consumerPosition() {
        return this.consumerPosition;
    }

    State state() {
        return this.state;
    }

    boolean isAcceptingSubscriptions() {
        return State.ACTIVE == this.state || State.DRAINING == this.state && !this.isDrained(this.producerPosition());
    }

    private void checkUntetheredSubscriptions(long l2, DriverConductor driverConductor) {
        int n2;
        long l3 = this.consumerPosition - (long)this.termWindowLength + (long)(this.termWindowLength >> 2);
        for (int i2 = n2 = this.untetheredSubscriptions.size() - 1; i2 >= 0; --i2) {
            UntetheredSubscription untetheredSubscription = this.untetheredSubscriptions.get(i2);
            if (UntetheredSubscription.State.ACTIVE == untetheredSubscription.state) {
                if (untetheredSubscription.position.getVolatile() > l3) {
                    untetheredSubscription.timeOfLastUpdateNs = l2;
                    continue;
                }
                if (untetheredSubscription.timeOfLastUpdateNs + this.untetheredWindowLimitTimeoutNs - l2 > 0L) continue;
                driverConductor.notifyUnavailableImageLink(this.registrationId, untetheredSubscription.subscriptionLink);
                untetheredSubscription.state(UntetheredSubscription.State.LINGER, l2, this.streamId, this.sessionId);
                continue;
            }
            if (UntetheredSubscription.State.LINGER == untetheredSubscription.state) {
                if (untetheredSubscription.timeOfLastUpdateNs + this.untetheredWindowLimitTimeoutNs - l2 > 0L) continue;
                this.subscriberPositions = ArrayUtil.remove(this.subscriberPositions, untetheredSubscription.position);
                untetheredSubscription.state(UntetheredSubscription.State.RESTING, l2, this.streamId, this.sessionId);
                continue;
            }
            if (UntetheredSubscription.State.RESTING != untetheredSubscription.state || untetheredSubscription.timeOfLastUpdateNs + this.untetheredRestingTimeoutNs - l2 > 0L) continue;
            this.subscriberPositions = ArrayUtil.add(this.subscriberPositions, untetheredSubscription.position);
            driverConductor.notifyAvailableImageLink(this.registrationId, this.sessionId, untetheredSubscription.subscriptionLink, untetheredSubscription.position.id(), this.joinPosition(), this.rawLog.fileName(), "aeron:ipc");
            untetheredSubscription.state(UntetheredSubscription.State.ACTIVE, l2, this.streamId, this.sessionId);
            LogBufferDescriptor.isConnected(this.metaDataBuffer, true);
        }
    }

    private boolean isDrained(long l2) {
        for (ReadablePosition readablePosition : this.subscriberPositions) {
            if (readablePosition.getVolatile() >= l2) continue;
            return false;
        }
        return true;
    }

    private void checkForBlockedPublisher(long l2, long l3) {
        long l4 = this.consumerPosition;
        if (l4 == this.lastConsumerPosition && this.isPossiblyBlocked(l2, l4)) {
            if (this.timeOfLastConsumerPositionUpdateNs + this.unblockTimeoutNs - l3 < 0L && LogBufferUnblocker.unblock(this.termBuffers, this.metaDataBuffer, l4, this.termBufferLength)) {
                this.unblockedPublications.incrementOrdered();
            }
        } else {
            this.timeOfLastConsumerPositionUpdateNs = l3;
            this.lastConsumerPosition = l4;
        }
    }

    private boolean isPossiblyBlocked(long l2, long l3) {
        int n2;
        int n3 = LogBufferDescriptor.activeTermCount(this.metaDataBuffer);
        if (n3 != (n2 = (int)(l3 >> this.positionBitsToShift))) {
            return true;
        }
        return l2 > l3;
    }

    private void cleanBufferTo(long l2) {
        long l3 = this.cleanPosition;
        if (l2 > l3) {
            UnsafeBuffer unsafeBuffer = this.termBuffers[LogBufferDescriptor.indexByPosition(l3, this.positionBitsToShift)];
            int n2 = (int)(l2 - l3);
            int n3 = this.termBufferLength;
            int n4 = (int)l3 & n3 - 1;
            int n5 = Math.min(n2, n3 - n4);
            unsafeBuffer.setMemory(n4 + 8, n5 - 8, (byte)0);
            unsafeBuffer.putLongOrdered(n4, 0L);
            this.cleanPosition = l3 + (long)n5;
        }
    }

    static enum State {
        ACTIVE,
        DRAINING,
        LINGER,
        DONE;

    }
}

