/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.protocol.ResolutionEntryFlyweight;
import java.util.ArrayList;
import java.util.Arrays;
import org.agrona.collections.ArrayListUtil;
import org.agrona.concurrent.status.AtomicCounter;

final class DriverNameResolverCache
implements AutoCloseable {
    private static final int INVALID_INDEX = -1;
    private final ArrayList<CacheEntry> entries = new ArrayList();
    private final long timeoutMs;
    private final Iterator iterator = new Iterator();

    DriverNameResolverCache(long l2) {
        this.timeoutMs = l2;
    }

    @Override
    public void close() {
    }

    CacheEntry lookup(String string, byte by2) {
        int n2 = this.findEntryIndexByNameAndType(string, by2);
        return -1 == n2 ? null : this.entries.get(n2);
    }

    void addOrUpdateEntry(byte[] byArray, int n2, long l2, byte by2, byte[] byArray2, int n3, AtomicCounter atomicCounter) {
        int n4 = this.findEntryIndexByNameAndType(byArray, n2, by2);
        int n5 = ResolutionEntryFlyweight.addressLength(by2);
        if (-1 == n4) {
            CacheEntry cacheEntry = new CacheEntry(Arrays.copyOf(byArray, n2), by2, l2, l2 + this.timeoutMs, Arrays.copyOf(byArray2, n5), n3);
            this.entries.add(cacheEntry);
            atomicCounter.setOrdered(this.entries.size());
        } else {
            CacheEntry cacheEntry = this.entries.get(n4);
            cacheEntry.timeOfLastActivityMs = l2;
            cacheEntry.deadlineMs = l2 + this.timeoutMs;
            if (n3 != cacheEntry.port || !DriverNameResolverCache.byteSubsetEquals(byArray2, cacheEntry.address, n5)) {
                cacheEntry.address = Arrays.copyOf(byArray2, n5);
                cacheEntry.port = n3;
            }
        }
    }

    int timeoutOldEntries(long l2, AtomicCounter atomicCounter) {
        int n2;
        int n3 = 0;
        ArrayList<CacheEntry> arrayList = this.entries;
        for (int i2 = n2 = arrayList.size() - 1; i2 >= 0; --i2) {
            CacheEntry cacheEntry = arrayList.get(i2);
            if (l2 <= cacheEntry.deadlineMs) continue;
            ArrayListUtil.fastUnorderedRemove(arrayList, i2, n2--);
            atomicCounter.setOrdered(arrayList.size());
            ++n3;
        }
        return n3;
    }

    Iterator resetIterator() {
        this.iterator.cache = this;
        this.iterator.index = -1;
        return this.iterator;
    }

    static boolean byteSubsetEquals(byte[] byArray, byte[] byArray2, int n2) {
        if (byArray.length < n2 || byArray2.length < n2) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    static boolean byteSubsetEquals(byte[] byArray, String string) {
        int n2 = string.length();
        if (byArray.length < n2) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] == string.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    private int findEntryIndexByNameAndType(byte[] byArray, int n2, byte by2) {
        for (int i2 = 0; i2 < this.entries.size(); ++i2) {
            CacheEntry cacheEntry = this.entries.get(i2);
            if (by2 != cacheEntry.type || !DriverNameResolverCache.byteSubsetEquals(cacheEntry.name, byArray, n2)) continue;
            return i2;
        }
        return -1;
    }

    private int findEntryIndexByNameAndType(String string, byte by2) {
        for (int i2 = 0; i2 < this.entries.size(); ++i2) {
            CacheEntry cacheEntry = this.entries.get(i2);
            if (by2 != cacheEntry.type || !DriverNameResolverCache.byteSubsetEquals(cacheEntry.name, string)) continue;
            return i2;
        }
        return -1;
    }

    static final class CacheEntry {
        long deadlineMs;
        long timeOfLastActivityMs;
        int port;
        final byte type;
        final byte[] name;
        byte[] address;

        CacheEntry(byte[] byArray, byte by2, long l2, long l3, byte[] byArray2, int n2) {
            this.name = byArray;
            this.type = by2;
            this.timeOfLastActivityMs = l2;
            this.deadlineMs = l3;
            this.address = byArray2;
            this.port = n2;
        }
    }

    static final class Iterator {
        int index = -1;
        DriverNameResolverCache cache;

        Iterator() {
        }

        boolean hasNext() {
            return this.index + 1 < this.cache.entries.size();
        }

        CacheEntry next() {
            return (CacheEntry)this.cache.entries.get(++this.index);
        }

        void rewindNext() {
            --this.index;
        }
    }
}

