/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.ErrorCode;
import io.aeron.command.CorrelatedMessageFlyweight;
import io.aeron.command.CounterMessageFlyweight;
import io.aeron.command.DestinationMessageFlyweight;
import io.aeron.command.PublicationMessageFlyweight;
import io.aeron.command.RemoveMessageFlyweight;
import io.aeron.command.SubscriptionMessageFlyweight;
import io.aeron.command.TerminateDriverFlyweight;
import io.aeron.driver.ClientProxy;
import io.aeron.driver.DriverConductor;
import io.aeron.exceptions.ControlProtocolException;
import io.aeron.exceptions.StorageSpaceException;
import org.agrona.ErrorHandler;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.ControlledMessageHandler;
import org.agrona.concurrent.ringbuffer.RingBuffer;
import org.agrona.concurrent.status.AtomicCounter;

final class ClientCommandAdapter
implements ControlledMessageHandler {
    private final PublicationMessageFlyweight publicationMsgFlyweight = new PublicationMessageFlyweight();
    private final SubscriptionMessageFlyweight subscriptionMsgFlyweight = new SubscriptionMessageFlyweight();
    private final CorrelatedMessageFlyweight correlatedMsgFlyweight = new CorrelatedMessageFlyweight();
    private final RemoveMessageFlyweight removeMsgFlyweight = new RemoveMessageFlyweight();
    private final DestinationMessageFlyweight destinationMsgFlyweight = new DestinationMessageFlyweight();
    private final CounterMessageFlyweight counterMsgFlyweight = new CounterMessageFlyweight();
    private final TerminateDriverFlyweight terminateDriverFlyweight = new TerminateDriverFlyweight();
    private final DriverConductor conductor;
    private final RingBuffer toDriverCommands;
    private final ClientProxy clientProxy;
    private final AtomicCounter errors;
    private final ErrorHandler errorHandler;

    ClientCommandAdapter(AtomicCounter atomicCounter, ErrorHandler errorHandler, RingBuffer ringBuffer, ClientProxy clientProxy, DriverConductor driverConductor) {
        this.errors = atomicCounter;
        this.errorHandler = errorHandler;
        this.toDriverCommands = ringBuffer;
        this.clientProxy = clientProxy;
        this.conductor = driverConductor;
    }

    int receive() {
        return this.toDriverCommands.controlledRead(this, 2);
    }

    @Override
    public ControlledMessageHandler.Action onMessage(int n2, MutableDirectBuffer mutableDirectBuffer, int n3, int n4) {
        long l2 = 0L;
        if (this.conductor.notAcceptingClientCommands()) {
            return ControlledMessageHandler.Action.ABORT;
        }
        try {
            switch (n2) {
                case 1: {
                    this.publicationMsgFlyweight.wrap(mutableDirectBuffer, n3);
                    this.publicationMsgFlyweight.validateLength(n2, n4);
                    l2 = this.publicationMsgFlyweight.correlationId();
                    this.addPublication(l2, false);
                    break;
                }
                case 2: {
                    this.removeMsgFlyweight.wrap(mutableDirectBuffer, n3);
                    this.removeMsgFlyweight.validateLength(n2, n4);
                    l2 = this.removeMsgFlyweight.correlationId();
                    this.conductor.onRemovePublication(this.removeMsgFlyweight.registrationId(), l2);
                    break;
                }
                case 3: {
                    this.publicationMsgFlyweight.wrap(mutableDirectBuffer, n3);
                    this.publicationMsgFlyweight.validateLength(n2, n4);
                    l2 = this.publicationMsgFlyweight.correlationId();
                    this.addPublication(l2, true);
                    break;
                }
                case 4: {
                    this.subscriptionMsgFlyweight.wrap(mutableDirectBuffer, n3);
                    this.subscriptionMsgFlyweight.validateLength(n2, n4);
                    l2 = this.subscriptionMsgFlyweight.correlationId();
                    long l3 = this.subscriptionMsgFlyweight.clientId();
                    int n5 = this.subscriptionMsgFlyweight.streamId();
                    String string = this.subscriptionMsgFlyweight.channel();
                    if (string.startsWith("aeron:ipc")) {
                        this.conductor.onAddIpcSubscription(string, n5, l2, l3);
                        break;
                    }
                    if (string.startsWith("aeron-spy")) {
                        this.conductor.onAddSpySubscription(string, n5, l2, l3);
                        break;
                    }
                    this.conductor.onAddNetworkSubscription(string, n5, l2, l3);
                    break;
                }
                case 5: {
                    this.removeMsgFlyweight.wrap(mutableDirectBuffer, n3);
                    this.removeMsgFlyweight.validateLength(n2, n4);
                    l2 = this.removeMsgFlyweight.correlationId();
                    this.conductor.onRemoveSubscription(this.removeMsgFlyweight.registrationId(), l2);
                    break;
                }
                case 7: {
                    this.destinationMsgFlyweight.wrap(mutableDirectBuffer, n3);
                    this.destinationMsgFlyweight.validateLength(n2, n4);
                    l2 = this.destinationMsgFlyweight.correlationId();
                    long l4 = this.destinationMsgFlyweight.registrationCorrelationId();
                    String string = this.destinationMsgFlyweight.channel();
                    this.conductor.onAddSendDestination(l4, string, l2);
                    break;
                }
                case 8: {
                    this.destinationMsgFlyweight.wrap(mutableDirectBuffer, n3);
                    this.destinationMsgFlyweight.validateLength(n2, n4);
                    l2 = this.destinationMsgFlyweight.correlationId();
                    long l5 = this.destinationMsgFlyweight.registrationCorrelationId();
                    String string = this.destinationMsgFlyweight.channel();
                    this.conductor.onRemoveSendDestination(l5, string, l2);
                    break;
                }
                case 6: {
                    this.correlatedMsgFlyweight.wrap(mutableDirectBuffer, n3);
                    this.correlatedMsgFlyweight.validateLength(n2, n4);
                    this.conductor.onClientKeepalive(this.correlatedMsgFlyweight.clientId());
                    break;
                }
                case 9: {
                    this.counterMsgFlyweight.wrap(mutableDirectBuffer, n3);
                    this.counterMsgFlyweight.validateLength(n2, n4);
                    l2 = this.counterMsgFlyweight.correlationId();
                    long l6 = this.counterMsgFlyweight.clientId();
                    this.conductor.onAddCounter(this.counterMsgFlyweight.typeId(), mutableDirectBuffer, n3 + this.counterMsgFlyweight.keyBufferOffset(), this.counterMsgFlyweight.keyBufferLength(), mutableDirectBuffer, n3 + this.counterMsgFlyweight.labelBufferOffset(), this.counterMsgFlyweight.labelBufferLength(), l2, l6);
                    break;
                }
                case 10: {
                    this.removeMsgFlyweight.wrap(mutableDirectBuffer, n3);
                    this.removeMsgFlyweight.validateLength(n2, n4);
                    l2 = this.removeMsgFlyweight.correlationId();
                    this.conductor.onRemoveCounter(this.removeMsgFlyweight.registrationId(), l2);
                    break;
                }
                case 11: {
                    this.correlatedMsgFlyweight.wrap(mutableDirectBuffer, n3);
                    this.correlatedMsgFlyweight.validateLength(n2, n4);
                    this.conductor.onClientClose(this.correlatedMsgFlyweight.clientId());
                    break;
                }
                case 12: {
                    this.destinationMsgFlyweight.wrap(mutableDirectBuffer, n3);
                    this.destinationMsgFlyweight.validateLength(n2, n4);
                    l2 = this.destinationMsgFlyweight.correlationId();
                    long l7 = this.destinationMsgFlyweight.registrationCorrelationId();
                    String string = this.destinationMsgFlyweight.channel();
                    this.conductor.onAddRcvDestination(l7, string, l2);
                    break;
                }
                case 13: {
                    this.destinationMsgFlyweight.wrap(mutableDirectBuffer, n3);
                    this.destinationMsgFlyweight.validateLength(n2, n4);
                    l2 = this.destinationMsgFlyweight.correlationId();
                    long l8 = this.destinationMsgFlyweight.registrationCorrelationId();
                    String string = this.destinationMsgFlyweight.channel();
                    this.conductor.onRemoveRcvDestination(l8, string, l2);
                    break;
                }
                case 14: {
                    this.terminateDriverFlyweight.wrap(mutableDirectBuffer, n3);
                    this.terminateDriverFlyweight.validateLength(n2, n4);
                    this.conductor.onTerminateDriver(mutableDirectBuffer, this.terminateDriverFlyweight.tokenBufferOffset(), this.terminateDriverFlyweight.tokenBufferLength());
                    break;
                }
                default: {
                    ControlProtocolException controlProtocolException = new ControlProtocolException(ErrorCode.UNKNOWN_COMMAND_TYPE_ID, "command typeId=" + n2);
                    this.recordError(controlProtocolException);
                    this.clientProxy.onError(l2, controlProtocolException.errorCode(), controlProtocolException.getMessage());
                    break;
                }
            }
        }
        catch (ControlProtocolException controlProtocolException) {
            this.recordError(controlProtocolException);
            this.clientProxy.onError(l2, controlProtocolException.errorCode(), controlProtocolException.getMessage());
        }
        catch (StorageSpaceException storageSpaceException) {
            this.recordError(storageSpaceException);
            this.clientProxy.onError(l2, ErrorCode.STORAGE_SPACE, storageSpaceException.getMessage());
        }
        catch (Exception exception) {
            this.recordError(exception);
            if (StorageSpaceException.isStorageSpaceError(exception)) {
                this.clientProxy.onError(l2, ErrorCode.STORAGE_SPACE, exception.getMessage());
            }
            String string = exception.getClass().getName() + " : " + exception.getMessage();
            this.clientProxy.onError(l2, ErrorCode.GENERIC_ERROR, string);
        }
        return ControlledMessageHandler.Action.CONTINUE;
    }

    private void addPublication(long l2, boolean bl2) {
        long l3 = this.publicationMsgFlyweight.clientId();
        int n2 = this.publicationMsgFlyweight.streamId();
        String string = this.publicationMsgFlyweight.channel();
        if (string.startsWith("aeron:ipc")) {
            this.conductor.onAddIpcPublication(string, n2, l2, l3, bl2);
        } else {
            this.conductor.onAddNetworkPublication(string, n2, l2, l3, bl2);
        }
    }

    private void recordError(Exception exception) {
        if (!this.errors.isClosed()) {
            this.errors.increment();
        }
        this.errorHandler.onError(exception);
    }
}

