/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.command;

import io.aeron.ErrorCode;
import io.aeron.command.CorrelatedMessageFlyweight;
import io.aeron.exceptions.ControlProtocolException;
import org.agrona.MutableDirectBuffer;

public class PublicationMessageFlyweight
extends CorrelatedMessageFlyweight {
    private static final int STREAM_ID_FIELD_OFFSET = 16;
    private static final int CHANNEL_OFFSET = 20;
    private static final int MINIMUM_LENGTH = 24;
    private int lengthOfChannel;

    @Override
    public PublicationMessageFlyweight wrap(MutableDirectBuffer mutableDirectBuffer, int n2) {
        super.wrap(mutableDirectBuffer, n2);
        return this;
    }

    public int streamId() {
        return this.buffer.getInt(this.offset + 16);
    }

    public PublicationMessageFlyweight streamId(int n2) {
        this.buffer.putInt(this.offset + 16, n2);
        return this;
    }

    public String channel() {
        return this.buffer.getStringAscii(this.offset + 20);
    }

    public void appendChannel(Appendable appendable) {
        this.buffer.getStringAscii(this.offset + 20, appendable);
    }

    public PublicationMessageFlyweight channel(String string) {
        this.lengthOfChannel = this.buffer.putStringAscii(this.offset + 20, string);
        return this;
    }

    public int length() {
        return 20 + this.lengthOfChannel;
    }

    @Override
    public void validateLength(int n2, int n3) {
        if (n3 < 24) {
            throw new ControlProtocolException(ErrorCode.MALFORMED_COMMAND, "command=" + n2 + " too short: length=" + n3);
        }
        if (n3 - 24 < this.buffer.getInt(this.offset + 20)) {
            throw new ControlProtocolException(ErrorCode.MALFORMED_COMMAND, "command=" + n2 + " too short for channel: length=" + n3);
        }
    }

    public static int computeLength(int n2) {
        return 24 + n2;
    }
}

