/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.command;

import org.agrona.BitUtil;
import org.agrona.MutableDirectBuffer;

public class ImageBuffersReadyFlyweight {
    private static final int CORRELATION_ID_OFFSET = 0;
    private static final int SESSION_ID_OFFSET = 8;
    private static final int STREAM_ID_FIELD_OFFSET = 12;
    private static final int SUBSCRIPTION_REGISTRATION_ID_OFFSET = 16;
    private static final int SUBSCRIBER_POSITION_ID_OFFSET = 24;
    private static final int LOG_FILE_NAME_OFFSET = 28;
    private MutableDirectBuffer buffer;
    private int offset;

    public final ImageBuffersReadyFlyweight wrap(MutableDirectBuffer mutableDirectBuffer, int n2) {
        this.buffer = mutableDirectBuffer;
        this.offset = n2;
        return this;
    }

    public long correlationId() {
        return this.buffer.getLong(this.offset + 0);
    }

    public ImageBuffersReadyFlyweight correlationId(long l2) {
        this.buffer.putLong(this.offset + 0, l2);
        return this;
    }

    public int sessionId() {
        return this.buffer.getInt(this.offset + 8);
    }

    public ImageBuffersReadyFlyweight sessionId(int n2) {
        this.buffer.putInt(this.offset + 8, n2);
        return this;
    }

    public int streamId() {
        return this.buffer.getInt(this.offset + 12);
    }

    public ImageBuffersReadyFlyweight streamId(int n2) {
        this.buffer.putInt(this.offset + 12, n2);
        return this;
    }

    public ImageBuffersReadyFlyweight subscriberPositionId(int n2) {
        this.buffer.putInt(this.offset + 24, n2);
        return this;
    }

    public int subscriberPositionId() {
        return this.buffer.getInt(this.offset + 24);
    }

    public ImageBuffersReadyFlyweight subscriptionRegistrationId(long l2) {
        this.buffer.putLong(this.offset + 16, l2);
        return this;
    }

    public long subscriptionRegistrationId() {
        return this.buffer.getLong(this.offset + 16);
    }

    public String logFileName() {
        return this.buffer.getStringAscii(this.offset + 28);
    }

    public void appendLogFileName(Appendable appendable) {
        this.buffer.getStringAscii(this.offset + 28, appendable);
    }

    public ImageBuffersReadyFlyweight logFileName(String string) {
        this.buffer.putStringAscii(this.offset + 28, string);
        return this;
    }

    public String sourceIdentity() {
        return this.buffer.getStringAscii(this.offset + this.sourceIdentityOffset());
    }

    public void appendSourceIdentity(Appendable appendable) {
        this.buffer.getStringAscii(this.offset + this.sourceIdentityOffset(), appendable);
    }

    public ImageBuffersReadyFlyweight sourceIdentity(String string) {
        this.buffer.putStringAscii(this.offset + this.sourceIdentityOffset(), string);
        return this;
    }

    public int length() {
        int n2 = this.sourceIdentityOffset();
        return n2 + this.buffer.getInt(this.offset + n2) + 4;
    }

    private int sourceIdentityOffset() {
        int n2 = BitUtil.align(this.buffer.getInt(this.offset + 28), 4);
        return 32 + n2;
    }
}

