/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.command;

import io.aeron.ErrorCode;
import org.agrona.MutableDirectBuffer;

public class ErrorResponseFlyweight {
    private static final int OFFENDING_COMMAND_CORRELATION_ID_OFFSET = 0;
    private static final int ERROR_CODE_OFFSET = 8;
    private static final int ERROR_MESSAGE_OFFSET = 12;
    private MutableDirectBuffer buffer;
    private int offset;

    public final ErrorResponseFlyweight wrap(MutableDirectBuffer mutableDirectBuffer, int n2) {
        this.buffer = mutableDirectBuffer;
        this.offset = n2;
        return this;
    }

    public long offendingCommandCorrelationId() {
        return this.buffer.getLong(this.offset + 0);
    }

    public ErrorResponseFlyweight offendingCommandCorrelationId(long l2) {
        this.buffer.putLong(this.offset + 0, l2);
        return this;
    }

    public ErrorCode errorCode() {
        return ErrorCode.get(this.buffer.getInt(this.offset + 8));
    }

    public int errorCodeValue() {
        return this.buffer.getInt(this.offset + 8);
    }

    public ErrorResponseFlyweight errorCode(ErrorCode errorCode) {
        this.buffer.putInt(this.offset + 8, errorCode.value());
        return this;
    }

    public String errorMessage() {
        return this.buffer.getStringAscii(this.offset + 12);
    }

    public int appendMessage(Appendable appendable) {
        return this.buffer.getStringAscii(this.offset + 12, appendable);
    }

    public ErrorResponseFlyweight errorMessage(String string) {
        this.buffer.putStringAscii(this.offset + 12, string);
        return this;
    }

    public int length() {
        return 16 + this.buffer.getInt(this.offset + 12);
    }
}

