/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.BufferBuilder;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;

public class ImageControlledFragmentAssembler
implements ControlledFragmentHandler {
    private final ControlledFragmentHandler delegate;
    private final BufferBuilder builder;

    public ImageControlledFragmentAssembler(ControlledFragmentHandler controlledFragmentHandler) {
        this(controlledFragmentHandler, 0, false);
    }

    public ImageControlledFragmentAssembler(ControlledFragmentHandler controlledFragmentHandler, int n2) {
        this(controlledFragmentHandler, n2, false);
    }

    public ImageControlledFragmentAssembler(ControlledFragmentHandler controlledFragmentHandler, int n2, boolean bl2) {
        this.delegate = controlledFragmentHandler;
        this.builder = new BufferBuilder(n2, bl2);
    }

    public ControlledFragmentHandler delegate() {
        return this.delegate;
    }

    BufferBuilder bufferBuilder() {
        return this.builder;
    }

    @Override
    public ControlledFragmentHandler.Action onFragment(DirectBuffer directBuffer, int n2, int n3, Header header) {
        ControlledFragmentHandler.Action action = ControlledFragmentHandler.Action.CONTINUE;
        byte by2 = header.flags();
        if ((by2 & 0xFFFFFFC0) == -64) {
            action = this.delegate.onFragment(directBuffer, n2, n3, header);
        } else if ((by2 & 0xFFFFFF80) == -128) {
            this.builder.reset().append(directBuffer, n2, n3).nextTermOffset(BitUtil.align(n2 + n3 + 32, 32));
        } else if (n2 == this.builder.nextTermOffset()) {
            int n4 = this.builder.limit();
            this.builder.append(directBuffer, n2, n3);
            if ((by2 & 0x40) == 64) {
                action = this.delegate.onFragment(this.builder.buffer(), 0, this.builder.limit(), header);
                if (ControlledFragmentHandler.Action.ABORT == action) {
                    this.builder.limit(n4);
                } else {
                    this.builder.reset();
                }
            } else {
                this.builder.nextTermOffset(BitUtil.align(n2 + n3 + 32, 32));
            }
        } else {
            this.builder.reset();
        }
        return action;
    }
}

