/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.ClientConductor;
import io.aeron.DirectBufferVector;
import io.aeron.ExclusivePublicationValues;
import io.aeron.LogBuffers;
import io.aeron.ReservedValueSupplier;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.logbuffer.LogBufferDescriptor;
import java.nio.ByteOrder;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.ReadablePosition;

public final class ExclusivePublication
extends ExclusivePublicationValues {
    byte p064;
    byte p065;
    byte p066;
    byte p067;
    byte p068;
    byte p069;
    byte p070;
    byte p071;
    byte p072;
    byte p073;
    byte p074;
    byte p075;
    byte p076;
    byte p077;
    byte p078;
    byte p079;
    byte p080;
    byte p081;
    byte p082;
    byte p083;
    byte p084;
    byte p085;
    byte p086;
    byte p087;
    byte p088;
    byte p089;
    byte p090;
    byte p091;
    byte p092;
    byte p093;
    byte p094;
    byte p095;
    byte p096;
    byte p097;
    byte p098;
    byte p099;
    byte p100;
    byte p101;
    byte p102;
    byte p103;
    byte p104;
    byte p105;
    byte p106;
    byte p107;
    byte p108;
    byte p109;
    byte p110;
    byte p111;
    byte p112;
    byte p113;
    byte p114;
    byte p115;
    byte p116;
    byte p117;
    byte p118;
    byte p119;
    byte p120;
    byte p121;
    byte p122;
    byte p123;
    byte p124;
    byte p125;
    byte p126;
    byte p127;

    ExclusivePublication(ClientConductor clientConductor, String string, int n2, int n3, ReadablePosition readablePosition, int n4, LogBuffers logBuffers, long l2, long l3) {
        super(clientConductor, string, n2, n3, readablePosition, n4, logBuffers, l2, l3);
        int n5;
        UnsafeBuffer unsafeBuffer = logBuffers.metaDataBuffer();
        int n6 = LogBufferDescriptor.activeTermCount(unsafeBuffer);
        this.activePartitionIndex = n5 = LogBufferDescriptor.indexByTermCount(n6);
        long l4 = LogBufferDescriptor.rawTail(unsafeBuffer, n5);
        this.termId = LogBufferDescriptor.termId(l4);
        this.termOffset = LogBufferDescriptor.termOffset(l4);
        this.termBeginPosition = LogBufferDescriptor.computeTermBeginPosition(this.termId, this.positionBitsToShift, this.initialTermId);
    }

    @Override
    public long position() {
        if (this.isClosed) {
            return -4L;
        }
        return this.termBeginPosition + (long)this.termOffset;
    }

    @Override
    public long availableWindow() {
        if (this.isClosed) {
            return -4L;
        }
        return this.positionLimit.getVolatile() - (this.termBeginPosition + (long)this.termOffset);
    }

    public int termId() {
        return this.termId;
    }

    public int termOffset() {
        return this.termOffset;
    }

    @Override
    public long offer(DirectBuffer directBuffer, int n2, int n3, ReservedValueSupplier reservedValueSupplier) {
        long l2 = -4L;
        if (!this.isClosed) {
            long l3 = this.termBeginPosition + (long)this.termOffset;
            long l4 = this.positionLimit.getVolatile();
            if (l3 < l4) {
                int n4;
                int n5 = LogBufferDescriptor.TERM_TAIL_COUNTERS_OFFSET + this.activePartitionIndex * 8;
                UnsafeBuffer unsafeBuffer = this.termBuffers[this.activePartitionIndex];
                if (n3 <= this.maxPayloadLength) {
                    this.checkPositiveLength(n3);
                    n4 = this.appendUnfragmentedMessage(n5, unsafeBuffer, directBuffer, n2, n3, reservedValueSupplier);
                } else {
                    this.checkMaxMessageLength(n3);
                    n4 = this.appendFragmentedMessage(unsafeBuffer, n5, directBuffer, n2, n3, reservedValueSupplier);
                }
                l2 = this.newPosition(n4);
            } else {
                l2 = this.backPressureStatus(l3, n3);
            }
        }
        return l2;
    }

    @Override
    public long offer(DirectBuffer directBuffer, int n2, int n3, DirectBuffer directBuffer2, int n4, int n5, ReservedValueSupplier reservedValueSupplier) {
        long l2 = -4L;
        if (!this.isClosed) {
            long l3 = this.positionLimit.getVolatile();
            long l4 = this.termBeginPosition + (long)this.termOffset;
            int n6 = ExclusivePublication.validateAndComputeLength(n3, n5);
            if (l4 < l3) {
                int n7;
                int n8 = LogBufferDescriptor.TERM_TAIL_COUNTERS_OFFSET + this.activePartitionIndex * 8;
                UnsafeBuffer unsafeBuffer = this.termBuffers[this.activePartitionIndex];
                if (n6 <= this.maxPayloadLength) {
                    this.checkPositiveLength(n6);
                    n7 = this.appendUnfragmentedMessage(unsafeBuffer, n8, directBuffer, n2, n3, directBuffer2, n4, n5, reservedValueSupplier);
                } else {
                    this.checkMaxMessageLength(n6);
                    n7 = this.appendFragmentedMessage(unsafeBuffer, n8, directBuffer, n2, n3, directBuffer2, n4, n5, this.maxPayloadLength, reservedValueSupplier);
                }
                l2 = this.newPosition(n7);
            } else {
                l2 = this.backPressureStatus(l4, n6);
            }
        }
        return l2;
    }

    @Override
    public long offer(DirectBufferVector[] directBufferVectorArray, ReservedValueSupplier reservedValueSupplier) {
        int n2 = DirectBufferVector.validateAndComputeLength(directBufferVectorArray);
        long l2 = -4L;
        if (!this.isClosed) {
            long l3 = this.termBeginPosition + (long)this.termOffset;
            long l4 = this.positionLimit.getVolatile();
            if (l3 < l4) {
                int n3;
                int n4 = LogBufferDescriptor.TERM_TAIL_COUNTERS_OFFSET + this.activePartitionIndex * 8;
                UnsafeBuffer unsafeBuffer = this.termBuffers[this.activePartitionIndex];
                if (n2 <= this.maxPayloadLength) {
                    n3 = this.appendUnfragmentedMessage(unsafeBuffer, n4, directBufferVectorArray, n2, reservedValueSupplier);
                } else {
                    this.checkMaxMessageLength(n2);
                    n3 = this.appendFragmentedMessage(unsafeBuffer, n4, directBufferVectorArray, n2, reservedValueSupplier);
                }
                l2 = this.newPosition(n3);
            } else {
                l2 = this.backPressureStatus(l3, n2);
            }
        }
        return l2;
    }

    @Override
    public long tryClaim(int n2, BufferClaim bufferClaim) {
        this.checkPayloadLength(n2);
        long l2 = -4L;
        if (!this.isClosed) {
            long l3 = this.termBeginPosition + (long)this.termOffset;
            long l4 = this.positionLimit.getVolatile();
            if (l3 < l4) {
                int n3 = LogBufferDescriptor.TERM_TAIL_COUNTERS_OFFSET + this.activePartitionIndex * 8;
                UnsafeBuffer unsafeBuffer = this.termBuffers[this.activePartitionIndex];
                int n4 = this.claim(unsafeBuffer, n3, n2, bufferClaim);
                l2 = this.newPosition(n4);
            } else {
                l2 = this.backPressureStatus(l3, n2);
            }
        }
        return l2;
    }

    public long appendPadding(int n2) {
        if (n2 > this.maxFramedLength) {
            throw new IllegalArgumentException("padding exceeds maxFramedLength of " + this.maxFramedLength + ", length=" + n2);
        }
        long l2 = -4L;
        if (!this.isClosed) {
            long l3 = this.termBeginPosition + (long)this.termOffset;
            long l4 = this.positionLimit.getVolatile();
            if (l3 < l4) {
                this.checkPositiveLength(n2);
                int n3 = LogBufferDescriptor.TERM_TAIL_COUNTERS_OFFSET + this.activePartitionIndex * 8;
                UnsafeBuffer unsafeBuffer = this.termBuffers[this.activePartitionIndex];
                int n4 = this.appendPadding(unsafeBuffer, n3, n2);
                l2 = this.newPosition(n4);
            } else {
                l2 = this.backPressureStatus(l3, n2);
            }
        }
        return l2;
    }

    public long offerBlock(MutableDirectBuffer mutableDirectBuffer, int n2, int n3) {
        long l2;
        long l3;
        if (this.isClosed) {
            return -4L;
        }
        if (this.termOffset >= this.termBufferLength) {
            this.rotateTerm();
        }
        if ((l3 = this.termBeginPosition + (long)this.termOffset) < (l2 = this.positionLimit.getVolatile())) {
            this.checkBlockLength(n3);
            this.checkFirstFrame(mutableDirectBuffer, n2);
            int n4 = LogBufferDescriptor.TERM_TAIL_COUNTERS_OFFSET + this.activePartitionIndex * 8;
            UnsafeBuffer unsafeBuffer = this.termBuffers[this.activePartitionIndex];
            int n5 = this.appendBlock(unsafeBuffer, n4, mutableDirectBuffer, n2, n3);
            return this.newPosition(n5);
        }
        return this.backPressureStatus(l3, n3);
    }

    private void checkBlockLength(int n2) {
        int n3 = this.termBufferLength - this.termOffset;
        if (n2 > n3) {
            throw new IllegalArgumentException("invalid block length " + n2 + ", remaining space in term is " + n3);
        }
    }

    private void checkFirstFrame(MutableDirectBuffer mutableDirectBuffer, int n2) {
        boolean bl2 = true;
        int n3 = mutableDirectBuffer.getInt(n2 + 8, ByteOrder.LITTLE_ENDIAN);
        int n4 = mutableDirectBuffer.getInt(n2 + 12, ByteOrder.LITTLE_ENDIAN);
        int n5 = mutableDirectBuffer.getInt(n2 + 16, ByteOrder.LITTLE_ENDIAN);
        int n6 = mutableDirectBuffer.getInt(n2 + 20, ByteOrder.LITTLE_ENDIAN);
        int n7 = mutableDirectBuffer.getShort(n2 + 6, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        if (n3 != this.termOffset || n4 != this.sessionId || n5 != this.streamId || n6 != this.termId || 1 != n7) {
            throw new IllegalArgumentException("improperly formatted block: termOffset=" + n3 + " (expected=" + this.termOffset + "), sessionId=" + n4 + " (expected=" + this.sessionId + "), streamId=" + n5 + " (expected=" + this.streamId + "), termId=" + n6 + " (expected=" + this.termId + "), frameType=" + n7 + " (expected=" + 1 + ")");
        }
    }

    private long newPosition(int n2) {
        if (n2 > 0) {
            this.termOffset = n2;
            return this.termBeginPosition + (long)n2;
        }
        if (this.termBeginPosition + (long)this.termBufferLength >= this.maxPossiblePosition) {
            return -5L;
        }
        this.rotateTerm();
        return -3L;
    }

    private void rotateTerm() {
        int n2 = LogBufferDescriptor.nextPartitionIndex(this.activePartitionIndex);
        int n3 = this.termId + 1;
        this.activePartitionIndex = n2;
        this.termOffset = 0;
        this.termId = n3;
        this.termBeginPosition += (long)this.termBufferLength;
        int n4 = n3 - this.initialTermId;
        LogBufferDescriptor.initialiseTailWithTermId(this.logMetaDataBuffer, n2, n3);
        LogBufferDescriptor.activeTermCountOrdered(this.logMetaDataBuffer, n4);
    }

    private int handleEndOfLog(UnsafeBuffer unsafeBuffer, int n2) {
        if (this.termOffset < n2) {
            int n3 = this.termOffset;
            int n4 = n2 - n3;
            this.headerWriter.write(unsafeBuffer, n3, n4, this.termId);
            FrameDescriptor.frameType(unsafeBuffer, n3, 0);
            FrameDescriptor.frameLengthOrdered(unsafeBuffer, n3, n4);
        }
        return -1;
    }

    private int appendUnfragmentedMessage(int n2, UnsafeBuffer unsafeBuffer, DirectBuffer directBuffer, int n3, int n4, ReservedValueSupplier reservedValueSupplier) {
        int n5 = n4 + 32;
        int n6 = BitUtil.align(n5, 32);
        int n7 = unsafeBuffer.capacity();
        int n8 = this.termOffset + n6;
        this.logMetaDataBuffer.putLongOrdered(n2, LogBufferDescriptor.packTail(this.termId, n8));
        if (n8 > n7) {
            n8 = this.handleEndOfLog(unsafeBuffer, n7);
        } else {
            this.headerWriter.write(unsafeBuffer, this.termOffset, n5, this.termId);
            unsafeBuffer.putBytes(this.termOffset + 32, directBuffer, n3, n4);
            if (null != reservedValueSupplier) {
                long l2 = reservedValueSupplier.get(unsafeBuffer, this.termOffset, n5);
                unsafeBuffer.putLong(this.termOffset + 24, l2, ByteOrder.LITTLE_ENDIAN);
            }
            FrameDescriptor.frameLengthOrdered(unsafeBuffer, this.termOffset, n5);
        }
        return n8;
    }

    private int appendFragmentedMessage(UnsafeBuffer unsafeBuffer, int n2, DirectBuffer directBuffer, int n3, int n4, ReservedValueSupplier reservedValueSupplier) {
        int n5 = ExclusivePublication.computeFramedLength(n4, this.maxPayloadLength);
        int n6 = unsafeBuffer.capacity();
        int n7 = this.termOffset + n5;
        this.logMetaDataBuffer.putLongOrdered(n2, LogBufferDescriptor.packTail(this.termId, n7));
        if (n7 > n6) {
            n7 = this.handleEndOfLog(unsafeBuffer, n6);
        } else {
            int n8;
            int n9 = this.termOffset;
            byte by2 = -128;
            int n10 = n4;
            do {
                n8 = Math.min(n10, this.maxPayloadLength);
                int n11 = n8 + 32;
                int n12 = BitUtil.align(n11, 32);
                this.headerWriter.write(unsafeBuffer, n9, n11, this.termId);
                unsafeBuffer.putBytes(n9 + 32, directBuffer, n3 + (n4 - n10), n8);
                if (n10 <= this.maxPayloadLength) {
                    by2 = (byte)(by2 | 0x40);
                }
                FrameDescriptor.frameFlags(unsafeBuffer, n9, by2);
                if (null != reservedValueSupplier) {
                    long l2 = reservedValueSupplier.get(unsafeBuffer, n9, n11);
                    unsafeBuffer.putLong(n9 + 24, l2, ByteOrder.LITTLE_ENDIAN);
                }
                FrameDescriptor.frameLengthOrdered(unsafeBuffer, n9, n11);
                by2 = 0;
                n9 += n12;
            } while ((n10 -= n8) > 0);
        }
        return n7;
    }

    private int appendUnfragmentedMessage(UnsafeBuffer unsafeBuffer, int n2, DirectBuffer directBuffer, int n3, int n4, DirectBuffer directBuffer2, int n5, int n6, ReservedValueSupplier reservedValueSupplier) {
        int n7 = n4 + n6 + 32;
        int n8 = BitUtil.align(n7, 32);
        int n9 = unsafeBuffer.capacity();
        int n10 = this.termOffset + n8;
        this.logMetaDataBuffer.putLongOrdered(n2, LogBufferDescriptor.packTail(this.termId, n10));
        if (n10 > n9) {
            n10 = this.handleEndOfLog(unsafeBuffer, n9);
        } else {
            this.headerWriter.write(unsafeBuffer, this.termOffset, n7, this.termId);
            unsafeBuffer.putBytes(this.termOffset + 32, directBuffer, n3, n4);
            unsafeBuffer.putBytes(this.termOffset + 32 + n4, directBuffer2, n5, n6);
            if (null != reservedValueSupplier) {
                long l2 = reservedValueSupplier.get(unsafeBuffer, this.termOffset, n7);
                unsafeBuffer.putLong(this.termOffset + 24, l2, ByteOrder.LITTLE_ENDIAN);
            }
            FrameDescriptor.frameLengthOrdered(unsafeBuffer, this.termOffset, n7);
        }
        return n10;
    }

    private int appendFragmentedMessage(UnsafeBuffer unsafeBuffer, int n2, DirectBuffer directBuffer, int n3, int n4, DirectBuffer directBuffer2, int n5, int n6, int n7, ReservedValueSupplier reservedValueSupplier) {
        int n8 = n4 + n6;
        int n9 = ExclusivePublication.computeFramedLength(n8, n7);
        int n10 = unsafeBuffer.capacity();
        int n11 = this.termOffset + n9;
        this.logMetaDataBuffer.putLongOrdered(n2, LogBufferDescriptor.packTail(this.termId, n11));
        if (n11 > n10) {
            n11 = this.handleEndOfLog(unsafeBuffer, n10);
        } else {
            int n12;
            int n13 = this.termOffset;
            byte by2 = -128;
            int n14 = n8;
            int n15 = 0;
            int n16 = 0;
            do {
                n12 = Math.min(n14, n7);
                int n17 = n12 + 32;
                int n18 = BitUtil.align(n17, 32);
                this.headerWriter.write(unsafeBuffer, n13, n17, this.termId);
                int n19 = 0;
                int n20 = n13 + 32;
                do {
                    int n21;
                    int n22;
                    if ((n22 = n4 - n15) > 0) {
                        n21 = Math.min(n12 - n19, n22);
                        unsafeBuffer.putBytes(n20, directBuffer, n3 + n15, n21);
                        n19 += n21;
                        n20 += n21;
                        n15 += n21;
                        continue;
                    }
                    n21 = Math.min(n12 - n19, n6 - n16);
                    unsafeBuffer.putBytes(n20, directBuffer2, n5 + n16, n21);
                    n19 += n21;
                    n20 += n21;
                    n16 += n21;
                } while (n19 < n12);
                if (n14 <= n7) {
                    by2 = (byte)(by2 | 0x40);
                }
                FrameDescriptor.frameFlags(unsafeBuffer, n13, by2);
                if (null != reservedValueSupplier) {
                    long l2 = reservedValueSupplier.get(unsafeBuffer, n13, n17);
                    unsafeBuffer.putLong(n13 + 24, l2, ByteOrder.LITTLE_ENDIAN);
                }
                FrameDescriptor.frameLengthOrdered(unsafeBuffer, n13, n17);
                by2 = 0;
                n13 += n18;
            } while ((n14 -= n12) > 0);
        }
        return n11;
    }

    private int appendUnfragmentedMessage(UnsafeBuffer unsafeBuffer, int n2, DirectBufferVector[] directBufferVectorArray, int n3, ReservedValueSupplier reservedValueSupplier) {
        int n4 = n3 + 32;
        int n5 = BitUtil.align(n4, 32);
        int n6 = unsafeBuffer.capacity();
        int n7 = this.termOffset + n5;
        this.logMetaDataBuffer.putLongOrdered(n2, LogBufferDescriptor.packTail(this.termId, n7));
        if (n7 > n6) {
            n7 = this.handleEndOfLog(unsafeBuffer, n6);
        } else {
            this.headerWriter.write(unsafeBuffer, this.termOffset, n4, this.termId);
            int n8 = this.termOffset + 32;
            for (DirectBufferVector directBufferVector : directBufferVectorArray) {
                unsafeBuffer.putBytes(n8, directBufferVector.buffer(), directBufferVector.offset(), directBufferVector.length());
                n8 += directBufferVector.length();
            }
            if (null != reservedValueSupplier) {
                long l2 = reservedValueSupplier.get(unsafeBuffer, this.termOffset, n4);
                unsafeBuffer.putLong(this.termOffset + 24, l2, ByteOrder.LITTLE_ENDIAN);
            }
            FrameDescriptor.frameLengthOrdered(unsafeBuffer, this.termOffset, n4);
        }
        return n7;
    }

    private int appendFragmentedMessage(UnsafeBuffer unsafeBuffer, int n2, DirectBufferVector[] directBufferVectorArray, int n3, ReservedValueSupplier reservedValueSupplier) {
        int n4 = ExclusivePublication.computeFramedLength(n3, this.maxPayloadLength);
        int n5 = unsafeBuffer.capacity();
        int n6 = this.termOffset + n4;
        this.logMetaDataBuffer.putLongOrdered(n2, LogBufferDescriptor.packTail(this.termId, n6));
        if (n6 > n5) {
            n6 = this.handleEndOfLog(unsafeBuffer, n5);
        } else {
            int n7;
            int n8 = this.termOffset;
            byte by2 = -128;
            int n9 = n3;
            int n10 = 0;
            int n11 = 0;
            do {
                n7 = Math.min(n9, this.maxPayloadLength);
                int n12 = n7 + 32;
                int n13 = BitUtil.align(n12, 32);
                this.headerWriter.write(unsafeBuffer, n8, n12, this.termId);
                int n14 = 0;
                int n15 = n8 + 32;
                do {
                    DirectBufferVector directBufferVector = directBufferVectorArray[n10];
                    int n16 = directBufferVector.length() - n11;
                    int n17 = Math.min(n7 - n14, n16);
                    unsafeBuffer.putBytes(n15, directBufferVector.buffer(), directBufferVector.offset() + n11, n17);
                    n14 += n17;
                    n15 += n17;
                    n11 += n17;
                    if (n16 > n17) continue;
                    ++n10;
                    n11 = 0;
                } while (n14 < n7);
                if (n9 <= this.maxPayloadLength) {
                    by2 = (byte)(by2 | 0x40);
                }
                FrameDescriptor.frameFlags(unsafeBuffer, n8, by2);
                if (null != reservedValueSupplier) {
                    long l2 = reservedValueSupplier.get(unsafeBuffer, n8, n12);
                    unsafeBuffer.putLong(n8 + 24, l2, ByteOrder.LITTLE_ENDIAN);
                }
                FrameDescriptor.frameLengthOrdered(unsafeBuffer, n8, n12);
                by2 = 0;
                n8 += n13;
            } while ((n9 -= n7) > 0);
        }
        return n6;
    }

    int claim(UnsafeBuffer unsafeBuffer, int n2, int n3, BufferClaim bufferClaim) {
        int n4 = n3 + 32;
        int n5 = BitUtil.align(n4, 32);
        int n6 = unsafeBuffer.capacity();
        int n7 = this.termOffset + n5;
        this.logMetaDataBuffer.putLongOrdered(n2, LogBufferDescriptor.packTail(this.termId, n7));
        if (n7 > n6) {
            n7 = this.handleEndOfLog(unsafeBuffer, n6);
        } else {
            this.headerWriter.write(unsafeBuffer, this.termOffset, n4, this.termId);
            bufferClaim.wrap(unsafeBuffer, this.termOffset, n4);
        }
        return n7;
    }

    private int appendPadding(UnsafeBuffer unsafeBuffer, int n2, int n3) {
        int n4 = n3 + 32;
        int n5 = BitUtil.align(n4, 32);
        int n6 = unsafeBuffer.capacity();
        int n7 = this.termOffset + n5;
        this.logMetaDataBuffer.putLongOrdered(n2, LogBufferDescriptor.packTail(this.termId, n7));
        if (n7 > n6) {
            n7 = this.handleEndOfLog(unsafeBuffer, n6);
        } else {
            this.headerWriter.write(unsafeBuffer, this.termOffset, n4, this.termId);
            FrameDescriptor.frameType(unsafeBuffer, this.termOffset, 0);
            FrameDescriptor.frameLengthOrdered(unsafeBuffer, this.termOffset, n4);
        }
        return n7;
    }

    private int appendBlock(UnsafeBuffer unsafeBuffer, int n2, MutableDirectBuffer mutableDirectBuffer, int n3, int n4) {
        int n5 = this.termOffset + n4;
        int n6 = mutableDirectBuffer.getInt(n3, ByteOrder.LITTLE_ENDIAN);
        this.logMetaDataBuffer.putLongOrdered(n2, LogBufferDescriptor.packTail(this.termId, n5));
        mutableDirectBuffer.putInt(n3, 0, ByteOrder.LITTLE_ENDIAN);
        unsafeBuffer.putBytes(this.termOffset, mutableDirectBuffer, n3, n4);
        FrameDescriptor.frameLengthOrdered(unsafeBuffer, this.termOffset, n6);
        return n5;
    }
}

