/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.logbuffer.LogBufferDescriptor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.agrona.AsciiEncoding;
import org.agrona.collections.ArrayUtil;
import org.agrona.collections.Object2ObjectHashMap;

public final class ChannelUri {
    public static final String AERON_SCHEME = "aeron";
    public static final String SPY_QUALIFIER = "aeron-spy";
    public static final long INVALID_TAG = -1L;
    private static final int CHANNEL_TAG_INDEX = 0;
    private static final int ENTITY_TAG_INDEX = 1;
    private static final String AERON_PREFIX = "aeron:";
    private String prefix;
    private String media;
    private final Object2ObjectHashMap<String, String> params;
    private final String[] tags;

    private ChannelUri(String string, String string2, Object2ObjectHashMap<String, String> object2ObjectHashMap) {
        this.prefix = string;
        this.media = string2;
        this.params = object2ObjectHashMap;
        this.tags = ChannelUri.splitTags(object2ObjectHashMap.get("tags"));
    }

    public String prefix() {
        return this.prefix;
    }

    public ChannelUri prefix(String string) {
        this.prefix = string;
        return this;
    }

    public String media() {
        return this.media;
    }

    public ChannelUri media(String string) {
        ChannelUri.validateMedia(string);
        this.media = string;
        return this;
    }

    public boolean isUdp() {
        return "udp".equals(this.media);
    }

    public boolean isIpc() {
        return "ipc".equals(this.media);
    }

    public String scheme() {
        return AERON_SCHEME;
    }

    public String get(String string) {
        return this.params.get(string);
    }

    public String get(String string, String string2) {
        String string3 = this.params.get(string);
        if (null != string3) {
            return string3;
        }
        return string2;
    }

    public String put(String string, String string2) {
        return this.params.put(string, string2);
    }

    public String remove(String string) {
        return this.params.remove(string);
    }

    public boolean containsKey(String string) {
        return this.params.containsKey(string);
    }

    public String channelTag() {
        return this.tags.length > 0 ? this.tags[0] : null;
    }

    public String entityTag() {
        return this.tags.length > 1 ? this.tags[1] : null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ChannelUri)) {
            return false;
        }
        ChannelUri channelUri = (ChannelUri)object;
        return Objects.equals(this.prefix, channelUri.prefix) && Objects.equals(this.media, channelUri.media) && Objects.equals(this.params, channelUri.params) && Arrays.equals(this.tags, channelUri.tags);
    }

    public int hashCode() {
        int n2 = 19;
        n2 = 31 * n2 + Objects.hashCode(this.prefix);
        n2 = 31 * n2 + Objects.hashCode(this.media);
        n2 = 31 * n2 + Objects.hashCode(this.params);
        n2 = 31 * n2 + Arrays.hashCode(this.tags);
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder;
        if (this.prefix == null || this.prefix.isEmpty()) {
            stringBuilder = new StringBuilder(this.params.size() * 20 + 10);
        } else {
            stringBuilder = new StringBuilder(this.params.size() * 20 + 20);
            stringBuilder.append(this.prefix);
            if (!this.prefix.endsWith(":")) {
                stringBuilder.append(':');
            }
        }
        stringBuilder.append(AERON_PREFIX).append(this.media);
        if (this.params.size() > 0) {
            stringBuilder.append('?');
            for (Map.Entry entry : this.params.entrySet()) {
                stringBuilder.append((String)entry.getKey()).append('=').append((String)entry.getValue()).append('|');
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public void initialPosition(long l2, int n2, int n3) {
        if (l2 < 0L || 0L != (l2 & 0x1FL)) {
            throw new IllegalArgumentException("invalid position: " + l2);
        }
        int n4 = LogBufferDescriptor.positionBitsToShift(n3);
        int n5 = LogBufferDescriptor.computeTermIdFromPosition(l2, n4, n2);
        int n6 = (int)(l2 & (long)(n3 - 1));
        this.put("init-term-id", Integer.toString(n2));
        this.put("term-id", Integer.toString(n5));
        this.put("term-offset", Integer.toString(n6));
        this.put("term-length", Integer.toString(n3));
    }

    public static ChannelUri parse(CharSequence charSequence) {
        String string;
        int n2 = 0;
        if (ChannelUri.startsWith(charSequence, 0, "aeron-spy:")) {
            string = SPY_QUALIFIER;
            n2 = "aeron-spy:".length();
        } else {
            string = "";
        }
        if (!ChannelUri.startsWith(charSequence, n2, AERON_PREFIX)) {
            throw new IllegalArgumentException("Aeron URIs must start with 'aeron:', found: " + charSequence);
        }
        n2 += AERON_PREFIX.length();
        StringBuilder stringBuilder = new StringBuilder();
        Object2ObjectHashMap<String, String> object2ObjectHashMap = new Object2ObjectHashMap<String, String>();
        String string2 = null;
        String string3 = null;
        State state = State.MEDIA;
        int n3 = charSequence.length();
        block13: for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = charSequence.charAt(i2);
            switch (state) {
                case MEDIA: {
                    switch (c2) {
                        case '?': {
                            string2 = stringBuilder.toString();
                            stringBuilder.setLength(0);
                            state = State.PARAMS_KEY;
                            continue block13;
                        }
                        case ':': 
                        case '=': 
                        case '|': {
                            throw new IllegalArgumentException("encountered '" + c2 + "' within media definition at index " + i2 + " in " + charSequence);
                        }
                    }
                    stringBuilder.append(c2);
                    continue block13;
                }
                case PARAMS_KEY: {
                    if (c2 == '=') {
                        if (0 == stringBuilder.length()) {
                            throw new IllegalStateException("empty key not allowed at index " + i2 + " in " + charSequence);
                        }
                        string3 = stringBuilder.toString();
                        stringBuilder.setLength(0);
                        state = State.PARAMS_VALUE;
                        continue block13;
                    }
                    if (c2 == '|') {
                        throw new IllegalStateException("invalid end of key at index " + i2 + " in " + charSequence);
                    }
                    stringBuilder.append(c2);
                    continue block13;
                }
                case PARAMS_VALUE: {
                    if (c2 == '|') {
                        object2ObjectHashMap.put(string3, stringBuilder.toString());
                        stringBuilder.setLength(0);
                        state = State.PARAMS_KEY;
                        continue block13;
                    }
                    stringBuilder.append(c2);
                    continue block13;
                }
                default: {
                    throw new IllegalStateException("unexpected state=" + (Object)((Object)state) + " in " + charSequence);
                }
            }
        }
        switch (state) {
            case MEDIA: {
                string2 = stringBuilder.toString();
                ChannelUri.validateMedia(string2);
                break;
            }
            case PARAMS_VALUE: {
                object2ObjectHashMap.put(string3, stringBuilder.toString());
                break;
            }
            default: {
                throw new IllegalStateException("no more input found, state=" + (Object)((Object)state) + " in " + charSequence);
            }
        }
        return new ChannelUri(string, string2, object2ObjectHashMap);
    }

    public static String addSessionId(String string, int n2) {
        ChannelUri channelUri = ChannelUri.parse(string);
        channelUri.put("session-id", Integer.toString(n2));
        return channelUri.toString();
    }

    public static boolean isTagged(String string) {
        return ChannelUri.startsWith(string, 0, "tag:");
    }

    public static long getTag(String string) {
        return ChannelUri.isTagged(string) ? AsciiEncoding.parseLongAscii(string, 4, string.length() - 4) : -1L;
    }

    public static String createDestinationUri(String string, String string2) {
        ChannelUri channelUri = ChannelUri.parse(string);
        String string3 = AERON_PREFIX + channelUri.media() + "?" + "endpoint" + "=" + string2;
        String string4 = channelUri.get("interface");
        if (null != string4) {
            return string3 + "|" + "interface" + "=" + string4;
        }
        return string3;
    }

    public void replaceEndpointWildcardPort(String string) {
        int n2 = Objects.requireNonNull(string, "resolvedEndpoint is null").lastIndexOf(58);
        if (-1 == n2) {
            throw new IllegalArgumentException("No port specified on resolvedEndpoint=" + string);
        }
        if (string.endsWith(":0")) {
            throw new IllegalArgumentException("Wildcard port specified on resolvedEndpoint=" + string);
        }
        String string2 = this.get("endpoint");
        if (null == string2) {
            this.put("endpoint", string);
        } else if (string2.endsWith(":0")) {
            String string3 = string2.substring(0, string2.length() - 2) + string.substring(string.lastIndexOf(58));
            this.put("endpoint", string3);
        }
    }

    private static void validateMedia(String string) {
        if ("ipc".equals(string) || "udp".equals(string)) {
            return;
        }
        throw new IllegalArgumentException("unknown media: " + string);
    }

    private static boolean startsWith(CharSequence charSequence, int n2, String string) {
        if (charSequence.length() - n2 < string.length()) {
            return false;
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (charSequence.charAt(n2 + i2) == string.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    private static String[] splitTags(String string) {
        String[] stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
        if (null != string) {
            int n2 = ChannelUri.countTags(string);
            if (n2 == 1) {
                stringArray = new String[]{string};
            } else {
                int n3 = 0;
                int n4 = 0;
                stringArray = new String[n2];
                int n5 = string.length();
                for (int i2 = 0; i2 < n5; ++i2) {
                    if (string.charAt(i2) != ',') continue;
                    stringArray[n4++] = string.substring(n3, i2);
                    n3 = i2 + 1;
                    if (n4 < n2 - 1) continue;
                    stringArray[n4] = string.substring(n3, n5);
                }
            }
        }
        return stringArray;
    }

    private static int countTags(String string) {
        int n2 = 1;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (string.charAt(i2) != ',') continue;
            ++n2;
        }
        return n2;
    }

    Map<String, String> diff(ChannelUri channelUri) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (!Objects.equals(this.prefix, channelUri.prefix)) {
            hashMap.put("prefix", this.prefix + " != " + channelUri.prefix);
        }
        if (!Objects.equals(this.media, channelUri.media)) {
            hashMap.put("media", this.media + " != " + channelUri.media);
        }
        if (!Objects.equals(this.params, channelUri.params)) {
            this.params.forEach((string, string2) -> {
                String string3 = channelUri.params.get(string);
                if (!Objects.equals(string2, string3)) {
                    hashMap.put((String)string, string2 + " != " + string3);
                }
            });
        }
        if (!Arrays.equals(this.tags, channelUri.tags)) {
            hashMap.put("tags", Arrays.toString(this.tags) + " != " + Arrays.toString(channelUri.tags));
        }
        return hashMap;
    }

    private static enum State {
        MEDIA,
        PARAMS_KEY,
        PARAMS_VALUE;

    }
}

