/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.tools.rectangle;

import impl.org.controlsfx.tools.MathTools;
import impl.org.controlsfx.tools.rectangle.Edge2D;
import java.util.Objects;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;

public class Rectangles2D {
    public static boolean contains(Rectangle2D rectangle2D, Edge2D edge2D) {
        Objects.requireNonNull(rectangle2D, "The argument 'rectangle' must not be null.");
        Objects.requireNonNull(edge2D, "The argument 'edge' must not be null.");
        boolean bl2 = rectangle2D.contains(edge2D.getUpperLeft()) && rectangle2D.contains(edge2D.getLowerRight());
        return bl2;
    }

    public static Point2D inRectangle(Rectangle2D rectangle2D, Point2D point2D) {
        Objects.requireNonNull(rectangle2D, "The argument 'rectangle' must not be null.");
        Objects.requireNonNull(point2D, "The argument 'point' must not be null.");
        if (rectangle2D.contains(point2D)) {
            return point2D;
        }
        double d2 = MathTools.inInterval(rectangle2D.getMinX(), point2D.getX(), rectangle2D.getMaxX());
        double d3 = MathTools.inInterval(rectangle2D.getMinY(), point2D.getY(), rectangle2D.getMaxY());
        return new Point2D(d2, d3);
    }

    public static Point2D getCenterPoint(Rectangle2D rectangle2D) {
        Objects.requireNonNull(rectangle2D, "The argument 'rectangle' must not be null.");
        double d2 = (rectangle2D.getMinX() + rectangle2D.getMaxX()) / 2.0;
        double d3 = (rectangle2D.getMinY() + rectangle2D.getMaxY()) / 2.0;
        return new Point2D(d2, d3);
    }

    public static Rectangle2D intersection(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        Objects.requireNonNull(rectangle2D, "The argument 'a' must not be null.");
        Objects.requireNonNull(rectangle2D2, "The argument 'b' must not be null.");
        if (rectangle2D.intersects(rectangle2D2)) {
            double d2 = Math.max(rectangle2D.getMinX(), rectangle2D2.getMinX());
            double d3 = Math.min(rectangle2D.getMaxX(), rectangle2D2.getMaxX());
            double d4 = d3 - d2;
            double d5 = Math.max(rectangle2D.getMinY(), rectangle2D2.getMinY());
            double d6 = Math.min(rectangle2D.getMaxY(), rectangle2D2.getMaxY());
            double d7 = d6 - d5;
            return new Rectangle2D(d2, d5, d4, d7);
        }
        return Rectangle2D.EMPTY;
    }

    public static Rectangle2D forDiagonalCorners(Point2D point2D, Point2D point2D2) {
        Objects.requireNonNull(point2D, "The specified corner must not be null.");
        Objects.requireNonNull(point2D2, "The specified diagonal corner must not be null.");
        double d2 = Math.min(point2D.getX(), point2D2.getX());
        double d3 = Math.min(point2D.getY(), point2D2.getY());
        double d4 = Math.abs(point2D.getX() - point2D2.getX());
        double d5 = Math.abs(point2D.getY() - point2D2.getY());
        return new Rectangle2D(d2, d3, d4, d5);
    }

    public static Rectangle2D forUpperLeftCornerAndSize(Point2D point2D, double d2, double d3) {
        return new Rectangle2D(point2D.getX(), point2D.getY(), d2, d3);
    }

    public static Rectangle2D forDiagonalCornersAndRatio(Point2D point2D, Point2D point2D2, double d2) {
        Objects.requireNonNull(point2D, "The specified fixed corner must not be null.");
        Objects.requireNonNull(point2D2, "The specified diagonal corner must not be null.");
        if (d2 < 0.0) {
            throw new IllegalArgumentException("The specified ratio " + d2 + " must be larger than zero.");
        }
        double d3 = point2D2.getX() - point2D.getX();
        double d4 = point2D2.getY() - point2D.getY();
        double d5 = Rectangles2D.correctCoordinateDifferenceByRatio(d3, d4, d2);
        double d6 = Rectangles2D.correctCoordinateDifferenceByRatio(d4, d3, 1.0 / d2);
        double d7 = Rectangles2D.getMinCoordinate(point2D.getX(), d5);
        double d8 = Rectangles2D.getMinCoordinate(point2D.getY(), d6);
        double d9 = Math.abs(d5);
        double d10 = Math.abs(d6);
        return new Rectangle2D(d7, d8, d9, d10);
    }

    private static double correctCoordinateDifferenceByRatio(double d2, double d3, double d4) {
        double d5 = d3 * d4;
        double d6 = Math.min(Math.abs(d2), Math.abs(d5));
        return d6 * Math.signum(d2);
    }

    private static double getMinCoordinate(double d2, double d3) {
        if (d3 < 0.0) {
            return d2 + d3;
        }
        return d2;
    }

    public static Rectangle2D forCenterAndSize(Point2D point2D, double d2, double d3) {
        Objects.requireNonNull(point2D, "The specified center point must not be null.");
        double d4 = Math.abs(d2);
        double d5 = Math.abs(d3);
        double d6 = point2D.getX() - d4 / 2.0;
        double d7 = point2D.getY() - d5 / 2.0;
        return new Rectangle2D(d6, d7, d2, d3);
    }

    public static Rectangle2D fixRatio(Rectangle2D rectangle2D, double d2) {
        Objects.requireNonNull(rectangle2D, "The specified original rectangle must not be null.");
        if (d2 < 0.0) {
            throw new IllegalArgumentException("The specified ratio " + d2 + " must be larger than zero.");
        }
        return Rectangles2D.createWithFixedRatioWithinBounds(rectangle2D, d2, null);
    }

    public static Rectangle2D fixRatioWithinBounds(Rectangle2D rectangle2D, double d2, Rectangle2D rectangle2D2) {
        Objects.requireNonNull(rectangle2D, "The specified original rectangle must not be null.");
        Objects.requireNonNull(rectangle2D2, "The specified bounds for the new rectangle must not be null.");
        if (d2 < 0.0) {
            throw new IllegalArgumentException("The specified ratio " + d2 + " must be larger than zero.");
        }
        return Rectangles2D.createWithFixedRatioWithinBounds(rectangle2D, d2, rectangle2D2);
    }

    private static Rectangle2D createWithFixedRatioWithinBounds(Rectangle2D rectangle2D, double d2, Rectangle2D rectangle2D2) {
        boolean bl2;
        Point2D point2D = Rectangles2D.getCenterPoint(rectangle2D);
        boolean bl3 = bl2 = rectangle2D2 == null || rectangle2D2.contains(point2D);
        if (!bl2) {
            throw new IllegalArgumentException("The center point " + point2D + " of the original rectangle is out of the specified bounds.");
        }
        double d3 = rectangle2D.getWidth() * rectangle2D.getHeight();
        return Rectangles2D.createForCenterAreaAndRatioWithinBounds(point2D, d3, d2, rectangle2D2);
    }

    public static Rectangle2D forCenterAndAreaAndRatio(Point2D point2D, double d2, double d3) {
        Objects.requireNonNull(point2D, "The specified center point of the new rectangle must not be null.");
        if (d2 < 0.0) {
            throw new IllegalArgumentException("The specified area " + d2 + " must be larger than zero.");
        }
        if (d3 < 0.0) {
            throw new IllegalArgumentException("The specified ratio " + d3 + " must be larger than zero.");
        }
        return Rectangles2D.createForCenterAreaAndRatioWithinBounds(point2D, d2, d3, null);
    }

    public static Rectangle2D forCenterAndAreaAndRatioWithinBounds(Point2D point2D, double d2, double d3, Rectangle2D rectangle2D) {
        Objects.requireNonNull(point2D, "The specified center point of the new rectangle must not be null.");
        Objects.requireNonNull(rectangle2D, "The specified bounds for the new rectangle must not be null.");
        boolean bl2 = rectangle2D.contains(point2D);
        if (!bl2) {
            throw new IllegalArgumentException("The center point " + point2D + " of the original rectangle is out of the specified bounds.");
        }
        if (d2 < 0.0) {
            throw new IllegalArgumentException("The specified area " + d2 + " must be larger than zero.");
        }
        if (d3 < 0.0) {
            throw new IllegalArgumentException("The specified ratio " + d3 + " must be larger than zero.");
        }
        return Rectangles2D.createForCenterAreaAndRatioWithinBounds(point2D, d2, d3, rectangle2D);
    }

    private static Rectangle2D createForCenterAreaAndRatioWithinBounds(Point2D point2D, double d2, double d3, Rectangle2D rectangle2D) {
        boolean bl2;
        double d4 = Math.sqrt(d2 * d3);
        double d5 = d2 / d4;
        boolean bl3 = bl2 = rectangle2D != null;
        if (bl2) {
            double d6 = Rectangles2D.lengthReductionToStayWithinBounds(point2D, d4, d5, rectangle2D);
            d4 *= d6;
            d5 *= d6;
        }
        return Rectangles2D.forCenterAndSize(point2D, d4, d5);
    }

    private static double lengthReductionToStayWithinBounds(Point2D point2D, double d2, double d3, Rectangle2D rectangle2D) {
        Objects.requireNonNull(point2D, "The specified center point of the new rectangle must not be null.");
        Objects.requireNonNull(rectangle2D, "The specified bounds for the new rectangle must not be null.");
        boolean bl2 = rectangle2D.contains(point2D);
        if (!bl2) {
            throw new IllegalArgumentException("The center point " + point2D + " of the original rectangle is out of the specified bounds.");
        }
        if (d2 < 0.0) {
            throw new IllegalArgumentException("The specified width " + d2 + " must be larger than zero.");
        }
        if (d3 < 0.0) {
            throw new IllegalArgumentException("The specified height " + d3 + " must be larger than zero.");
        }
        double d4 = Math.abs(point2D.getX() - rectangle2D.getMinX());
        double d5 = Math.abs(point2D.getX() - rectangle2D.getMaxX());
        double d6 = Math.abs(point2D.getY() - rectangle2D.getMinY());
        double d7 = Math.abs(point2D.getY() - rectangle2D.getMaxY());
        return MathTools.min(1.0, d4 / d2 * 2.0, d5 / d2 * 2.0, d6 / d3 * 2.0, d7 / d3 * 2.0);
    }

    public static Rectangle2D forEdgeAndOpposingPoint(Edge2D edge2D, Point2D point2D) {
        double d2 = edge2D.getOrthogonalDifference(point2D);
        return Rectangles2D.createForEdgeAndOtherDimension(edge2D, d2);
    }

    public static Rectangle2D forEdgeAndOpposingPointAndRatioWithinBounds(Edge2D edge2D, Point2D point2D, double d2, Rectangle2D rectangle2D) {
        Objects.requireNonNull(edge2D, "The specified edge must not be null.");
        Objects.requireNonNull(point2D, "The specified point must not be null.");
        Objects.requireNonNull(rectangle2D, "The specified bounds must not be null.");
        boolean bl2 = Rectangles2D.contains(rectangle2D, edge2D);
        if (!bl2) {
            throw new IllegalArgumentException("The specified edge " + edge2D + " is not entirely contained on the specified bounds.");
        }
        if (d2 < 0.0) {
            throw new IllegalArgumentException("The specified ratio " + d2 + " must be larger than zero.");
        }
        Point2D point2D2 = Rectangles2D.movePointIntoBounds(point2D, rectangle2D);
        Edge2D edge2D2 = Rectangles2D.resizeEdgeForDistanceAndRatio(edge2D, point2D2, d2);
        Edge2D edge2D3 = Rectangles2D.resizeEdgeForBounds(edge2D2, rectangle2D);
        double d3 = Math.signum(edge2D3.getOrthogonalDifference(point2D2));
        d3 = edge2D3.isHorizontal() ? (d3 *= edge2D3.getLength() / d2) : (d3 *= edge2D3.getLength() * d2);
        return Rectangles2D.createForEdgeAndOtherDimension(edge2D3, d3);
    }

    private static Point2D movePointIntoBounds(Point2D point2D, Rectangle2D rectangle2D) {
        if (rectangle2D.contains(point2D)) {
            return point2D;
        }
        double d2 = MathTools.inInterval(rectangle2D.getMinX(), point2D.getX(), rectangle2D.getMaxX());
        double d3 = MathTools.inInterval(rectangle2D.getMinY(), point2D.getY(), rectangle2D.getMaxY());
        return new Point2D(d2, d3);
    }

    private static Edge2D resizeEdgeForDistanceAndRatio(Edge2D edge2D, Point2D point2D, double d2) {
        double d3 = Math.abs(edge2D.getOrthogonalDifference(point2D));
        if (edge2D.isHorizontal()) {
            double d4 = d3 * d2;
            return new Edge2D(edge2D.getCenterPoint(), edge2D.getOrientation(), d4);
        }
        double d5 = d3 / d2;
        return new Edge2D(edge2D.getCenterPoint(), edge2D.getOrientation(), d5);
    }

    private static Edge2D resizeEdgeForBounds(Edge2D edge2D, Rectangle2D rectangle2D) {
        boolean bl2 = Rectangles2D.contains(rectangle2D, edge2D);
        if (bl2) {
            return edge2D;
        }
        boolean bl3 = rectangle2D.contains(edge2D.getCenterPoint());
        if (!bl3) {
            throw new IllegalArgumentException("The specified edge's center point (" + edge2D + ") is out of the specified bounds (" + rectangle2D + ").");
        }
        if (edge2D.isHorizontal()) {
            double d2 = Math.abs(rectangle2D.getMinX() - edge2D.getCenterPoint().getX());
            double d3 = Math.abs(rectangle2D.getMaxX() - edge2D.getCenterPoint().getX());
            double d4 = MathTools.inInterval(0.0, edge2D.getLength() / 2.0, d2);
            double d5 = MathTools.inInterval(0.0, edge2D.getLength() / 2.0, d3);
            double d6 = Math.min(d4, d5) * 2.0;
            return new Edge2D(edge2D.getCenterPoint(), edge2D.getOrientation(), d6);
        }
        double d7 = Math.abs(rectangle2D.getMinY() - edge2D.getCenterPoint().getY());
        double d8 = Math.abs(rectangle2D.getMaxY() - edge2D.getCenterPoint().getY());
        double d9 = MathTools.inInterval(0.0, edge2D.getLength() / 2.0, d7);
        double d10 = MathTools.inInterval(0.0, edge2D.getLength() / 2.0, d8);
        double d11 = Math.min(d9, d10) * 2.0;
        return new Edge2D(edge2D.getCenterPoint(), edge2D.getOrientation(), d11);
    }

    private static Rectangle2D createForEdgeAndOtherDimension(Edge2D edge2D, double d2) {
        if (edge2D.isHorizontal()) {
            return Rectangles2D.createForHorizontalEdgeAndHeight(edge2D, d2);
        }
        return Rectangles2D.createForVerticalEdgeAndWidth(edge2D, d2);
    }

    private static Rectangle2D createForHorizontalEdgeAndHeight(Edge2D edge2D, double d2) {
        Point2D point2D = edge2D.getUpperLeft();
        double d3 = point2D.getX();
        double d4 = point2D.getY() + Math.min(0.0, d2);
        double d5 = Math.abs(edge2D.getLength());
        double d6 = Math.abs(d2);
        return new Rectangle2D(d3, d4, d5, d6);
    }

    private static Rectangle2D createForVerticalEdgeAndWidth(Edge2D edge2D, double d2) {
        Point2D point2D = edge2D.getUpperLeft();
        double d3 = point2D.getX() + Math.min(0.0, d2);
        double d4 = point2D.getY();
        double d5 = Math.abs(d2);
        double d6 = Math.abs(edge2D.getLength());
        return new Rectangle2D(d3, d4, d5, d6);
    }

    public static Rectangle2D fromBounds(Bounds bounds) {
        return new Rectangle2D(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
    }
}

