/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.tools.rectangle;

import impl.org.controlsfx.tools.rectangle.CoordinatePosition;
import java.util.EnumSet;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;

public class CoordinatePositions {
    public static EnumSet<CoordinatePosition> onRectangleAndEdges(Rectangle2D rectangle2D, Point2D point2D, double d2) {
        EnumSet<CoordinatePosition> enumSet = EnumSet.noneOf(CoordinatePosition.class);
        enumSet.add(CoordinatePositions.inRectangle(rectangle2D, point2D));
        enumSet.add(CoordinatePositions.onEdges(rectangle2D, point2D, d2));
        return enumSet;
    }

    public static CoordinatePosition inRectangle(Rectangle2D rectangle2D, Point2D point2D) {
        if (rectangle2D.contains(point2D)) {
            return CoordinatePosition.IN_RECTANGLE;
        }
        return CoordinatePosition.OUT_OF_RECTANGLE;
    }

    public static CoordinatePosition onEdges(Rectangle2D rectangle2D, Point2D point2D, double d2) {
        CoordinatePosition coordinatePosition = CoordinatePositions.closeToVertical(rectangle2D, point2D, d2);
        CoordinatePosition coordinatePosition2 = CoordinatePositions.closeToHorizontal(rectangle2D, point2D, d2);
        return CoordinatePositions.extractSingleCardinalDirection(coordinatePosition, coordinatePosition2);
    }

    private static CoordinatePosition closeToVertical(Rectangle2D rectangle2D, Point2D point2D, double d2) {
        boolean bl2;
        boolean bl3;
        double d3 = Math.abs(point2D.getX() - rectangle2D.getMinX());
        double d4 = Math.abs(point2D.getX() - rectangle2D.getMaxX());
        boolean bl4 = d3 < d2 && d3 < d4;
        boolean bl5 = bl3 = d4 < d2 && d4 < d3;
        if (!bl4 && !bl3) {
            return null;
        }
        boolean bl6 = bl2 = rectangle2D.getMinY() - d2 < point2D.getY() && point2D.getY() < rectangle2D.getMaxY() + d2;
        if (bl2) {
            if (bl4) {
                return CoordinatePosition.WEST_EDGE;
            }
            if (bl3) {
                return CoordinatePosition.EAST_EDGE;
            }
        }
        return null;
    }

    private static CoordinatePosition closeToHorizontal(Rectangle2D rectangle2D, Point2D point2D, double d2) {
        boolean bl2;
        boolean bl3;
        double d3 = Math.abs(point2D.getY() - rectangle2D.getMinY());
        double d4 = Math.abs(point2D.getY() - rectangle2D.getMaxY());
        boolean bl4 = d3 < d2 && d3 < d4;
        boolean bl5 = bl3 = d4 < d2 && d4 < d3;
        if (!bl4 && !bl3) {
            return null;
        }
        boolean bl6 = bl2 = rectangle2D.getMinX() - d2 < point2D.getX() && point2D.getX() < rectangle2D.getMaxX() + d2;
        if (bl2) {
            if (bl4) {
                return CoordinatePosition.NORTH_EDGE;
            }
            if (bl3) {
                return CoordinatePosition.SOUTH_EDGE;
            }
        }
        return null;
    }

    private static CoordinatePosition extractSingleCardinalDirection(CoordinatePosition coordinatePosition, CoordinatePosition coordinatePosition2) {
        if (coordinatePosition == null) {
            return coordinatePosition2;
        }
        if (coordinatePosition2 == null) {
            return coordinatePosition;
        }
        if (coordinatePosition2 == CoordinatePosition.NORTH_EDGE && coordinatePosition == CoordinatePosition.EAST_EDGE) {
            return CoordinatePosition.NORTHEAST_EDGE;
        }
        if (coordinatePosition2 == CoordinatePosition.NORTH_EDGE && coordinatePosition == CoordinatePosition.WEST_EDGE) {
            return CoordinatePosition.NORTHWEST_EDGE;
        }
        if (coordinatePosition2 == CoordinatePosition.SOUTH_EDGE && coordinatePosition == CoordinatePosition.EAST_EDGE) {
            return CoordinatePosition.SOUTHEAST_EDGE;
        }
        if (coordinatePosition2 == CoordinatePosition.SOUTH_EDGE && coordinatePosition == CoordinatePosition.WEST_EDGE) {
            return CoordinatePosition.SOUTHWEST_EDGE;
        }
        throw new IllegalArgumentException();
    }
}

