/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.tableview2.filter.parser.number;

import impl.org.controlsfx.i18n.Localization;
import impl.org.controlsfx.tableview2.filter.parser.Operation;
import impl.org.controlsfx.tableview2.filter.parser.aggregate.AggregatorsParser;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.controlsfx.control.tableview2.filter.parser.Parser;

public class NumberParser<T extends Number>
implements Parser<T> {
    private String errorString = "";

    @Override
    public Predicate<T> parse(String string) {
        this.errorString = "";
        Predicate predicate = this.aggregate(string);
        if (predicate == null) {
            Optional<NumberOperation> optional = Stream.of(NumberOperation.values()).filter(numberOperation -> string.startsWith(numberOperation.get())).filter(numberOperation -> string.length() > numberOperation.length()).findFirst();
            if (optional.isPresent()) {
                NumberOperation numberOperation2 = optional.get();
                String string2 = this.trim(string, numberOperation2.length());
                if (!this.isNumeric(string2)) {
                    this.errorString = Localization.localize(Localization.asKey("parser.text.error.number.input"));
                    return null;
                }
                return numberOperation2.operate(this.convert(string2));
            }
            this.errorString = Localization.localize(Localization.asKey("parser.text.error.start.operator"));
            return null;
        }
        return predicate;
    }

    @Override
    public List<String> operators() {
        return Stream.concat(Arrays.stream(NumberOperation.values()).map(Operation::get), AggregatorsParser.getStrings()).collect(Collectors.toList());
    }

    @Override
    public String getSymbol(String string) {
        return Arrays.stream(NumberOperation.values()).filter(numberOperation -> numberOperation.get().equals(string)).map(Operation::getSymbol).findFirst().orElse(NumberParser.i18nString("symbol.default"));
    }

    @Override
    public boolean isValid(String string) {
        this.parse(string);
        return this.errorString.isEmpty();
    }

    @Override
    public String getErrorMessage() {
        return this.errorString;
    }

    private boolean isNumeric(String string) {
        return !string.isEmpty() && string.matches("-?\\d+(\\.\\d+)?");
    }

    private String trim(String string, int n2) {
        return string.substring(n2, string.length()).trim();
    }

    private double convert(String string) {
        return Double.parseDouble(string);
    }

    private static String i18nString(String string) {
        return Localization.localize(Localization.asKey("parser.text.operator." + string));
    }

    private static enum NumberOperation implements Operation<Number, Number>
    {
        EQUALS("text.equals", "symbol.equals"){

            @Override
            public Predicate<Number> operate(Number number) {
                return number2 -> number2 != null && number2.doubleValue() == number.doubleValue();
            }
        }
        ,
        NOT_EQUALS("text.notequals", "symbol.notequals"){

            @Override
            public Predicate<Number> operate(Number number) {
                return number2 -> number2 != null && number2.doubleValue() != number.doubleValue();
            }
        }
        ,
        GREATER_THAN_EQUALS("text.greaterthanequals", "symbol.greaterthanequals"){

            @Override
            public Predicate<Number> operate(Number number) {
                return number2 -> number2 != null && number2.doubleValue() >= number.doubleValue();
            }
        }
        ,
        GREATER_THAN("text.greaterthan", "symbol.greaterthan"){

            @Override
            public Predicate<Number> operate(Number number) {
                return number2 -> number2 != null && number2.doubleValue() > number.doubleValue();
            }
        }
        ,
        LESS_THAN_EQUALS("text.lessthanequals", "symbol.lessthanequals"){

            @Override
            public Predicate<Number> operate(Number number) {
                return number2 -> number2 != null && number2.doubleValue() <= number.doubleValue();
            }
        }
        ,
        LESS_THAN("text.lessthan", "symbol.lessthan"){

            @Override
            public Predicate<Number> operate(Number number) {
                return number2 -> number2 != null && number2.doubleValue() < number.doubleValue();
            }
        };

        private final String opr;
        private final String symbol;

        private NumberOperation(String string2, String string3) {
            this.opr = NumberParser.i18nString(string2);
            this.symbol = NumberParser.i18nString(string3);
        }

        @Override
        public int length() {
            return this.opr.length();
        }

        @Override
        public String get() {
            return this.opr;
        }

        @Override
        public String getSymbol() {
            return this.symbol;
        }
    }
}

