/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.tableview2.filter.parser.aggregate;

import impl.org.controlsfx.i18n.Localization;
import impl.org.controlsfx.tableview2.filter.parser.aggregate.Aggregator;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.controlsfx.control.tableview2.filter.parser.Parser;

public enum AggregatorsParser implements Aggregator
{
    AND("text.and"){

        @Override
        public <T> Predicate<T> aggregate(String string, String string2, Parser<T> parser) {
            if (parser.isValid(string) && parser.isValid(string2)) {
                Predicate<T> predicate = parser.parse(string);
                Predicate<T> predicate2 = parser.parse(string2);
                if (predicate != null && predicate2 != null) {
                    return predicate.and(predicate2);
                }
            }
            return null;
        }
    }
    ,
    OR("text.or"){

        @Override
        public <T> Predicate<T> aggregate(String string, String string2, Parser<T> parser) {
            if (parser.isValid(string) && parser.isValid(string2)) {
                Predicate<T> predicate = parser.parse(string);
                Predicate<T> predicate2 = parser.parse(string2);
                if (predicate != null && predicate2 != null) {
                    return predicate.or(predicate2);
                }
            }
            return null;
        }
    };

    private final String type;

    private AggregatorsParser(String string2) {
        this.type = " " + AggregatorsParser.i18nString(string2) + " ";
    }

    public String get() {
        return this.type;
    }

    public static Stream<String> getStrings() {
        return Arrays.stream(AggregatorsParser.values()).map(AggregatorsParser::get);
    }

    public static Optional<Aggregation> findParser(String string) {
        AggregatorsParser aggregatorsParser = null;
        int n2 = string.length();
        for (AggregatorsParser aggregatorsParser2 : AggregatorsParser.values()) {
            int n3 = string.indexOf(aggregatorsParser2.get());
            if (n3 == -1 || n3 >= n2) continue;
            n2 = n3;
            aggregatorsParser = aggregatorsParser2;
        }
        if (aggregatorsParser != null) {
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + aggregatorsParser.get().length(), string.length());
            return Optional.of(new Aggregation(string2.trim(), string3.trim(), aggregatorsParser));
        }
        return Optional.empty();
    }

    private static String i18nString(String string) {
        return Localization.localize(Localization.asKey("parser.text.operator." + string));
    }

    public static class Aggregation {
        private final String lhs;
        private final String rhs;
        private final AggregatorsParser parser;

        Aggregation(String string, String string2, AggregatorsParser aggregatorsParser) {
            this.lhs = string;
            this.rhs = string2;
            this.parser = aggregatorsParser;
        }

        public String getLhs() {
            return this.lhs;
        }

        public String getRhs() {
            return this.rhs;
        }

        public AggregatorsParser getParser() {
            return this.parser;
        }
    }
}

