/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.tableview2;

import impl.org.controlsfx.tableview2.RowHeader;
import impl.org.controlsfx.tableview2.SortUtils;
import impl.org.controlsfx.tableview2.SouthTableHeaderRow;
import impl.org.controlsfx.tableview2.TableHeaderRow2;
import impl.org.controlsfx.tableview2.TableRow2;
import impl.org.controlsfx.tableview2.TableView2VirtualFlow;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.SortEvent;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.skin.TableHeaderRow;
import javafx.scene.control.skin.TableViewSkinBase;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.controlsfx.control.tableview2.TableView2;

public class TableView2Skin<S>
extends TableViewSkinBase<S, S, TableView<S>, TableRow<S>, TableColumn<S, ?>> {
    private static final double DEFAULT_CELL_HEIGHT;
    final Map<TableRow2<S>, Set<TableCell<S, ?>>> deportedCells = new HashMap();
    ObservableMap<Integer, Double> rowHeightMap = FXCollections.observableHashMap();
    protected TableView2<S> tableView;
    private final TableView2<S> parentTableView;
    protected RowHeader<S> rowHeader;
    private final ObservableSet<Integer> currentlyFixedRow = FXCollections.observableSet(new HashSet());
    private final ObservableList<Integer> selectedRows = FXCollections.observableArrayList();
    private final ObservableList<Integer> selectedColumns = FXCollections.observableArrayList();
    private double fixedRowHeight = 0.0;
    BitSet hBarValue;
    BitSet rowToLayout;
    double fixedColumnWidth;
    BooleanProperty lastRowLayout = new SimpleBooleanProperty(true);
    TableHeaderRow tableHeaderRow;
    private boolean key = false;
    private final EventHandler<KeyEvent> keyPressedEventHandler = keyEvent -> {
        this.key = true;
    };
    private final EventHandler<MouseEvent> mousePressedEventHandler = mouseEvent -> {
        this.key = false;
    };
    private final List<Integer> oldSelectedColumns = new ArrayList<Integer>();
    private final List<Integer> oldSelectedRows = new ArrayList<Integer>();
    private final VirtualFlow<TableRow<S>> flow;
    private final IntegerProperty size = new SimpleIntegerProperty();
    private final InvalidationListener vbarValueListener = observable -> this.verticalScroll();
    private final ListChangeListener<Integer> fixedRowsListener = new ListChangeListener<Integer>(){

        public void onChanged(ListChangeListener.Change<? extends Integer> change) {
            TableView2Skin.this.hBarValue.clear();
            while (change.next()) {
                if (change.wasPermutated()) {
                    for (Integer n2 : change.getList()) {
                        TableView2Skin.this.rowToLayout.set((int)n2, true);
                    }
                    continue;
                }
                for (Integer n2 : change.getRemoved()) {
                    TableView2Skin.this.rowToLayout.set((int)n2, false);
                }
                for (Integer n2 : change.getAddedSubList()) {
                    TableView2Skin.this.rowToLayout.set((int)n2, true);
                }
            }
            TableView2Skin.this.getFlow().requestLayout();
        }
    };
    private final SetChangeListener<? super Integer> currentlyFixedRowListener = change -> this.computeFixedRowHeight();
    private final ListChangeListener<TableColumn> fixedColumnsListener = new ListChangeListener<TableColumn>(){

        public void onChanged(ListChangeListener.Change<? extends TableColumn> change) {
            TableView2Skin.this.hBarValue.clear();
            TableView2Skin.this.getFlow().requestLayout();
        }
    };

    public TableView2Skin(TableView2<S> tableView2) {
        super(tableView2);
        this.flow = this.getVirtualFlow();
        this.flow.setCellFactory(virtualFlow -> this.createCell());
        this.tableView = tableView2;
        this.parentTableView = tableView2.getParent() != null && tableView2.getParent() instanceof RowHeader ? ((RowHeader)tableView2.getParent()).getParentTableView() : null;
        tableView2.rowFactoryProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> tableView -> new TableRow2(tableView2), (Observable[])new Observable[]{tableView2.skinProperty()}));
        this.getCurrentlyFixedRow().addListener(this.currentlyFixedRowListener);
        this.tableView.getFixedRows().addListener(this.fixedRowsListener);
        this.tableView.getFixedColumns().addListener(this.fixedColumnsListener);
        this.init();
        this.hBarValue = new BitSet(this.getItemCount());
        this.rowToLayout = this.initRowToLayoutBitSet();
        tableView2.rowFixingEnabledProperty().addListener(observable -> {
            this.rowToLayout = this.initRowToLayoutBitSet();
            tableView2.refresh();
        });
        this.computeFixedRowHeight();
        EventHandler eventHandler = mouseEvent -> {
            if (tableView2.getEditingCell() != null) {
                tableView2.edit(-1, null);
            }
            tableView2.requestFocus();
        };
        this.getFlow().getVerticalBar().addEventFilter(MouseEvent.MOUSE_PRESSED, eventHandler);
        this.getFlow().getHorizontalBar().addEventFilter(MouseEvent.MOUSE_PRESSED, eventHandler);
        this.registerChangeListener((ObservableValue)tableView2.fixedCellSizeProperty(), observableValue -> {
            tableView2.refresh();
            this.verticalScroll();
            this.computeFixedRowHeight();
        });
        this.registerChangeListener((ObservableValue)tableView2.columnFixingEnabledProperty(), observableValue -> {
            tableView2.refresh();
            this.verticalScroll();
            this.computeFixedRowHeight();
        });
    }

    public double getRowHeight(int n2) {
        if (this.tableView.getFixedCellSize() > 0.0) {
            return this.tableView.getFixedCellSize();
        }
        if (n2 < 0 || n2 >= this.getItemCount() || this.rowHeightMap.get((Object)n2) == null) {
            return DEFAULT_CELL_HEIGHT;
        }
        return (Double)this.rowHeightMap.get((Object)n2);
    }

    public double getFixedRowHeight() {
        return this.fixedRowHeight;
    }

    public ObservableList<Integer> getSelectedRows() {
        return this.selectedRows;
    }

    public ObservableList<Integer> getSelectedColumns() {
        return this.selectedColumns;
    }

    public TableRow<S> getRowIndexed(int n2) {
        Object object;
        List<?> list = this.getFlow().getCells();
        if (!list.isEmpty() && n2 >= (object = (IndexedCell)list.get(0)).getIndex() && n2 - object.getIndex() < list.size()) {
            return (TableRow)list.get(n2 - object.getIndex());
        }
        for (IndexedCell indexedCell : this.getFlow().getFixedCells()) {
            if (indexedCell.getIndex() != n2) continue;
            return (TableRow)indexedCell;
        }
        return null;
    }

    public int getFirstRow(TablePositionBase<?> tablePositionBase, int n2) {
        return n2;
    }

    public TableRow<S> getRow(int n2) {
        if (n2 < this.getFlow().getCells().size()) {
            return (TableRow)this.getFlow().getCells().get(n2);
        }
        return null;
    }

    public final boolean containsRow(int n2) {
        for (Object obj : this.getFlow().getCells()) {
            if (((TableRow2)((Object)obj)).getIndex() != n2 || ((TableRow2)((Object)obj)).getChildrenUnmodifiable().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public int getCellsSize() {
        return this.getFlow().getCells().size();
    }

    public ScrollBar getHBar() {
        if (this.getFlow() != null) {
            return this.getFlow().getHorizontalBar();
        }
        return null;
    }

    public ScrollBar getVBar() {
        return this.getFlow().getVerticalBar();
    }

    protected final void init() {
        if (this.parentTableView == null) {
            this.rowHeader = new RowHeader<S>(this.tableView);
            this.getChildren().add(this.rowHeader);
            this.rowHeader.init(this, (TableHeaderRow2)this.getTableHeaderRow());
        }
        this.getFlow().getVerticalBar().valueProperty().addListener(this.vbarValueListener);
        ((TableHeaderRow2)this.getTableHeaderRow()).init();
        this.getFlow().init();
        if (this.parentTableView != null) {
            return;
        }
        this.tableView.addEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)new WeakEventHandler(this.keyPressedEventHandler));
        this.tableView.addEventFilter(MouseEvent.MOUSE_PRESSED, (EventHandler)new WeakEventHandler(this.mousePressedEventHandler));
        if (this.tableView.getSelectionModel() != null) {
            this.tableView.getSelectionModel().selectedIndexProperty().addListener((observableValue, number, number2) -> {
                this.updateHeaders();
                this.scrollToVisibleCell((Number)number2, (Number)number);
            });
            this.tableView.getSelectionModel().getSelectedCells().addListener(observable -> this.updateHeaders());
            this.tableView.selectionModelProperty().addListener((observableValue2, tableViewSelectionModel, tableViewSelectionModel2) -> {
                if (tableViewSelectionModel2 != null) {
                    tableViewSelectionModel2.selectedIndexProperty().addListener((observableValue, number, number2) -> {
                        this.updateHeaders();
                        this.scrollToVisibleCell((Number)number2, (Number)number);
                    });
                    tableViewSelectionModel2.getSelectedCells().addListener(observable -> this.updateHeaders());
                }
            });
        }
        this.tableView.getVisibleLeafColumns().addListener(observable -> this.updateHeaders());
        this.getChildren().stream().filter(node -> node.getStyleClass().contains((Object)"column-overlay")).findFirst().ifPresent(node -> node.translateXProperty().bind((ObservableValue)this.rowHeader.rowHeaderWidthProperty()));
        Region region = (Region)this.getChildren().get(3);
        region.translateXProperty().addListener((observableValue, number, number2) -> {
            if (!this.tableView.isRowHeaderVisible() && !region.getTransforms().isEmpty()) {
                region.getTransforms().clear();
            } else if (this.tableView.isRowHeaderVisible()) {
                region.getTransforms().setAll((Object[])new Transform[]{new Translate(this.getRowHeaderOffset(), 0.0)});
            }
        });
        region.boundsInParentProperty().addListener((observableValue, bounds, bounds2) -> region.setOpacity(bounds2.getMaxX() > this.tableView.getWidth() ? 0.0 : 1.0));
        this.getTableHeaderRow().getChildren().stream().filter(node -> node.getStyleClass().contains((Object)"show-hide-columns-button")).findFirst().ifPresent(node -> node.translateXProperty().bind((ObservableValue)this.rowHeader.rowHeaderWidthProperty().multiply(-1)));
        this.tableView.addEventHandler(SortEvent.ANY, sortEvent -> {
            if (sortEvent != null && SortUtils.SortEndedEvent.SORT_ENDED_EVENT.equals((Object)sortEvent.getEventType())) {
                this.getFlow().rebuildFixedCells();
            }
        });
    }

    protected final ObservableSet<Integer> getCurrentlyFixedRow() {
        return this.currentlyFixedRow;
    }

    public final IntegerProperty sizeProperty() {
        return this.size;
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        if (this.tableView == null) {
            return;
        }
        this.size.set(this.getItemCount());
        double d6 = d4;
        double d7 = d5;
        double d8 = this.getRowHeaderOffset();
        if (this.tableView.isRowHeaderVisible()) {
            d2 += d8;
            d6 -= d8;
        }
        super.layoutChildren(d2, d3, d6, d7);
        double d9 = ((TableView)this.getSkinnable()).getLayoutBounds().getHeight() / 2.0;
        double d10 = 0.0;
        if (this.isColumnHeaderVisible()) {
            d10 = this.tableHeaderRow.prefHeight(-1.0);
            this.layoutInArea((Node)this.getTableHeaderRow(), d2, d3, d6, d10, d9, HPos.CENTER, VPos.CENTER);
            d3 += d10;
        }
        if (this.tableView.isRowHeaderVisible() && this.rowHeader != null) {
            this.layoutInArea((Node)this.rowHeader, d2 - d8, d3 - d10, d8, d7, d9, HPos.CENTER, VPos.CENTER);
        }
    }

    protected boolean isColumnHeaderVisible() {
        if (this.tableHeaderRow == null) {
            this.tableHeaderRow = this.getTableHeaderRow();
        }
        return this.tableHeaderRow.isVisible();
    }

    protected int getViewColumn(int n2) {
        return (int)this.tableView.getColumns().stream().limit(n2 > -1 ? (long)n2 : 0L).filter(TableColumnBase::isVisible).count();
    }

    protected void onFocusAboveCell() {
        this.focusScroll();
    }

    protected void onFocusBelowCell() {
        this.focusScroll();
    }

    private int getFixedRowSize() {
        return this.tableView.getFixedRows().size();
    }

    void focusScroll() {
        TableView.TableViewFocusModel tableViewFocusModel = this.tableView.getFocusModel();
        if (tableViewFocusModel == null) {
            return;
        }
        int n2 = tableViewFocusModel.getFocusedIndex();
        if (!this.getFlow().getCells().isEmpty() && ((IndexedCell)this.getFlow().getCells().get(this.getFixedRowSize())).getIndex() > n2 && !this.tableView.getFixedRows().contains((Object)n2)) {
            this.flow.scrollTo(n2);
        } else {
            this.flow.scrollTo(n2);
        }
        this.scrollHorizontally();
    }

    protected void onSelectAboveCell() {
        super.onSelectAboveCell();
        this.scrollHorizontally();
    }

    protected void onSelectBelowCell() {
        super.onSelectBelowCell();
        this.scrollHorizontally();
    }

    protected VirtualFlow<TableRow<S>> createVirtualFlow() {
        return new TableView2VirtualFlow<TableRow<S>>(this);
    }

    protected TableHeaderRow createTableHeaderRow() {
        return new TableHeaderRow2(this);
    }

    protected TableHeaderRow2 getTableHeaderRow2() {
        return (TableHeaderRow2)this.getTableHeaderRow();
    }

    private double getRowHeaderOffset() {
        if (this.rowHeader != null) {
            return this.rowHeader.computeHeaderWidth();
        }
        return 0.0;
    }

    protected SouthTableHeaderRow getSouthHeader() {
        return this.getTableHeaderRow2().getSouthHeaderRow();
    }

    BooleanProperty getTableMenuButtonVisibleProperty() {
        return this.tableView.tableMenuButtonVisibleProperty();
    }

    public void scrollHorizontally() {
        super.scrollHorizontally();
    }

    protected void scrollHorizontally(TableColumn<S, ?> tableColumn) {
        if (tableColumn == null || !tableColumn.isVisible()) {
            return;
        }
        this.fixedColumnWidth = 0.0;
        double d2 = this.getFlow().getHorizontalBar().getValue();
        int n2 = this.tableView.getVisibleLeafColumns().indexOf(tableColumn);
        double d3 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!((TableColumn)this.tableView.getVisibleLeafColumns().get(i2)).isVisible()) continue;
            TableColumn tableColumn2 = (TableColumn)this.tableView.getVisibleLeafColumns().get(i2);
            while (tableColumn2.getParentColumn() != null) {
                tableColumn2 = (TableColumn)tableColumn2.getParentColumn();
            }
            if (this.tableView.isColumnFixingEnabled() && this.tableView.getFixedColumns().contains((Object)tableColumn2)) {
                this.fixedColumnWidth += tableColumn2.getWidth();
            }
            d3 += tableColumn2.getWidth();
        }
        double d4 = d3 + tableColumn.getWidth();
        double d5 = this.tableView.getWidth() - this.snappedLeftInset() - this.snappedRightInset() - (this.rowHeader != null ? this.rowHeader.getRowHeaderWidth() : 0.0);
        double d6 = this.getFlow().getHorizontalBar().getMax();
        if (d3 < d2 + this.fixedColumnWidth && d3 >= 0.0 && d3 >= this.fixedColumnWidth) {
            double d7 = d3 - this.fixedColumnWidth < 0.0 ? d3 : d3 - this.fixedColumnWidth;
            this.getFlow().getHorizontalBar().setValue(d7);
        } else if (d3 > d2 + d5) {
            double d8 = d3 < 0.0 || d4 > d5 ? d3 - d2 - this.fixedColumnWidth : 0.0;
            double d9 = Math.min(d2 + d8, d6);
            this.getFlow().getHorizontalBar().setValue(d9);
        }
    }

    private void verticalScroll() {
        if (this.rowHeader != null) {
            this.rowHeader.requestLayout();
        }
    }

    final TableView2VirtualFlow<?> getFlow() {
        return (TableView2VirtualFlow)this.flow;
    }

    private BitSet initRowToLayoutBitSet() {
        int n2 = this.getItemCount();
        BitSet bitSet = new BitSet(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!this.tableView.isRowFixingEnabled() || !this.tableView.getFixedRows().contains((Object)i2)) continue;
            bitSet.set(i2);
        }
        return bitSet;
    }

    public final void computeFixedRowHeight() {
        this.fixedRowHeight = this.getCurrentlyFixedRow().stream().mapToDouble(this::getRowHeight).sum();
    }

    public TableRow<S> createCell() {
        TableRow tableRow = ((TableView)this.getSkinnable()).getRowFactory() != null ? (TableRow)((TableView)this.getSkinnable()).getRowFactory().call((Object)((TableView)this.getSkinnable())) : new TableRow();
        tableRow.updateTableView((TableView)this.getSkinnable());
        return tableRow;
    }

    public final int getItemCount() {
        return ((TableView)this.getSkinnable()).getItems() == null ? 0 : ((TableView)this.getSkinnable()).getItems().size();
    }

    public void setHbarValue(double d2) {
        this.setHbarValue(d2, 0);
    }

    public void setHbarValue(double d2, int n2) {
        if (n2 > 5) {
            return;
        }
        int n3 = n2 + 1;
        if (this.flow.getScene() == null) {
            Platform.runLater(() -> this.setHbarValue(d2, n3));
            return;
        }
        this.getHBar().setValue(d2);
    }

    private void updateHeaders() {
        List list;
        ObservableList observableList = this.tableView.getSelectionModel().getSelectedCells();
        List list2 = observableList.stream().map(TablePosition::getColumn).filter(n2 -> n2 > -1 && this.tableView.getSelectionModel().isCellSelectionEnabled()).collect(Collectors.toList());
        if (!this.oldSelectedColumns.equals(list2)) {
            this.oldSelectedColumns.clear();
            this.oldSelectedColumns.addAll(list2);
            this.getSelectedColumns().setAll(list2);
        }
        if (!this.oldSelectedRows.equals(list = observableList.stream().map(TablePositionBase::getRow).collect(Collectors.toList()))) {
            this.oldSelectedRows.clear();
            this.oldSelectedRows.addAll(list);
            this.getSelectedRows().setAll(list);
        }
    }

    private void scrollToVisibleCell(Number number, Number number2) {
        if (this.key && number != null && number2 != null) {
            double d2 = 0.0;
            double d3 = 0.0;
            for (int i2 = this.getRow(0).getIndex(); i2 < number.intValue(); ++i2) {
                d3 = this.getRowHeight(i2);
                d2 += d3;
            }
            double d4 = this.getFixedRowHeight();
            if (d4 > d2) {
                this.flow.scrollTo(number.intValue());
            } else if (d4 > d2 - d3) {
                this.flow.scrollPixels(d2 - d3 - d4);
            }
        }
    }

    static {
        double d2;
        DEFAULT_CELL_HEIGHT = d2 = 24.0;
    }
}

