/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import impl.org.controlsfx.i18n.Localization;
import impl.org.controlsfx.spreadsheet.GridRow;
import impl.org.controlsfx.spreadsheet.GridViewSkin;
import impl.org.controlsfx.spreadsheet.HorizontalHeader;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Stack;
import javafx.beans.InvalidationListener;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.NodeOrientation;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.stage.WindowEvent;
import org.controlsfx.control.spreadsheet.Picker;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class VerticalHeader
extends StackPane {
    public static final int PICKER_SIZE = 16;
    private static final int DRAG_RECT_HEIGHT = 5;
    private static final String TABLE_ROW_KEY = "TableRow";
    private static final String PICKER_INDEX = "PickerIndex";
    private static final String TABLE_LABEL_KEY = "Label";
    private static final Image pinImage = new Image(SpreadsheetView.class.getResource("pinSpreadsheetView.png").toExternalForm());
    private final SpreadsheetHandle handle;
    private final SpreadsheetView spreadsheetView;
    private double horizontalHeaderHeight;
    private final DoubleProperty innerVerticalHeaderWidth = new SimpleDoubleProperty();
    private Rectangle clip;
    private ContextMenu blankContextMenu;
    private double lastY = 0.0;
    private static double dragAnchorY = 0.0;
    private final List<Rectangle> dragRects = new ArrayList<Rectangle>();
    private int dragRectCount = 0;
    private final List<Label> labelList = new ArrayList<Label>();
    private int labelCount = 0;
    private GridViewSkin skin;
    private boolean resizing = false;
    private final Stack<Label> pickerPile;
    private final Stack<Label> pickerUsed;
    private final BitSet selectedRows = new BitSet();
    private final EventHandler<MouseEvent> rectMousePressed = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && mouseEvent.isPrimaryButtonDown()) {
                Rectangle rectangle = (Rectangle)mouseEvent.getSource();
                GridRow gridRow = (GridRow)((Object)rectangle.getProperties().get((Object)VerticalHeader.TABLE_ROW_KEY));
                VerticalHeader.this.skin.resizeRowToFitContent(VerticalHeader.this.spreadsheetView.getModelRow(gridRow.getIndex()));
                VerticalHeader.this.requestLayout();
            } else {
                dragAnchorY = mouseEvent.getSceneY();
                VerticalHeader.this.resizing = true;
            }
            mouseEvent.consume();
        }
    };
    private final EventHandler<MouseEvent> rectMouseDragged = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent mouseEvent) {
            Rectangle rectangle = (Rectangle)mouseEvent.getSource();
            GridRow gridRow = (GridRow)((Object)rectangle.getProperties().get((Object)VerticalHeader.TABLE_ROW_KEY));
            Label label = (Label)rectangle.getProperties().get((Object)VerticalHeader.TABLE_LABEL_KEY);
            if (gridRow != null) {
                VerticalHeader.this.rowResizing(gridRow, label, mouseEvent);
            }
            mouseEvent.consume();
        }
    };
    private final EventHandler<MouseEvent> rectMouseReleased = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent mouseEvent) {
            VerticalHeader.this.lastY = 0.0;
            VerticalHeader.this.resizing = false;
            VerticalHeader.this.requestLayout();
            mouseEvent.consume();
            Rectangle rectangle = (Rectangle)mouseEvent.getSource();
            GridRow gridRow = (GridRow)((Object)rectangle.getProperties().get((Object)VerticalHeader.TABLE_ROW_KEY));
            if (VerticalHeader.this.selectedRows.get(gridRow.getIndex())) {
                double d2 = gridRow.getHeight();
                int n2 = VerticalHeader.this.selectedRows.nextSetBit(0);
                while (n2 >= 0) {
                    VerticalHeader.this.skin.rowHeightMap.put((Object)VerticalHeader.this.spreadsheetView.getModelRow(n2), (Object)d2);
                    Event.fireEvent((EventTarget)VerticalHeader.this.spreadsheetView, (Event)new SpreadsheetView.RowHeightEvent(VerticalHeader.this.spreadsheetView.getModelRow(n2), d2));
                    n2 = VerticalHeader.this.selectedRows.nextSetBit(n2 + 1);
                }
            }
        }
    };
    private final EventHandler<MouseEvent> pickerMouseEvent = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent mouseEvent) {
            Label label = (Label)mouseEvent.getSource();
            ((Picker)label.getProperties().get((Object)VerticalHeader.PICKER_INDEX)).onClick();
        }
    };
    private final InvalidationListener layout = observable -> this.requestLayout();

    public VerticalHeader(SpreadsheetHandle spreadsheetHandle) {
        this.handle = spreadsheetHandle;
        this.spreadsheetView = spreadsheetHandle.getView();
        this.pickerPile = new Stack();
        this.pickerUsed = new Stack();
    }

    void init(GridViewSkin gridViewSkin, HorizontalHeader horizontalHeader) {
        this.skin = gridViewSkin;
        horizontalHeader.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                VerticalHeader.this.horizontalHeaderHeight = number2.doubleValue();
                VerticalHeader.this.requestLayout();
            }
        });
        this.handle.getView().gridProperty().addListener(this.layout);
        this.handle.getView().hiddenRowsProperty().addListener(this.layout);
        this.handle.getView().hiddenColumnsProperty().addListener(this.layout);
        this.clip = new Rectangle(this.getVerticalHeaderWidth(), this.snapSize(((TableView)gridViewSkin.getSkinnable()).getHeight()));
        this.clip.relocate(this.snappedTopInset(), this.snappedLeftInset());
        this.clip.setSmooth(false);
        this.clip.heightProperty().bind((ObservableValue)((TableView)gridViewSkin.getSkinnable()).heightProperty());
        this.clip.widthProperty().bind((ObservableValue)this.innerVerticalHeaderWidth);
        this.setClip((Node)this.clip);
        this.spreadsheetView.showRowHeaderProperty().addListener(this.layout);
        this.spreadsheetView.showColumnHeaderProperty().addListener(this.layout);
        this.spreadsheetView.getFixedRows().addListener(this.layout);
        this.spreadsheetView.fixingRowsAllowedProperty().addListener(this.layout);
        this.spreadsheetView.rowHeaderWidthProperty().addListener(this.layout);
        this.spreadsheetView.heightProperty().addListener(this.layout);
        this.spreadsheetView.getRowPickers().addListener(this.layout);
        gridViewSkin.getSelectedRows().addListener(this.layout);
        this.blankContextMenu = new ContextMenu();
    }

    public double getVerticalHeaderWidth() {
        return this.innerVerticalHeaderWidth.get();
    }

    public ReadOnlyDoubleProperty verticalHeaderWidthProperty() {
        return this.innerVerticalHeaderWidth;
    }

    public double computeHeaderWidth() {
        double d2 = 0.0;
        if (!this.spreadsheetView.getRowPickers().isEmpty()) {
            d2 += 16.0;
        }
        if (this.spreadsheetView.isShowRowHeader()) {
            d2 += this.spreadsheetView.getRowHeaderWidth();
        }
        return d2;
    }

    void clearSelectedRows() {
        this.selectedRows.clear();
    }

    protected void layoutChildren() {
        if (this.resizing) {
            return;
        }
        if ((this.spreadsheetView.isShowRowHeader() || !this.spreadsheetView.getRowPickers().isEmpty()) && this.skin.getCellsSize() > 0) {
            ScrollBar scrollBar;
            Label label;
            double d2 = this.snappedLeftInset();
            this.pickerPile.addAll(this.pickerUsed.subList(0, this.pickerUsed.size()));
            this.pickerUsed.clear();
            this.labelCount = 0;
            this.dragRectCount = 0;
            if (!this.spreadsheetView.getRowPickers().isEmpty()) {
                this.innerVerticalHeaderWidth.setValue((Number)16);
                d2 += 16.0;
            } else {
                this.innerVerticalHeaderWidth.setValue((Number)0);
            }
            if (this.spreadsheetView.isShowRowHeader()) {
                this.innerVerticalHeaderWidth.setValue((Number)(this.getVerticalHeaderWidth() + this.spreadsheetView.getRowHeaderWidth()));
            }
            this.getChildren().clear();
            int n2 = this.skin.getCellsSize();
            this.addVisibleRows(d2, n2);
            this.addFixedRows(d2, n2);
            if (this.spreadsheetView.showColumnHeaderProperty().get()) {
                label = this.getLabel(null);
                label.setOnMousePressed(mouseEvent -> this.spreadsheetView.getSelectionModel().selectAll());
                label.setText("");
                label.resize(this.spreadsheetView.getRowHeaderWidth(), this.horizontalHeaderHeight);
                label.layoutYProperty().unbind();
                label.setLayoutY(0.0);
                label.setLayoutX(d2);
                label.getStyleClass().clear();
                label.setContextMenu(this.blankContextMenu);
                this.getChildren().add((Object)label);
            }
            if ((scrollBar = this.handle.getCellsViewSkin().getHBar()).isVisible()) {
                label = this.getLabel(null);
                label.getProperties().put((Object)TABLE_ROW_KEY, null);
                label.setText("");
                label.resize(this.getVerticalHeaderWidth(), scrollBar.getHeight());
                label.layoutYProperty().unbind();
                label.relocate(this.snappedLeftInset(), this.getHeight() - scrollBar.getHeight());
                label.getStyleClass().clear();
                label.setContextMenu(this.blankContextMenu);
                this.getChildren().add((Object)label);
            }
        } else {
            this.getChildren().clear();
        }
    }

    public static boolean isFixedRowEmpty(SpreadsheetView spreadsheetView) {
        for (Integer n2 : spreadsheetView.getFixedRows()) {
            if (spreadsheetView.getHiddenRows().get(n2)) continue;
            return false;
        }
        return true;
    }

    private void addFixedRows(double d2, int n2) {
        double d3 = 0.0;
        ObservableSet<Integer> observableSet = this.handle.getCellsViewSkin().getCurrentlyFixedRow();
        if (!VerticalHeader.isFixedRowEmpty(this.spreadsheetView) && n2 != 0) {
            for (int i2 = 0; i2 < this.spreadsheetView.getFixedRows().size(); ++i2) {
                Object object;
                double d4;
                int n3 = (Integer)this.spreadsheetView.getFixedRows().get(i2);
                if (this.spreadsheetView.getHiddenRows().get(n3)) continue;
                int n4 = this.spreadsheetView.getFilteredRow(n3);
                if (!observableSet.contains(n4)) break;
                double d5 = this.skin.getRowHeight(n4);
                double d6 = d4 = this.spreadsheetView.showColumnHeaderProperty().get() ? this.snappedTopInset() + this.horizontalHeaderHeight + d3 : this.snappedTopInset() + d3;
                if (this.spreadsheetView.getRowPickers().containsKey((Object)n3)) {
                    object = this.getPicker((Picker)this.spreadsheetView.getRowPickers().get((Object)n3));
                    object.resize(16.0, d5);
                    object.layoutYProperty().unbind();
                    object.setLayoutY(d4);
                    this.getChildren().add(object);
                }
                if (this.spreadsheetView.isShowRowHeader()) {
                    Label label = this.getLabel(n4);
                    object = this.skin.getRowIndexed(n4);
                    label.getProperties().put((Object)TABLE_ROW_KEY, object);
                    label.setText(this.getRowHeader(n4));
                    label.resize(this.spreadsheetView.getRowHeaderWidth(), d5);
                    label.setContextMenu(this.getRowContextMenu(n4));
                    if (object != null) {
                        label.layoutYProperty().bind((ObservableValue)object.layoutYProperty().add(this.horizontalHeaderHeight).add((ObservableNumberValue)object.verticalShift));
                    }
                    label.setLayoutX(d2);
                    ObservableList observableList = label.getStyleClass();
                    if (this.skin.getSelectedRows().contains((Object)n4)) {
                        observableList.addAll((Object[])new String[]{"selected"});
                    } else {
                        observableList.removeAll((Object[])new String[]{"selected"});
                    }
                    observableList.addAll((Object[])new String[]{"fixed"});
                    this.getChildren().add((Object)label);
                    if (this.spreadsheetView.getGrid().isRowResizable(n4)) {
                        Rectangle rectangle = this.getDragRect();
                        rectangle.getProperties().put((Object)TABLE_ROW_KEY, object);
                        rectangle.getProperties().put((Object)TABLE_LABEL_KEY, (Object)label);
                        rectangle.setWidth(label.getWidth());
                        rectangle.relocate(this.snappedLeftInset() + d2, d4 + d5 - 5.0);
                        this.getChildren().add((Object)rectangle);
                    }
                }
                d3 += this.skin.getRowHeight(n4);
            }
        }
    }

    private void addVisibleRows(double d2, int n2) {
        double d3 = this.snappedTopInset();
        if (this.spreadsheetView.showColumnHeaderProperty().get()) {
            d3 += this.horizontalHeaderHeight;
        }
        if (n2 != 0) {
            d3 += this.skin.getRow(0).getLocalToParentTransform().getTy();
        }
        int n3 = this.skin.getItemCount();
        int n4 = 0;
        GridRow gridRow = this.skin.getRow(n4);
        double d4 = this.skin.getFixedRowHeight();
        double d5 = this.spreadsheetView.getRowHeaderWidth();
        while (n2 != 0 && gridRow != null && gridRow.getIndex() < n3) {
            Label label;
            int n5 = gridRow.getIndex();
            double d6 = gridRow.getHeight();
            int n6 = this.spreadsheetView.getFilteredSourceIndex(n5);
            if (gridRow.getLayoutY() >= d4 && this.spreadsheetView.getRowPickers().containsKey((Object)n6)) {
                label = this.getPicker((Picker)this.spreadsheetView.getRowPickers().get((Object)n6));
                label.resize(16.0, d6);
                label.layoutYProperty().bind((ObservableValue)gridRow.layoutYProperty().add(this.horizontalHeaderHeight));
                this.getChildren().add((Object)label);
            }
            if (this.spreadsheetView.isShowRowHeader()) {
                Label label2 = this.getLabel(n5);
                label2.getProperties().put((Object)TABLE_ROW_KEY, (Object)gridRow);
                label2.setText(this.getRowHeader(n5));
                label2.resize(d5, d6);
                label2.setLayoutX(d2);
                label2.layoutYProperty().bind((ObservableValue)gridRow.layoutYProperty().add(this.horizontalHeaderHeight));
                label2.setContextMenu(this.getRowContextMenu(n5));
                this.getChildren().add((Object)label2);
                label = label2.getStyleClass();
                if (this.skin.getSelectedRows().contains((Object)n5)) {
                    label.addAll((Object[])new String[]{"selected"});
                } else {
                    label.removeAll((Object[])new String[]{"selected"});
                }
                if (this.spreadsheetView.getFixedRows().contains((Object)n6)) {
                    label.addAll((Object[])new String[]{"fixed"});
                } else {
                    label.removeAll((Object[])new String[]{"fixed"});
                }
                d3 += d6;
                if (this.spreadsheetView.getGrid().isRowResizable(n6)) {
                    Rectangle rectangle = this.getDragRect();
                    rectangle.getProperties().put((Object)TABLE_ROW_KEY, (Object)gridRow);
                    rectangle.getProperties().put((Object)TABLE_LABEL_KEY, (Object)label2);
                    rectangle.setWidth(label2.getWidth());
                    rectangle.relocate(this.snappedLeftInset() + d2, d3 - 5.0);
                    this.getChildren().add((Object)rectangle);
                }
            }
            gridRow = this.skin.getRow(++n4);
        }
    }

    private void rowResizing(GridRow gridRow, Label label, MouseEvent mouseEvent) {
        double d2 = mouseEvent.getSceneY() - dragAnchorY;
        if (gridRow.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
            d2 = -d2;
        }
        double d3 = d2 - this.lastY;
        Double d4 = gridRow.getHeight() + d3;
        if (d4 < 0.0) {
            return;
        }
        this.handle.getCellsViewSkin().rowHeightMap.put((Object)this.spreadsheetView.getModelRow(gridRow.getIndex()), (Object)d4);
        Event.fireEvent((EventTarget)this.spreadsheetView, (Event)new SpreadsheetView.RowHeightEvent(this.spreadsheetView.getModelRow(gridRow.getIndex()), d4));
        label.resize(this.spreadsheetView.getRowHeaderWidth(), d4.doubleValue());
        gridRow.setPrefHeight(d4);
        gridRow.requestLayout();
        this.lastY = d2;
    }

    private Label getLabel(Integer n2) {
        Label label;
        if (this.labelList.isEmpty() || this.labelList.size() <= this.labelCount) {
            label = new Label();
            this.labelList.add(label);
        } else {
            label = this.labelList.get(this.labelCount);
        }
        ++this.labelCount;
        label.setOnMousePressed(n2 == null ? null : mouseEvent -> {
            if (mouseEvent.isPrimaryButtonDown()) {
                if (mouseEvent.getClickCount() == 2) {
                    this.skin.resizeRowToFitContent(this.spreadsheetView.getModelRow(n2));
                    this.requestLayout();
                } else {
                    this.headerClicked(n2, (MouseEvent)mouseEvent);
                }
            }
        });
        return label;
    }

    private void headerClicked(int n2, MouseEvent mouseEvent) {
        TableView.TableViewSelectionModel tableViewSelectionModel = this.handle.getGridView().getSelectionModel();
        int n3 = tableViewSelectionModel.getFocusedIndex();
        int n4 = this.handle.getCellsViewSkin().getItemCount();
        ObservableList observableList = tableViewSelectionModel.getTableView().getColumns();
        TableColumn tableColumn = (TableColumn)observableList.get(0);
        TableColumn tableColumn2 = (TableColumn)observableList.get(observableList.size() - 1);
        if (mouseEvent.isShortcutDown()) {
            BitSet bitSet = (BitSet)this.selectedRows.clone();
            tableViewSelectionModel.selectRange(n2, (TableColumnBase)tableColumn, n2, (TableColumnBase)tableColumn2);
            this.selectedRows.or(bitSet);
            this.selectedRows.set(n2);
        } else if (mouseEvent.isShiftDown() && n3 >= 0 && n3 < n4) {
            tableViewSelectionModel.clearSelection();
            tableViewSelectionModel.selectRange(n3, (TableColumnBase)tableColumn, n2, (TableColumnBase)tableColumn2);
            tableViewSelectionModel.getTableView().getFocusModel().focus(n3, tableColumn);
            int n5 = Math.min(n2, n3);
            int n6 = Math.max(n2, n3);
            this.selectedRows.set(n5, n6 + 1);
        } else {
            tableViewSelectionModel.clearSelection();
            tableViewSelectionModel.selectRange(n2, (TableColumnBase)tableColumn, n2, (TableColumnBase)tableColumn2);
            tableViewSelectionModel.getTableView().getFocusModel().focus(n2, tableColumn);
            this.selectedRows.set(n2);
        }
    }

    private Label getPicker(Picker picker) {
        Label label;
        if (this.pickerPile.isEmpty()) {
            label = new Label();
            picker.getStyleClass().addListener(this.layout);
            label.setOnMouseClicked(this.pickerMouseEvent);
        } else {
            label = this.pickerPile.pop();
        }
        this.pickerUsed.push(label);
        label.getStyleClass().setAll(picker.getStyleClass());
        label.getProperties().put((Object)PICKER_INDEX, (Object)picker);
        return label;
    }

    private Rectangle getDragRect() {
        if (this.dragRects.isEmpty() || this.dragRects.size() <= this.dragRectCount) {
            Rectangle rectangle = new Rectangle();
            rectangle.setWidth(this.getVerticalHeaderWidth());
            rectangle.setHeight(5.0);
            rectangle.setFill((Paint)Color.TRANSPARENT);
            rectangle.setSmooth(false);
            rectangle.setOnMousePressed(this.rectMousePressed);
            rectangle.setOnMouseDragged(this.rectMouseDragged);
            rectangle.setOnMouseReleased(this.rectMouseReleased);
            rectangle.setCursor(Cursor.V_RESIZE);
            this.dragRects.add(rectangle);
            ++this.dragRectCount;
            return rectangle;
        }
        return this.dragRects.get(this.dragRectCount++);
    }

    private ContextMenu getRowContextMenu(final Integer n2) {
        if (this.spreadsheetView.isRowFixable(n2)) {
            ContextMenu contextMenu = new ContextMenu();
            final MenuItem menuItem = new MenuItem(Localization.localize(Localization.asKey("spreadsheet.verticalheader.menu.fix")));
            contextMenu.setOnShowing((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent windowEvent) {
                    if (VerticalHeader.this.spreadsheetView.getFixedRows().contains((Object)VerticalHeader.this.spreadsheetView.getFilteredSourceIndex(n2))) {
                        menuItem.setText(Localization.localize(Localization.asKey("spreadsheet.verticalheader.menu.unfix")));
                    } else {
                        menuItem.setText(Localization.localize(Localization.asKey("spreadsheet.verticalheader.menu.fix")));
                    }
                }
            });
            menuItem.setGraphic((Node)new ImageView(pinImage));
            menuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    Integer n22 = VerticalHeader.this.spreadsheetView.getFilteredSourceIndex(n2);
                    if (VerticalHeader.this.spreadsheetView.getFixedRows().contains((Object)n22)) {
                        VerticalHeader.this.spreadsheetView.getFixedRows().remove((Object)n22);
                    } else {
                        VerticalHeader.this.spreadsheetView.getFixedRows().add((Object)n22);
                    }
                }
            });
            contextMenu.getItems().add((Object)menuItem);
            return contextMenu;
        }
        return this.blankContextMenu;
    }

    private String getRowHeader(int n2) {
        int n3 = this.spreadsheetView.getFilteredSourceIndex(n2);
        return this.spreadsheetView.getGrid().getRowHeaders().size() > n3 ? (String)this.spreadsheetView.getGrid().getRowHeaders().get(n3) : String.valueOf(n3 + 1);
    }
}

