/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import impl.org.controlsfx.spreadsheet.GridViewSkin;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.skin.NestedTableColumnHeader;
import javafx.scene.control.skin.TableColumnHeader;
import javafx.scene.input.MouseEvent;
import org.controlsfx.control.spreadsheet.SpreadsheetColumn;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class HorizontalHeaderColumn
extends NestedTableColumnHeader {
    public HorizontalHeaderColumn(TableColumnBase<?, ?> tableColumnBase) {
        super(tableColumnBase);
        this.widthProperty().addListener(observable -> {
            ((GridViewSkin)this.getTableSkin()).hBarValue.clear();
            ((GridViewSkin)this.getTableSkin()).rectangleSelection.updateRectangle();
        });
    }

    protected TableColumnHeader createTableColumnHeader(final TableColumnBase tableColumnBase) {
        if (tableColumnBase == null || tableColumnBase.getColumns().isEmpty()) {
            TableColumnHeader tableColumnHeader = new TableColumnHeader(tableColumnBase);
            tableColumnHeader.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2 && mouseEvent.isPrimaryButtonDown()) {
                        ((GridViewSkin)HorizontalHeaderColumn.this.getTableSkin()).resize(tableColumnBase, -1);
                    }
                }
            });
            return tableColumnHeader;
        }
        return new HorizontalHeaderColumn(tableColumnBase);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.layoutFixedColumns();
    }

    public void layoutFixedColumns() {
        SpreadsheetHandle spreadsheetHandle = ((GridViewSkin)this.getTableSkin()).handle;
        SpreadsheetView spreadsheetView = spreadsheetHandle.getView();
        if (spreadsheetHandle.getCellsViewSkin() == null || this.getChildren().isEmpty()) {
            return;
        }
        double d2 = spreadsheetHandle.getCellsViewSkin().getHBar().getValue();
        int n2 = (int)((Node)this.getChildren().get(0)).prefHeight(-1.0);
        double d3 = 0.0;
        double d4 = this.snappedLeftInset();
        int n3 = this.getColumnHeaders().size();
        n3 = n3 > spreadsheetHandle.getGridView().getVisibleLeafColumns().size() ? spreadsheetHandle.getGridView().getVisibleLeafColumns().size() : n3;
        n3 = n3 > spreadsheetView.getColumns().size() ? spreadsheetView.getColumns().size() : n3;
        for (int i2 = 0; i2 < n3; ++i2) {
            TableColumnHeader tableColumnHeader = (TableColumnHeader)this.getColumnHeaders().get(i2);
            double d5 = this.snapSize(tableColumnHeader.prefWidth(-1.0));
            tableColumnHeader.setPrefHeight(24.0);
            if (((SpreadsheetColumn)spreadsheetView.getColumns().get(spreadsheetView.getModelColumn(i2))).isFixed()) {
                double d6 = 0.0;
                if (d2 + d3 > d4) {
                    d6 = Math.abs(d2 - d4 + d3);
                    tableColumnHeader.toFront();
                    d3 += d5;
                }
                tableColumnHeader.relocate(d4 + d6, (double)n2 + this.snappedTopInset());
            }
            d4 += d5;
        }
    }
}

