/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import impl.org.controlsfx.spreadsheet.CellView;
import impl.org.controlsfx.spreadsheet.GridRow;
import impl.org.controlsfx.spreadsheet.GridViewSkin;
import impl.org.controlsfx.spreadsheet.SpreadsheetGridView;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.skin.CellSkinBase;
import javafx.scene.layout.BorderStroke;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetColumn;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class GridRowSkin
extends CellSkinBase<TableRow<ObservableList<SpreadsheetCell>>> {
    private final SpreadsheetHandle handle;
    private final SpreadsheetView spreadsheetView;
    private Reference<HashMap<TableColumnBase, CellView>> cellsMap;
    private final List<CellView> cells = new ArrayList<CellView>();

    public GridRowSkin(SpreadsheetHandle spreadsheetHandle, TableRow<ObservableList<SpreadsheetCell>> tableRow) {
        super(tableRow);
        this.handle = spreadsheetHandle;
        this.spreadsheetView = spreadsheetHandle.getView();
        ((TableRow)this.getSkinnable()).setPickOnBounds(false);
        tableRow.itemProperty().addListener(observable -> this.requestCellUpdate());
        this.registerChangeListener((ObservableValue)tableRow.indexProperty(), observableValue -> {
            if (((TableRow)this.getSkinnable()).isEmpty()) {
                this.requestCellUpdate();
            }
        });
    }

    private void requestCellUpdate() {
        ((TableRow)this.getSkinnable()).requestLayout();
        int n2 = ((TableRow)this.getSkinnable()).getIndex();
        this.getChildren().clear();
        int n3 = this.cells.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.cells.get(i2).updateIndex(n2);
        }
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        ObservableList observableList = this.handle.getGridView().getVisibleLeafColumns();
        if (observableList.isEmpty()) {
            super.layoutChildren(d2, d3, d4, d5);
            return;
        }
        GridRow gridRow = (GridRow)this.getSkinnable();
        SpreadsheetGridView spreadsheetGridView = this.handle.getGridView();
        int n2 = gridRow.getIndex();
        if (n2 < 0 || n2 >= spreadsheetGridView.getItems().size()) {
            this.getChildren().clear();
            this.putCellsInCache();
            return;
        }
        List list = (List)((TableRow)this.getSkinnable()).getItem();
        ObservableList<SpreadsheetColumn> observableList2 = this.spreadsheetView.getColumns();
        ObservableList observableList3 = spreadsheetGridView.getColumns();
        if (observableList2.size() != observableList3.size()) {
            return;
        }
        ((TableRow)this.getSkinnable()).setVisible(true);
        double d6 = this.snappedTopInset() + this.snappedBottomInset();
        double d7 = this.snappedLeftInset() + this.snappedRightInset();
        double d8 = this.getTableRowHeight(n2);
        double d9 = d8 == -1.0 ? 24.0 : d8;
        GridViewSkin gridViewSkin = this.handle.getCellsViewSkin();
        gridViewSkin.hBarValue.set(n2, true);
        double d10 = spreadsheetGridView.getWidth();
        double d11 = gridViewSkin.getHBar().getValue();
        ((GridRow)this.getSkinnable()).verticalShift.setValue((Number)this.getFixedRowShift(n2));
        double d12 = 0.0;
        ArrayList<CellView> arrayList = new ArrayList<CellView>();
        this.putCellsInCache();
        boolean bl2 = false;
        CellView cellView = null;
        boolean bl3 = false;
        block5: for (int i2 = 0; i2 < observableList2.size(); ++i2) {
            if (!((TableColumn)((TableView)gridViewSkin.getSkinnable()).getColumns().get(i2)).isVisible()) continue;
            double d13 = this.snapSize(((SpreadsheetColumn)observableList2.get(i2)).getWidth()) - this.snapSize(d7);
            if (list.size() <= i2) break;
            SpreadsheetCell spreadsheetCell = (SpreadsheetCell)list.get(i2);
            int n3 = this.spreadsheetView.getColumnSpan(spreadsheetCell);
            boolean bl4 = !this.isInvisible(d2, d13, d11, d10, n3);
            boolean bl5 = ((SpreadsheetColumn)observableList2.get(i2)).isFixed();
            if (bl5) {
                bl4 = true;
            }
            if (!bl4) {
                if (bl2) break;
                d2 += d13;
                continue;
            }
            CellView cellView2 = this.getCell((TableColumnBase)spreadsheetGridView.getColumns().get(i2));
            this.cells.add(0, cellView2);
            cellView2.setManaged(true);
            double d14 = 0.0;
            boolean bl6 = false;
            int n4 = this.spreadsheetView.getViewColumn(spreadsheetCell.getColumn());
            SpreadsheetView.SpanType spanType = null;
            if (bl5 && (spanType = this.spreadsheetView.getSpanType(n2, i2)) != SpreadsheetView.SpanType.COLUMN_SPAN_INVISIBLE && d11 + d12 > d2) {
                bl6 = true;
                d14 = Math.abs(d11 - d2 + d12);
                d12 += d13;
                arrayList.add(cellView2);
            }
            if (bl4) {
                spanType = spanType == null ? this.spreadsheetView.getSpanType(n2, i2) : spanType;
                switch (spanType) {
                    case ROW_SPAN_INVISIBLE: 
                    case BOTH_INVISIBLE: {
                        arrayList.remove((Object)cellView2);
                        this.getChildren().remove((Object)cellView2);
                        d2 += d13;
                        continue block5;
                    }
                    case COLUMN_SPAN_INVISIBLE: {
                        arrayList.remove((Object)cellView2);
                        this.getChildren().remove((Object)cellView2);
                        continue block5;
                    }
                    case ROW_VISIBLE: 
                    case NORMAL_CELL: {
                        if (cellView2.getIndex() != n2) {
                            cellView2.updateIndex(n2);
                        } else {
                            cellView2.updateItem(spreadsheetCell, false);
                        }
                        if (!(cellView2.isEditing() || cellView2.getParent() == this.getSkinnable() || spreadsheetCell.isCellGraphic() && gridViewSkin.rowToLayout.get(n2) && arrayList.contains((Object)cellView2))) {
                            this.getChildren().add(0, (Object)cellView2);
                        }
                    }
                    default: {
                        int n5;
                        double d15;
                        int n6;
                        int n7;
                        if (n3 > 1) {
                            n7 = ((TableView)gridViewSkin.getSkinnable()).getVisibleLeafColumns().size() - n4;
                            for (n6 = 1; n6 < n3 && n6 < n7; ++n6) {
                                double d16 = this.snapSize(((TableView)gridViewSkin.getSkinnable()).getVisibleLeafColumn(n4 + n6).getWidth());
                                d13 += d16;
                                if (!bl6) continue;
                                d12 += d16;
                            }
                        }
                        if (d8 == -1.0 && !cellView2.isEditing() && (d15 = cellView2.prefHeight(d13) + cellView2.snappedTopInset() + cellView2.snappedBottomInset()) > d9) {
                            bl3 = true;
                            gridViewSkin.rowHeightMap.put((Object)spreadsheetCell.getRow(), (Object)d15);
                            for (CellView cellView3 : this.cells) {
                                cellView3.resize(cellView3.getWidth(), cellView3.getHeight() + (d15 - d9));
                            }
                            d9 = d15;
                            gridViewSkin.getFlow().layoutChildren();
                        }
                        double d17 = d9;
                        d17 = this.snapSize(d17) - this.snapSize(d6);
                        if (spreadsheetCell.getRowSpan() > 1) {
                            n7 = this.spreadsheetView.getRowSpan(spreadsheetCell, n2);
                            d17 = 0.0;
                            n6 = this.spreadsheetView.getReverseRowSpan(spreadsheetCell, n2);
                            int n8 = n2 - n6;
                            int n9 = n8 + n6 + n7;
                            for (n5 = n8 + 1; n5 < n9; ++n5) {
                                d17 += this.snapSize(gridViewSkin.getRowHeight(n5));
                            }
                        }
                        boolean bl7 = false;
                        if (cellView != null && !this.hasRightBorder(cellView) && !this.hasLeftBorder(cellView2)) {
                            cellView2.resize(d13 + 1.0, d17);
                            bl7 = true;
                        } else {
                            cellView2.resize(d13, d17);
                        }
                        cellView = cellView2;
                        double d18 = 0.0;
                        if (spreadsheetCell.getRowSpan() > 1) {
                            int n10 = this.spreadsheetView.getReverseRowSpan(spreadsheetCell, n2);
                            int n11 = n2 - n10;
                            for (n5 = n11 + 1; n5 < n2; ++n5) {
                                d18 += gridViewSkin.getRowHeight(n5);
                            }
                        }
                        cellView2.relocate(d2 + d14 + (double)(bl7 ? -1 : 0), this.snappedTopInset() - d18 + ((GridRow)this.getSkinnable()).verticalShift.get());
                        break;
                    }
                }
            } else {
                this.getChildren().remove((Object)cellView2);
            }
            d2 += d13;
        }
        gridViewSkin.fixedColumnWidth = d12;
        this.handleFixedCell(arrayList, n2);
        this.removeUselessCell(n2);
        if (this.handle.getCellsViewSkin().lastRowLayout.get()) {
            this.handle.getCellsViewSkin().lastRowLayout.setValue(Boolean.valueOf(false));
        }
        if (bl3 && this.spreadsheetView.getFixedRows().contains((Object)this.spreadsheetView.getModelRow(n2))) {
            gridViewSkin.computeFixedRowHeight();
        }
    }

    private boolean hasRightBorder(CellView cellView) {
        return cellView.getBorder() != null && !cellView.getBorder().isEmpty() && ((BorderStroke)cellView.getBorder().getStrokes().get(0)).getWidths().getRight() > 0.0;
    }

    private boolean hasLeftBorder(CellView cellView) {
        return cellView.getBorder() != null && !cellView.getBorder().isEmpty() && ((BorderStroke)cellView.getBorder().getStrokes().get(0)).getWidths().getLeft() > 0.0;
    }

    private void removeUselessCell(int n2) {
        this.getChildren().removeIf(node -> {
            if (node instanceof CellView) {
                return !this.cells.contains(node) && ((CellView)((Object)node)).getIndex() == n2;
            }
            return false;
        });
    }

    private void removeDeportedCells() {
        GridViewSkin gridViewSkin = this.handle.getCellsViewSkin();
        for (Map.Entry<GridRow, Set<CellView>> entry : gridViewSkin.deportedCells.entrySet()) {
            ArrayList<CellView> arrayList = new ArrayList<CellView>();
            for (CellView cellView : entry.getValue()) {
                if (cellView.isEditing() || cellView.getTableRow() != this.getSkinnable() || entry.getKey() == this.getSkinnable()) continue;
                entry.getKey().removeCell(cellView);
                arrayList.add(cellView);
            }
            entry.getValue().removeAll(arrayList);
        }
    }

    private void handleFixedCell(List<CellView> list, int n2) {
        block7: {
            block6: {
                this.removeDeportedCells();
                if (list.isEmpty()) {
                    return;
                }
                GridViewSkin gridViewSkin = this.handle.getCellsViewSkin();
                if (!gridViewSkin.rowToLayout.get(n2)) break block6;
                GridRow gridRow = gridViewSkin.getFlow().getTopRow();
                if (gridRow == null) break block7;
                for (CellView cellView : list) {
                    if (!cellView.isEditing()) {
                        gridRow.removeCell(cellView);
                        gridRow.addCell(cellView);
                    }
                    double d2 = ((TableRow)this.getSkinnable()).getLayoutY() + cellView.getLayoutY();
                    if (gridViewSkin.deportedCells.containsKey((Object)gridRow)) {
                        gridViewSkin.deportedCells.get((Object)gridRow).add(cellView);
                    } else {
                        HashSet<CellView> hashSet = new HashSet<CellView>();
                        hashSet.add(cellView);
                        gridViewSkin.deportedCells.put(gridRow, hashSet);
                    }
                    cellView.relocate(cellView.getLayoutX(), d2 - gridRow.getLayoutY());
                }
                break block7;
            }
            for (CellView cellView : list) {
                cellView.toFront();
            }
        }
    }

    private HashMap<TableColumnBase, CellView> getCellsMap() {
        if (this.cellsMap == null || this.cellsMap.get() == null) {
            HashMap<TableColumnBase, CellView> hashMap = new HashMap<TableColumnBase, CellView>();
            this.cellsMap = new WeakReference(hashMap);
            return hashMap;
        }
        return this.cellsMap.get();
    }

    private void putCellsInCache() {
        for (CellView cellView : this.cells) {
            this.getCellsMap().put((TableColumnBase)cellView.getTableColumn(), cellView);
        }
        this.cells.clear();
    }

    private CellView getCell(TableColumnBase tableColumnBase) {
        TableColumn tableColumn = (TableColumn)tableColumnBase;
        if (this.getCellsMap().containsKey(tableColumn)) {
            return this.getCellsMap().remove(tableColumn);
        }
        CellView cellView = (CellView)((Object)tableColumn.getCellFactory().call((Object)tableColumn));
        cellView.updateTableColumn(tableColumn);
        cellView.updateTableView(tableColumn.getTableView());
        cellView.updateTableRow((TableRow)this.getSkinnable());
        return cellView;
    }

    private double getFixedRowShift(int n2) {
        double d2 = 0.0;
        int n3 = this.spreadsheetView.getFixedRows().indexOf((Object)this.spreadsheetView.getFilteredSourceIndex(n2));
        double d3 = 0.0;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (this.spreadsheetView.isRowHidden(i2)) continue;
            d3 += this.handle.getCellsViewSkin().getRowHeight((Integer)this.spreadsheetView.getFixedRows().get(i2));
        }
        if (n3 != -1 && ((TableRow)this.getSkinnable()).getLocalToParentTransform().getTy() <= d3) {
            d2 = d3 - ((TableRow)this.getSkinnable()).getLocalToParentTransform().getTy();
            this.handle.getCellsViewSkin().getCurrentlyFixedRow().add((Object)n2);
        } else {
            this.handle.getCellsViewSkin().getCurrentlyFixedRow().remove((Object)n2);
        }
        return d2;
    }

    private double getTableRowHeight(int n2) {
        Double d2 = (Double)this.handle.getCellsViewSkin().rowHeightMap.get((Object)this.spreadsheetView.getModelRow(n2));
        return d2 == null ? this.handle.getView().getGrid().getRowHeight(this.spreadsheetView.getModelRow(n2)) : d2.doubleValue();
    }

    private boolean isInvisible(double d2, double d3, double d4, double d5, int n2) {
        return d2 + d3 < d4 && n2 == 1 || d2 > d4 + d5;
    }

    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        double d7 = 0.0;
        ObservableList observableList = this.handle.getGridView().getVisibleLeafColumns();
        int n2 = observableList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            d7 += ((TableColumnBase)observableList.get(i2)).getWidth();
        }
        return d7;
    }

    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        return ((TableRow)this.getSkinnable()).getPrefHeight();
    }

    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        return ((TableRow)this.getSkinnable()).getPrefHeight();
    }

    protected double computeMaxHeight(double d2, double d3, double d4, double d5, double d6) {
        return super.computeMaxHeight(d2, d3, d4, d5, d6);
    }
}

