/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import impl.org.controlsfx.spreadsheet.CellView;
import impl.org.controlsfx.spreadsheet.GridRowSkin;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.WeakEventHandler;
import javafx.scene.control.Skin;
import javafx.scene.control.TableRow;
import javafx.scene.input.MouseEvent;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class GridRow
extends TableRow<ObservableList<SpreadsheetCell>> {
    private final SpreadsheetHandle handle;
    DoubleProperty verticalShift = new SimpleDoubleProperty();
    private final InvalidationListener setPrefHeightListener = new InvalidationListener(){

        public void invalidated(Observable observable) {
            GridRow.this.setRowHeight(GridRow.this.computePrefHeight(-1.0));
        }
    };
    private final WeakInvalidationListener weakPrefHeightListener = new WeakInvalidationListener(this.setPrefHeightListener);
    private final EventHandler<MouseEvent> dragDetectedEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent mouseEvent) {
            if (mouseEvent.getTarget().getClass().equals(GridRow.class) && mouseEvent.getPickResult().getIntersectedNode() != null && mouseEvent.getPickResult().getIntersectedNode().getClass().equals(CellView.class)) {
                Event.fireEvent((EventTarget)mouseEvent.getPickResult().getIntersectedNode(), (Event)mouseEvent);
            }
        }
    };
    private final WeakEventHandler<MouseEvent> weakDragHandler = new WeakEventHandler(this.dragDetectedEventHandler);
    private final InvalidationListener gridListener = new InvalidationListener(){

        public void invalidated(Observable observable) {
            GridRow.this.setRowHeight(GridRow.this.computePrefHeight(-1.0));
            GridRow.this.handle.getView().comparatorProperty().addListener((InvalidationListener)GridRow.this.weakComparatorListener);
        }
    };
    private final WeakInvalidationListener weakGridListener = new WeakInvalidationListener(this.gridListener);
    private final InvalidationListener comparatorListener = new InvalidationListener(){

        public void invalidated(Observable observable) {
            GridRow.this.updateIndex(GridRow.this.getIndex());
            GridRow.this.setRowHeight(GridRow.this.computePrefHeight(-1.0));
        }
    };
    private final WeakInvalidationListener weakComparatorListener = new WeakInvalidationListener(this.comparatorListener);

    public GridRow(final SpreadsheetHandle spreadsheetHandle) {
        this.handle = spreadsheetHandle;
        this.indexProperty().addListener((InvalidationListener)this.weakPrefHeightListener);
        this.visibleProperty().addListener((InvalidationListener)this.weakPrefHeightListener);
        spreadsheetHandle.getView().gridProperty().addListener((InvalidationListener)this.weakGridListener);
        spreadsheetHandle.getView().hiddenRowsProperty().addListener((InvalidationListener)this.weakPrefHeightListener);
        spreadsheetHandle.getView().hiddenColumnsProperty().addListener((InvalidationListener)this.weakPrefHeightListener);
        spreadsheetHandle.getView().comparatorProperty().addListener((InvalidationListener)this.weakComparatorListener);
        spreadsheetHandle.getCellsViewSkin().rowHeightMap.addListener((MapChangeListener)new MapChangeListener<Integer, Double>(){

            public void onChanged(MapChangeListener.Change<? extends Integer, ? extends Double> change) {
                if (change.wasAdded() && ((Integer)change.getKey()).intValue() == spreadsheetHandle.getView().getModelRow(GridRow.this.getIndex())) {
                    GridRow.this.setRowHeight((Double)change.getValueAdded());
                } else if (change.wasRemoved() && ((Integer)change.getKey()).intValue() == spreadsheetHandle.getView().getModelRow(GridRow.this.getIndex())) {
                    GridRow.this.setRowHeight(GridRow.this.computePrefHeight(-1.0));
                }
            }
        });
        this.addEventHandler(MouseEvent.DRAG_DETECTED, (EventHandler)this.weakDragHandler);
    }

    void addCell(CellView cellView) {
        this.getChildren().add((Object)cellView);
    }

    void removeCell(CellView cellView) {
        this.getChildren().remove((Object)cellView);
    }

    SpreadsheetView getSpreadsheetView() {
        return this.handle.getView();
    }

    protected double computePrefHeight(double d2) {
        return this.handle.getCellsViewSkin().getRowHeight(this.getIndex());
    }

    protected double computeMinHeight(double d2) {
        return this.handle.getCellsViewSkin().getRowHeight(this.getIndex());
    }

    protected Skin<?> createDefaultSkin() {
        return new GridRowSkin(this.handle, this);
    }

    public void setRowHeight(double d2) {
        CellView.getValue(() -> this.setHeight(d2));
        this.setPrefHeight(d2);
        this.handle.getCellsViewSkin().rectangleSelection.updateRectangle();
    }
}

