/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.controlsfx.control.TaskProgressView;

public class TaskProgressViewSkin<T extends Task<?>>
extends SkinBase<TaskProgressView<T>> {
    public TaskProgressViewSkin(TaskProgressView<T> taskProgressView) {
        super(taskProgressView);
        BorderPane borderPane = new BorderPane();
        borderPane.getStyleClass().add((Object)"box");
        ListView listView2 = new ListView();
        listView2.setPrefSize(500.0, 400.0);
        listView2.setPlaceholder((Node)new Label("No tasks running"));
        listView2.setCellFactory(listView -> new TaskCell());
        listView2.setFocusTraversable(false);
        Bindings.bindContent((List)listView2.getItems(), taskProgressView.getTasks());
        borderPane.setCenter((Node)listView2);
        this.getChildren().add((Object)listView2);
    }

    class TaskCell
    extends ListCell<T> {
        private ProgressBar progressBar;
        private Label titleText = new Label();
        private Label messageText;
        private Button cancelButton;
        private T task;
        private BorderPane borderPane;

        public TaskCell() {
            this.titleText.getStyleClass().add((Object)"task-title");
            this.messageText = new Label();
            this.messageText.getStyleClass().add((Object)"task-message");
            this.progressBar = new ProgressBar();
            this.progressBar.setMaxWidth(Double.MAX_VALUE);
            this.progressBar.setMaxHeight(8.0);
            this.progressBar.getStyleClass().add((Object)"task-progress-bar");
            this.cancelButton = new Button("Cancel");
            this.cancelButton.getStyleClass().add((Object)"task-cancel-button");
            this.cancelButton.setTooltip(new Tooltip("Cancel Task"));
            this.cancelButton.setOnAction(actionEvent -> {
                if (this.task != null) {
                    this.task.cancel();
                }
            });
            VBox vBox = new VBox();
            vBox.setSpacing(4.0);
            vBox.getChildren().add((Object)this.titleText);
            vBox.getChildren().add((Object)this.progressBar);
            vBox.getChildren().add((Object)this.messageText);
            BorderPane.setAlignment((Node)this.cancelButton, (Pos)Pos.CENTER);
            BorderPane.setMargin((Node)this.cancelButton, (Insets)new Insets(0.0, 0.0, 0.0, 4.0));
            this.borderPane = new BorderPane();
            this.borderPane.setCenter((Node)vBox);
            this.borderPane.setRight((Node)this.cancelButton);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        }

        public void updateIndex(int n2) {
            super.updateIndex(n2);
            if (n2 == -1) {
                this.setGraphic(null);
                this.getStyleClass().setAll((Object[])new String[]{"task-list-cell-empty"});
            }
        }

        protected void updateItem(T t2, boolean bl2) {
            super.updateItem(t2, bl2);
            this.task = t2;
            if (bl2 || t2 == null) {
                this.getStyleClass().setAll((Object[])new String[]{"task-list-cell-empty"});
                this.setGraphic(null);
            } else if (t2 != null) {
                this.getStyleClass().setAll((Object[])new String[]{"task-list-cell"});
                this.progressBar.progressProperty().bind((ObservableValue)t2.progressProperty());
                this.titleText.textProperty().bind((ObservableValue)t2.titleProperty());
                this.messageText.textProperty().bind((ObservableValue)t2.messageProperty());
                this.cancelButton.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)t2.runningProperty()));
                Callback callback = ((TaskProgressView)TaskProgressViewSkin.this.getSkinnable()).getGraphicFactory();
                if (callback != null) {
                    Node node = (Node)callback.call(t2);
                    if (node != null) {
                        BorderPane.setAlignment((Node)node, (Pos)Pos.CENTER);
                        BorderPane.setMargin((Node)node, (Insets)new Insets(0.0, 4.0, 0.0, 0.0));
                        this.borderPane.setLeft(node);
                    }
                } else {
                    this.borderPane.setLeft(null);
                }
                this.setGraphic((Node)this.borderPane);
            }
        }
    }
}

