/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import impl.org.controlsfx.ImplUtils;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.Label;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;

public abstract class NotificationBar
extends Region {
    private static final double MIN_HEIGHT = 40.0;
    final Label label;
    Label title;
    ButtonBar actionsBar;
    Button closeBtn;
    private final GridPane pane;
    public DoubleProperty transition = new SimpleDoubleProperty(){

        protected void invalidated() {
            NotificationBar.this.requestContainerLayout();
        }
    };
    private final Duration TRANSITION_DURATION = new Duration(350.0);
    private Timeline timeline;
    private double transitionStartValue;

    public void requestContainerLayout() {
        this.layoutChildren();
    }

    public String getTitle() {
        return "";
    }

    public boolean isCloseButtonVisible() {
        return true;
    }

    public abstract String getText();

    public abstract Node getGraphic();

    public abstract ObservableList<Action> getActions();

    public abstract void hide();

    public abstract boolean isShowing();

    public abstract boolean isShowFromTop();

    public abstract double getContainerHeight();

    public abstract void relocateInParent(double var1, double var3);

    public NotificationBar() {
        this.getStyleClass().add((Object)"notification-bar");
        this.setVisible(this.isShowing());
        this.pane = new GridPane();
        this.pane.getStyleClass().add((Object)"pane");
        this.pane.setAlignment(Pos.BASELINE_LEFT);
        this.getChildren().setAll((Object[])new Node[]{this.pane});
        String string = this.getTitle();
        if (string != null && !string.isEmpty()) {
            this.title = new Label();
            this.title.setFocusTraversable(false);
            this.title.getStyleClass().add((Object)"title");
            this.title.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
            GridPane.setHgrow((Node)this.title, (Priority)Priority.ALWAYS);
            this.title.setText(string);
            this.title.opacityProperty().bind((ObservableValue)this.transition);
        }
        this.label = new Label();
        this.label.setFocusTraversable(false);
        this.label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        GridPane.setVgrow((Node)this.label, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.label, (Priority)Priority.ALWAYS);
        this.label.setText(this.getText());
        this.label.setGraphic(this.getGraphic());
        this.label.opacityProperty().bind((ObservableValue)this.transition);
        this.getActions().addListener(observable -> this.updatePane());
        this.closeBtn = new Button();
        this.closeBtn.setFocusTraversable(false);
        this.closeBtn.setOnAction(actionEvent -> this.hide());
        this.closeBtn.getStyleClass().setAll((Object[])new String[]{"close-button"});
        StackPane stackPane = new StackPane();
        stackPane.getStyleClass().setAll((Object[])new String[]{"graphic"});
        this.closeBtn.setGraphic((Node)stackPane);
        this.closeBtn.setMinSize(17.0, 17.0);
        this.closeBtn.setPrefSize(17.0, 17.0);
        this.closeBtn.opacityProperty().bind((ObservableValue)this.transition);
        GridPane.setMargin((Node)this.closeBtn, (Insets)new Insets(0.0, 0.0, 0.0, 8.0));
        GridPane.setValignment((Node)this.closeBtn, (VPos)VPos.TOP);
        this.updatePane();
        this.focusedProperty().addListener((observableValue, bl2, bl3) -> {
            if (bl3.booleanValue()) {
                this.actionsBar.requestFocus();
            }
        });
        EventHandler eventHandler = keyEvent -> {
            if (KeyCode.TAB.equals((Object)keyEvent.getCode())) {
                this.handleTraversal((KeyEvent)keyEvent);
            }
            keyEvent.consume();
        };
        this.addEventHandler(KeyEvent.KEY_PRESSED, eventHandler);
    }

    void updatePane() {
        this.actionsBar = ActionUtils.createButtonBar(this.getActions());
        this.actionsBar.opacityProperty().bind((ObservableValue)this.transition);
        this.actionsBar.focusedProperty().addListener((observableValue, bl2, bl3) -> {
            if (!this.actionsBar.getButtons().isEmpty()) {
                ((Node)this.actionsBar.getButtons().get(0)).requestFocus();
            }
        });
        GridPane.setHgrow((Node)this.actionsBar, (Priority)Priority.SOMETIMES);
        this.pane.getChildren().clear();
        int n2 = 0;
        if (this.title != null) {
            this.pane.add((Node)this.title, 0, n2++);
        }
        this.pane.add((Node)this.label, 0, n2);
        this.pane.add((Node)this.actionsBar, 1, n2);
        if (this.isCloseButtonVisible()) {
            this.pane.add((Node)this.closeBtn, 2, 0, 1, n2 + 1);
        }
    }

    public void handleTraversal(KeyEvent keyEvent) {
        if (this.actionsBar != null && this.actionsBar.getButtons().size() > 0) {
            if (keyEvent.isShiftDown()) {
                if (((Node)this.actionsBar.getButtons().get(0)).isFocused()) {
                    ImplUtils.focusPreviousSibling((Node)this.getParent());
                }
            } else if (((Node)this.actionsBar.getButtons().get(this.actionsBar.getButtons().size() - 1)).isFocused()) {
                ImplUtils.focusNextSibling((Node)this.getParent());
            }
        }
    }

    protected void layoutChildren() {
        double d2 = this.getWidth();
        double d3 = this.computePrefHeight(-1.0);
        double d4 = this.prefHeight(d2);
        double d5 = this.minHeight(d2);
        if (this.isShowFromTop()) {
            this.pane.resize(d2, d3);
            this.relocateInParent(0.0, (this.transition.get() - 1.0) * d5);
        } else {
            this.pane.resize(d2, d4);
            this.relocateInParent(0.0, this.getContainerHeight() - d4);
        }
    }

    protected double computeMinHeight(double d2) {
        return Math.max(super.computePrefHeight(d2), 40.0);
    }

    protected double computePrefHeight(double d2) {
        return Math.max(this.pane.prefHeight(d2), this.minHeight(d2)) * this.transition.get();
    }

    public void doShow() {
        this.transitionStartValue = 0.0;
        this.doAnimationTransition();
    }

    public void doHide() {
        this.transitionStartValue = 1.0;
        this.doAnimationTransition();
    }

    private void doAnimationTransition() {
        KeyFrame keyFrame;
        KeyFrame keyFrame2;
        Duration duration;
        if (this.timeline != null && this.timeline.getStatus() != Animation.Status.STOPPED) {
            duration = this.timeline.getCurrentTime();
            duration = duration == Duration.ZERO ? this.TRANSITION_DURATION : duration;
            this.transitionStartValue = this.transition.get();
            this.timeline.stop();
        } else {
            duration = this.TRANSITION_DURATION;
        }
        this.timeline = new Timeline();
        this.timeline.setCycleCount(1);
        if (this.isShowing()) {
            keyFrame2 = new KeyFrame(Duration.ZERO, actionEvent -> {
                this.setCache(true);
                this.setVisible(true);
                this.pane.fireEvent(new Event(NotificationPane.ON_SHOWING));
            }, new KeyValue[]{new KeyValue((WritableValue)this.transition, (Object)this.transitionStartValue)});
            keyFrame = new KeyFrame(duration, actionEvent -> {
                this.pane.setCache(false);
                this.pane.fireEvent(new Event(NotificationPane.ON_SHOWN));
            }, new KeyValue[]{new KeyValue((WritableValue)this.transition, (Object)1, Interpolator.EASE_OUT)});
        } else {
            keyFrame2 = new KeyFrame(Duration.ZERO, actionEvent -> {
                this.pane.setCache(true);
                this.pane.fireEvent(new Event(NotificationPane.ON_HIDING));
            }, new KeyValue[]{new KeyValue((WritableValue)this.transition, (Object)this.transitionStartValue)});
            keyFrame = new KeyFrame(duration, actionEvent -> {
                this.setCache(false);
                this.setVisible(false);
                this.pane.fireEvent(new Event(NotificationPane.ON_HIDDEN));
            }, new KeyValue[]{new KeyValue((WritableValue)this.transition, (Object)0, Interpolator.EASE_IN)});
        }
        this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{keyFrame2, keyFrame});
        this.timeline.play();
    }
}

