/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import impl.org.controlsfx.skin.GridRow;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.scene.control.skin.VirtualContainerBase;
import javafx.scene.control.skin.VirtualFlow;
import org.controlsfx.control.GridView;

public class GridViewSkin<T>
extends VirtualContainerBase<GridView<T>, GridRow<T>> {
    private VirtualFlow<GridRow<T>> flow;
    private final ListChangeListener<T> gridViewItemsListener = change -> {
        this.updateItemCount();
        ((GridView)this.getSkinnable()).requestLayout();
    };
    private final WeakListChangeListener<T> weakGridViewItemsListener = new WeakListChangeListener(this.gridViewItemsListener);

    public GridViewSkin(GridView<T> gridView) {
        super(gridView);
        this.flow = this.getVirtualFlow();
        this.flow.setId("virtual-flow");
        this.flow.setPannable(false);
        this.flow.setVertical(true);
        this.flow.setFocusTraversable(((GridView)this.getSkinnable()).isFocusTraversable());
        this.flow.setCellFactory(virtualFlow -> this.createCell());
        this.getChildren().add(this.flow);
        this.updateGridViewItems();
        this.updateItemCount();
        this.registerChangeListener((ObservableValue)gridView.itemsProperty(), observableValue -> this.updateGridViewItems());
        this.registerChangeListener((ObservableValue)gridView.cellFactoryProperty(), observableValue -> this.getFlow().recreateCells());
        this.registerChangeListener((ObservableValue)gridView.parentProperty(), observableValue -> {
            if (((GridView)this.getSkinnable()).getParent() != null && ((GridView)this.getSkinnable()).isVisible()) {
                ((GridView)this.getSkinnable()).requestLayout();
            }
        });
        this.registerChangeListener((ObservableValue)gridView.cellHeightProperty(), observableValue -> this.getFlow().recreateCells());
        this.registerChangeListener((ObservableValue)gridView.cellWidthProperty(), observableValue -> {
            this.updateItemCount();
            this.getFlow().recreateCells();
        });
        this.registerChangeListener((ObservableValue)gridView.horizontalCellSpacingProperty(), observableValue -> {
            this.updateItemCount();
            this.getFlow().recreateCells();
        });
        this.registerChangeListener((ObservableValue)gridView.verticalCellSpacingProperty(), observableValue -> this.getFlow().recreateCells());
        this.registerChangeListener((ObservableValue)gridView.widthProperty(), observableValue -> this.updateItemCount());
        this.registerChangeListener((ObservableValue)gridView.heightProperty(), observableValue -> this.updateItemCount());
    }

    protected VirtualFlow<GridRow<T>> createVirtualFlow() {
        return new GridVirtualFlow();
    }

    public void updateGridViewItems() {
        if (((GridView)this.getSkinnable()).getItems() != null) {
            ((GridView)this.getSkinnable()).getItems().removeListener(this.weakGridViewItemsListener);
        }
        if (((GridView)this.getSkinnable()).getItems() != null) {
            ((GridView)this.getSkinnable()).getItems().addListener(this.weakGridViewItemsListener);
        }
        this.updateItemCount();
        this.getFlow().recreateCells();
        ((GridView)this.getSkinnable()).requestLayout();
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        double d6 = ((GridView)this.getSkinnable()).getInsets().getLeft();
        double d7 = ((GridView)this.getSkinnable()).getInsets().getTop();
        double d8 = ((GridView)this.getSkinnable()).getWidth() - (((GridView)this.getSkinnable()).getInsets().getLeft() + ((GridView)this.getSkinnable()).getInsets().getRight());
        double d9 = ((GridView)this.getSkinnable()).getHeight() - (((GridView)this.getSkinnable()).getInsets().getTop() + ((GridView)this.getSkinnable()).getInsets().getBottom());
        this.flow.resizeRelocate(d6, d7, d8, d9);
    }

    public int getItemCount() {
        ObservableList observableList = ((GridView)this.getSkinnable()).getItems();
        return observableList == null ? 0 : (int)Math.ceil((double)observableList.size() / (double)this.computeMaxCellsInRow());
    }

    protected void updateItemCount() {
        if (this.flow == null) {
            return;
        }
        int n2 = this.flow.getCellCount();
        int n3 = this.getItemCount();
        if (n3 != n2) {
            this.flow.setCellCount(n3);
            this.getFlow().rebuildCells();
        } else {
            this.getFlow().reconfigureCells();
        }
        this.updateRows(n3);
        ((GridView)this.getSkinnable()).requestLayout();
    }

    public int computeMaxCellsInRow() {
        return Math.max((int)Math.floor(this.computeRowWidth() / this.computeCellWidth()), 1);
    }

    protected double computeRowWidth() {
        return ((GridView)this.getSkinnable()).getWidth() - 18.0;
    }

    protected double computeCellWidth() {
        return ((GridView)this.getSkinnable()).cellWidthProperty().doubleValue() + ((GridView)this.getSkinnable()).horizontalCellSpacingProperty().doubleValue() * 2.0;
    }

    protected void updateRows(int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            GridRow gridRow = (GridRow)this.flow.getVisibleCell(i2);
            if (gridRow == null) continue;
            gridRow.updateIndex(i2);
        }
    }

    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        return 0.0;
    }

    private GridRow<T> createCell() {
        GridRow gridRow = new GridRow();
        gridRow.updateGridView((GridView)this.getSkinnable());
        return gridRow;
    }

    private GridVirtualFlow getFlow() {
        return (GridVirtualFlow)this.getVirtualFlow();
    }

    private class GridVirtualFlow
    extends VirtualFlow<GridRow<T>> {
        private GridVirtualFlow() {
        }

        public void recreateCells() {
            super.recreateCells();
        }

        public void rebuildCells() {
            super.rebuildCells();
        }

        public void reconfigureCells() {
            super.reconfigureCells();
        }
    }
}

