/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import org.controlsfx.control.decoration.Decoration;
import org.controlsfx.control.decoration.Decorator;

public class DecorationPane
extends StackPane {
    private final Map<Node, List<Node>> nodeDecorationMap = new WeakHashMap<Node, List<Node>>();
    ChangeListener<Boolean> visibilityListener = new ChangeListener<Boolean>(){

        public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl2, Boolean bl3) {
            BooleanProperty booleanProperty = (BooleanProperty)observableValue;
            Node node = (Node)booleanProperty.getBean();
            DecorationPane.this.removeAllDecorationsOnNode(node, (List<Decoration>)Decorator.getDecorations(node));
            Decorator.removeAllDecorations(node);
        }
    };

    public DecorationPane() {
        this.setBackground(null);
    }

    public void setRoot(Node node) {
        this.getChildren().setAll((Object[])new Node[]{node});
    }

    public void updateDecorationsOnNode(Node node, List<Decoration> list, List<Decoration> list2) {
        this.removeAllDecorationsOnNode(node, list2);
        this.addAllDecorationsOnNode(node, list);
    }

    private void showDecoration(Node node, Decoration decoration) {
        Node node2 = decoration.applyDecoration(node);
        if (node2 != null) {
            List<Node> list = this.nodeDecorationMap.get(node);
            if (list == null) {
                list = new ArrayList<Node>();
                this.nodeDecorationMap.put(node, list);
            }
            list.add(node2);
            if (!this.getChildren().contains((Object)node2)) {
                this.getChildren().add((Object)node2);
                StackPane.setAlignment((Node)node2, (Pos)Pos.TOP_LEFT);
            }
        }
        node.visibleProperty().addListener(this.visibilityListener);
    }

    private void removeAllDecorationsOnNode(Node node, List<Decoration> list) {
        if (list == null || node == null) {
            return;
        }
        List<Node> list2 = this.nodeDecorationMap.remove(node);
        if (list2 != null) {
            for (Node object : list2) {
                boolean bl2 = this.getChildren().remove((Object)object);
                if (bl2) continue;
                throw new IllegalStateException("Could not remove decoration " + object + " from decoration pane children list: " + this.getChildren());
            }
        }
        for (Decoration decoration : list) {
            decoration.removeDecoration(node);
        }
    }

    private void addAllDecorationsOnNode(Node node, List<Decoration> list) {
        if (list == null) {
            return;
        }
        for (Decoration decoration : list) {
            this.showDecoration(node, decoration);
        }
    }
}

